/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.helpers;

import com.stimulsoft.base.drawing.StiBytesFromURL;
import com.stimulsoft.lib.io.StiIOUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.simplecomponents.StiImage;
import com.stimulsoft.report.components.simplecomponents.StiImageHelper;
import com.stimulsoft.report.dictionary.StiDataColumn;
import com.stimulsoft.report.dictionary.StiResource;
import com.stimulsoft.report.dictionary.StiVariable;
import com.stimulsoft.report.export.tools.StiImageFormat;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageIO;

public class StiHyperlinkProcessor {
    public static final String ServerIdent = "stimulsoft-server://";
    public static final String ResourceIdent = "resource://";
    public static final String VariableIdent = "variable://";
    public static final String DataColumnIdent = "datacolumn://";
    public static final String FileIdent = "file://";

    public static boolean isResourceHyperlink(String hyperlink) {
        return !StiValidationUtil.isNullOrWhiteSpace((String)hyperlink) && hyperlink.toLowerCase().startsWith(ResourceIdent);
    }

    public static boolean isServerHyperlink(String hyperlink) {
        return !StiValidationUtil.isNullOrWhiteSpace((String)hyperlink) && hyperlink.startsWith(ServerIdent);
    }

    public static boolean isVariableHyperlink(String hyperlink) {
        return !StiValidationUtil.isNullOrWhiteSpace((String)hyperlink) && hyperlink.toLowerCase().startsWith(VariableIdent);
    }

    public static String getVariableNameFromHyperlink(String hyperlink) {
        if (!StiHyperlinkProcessor.isVariableHyperlink(hyperlink)) {
            return null;
        }
        return hyperlink.substring(VariableIdent.length());
    }

    public static String getDataColumnNameFromHyperlink(String hyperlink) {
        if (!StiHyperlinkProcessor.isDataColumnHyperlink(hyperlink)) {
            return null;
        }
        return hyperlink.substring(0, DataColumnIdent.length());
    }

    public static byte[] getBytes(StiReport report, String hyperlink) throws UnsupportedEncodingException, FileNotFoundException, IOException {
        String resourceName = StiHyperlinkProcessor.getResourceNameFromHyperlink(hyperlink);
        if (resourceName != null) {
            StiResource resource = StiHyperlinkProcessor.getResource(report, resourceName);
            return resource != null ? resource.getContent() : null;
        }
        String variableName = StiHyperlinkProcessor.getVariableNameFromHyperlink(hyperlink);
        if (variableName != null) {
            StiVariable variable = StiHyperlinkProcessor.getVariable(report, variableName);
            if (variable != null) {
                if (variable.getValueObject() instanceof StiImage) {
                    return ((StiImage)variable.getValueObject()).getImageToDraw().getBytes();
                }
                if (variable.getValueObject() instanceof byte[] && StiImageHelper.isImage((byte[])variable.getValueObject())) {
                    return (byte[])variable.getValueObject();
                }
            }
            return null;
        }
        String dataColumnName = StiHyperlinkProcessor.getDataColumnNameFromHyperlink(hyperlink);
        if (dataColumnName != null) {
            ArrayList<Object> columnData = StiDataColumn.getDatasFromDataColumn(report.getDictionary(), dataColumnName, 1);
            return columnData.size() > 0 ? (byte[])columnData.get(0) : null;
        }
        String file = StiHyperlinkProcessor.getFileNameFromHyperlink(hyperlink);
        if (file != null) {
            File sFile = new File(file);
            if (!sFile.exists()) {
                return null;
            }
            return StiIOUtil.toString((InputStream)new FileInputStream(sFile)).getBytes("UTF-8");
        }
        return StiBytesFromURL.load((String)hyperlink);
    }

    public static StiImage getImage(StiReport report, String hyperlink) throws FileNotFoundException, IOException {
        StiResource resource;
        String resourceName = StiHyperlinkProcessor.getResourceNameFromHyperlink(hyperlink);
        if (resourceName != null && (resource = StiHyperlinkProcessor.getResource(report, resourceName)) != null) {
            return resource.getResourceAsImage();
        }
        StiVariable variable = StiHyperlinkProcessor.getVariable(report, StiHyperlinkProcessor.getVariableNameFromHyperlink(hyperlink));
        if (variable != null) {
            return (StiImage)variable.getValueObject();
        }
        String file = StiHyperlinkProcessor.getFileNameFromHyperlink(hyperlink);
        if (file != null) {
            return new File(file).exists() ? StiImageHelper.FromFile(file) : null;
        }
        BufferedImage bi = ImageIO.read(new URL(hyperlink));
        StiImage img = new StiImage();
        img.setImageBytesToDraw(StiImageHelper.imageToBase64(bi, StiImageFormat.Png));
        return img;
    }

    public static String getString(StiReport report, String hyperlink) throws FileNotFoundException, IOException {
        String resourceName = StiHyperlinkProcessor.getResourceNameFromHyperlink(hyperlink);
        if (resourceName != null) {
            StiResource resource = StiHyperlinkProcessor.getResource(report, resourceName);
            return resource != null ? new String(resource.content, "UTF-8") : null;
        }
        String variableName = StiHyperlinkProcessor.getVariableNameFromHyperlink(hyperlink);
        if (variableName != null) {
            StiVariable variable = StiHyperlinkProcessor.getVariable(report, variableName);
            return variable != null ? (String)variable.getValueObject() : null;
        }
        String dataColumnName = StiHyperlinkProcessor.getDataColumnNameFromHyperlink(hyperlink);
        if (dataColumnName != null) {
            ArrayList<Object> columnData = StiDataColumn.getDatasFromDataColumn(report.getDictionary(), dataColumnName, 1);
            return columnData.size() > 0 ? (String)columnData.get(0) : null;
        }
        String file = StiHyperlinkProcessor.getFileNameFromHyperlink(hyperlink);
        if (file != null) {
            return new File(file).exists() ? StiIOUtil.toString((InputStream)new FileInputStream(file)) : null;
        }
        return new String(StiBytesFromURL.load((String)hyperlink), "UTF-8");
    }

    private static StiResource getResource(StiReport report, String resourceName) {
        if (report == null || StiValidationUtil.isNullOrWhiteSpace((String)resourceName)) {
            return null;
        }
        resourceName = resourceName.toLowerCase().trim();
        Iterator iterator = report.getDictionary().getResources().iterator();
        while (iterator.hasNext()) {
            StiResource resource = (StiResource)iterator.next();
            if (resource.getName() == null || !resource.getName().toLowerCase().trim().equals(resourceName)) continue;
            return resource;
        }
        return null;
    }

    private static StiVariable getVariable(StiReport report, String variableName) {
        if (report == null || StiValidationUtil.isNullOrWhiteSpace((String)variableName)) {
            return null;
        }
        variableName = variableName.toLowerCase().trim();
        Iterator iterator = report.getDictionary().getVariables().iterator();
        while (iterator.hasNext()) {
            StiVariable variable = (StiVariable)iterator.next();
            if (variable.getName() == null || !variable.getName().toLowerCase().trim().equals(variableName)) continue;
            return variable;
        }
        return null;
    }

    public static String getResourceNameFromHyperlink(String hyperlink) {
        return StiHyperlinkProcessor.isResourceHyperlink(hyperlink) ? hyperlink.substring(ResourceIdent.length()) : null;
    }

    public static String getFileNameFromHyperlink(String hyperlink) {
        if (!StiHyperlinkProcessor.isFileHyperlink(hyperlink)) {
            return null;
        }
        return hyperlink.substring(FileIdent.length());
    }

    public static boolean isFileHyperlink(String hyperlink) {
        return !StiValidationUtil.isNullOrWhiteSpace((String)hyperlink) && hyperlink.toLowerCase().startsWith(FileIdent);
    }

    public static boolean isDataColumnHyperlink(String hyperlink) {
        return !StiValidationUtil.isNullOrWhiteSpace((String)hyperlink) && hyperlink.startsWith(DataColumnIdent);
    }

    public static String createResourceName(String name) {
        return String.format("%s%s", ResourceIdent, name);
    }
}

