/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.helpers;

import com.stimulsoft.base.StiFontCollection;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.dictionary.StiResource;
import com.stimulsoft.report.dictionary.enums.StiResourceType;
import java.awt.Font;
import java.util.Iterator;

public class FontVHelper {
    public static boolean loadFontsFromResources(StiReport report) {
        boolean haveFonts = false;
        Iterator iterator = report.getDictionary().getResources().iterator();
        while (iterator.hasNext()) {
            StiResource resource = (StiResource)iterator.next();
            if (!FontVHelper.isFont(resource.getType()) || resource.getContent() == null) continue;
            Font font = StiFontCollection.addResourceFont((String)resource.getName(), (byte[])resource.getContent(), (String)resource.getType().toString().substring(4));
            haveFonts = true;
            report.getCustomFonts().put(font, resource.getContent());
        }
        return haveFonts;
    }

    public static void removeFontsFromResources(StiReport report) {
        Iterator iterator = report.getDictionary().getResources().iterator();
        while (iterator.hasNext()) {
            StiResource resource = (StiResource)iterator.next();
            if (!FontVHelper.isFont(resource.getType()) || resource.getContent() == null) continue;
            StiFontCollection.removeResourceFont((String)resource.getName(), (byte[])resource.getContent());
        }
    }

    public static boolean isFont(StiResourceType type) {
        return type == StiResourceType.FontOtf || type == StiResourceType.FontTtc || type == StiResourceType.FontTtf;
    }
}

