/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.export.tools.html;

import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiGlareBrush;
import com.stimulsoft.base.drawing.StiGlassBrush;
import com.stimulsoft.base.drawing.StiGradientBrush;
import com.stimulsoft.base.drawing.StiHatchBrush;
import com.stimulsoft.base.drawing.StiLineInfo;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.enums.StiStringTrimming;
import com.stimulsoft.base.drawing.enums.StiTextHorAlignment;
import com.stimulsoft.base.drawing.enums.StiVertAlignment;
import com.stimulsoft.base.enums.StiArabicDigitsType;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.base.utils.StiBidirectionalConvert;
import com.stimulsoft.base.utils.StiMath;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.barCodes.StiBarCode;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.components.StiBandInteraction;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.StiPagesCollection;
import com.stimulsoft.report.components.bands.StiDataBand;
import com.stimulsoft.report.components.complexcomponents.StiContainer;
import com.stimulsoft.report.components.enums.StiImageRotation;
import com.stimulsoft.report.components.enums.StiTextQuality;
import com.stimulsoft.report.components.interfaces.IStiEditable;
import com.stimulsoft.report.components.interfaces.IStiExportImage;
import com.stimulsoft.report.components.interfaces.IStiExportImageExtended;
import com.stimulsoft.report.components.interfaces.IStiFont;
import com.stimulsoft.report.components.interfaces.IStiTextBrush;
import com.stimulsoft.report.components.interfaces.IStiTextOptions;
import com.stimulsoft.report.components.simplecomponents.StiCheckBox;
import com.stimulsoft.report.components.simplecomponents.StiImage;
import com.stimulsoft.report.components.simplecomponents.StiRichText;
import com.stimulsoft.report.components.simplecomponents.StiShape;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.engine.engineV2.builders.StiDataBandV2Builder;
import com.stimulsoft.report.enums.StiExportFormat;
import com.stimulsoft.report.enums.StiHtmlChartType;
import com.stimulsoft.report.export.service.StiHtmlExportService;
import com.stimulsoft.report.export.settings.StiHtmlExportSettings;
import com.stimulsoft.report.export.tools.StiCell;
import com.stimulsoft.report.export.tools.StiCellStyle;
import com.stimulsoft.report.export.tools.StiMatrix;
import com.stimulsoft.report.export.tools.StiTextRenderer;
import com.stimulsoft.report.export.tools.html.StiHtmlExportQuality;
import com.stimulsoft.report.export.tools.html.StiHtmlHyperlink;
import com.stimulsoft.report.export.tools.html.StiHtmlImage;
import com.stimulsoft.report.export.tools.html.StiHtmlTable;
import com.stimulsoft.report.export.tools.html.StiHtmlTableCell;
import com.stimulsoft.report.export.tools.html.StiHtmlTableRow;
import com.stimulsoft.report.export.tools.html.StiHtmlUnit;
import com.stimulsoft.report.helpers.StiHyperlinkProcessor;
import com.stimulsoft.report.infographics.gauge.StiGauge;
import com.stimulsoft.report.maps.StiMap;
import com.stimulsoft.report.options.ExportOptions;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class StiHtmlTableRender {
    private StiHtmlExportService htmlExport = null;
    private StiHtmlExportSettings htmlExportSettings = null;
    private StiMatrix matrix;

    public void RenderStylesTable(boolean useBookmarks, boolean exportBookmarksOnly) throws IOException {
        this.renderStylesTable(useBookmarks, exportBookmarksOnly, null);
    }

    public StiHtmlTableRender(StiHtmlExportService htmlExport, StiHtmlExportSettings htmlExportSettings, StiPagesCollection pages) {
        this.matrix = new StiMatrix(pages, htmlExport, htmlExport.getStyles());
        this.htmlExport = htmlExport;
        this.htmlExportSettings = htmlExportSettings;
    }

    public void renderStyle(StiCellStyle style) throws IOException {
        this.htmlExport.renderBackColor(null, style.getColor());
        this.htmlExport.renderTextColor(null, style.getTextColor());
        this.htmlExport.renderFont(null, style.getFont());
        this.htmlExport.renderBorder(null, style.getBorder(), "top");
        this.htmlExport.renderBorder(null, style.getBorderL(), "left");
        this.htmlExport.renderBorder(null, style.getBorderR(), "right");
        this.htmlExport.renderBorder(null, style.getBorderB(), "bottom");
        this.htmlExport.renderTextDirection(null, style.getTextOptions());
        this.htmlExport.renderTextHorAlignment(null, style.getTextOptions(), style.getHorAlignment());
        this.htmlExport.renderVertAlignment(null, style.getVertAlignment(), style.getTextOptions(), style.isAllowHtmlTags());
        if (style.isAbsolutePosition()) {
            this.htmlExport.getHtmlWriter().writeStyleAttribute("position", "absolute");
        }
        this.htmlExport.getHtmlWriter().write("overflow:hidden;");
        this.htmlExport.getHtmlWriter().write(String.format("line-height:%sem;", StiMath.round((double)(1.15 * (double)style.lineSpacing * StiHtmlExportService.getFontHeightCorrection(style.getFont().getName())), (int)2)).replace(',', '.'));
        if (style.getTextOptions() != null && style.getTextOptions().getTrimming() != StiStringTrimming.None) {
            this.htmlExport.getHtmlWriter().write("text-overflow:ellipsis;");
        }
    }

    public void renderStyleTable(StiHtmlTableCell cell, StiCellStyle style) throws IOException {
        this.htmlExport.renderBackColor(cell, style.getColor());
        this.htmlExport.renderTextColor(cell, style.getTextColor());
        this.htmlExport.renderFont(cell, style.getFont());
        if (cell == null) {
            this.htmlExport.getHtmlWriter().write("border:0px;");
        }
        this.htmlExport.renderBorder(cell, style.getBorder(), "top");
        this.htmlExport.renderBorder(cell, style.getBorderL(), "left");
        this.htmlExport.renderBorder(cell, style.getBorderR(), "right");
        this.htmlExport.renderBorder(cell, style.getBorderB(), "bottom");
        this.htmlExport.renderTextDirection(cell, style.getTextOptions());
        this.htmlExport.renderTextHorAlignment(cell, style.getTextOptions(), style.getHorAlignment());
        this.htmlExport.renderVertAlignment(cell, style.getVertAlignment(), style.getTextOptions(), style.isAllowHtmlTags());
        if (cell == null) {
            if (style.isAbsolutePosition()) {
                this.htmlExport.getHtmlWriter().writeStyleAttribute("position", "absolute");
            }
            this.htmlExport.getHtmlWriter().write(String.format("line-height:%sem;", StiMath.round((double)(1.15 * (double)style.lineSpacing * StiHtmlExportService.getFontHeightCorrection(style.getFont().getName())), (int)2)).replace(',', '.'));
            if (ExportOptions.Html.isUseStrictTableCellSize() || ExportOptions.Html.useStrictTableCellSizeV2) {
                if (style.isWordWrap()) {
                    this.htmlExport.getHtmlWriter().write("word-wrap:break-word;");
                } else {
                    this.htmlExport.getHtmlWriter().write("white-space:nowrap;");
                }
                this.htmlExport.getHtmlWriter().write("overflow:hidden;");
            } else if (!style.isWordWrap() && ExportOptions.Html.getUseWordWrapBreakWordMode()) {
                this.htmlExport.getHtmlWriter().write("word-wrap:break-word;");
            }
        } else {
            if (style.isAbsolutePosition()) {
                cell.getStyle().put("position", "absolute");
            }
            cell.getStyle().put("line-height", String.format("%sem", StiMath.round((double)(1.15 * (double)style.lineSpacing * StiHtmlExportService.getFontHeightCorrection(style.getFont().getName())), (int)2)).replace(',', '.'));
            if (ExportOptions.Html.isUseStrictTableCellSize() || ExportOptions.Html.useStrictTableCellSizeV2) {
                if (style.isWordWrap()) {
                    cell.getStyle().put("word-wrap", "break-word");
                } else {
                    cell.getStyle().put("white-space", "nowrap");
                }
                cell.getStyle().put("overflow", "hidden");
            } else if (!style.isWordWrap() && ExportOptions.Html.getUseWordWrapBreakWordMode()) {
                cell.getStyle().put("word-wrap", "break-word");
            }
        }
    }

    public void renderStyles(boolean useBookmarks, boolean exportBookmarksOnly, Hashtable<String, String> cssStyles) throws IOException {
        this.htmlExport.getHtmlWriter().writeLine("<style type=\"text/css\">");
        if (!exportBookmarksOnly && this.htmlExport.isUseStylesTable()) {
            for (int index = 0; index < this.matrix.getStyles().size(); ++index) {
                StiCellStyle style = this.matrix.getStyles().get(index);
                this.htmlExport.getHtmlWriter().write(".s" + style.getStyleName());
                this.htmlExport.getHtmlWriter().write("{");
                this.renderStyle(style);
                this.htmlExport.getHtmlWriter().writeLine("}");
            }
        }
        if (cssStyles != null && cssStyles.size() > 0) {
            for (String key : cssStyles.keySet()) {
                this.htmlExport.getHtmlWriter().writeLine("." + key + " {" + cssStyles.get(key) + ";overflow:hidden;}");
            }
        }
        if (useBookmarks) {
            this.htmlExport.getHtmlWriter().writeLine(".dtree {font-family: Verdana, Geneva, Arial, Helvetica, sans-serif;font-size:11px;color:#666;white-space:nowrap;}");
            this.htmlExport.getHtmlWriter().writeLine(".dtree img {border: 0px;vertical-align: middle;}");
            this.htmlExport.getHtmlWriter().writeLine(".dtree a {color: #333;text-decoration: none;}");
            this.htmlExport.getHtmlWriter().writeLine(".dtree a.node, .dtree a.nodeSel {white-space: nowrap;padding: 1px 2px 1px 2px;}");
            this.htmlExport.getHtmlWriter().writeLine(".dtree a.node:hover, .dtree a.nodeSel:hover {color: #333;text-decoration: underline;}");
            this.htmlExport.getHtmlWriter().writeLine(".dtree a.nodeSel {background-color: #c0d2ec;}");
            this.htmlExport.getHtmlWriter().writeLine(".dtree .clip {overflow: hidden;}");
            this.htmlExport.getHtmlWriter().writeLine(".dtreeframe {border-right:1px;border-right-style:solid;border-right-color:Gray;}");
        }
        this.htmlExport.getHtmlWriter().writeLine("</style>");
    }

    public void renderStylesTable(boolean useBookmarks, boolean exportBookmarksOnly) throws IOException {
        this.renderStylesTable(useBookmarks, exportBookmarksOnly, null);
    }

    public void renderStylesTable(boolean useBookmarks, boolean exportBookmarksOnly, boolean addStyleTag) throws IOException {
        this.renderStylesTable(useBookmarks, exportBookmarksOnly, addStyleTag, null);
    }

    public void renderStylesTable(boolean useBookmarks, boolean exportBookmarksOnly, Hashtable<String, String> cssStyles) throws IOException {
        this.renderStylesTable(useBookmarks, exportBookmarksOnly, true, cssStyles);
    }

    public void renderStylesTable(boolean useBookmarks, boolean exportBookmarksOnly, boolean addStyleTag, Hashtable<String, String> cssStyles) throws IOException {
        this.renderStylesTable(useBookmarks, exportBookmarksOnly, addStyleTag, cssStyles, "");
    }

    public void renderStylesTable(boolean useBookmarks, boolean exportBookmarksOnly, boolean addStyleTag, Hashtable<String, String> cssStyles, String prefix) throws IOException {
        if (addStyleTag) {
            this.htmlExport.getHtmlWriter().writeLine("<style type=\"text/css\">");
        }
        if (!exportBookmarksOnly && this.htmlExport.isUseStylesTable()) {
            for (int index = 0; index < this.matrix.getStyles().size(); ++index) {
                StiCellStyle style = this.matrix.getStyles().get(index);
                this.htmlExport.getHtmlWriter().write(prefix + ".s" + style.getStyleName());
                this.htmlExport.getHtmlWriter().write("{");
                this.renderStyleTable(null, style);
                this.htmlExport.getHtmlWriter().writeLine("}");
            }
        }
        if (cssStyles != null && cssStyles.size() > 0) {
            for (String key : cssStyles.keySet()) {
                this.htmlExport.getHtmlWriter().writeLine(prefix + "." + key + " {" + cssStyles.get(key) + ";}");
            }
        }
        if (useBookmarks) {
            this.htmlExport.getHtmlWriter().writeLine(prefix + ".dtree {font-family: Verdana, Geneva, Arial, Helvetica, sans-serif;font-size:11px;color:#666;white-space:nowrap;}");
            this.htmlExport.getHtmlWriter().writeLine(prefix + ".dtree img {border: 0px;vertical-align: middle;}");
            this.htmlExport.getHtmlWriter().writeLine(prefix + ".dtree a {color: #333;text-decoration: none;}");
            this.htmlExport.getHtmlWriter().writeLine(prefix + ".dtree a.node, .dtree a.nodeSel {white-space: nowrap;padding: 1px 2px 1px 2px;}");
            this.htmlExport.getHtmlWriter().writeLine(prefix + ".dtree a.node:hover, .dtree a.nodeSel:hover {color: #333;text-decoration: underline;}");
            this.htmlExport.getHtmlWriter().writeLine(prefix + ".dtree a.nodeSel {background-color: #c0d2ec;}");
            this.htmlExport.getHtmlWriter().writeLine(prefix + ".dtree .clip {overflow: hidden;}");
            this.htmlExport.getHtmlWriter().writeLine(prefix + ".dtreeframe {border-right:1px;border-right-style:solid;border-right-color:Gray;}");
        }
        if (addStyleTag) {
            this.htmlExport.getHtmlWriter().writeLine("</style>");
        }
    }

    private double getWidth(List<Double> listX, int columnIndex, double zoom) {
        return (listX.get(columnIndex + 1) - listX.get(columnIndex)) * zoom;
    }

    private double getHeight(List<Double> listY, int rowIndex, double zoom) {
        return (listY.get(rowIndex + 1) - listY.get(rowIndex)) * zoom;
    }

    public void renderTable(boolean renderStyles, String backGroundImageString, boolean useBookmarks, boolean exportBookmarksOnly, Hashtable<String, String> cssStyles) throws Exception {
        if (renderStyles) {
            this.renderStylesTable(useBookmarks, exportBookmarksOnly, cssStyles);
        }
        StiHtmlTable table = new StiHtmlTable();
        table.setAlign(this.htmlExport.getPageHorAlignment());
        table.setBackImageUrl(backGroundImageString);
        table.setWidth(StiHtmlUnit.pixel((int)Math.round(this.matrix.getTotalWidth() * this.htmlExport.getZoom())));
        table.setBorderWidth(0);
        table.setCellPadding(0);
        table.setCellSpacing(0);
        ArrayList<Double> listX = new ArrayList<Double>(this.matrix.getCoordX().values());
        ArrayList<Double> listY = new ArrayList<Double>(this.matrix.getCoordY().values());
        boolean[][] lines = new boolean[this.matrix.getCoordX().size()][this.matrix.getCoordY().size()];
        Hashtable<StiCellStyle, Integer> hashStyles = new Hashtable<StiCellStyle, Integer>();
        for (StiCellStyle hashStyle : this.matrix.getStyles()) {
            hashStyles.put(hashStyle, this.matrix.getStyles().indexOf(hashStyle));
        }
        this.htmlExport.setStatusString(StiLocalization.getValue((String)"Export", (String)"ExportingCreatingDocument"));
        StiPage prevPage = null;
        for (int rowIndex = 0; rowIndex < this.matrix.getCoordY().size() - 1; ++rowIndex) {
            this.htmlExport.invokeExporting(rowIndex, this.matrix.getCoordY().size());
            if (this.htmlExport.isStoped()) {
                return;
            }
            double rowHeight = this.getHeight(listY, rowIndex, this.htmlExport.getZoom());
            StiHtmlTableRow row = new StiHtmlTableRow();
            row.setHeight(StiHtmlUnit.pixel(rowHeight));
            table.getRows().add(row);
            for (int columnIndex = 0; columnIndex < this.matrix.getCoordX().size() - 1; ++columnIndex) {
                StiCellStyle cellStyle;
                if (lines[columnIndex][rowIndex]) continue;
                StiHtmlTableCell cell = new StiHtmlTableCell();
                row.getCells().add(cell);
                double width = this.getWidth(listX, columnIndex, this.htmlExport.getZoom());
                double height = this.getHeight(listY, rowIndex, this.htmlExport.getZoom());
                StiCell matrixCell = this.matrix.getCells()[rowIndex][columnIndex];
                if (matrixCell != null) {
                    StiText text;
                    StiColor color;
                    String sTag;
                    StiCellStyle cellStyle2;
                    if (this.htmlExportSettings.isAddPageBreaks()) {
                        if (matrixCell.getComponent() != null && matrixCell.getComponent().getPage() != prevPage && prevPage != null) {
                            row.getStyle().put("page-break-before", "always");
                        }
                        prevPage = matrixCell.getComponent().getPage();
                    }
                    String cellText = matrixCell.getText() != null ? matrixCell.getText() : "";
                    boolean flag = true;
                    if (matrixCell.getComponent() != null) {
                        StiText stiText = null;
                        if (matrixCell.getComponent() instanceof StiText && ((StiText)matrixCell.getComponent()).getAllowHtmlTags()) {
                            stiText = (StiText)matrixCell.getComponent();
                            cellText = StiHtmlExportService.convertTextWithHtmlTagsToHtmlText(stiText, cellText, this.htmlExport.getZoom());
                            flag = false;
                        }
                    }
                    if (ExportOptions.Html.getReplaceSpecialCharacters() && flag) {
                        cellText = cellText.replace("&", "&amp;").replace("\"", "&quot;").replace("<", "&lt;").replace(">", "&gt;").replace("\\xA0", "&nbsp;");
                    }
                    if (ExportOptions.Html.isPreserveWhiteSpaces() && !StiValidationUtil.isNullOrWhiteSpace((String)cellText) && cellText.contains("  ")) {
                        cell.getStyle().put("white-space", "pre-wrap");
                        cellText = this.htmlExport.prepareTextForHtml(cellText, false);
                    } else {
                        cellText = this.htmlExport.prepareTextForHtml(cellText, true);
                    }
                    IStiTextOptions textOptions = null;
                    if (matrixCell.getComponent() instanceof IStiTextOptions && ExportOptions.Html.getConvertDigitsToArabic() && ((IStiTextOptions)((Object)matrixCell.getComponent())).getTextOptions().getRightToLeft()) {
                        textOptions = (IStiTextOptions)((Object)matrixCell.getComponent());
                        cellText = StiBidirectionalConvert.convertDigitsToArabic((String)cellText, (StiArabicDigitsType)ExportOptions.Html.getArabicDigitsType());
                    }
                    int colSpan = matrixCell.getWidth() + 1;
                    int rowSpan = matrixCell.getHeight() + 1;
                    for (int cIndex = columnIndex; cIndex < columnIndex + colSpan; ++cIndex) {
                        for (int rIndex = rowIndex; rIndex < rowIndex + rowSpan; ++rIndex) {
                            lines[cIndex][rIndex] = true;
                        }
                    }
                    if (colSpan > 1) {
                        cell.setColumnSpan(colSpan);
                    }
                    if (rowSpan > 1) {
                        cell.setRowSpan(rowSpan);
                    }
                    if ((cellStyle2 = this.matrix.getCellStyles()[rowIndex][columnIndex]) == null) {
                        cellStyle2 = matrixCell.getCellStyle();
                    }
                    if (cellStyle2 != null) {
                        if (hashStyles.containsKey(cellStyle2) && this.htmlExport.isUseStylesTable()) {
                            cell.setCssClass("s" + cellStyle2.getStyleName());
                        }
                        if (ExportOptions.Html.isUseStrictTableCellSize()) {
                            if (cellStyle2.getVertAlignment() != StiVertAlignment.Top) {
                                cell.getStyle().put("div:vertical-align", cellStyle2.getVertAlignment() == StiVertAlignment.Center ? "middle" : "bottom");
                            }
                            boolean rightToLeft = cellStyle2.getTextOptions() != null && cellStyle2.getTextOptions().getRightToLeft();
                            String textAlign = null;
                            if (cellStyle2.getHorAlignment() == StiTextHorAlignment.Left) {
                                String string = textAlign = !rightToLeft ? null : "right";
                            }
                            if (cellStyle2.getHorAlignment() == StiTextHorAlignment.Right) {
                                String string = textAlign = rightToLeft ? null : "right";
                            }
                            if (cellStyle2.getHorAlignment() == StiTextHorAlignment.Center) {
                                textAlign = "center";
                            }
                            if (cellStyle2.getHorAlignment() == StiTextHorAlignment.Width) {
                                textAlign = "justify";
                            }
                            if (textAlign != null) {
                                cell.getStyle().put("div:text-align", textAlign);
                            }
                        }
                    }
                    if (matrixCell.getComponent() != null && (sTag = matrixCell.getComponent().getTagStrValue()) != null && sTag.length() > 0) {
                        String[] sTagArray = StiMatrix.splitTag(sTag);
                        for (int index = 0; index < sTagArray.length; ++index) {
                            String[] stArr;
                            if (!sTagArray[index].toLowerCase().startsWith("css") || (stArr = StiMatrix.getStringsFromTag(sTagArray[index], 3)).length <= 1 || !this.htmlExport.isUseStylesTable()) continue;
                            cell.setCssClass(stArr[0].trim());
                            break;
                        }
                    }
                    if (!this.htmlExport.isUseStylesTable()) {
                        this.renderStyleTable(cell, cellStyle2);
                    }
                    if (this.htmlExport.getExportQuality() == StiHtmlExportQuality.High) {
                        if (ExportOptions.Html.getForceIE6Compatibility()) {
                            if (colSpan == 1) {
                                cell.setWidth(StiHtmlUnit.pixel((int)width));
                            }
                            if (rowSpan == 1) {
                                cell.setHeight(StiHtmlUnit.pixel((int)height));
                            }
                        } else {
                            if (colSpan > 1) {
                                for (int indexColSpan = 1; indexColSpan < colSpan; ++indexColSpan) {
                                    width += this.getWidth(listX, columnIndex + indexColSpan, this.htmlExport.getZoom());
                                }
                            }
                            if (rowSpan > 1) {
                                for (int indexRowSpan = 1; indexRowSpan < rowSpan; ++indexRowSpan) {
                                    height += this.getHeight(listY, rowIndex + indexRowSpan, this.htmlExport.getZoom());
                                }
                            }
                            cell.setWidth(StiHtmlUnit.pixel((int)width));
                            cell.setHeight(StiHtmlUnit.pixel((int)height));
                            if (ExportOptions.Html.useStrictTableCellSizeV2 && cellText.length() > 3) {
                                cell.getStyle().put("max-width", cell.getWidth().toString());
                                cell.getStyle().put("max-height", cell.getHeight().toString());
                            }
                        }
                    }
                    if (this.htmlExport.isRenderWebInteractions() && matrixCell.getComponent() != null && (this.matrix.isComponentHasInteraction(matrixCell.getComponent()) || this.matrix.interactions[rowIndex][columnIndex][1] > 0)) {
                        StiBandInteraction bandInteraction;
                        StiComponent comp = matrixCell.getComponent();
                        if (!this.matrix.isComponentHasInteraction(comp)) {
                            StiPage page = this.htmlExport.getReport().getRenderedPages().get(this.matrix.interactions[rowIndex][columnIndex][0] - 1);
                            this.htmlExport.getReport().getRenderedPages().GetPage(page);
                            comp = (StiComponent)page.getComponents().get(this.matrix.interactions[rowIndex][columnIndex][1] - 1);
                        }
                        cell.setInteraction(comp.getName());
                        if (comp.getInteraction().getSortingEnabled()) {
                            String dataBandName = comp.getInteraction().GetSortDataBandName();
                            StiDataBand dataBand = (StiDataBand)comp.getReport().GetComponentByName(dataBandName);
                            if (dataBand != null) {
                                int i;
                                StringBuffer sb = new StringBuffer();
                                for (i = 0; i < dataBand.getSort().size(); ++i) {
                                    sb.append(dataBand.getSort().get(i));
                                    if (i == dataBand.getSort().size() - 1) continue;
                                    sb.append(";");
                                }
                                cell.setDataBandSort(dataBandName + ";" + sb.toString());
                                for (i = 0; i < dataBand.getSort().size(); i += 2) {
                                    if (!dataBand.getSort().get(i + 1).equals(comp.getInteraction().GetSortColumnsString())) continue;
                                    cell.setSortDirection(dataBand.getSort().get(i).toLowerCase());
                                }
                            }
                        }
                        if (comp.getInteraction().getDrillDownEnabled() && (comp.getInteraction().getDrillDownPage() != null || !StiValidationUtil.isNullOrEmpty((String)comp.getInteraction().getDrillDownReport()))) {
                            if (comp.getInteraction().getDrillDownPage() != null) {
                                cell.setPageGuid(comp.getInteraction().getDrillDownPage().getGuid());
                            }
                            if (!StiValidationUtil.isNullOrEmpty((String)comp.getInteraction().getDrillDownReport())) {
                                cell.reportFile = comp.getInteraction().getDrillDownReport();
                            }
                            cell.setPageIndex(String.valueOf(comp.getPage().getReport().getRenderedPages().indexOf(comp.getPage())));
                            cell.setComponentIndex(String.valueOf(comp.getPage().getComponents().indexOf(comp)));
                            cell.drillDownMode = comp.getInteraction().getDrillDownMode().toString();
                        }
                        StiBandInteraction stiBandInteraction = bandInteraction = comp.getInteraction() instanceof StiBandInteraction ? (StiBandInteraction)comp.getInteraction() : null;
                        if (bandInteraction != null && bandInteraction.getCollapsingEnabled() && comp instanceof StiContainer) {
                            StiContainer cont = (StiContainer)comp;
                            cell.setCollapsed(String.valueOf(StiDataBandV2Builder.IsCollapsed(cont, false)).toLowerCase());
                            cell.setComponentIndex(String.valueOf(cont.getCollapsingIndex()));
                        }
                    }
                    String hyperlinkValue = null;
                    String tooltipValue = null;
                    String bookmarkValue = null;
                    String bookmarkGuid = null;
                    IStiExportImage exportImage = matrixCell.getExportImage();
                    boolean isChart = false;
                    boolean isGauge = false;
                    boolean isMap = false;
                    if (matrixCell.getComponent() != null) {
                        IStiEditable editable;
                        StiMap map;
                        StiGauge gauge;
                        StiChart chart;
                        hyperlinkValue = matrixCell.getComponent().getHyperlinkValue();
                        tooltipValue = matrixCell.getComponent().getToolTipValue();
                        bookmarkValue = matrixCell.getComponent().getBookmarkValue();
                        if (!StiValidationUtil.isNullOrEmpty((String)hyperlinkValue) && (hyperlinkValue = hyperlinkValue.trim()).startsWith("javascript:")) {
                            hyperlinkValue = null;
                        }
                        if (!StiValidationUtil.isNullOrWhiteSpace((String)hyperlinkValue) && hyperlinkValue.startsWith("##")) {
                            hyperlinkValue = hyperlinkValue.substring(1);
                        }
                        if (bookmarkValue == null || bookmarkValue.length() == 0) {
                            for (int yy = 0; yy <= matrixCell.getHeight(); ++yy) {
                                boolean breakLoop = false;
                                for (int xx = 0; xx <= matrixCell.getWidth(); ++xx) {
                                    String bkm = this.matrix.getBookmarks()[rowIndex + yy][columnIndex + xx];
                                    if (bkm == null || bkm.length() <= 0) continue;
                                    bookmarkValue = bkm;
                                    breakLoop = true;
                                    break;
                                }
                                if (breakLoop) break;
                            }
                        }
                        if (!StiValidationUtil.isNullOrEmpty((String)matrixCell.getComponent().getGuid()) && this.htmlExport.hashBookmarkGuid.containsKey(matrixCell.getComponent().getGuid())) {
                            bookmarkGuid = matrixCell.getComponent().getGuid();
                        }
                        if (ExportOptions.Html.isAllowStrippedImages() && exportImage == null) {
                            IStiExportImage exp;
                            IStiExportImage iStiExportImage = exp = matrixCell.getComponent() instanceof IStiExportImage ? (IStiExportImage)((Object)matrixCell.getComponent()) : null;
                            if (exp != null && exp instanceof IStiExportImageExtended && ((IStiExportImageExtended)exp).isExportAsImage(StiExportFormat.HtmlTable) && (textOptions == null || textOptions.getTextOptions().getAngle() == 0.0f)) {
                                exportImage = exp;
                            }
                        }
                        StiChart stiChart = chart = matrixCell.getComponent() instanceof StiChart ? (StiChart)matrixCell.getComponent() : null;
                        if (chart != null && this.htmlExport.chartType != StiHtmlChartType.Image) {
                            isChart = true;
                        }
                        StiGauge stiGauge = gauge = matrixCell.getComponent() instanceof StiGauge ? (StiGauge)matrixCell.getComponent() : null;
                        if (gauge != null && this.htmlExport.chartType != StiHtmlChartType.Image) {
                            isGauge = true;
                        }
                        StiMap stiMap = map = matrixCell.getComponent() instanceof StiMap ? (StiMap)matrixCell.getComponent() : null;
                        if (map != null && this.htmlExport.chartType != StiHtmlChartType.Image) {
                            isMap = true;
                        }
                        IStiEditable iStiEditable = editable = matrixCell.getComponent() instanceof IStiEditable ? (IStiEditable)((Object)matrixCell.getComponent()) : null;
                        if (editable != null && editable.getEditable()) {
                            StiRichText richTextBox;
                            StiText textBox;
                            StiCheckBox checkBox;
                            StringBuilder attr = new StringBuilder();
                            int editableIndex = matrixCell.getComponent().getPage().getComponents().indexOf(matrixCell.getComponent());
                            attr.append(editableIndex + ";");
                            StiCheckBox stiCheckBox = checkBox = matrixCell.getComponent() instanceof StiCheckBox ? (StiCheckBox)matrixCell.getComponent() : null;
                            if (checkBox != null) {
                                StiColor backColor = StiColorEnum.Transparent.color();
                                if (checkBox.getTextBrush() instanceof StiSolidBrush) {
                                    backColor = ((StiSolidBrush)checkBox.getTextBrush()).getColor();
                                } else if (checkBox.getTextBrush() instanceof StiGradientBrush) {
                                    backColor = ((StiGradientBrush)checkBox.getTextBrush()).getStartColor();
                                } else if (checkBox.getTextBrush() instanceof StiGlareBrush) {
                                    backColor = ((StiGlareBrush)checkBox.getTextBrush()).getStartColor();
                                } else if (checkBox.getTextBrush() instanceof StiGlassBrush) {
                                    backColor = ((StiGlassBrush)checkBox.getTextBrush()).getColor();
                                } else if (checkBox.getTextBrush() instanceof StiHatchBrush) {
                                    backColor = ((StiHatchBrush)checkBox.getTextBrush()).getForeColor();
                                }
                                attr.append(String.format("CheckBox;%s;%s;%s;%s;%s;%s", checkBox.getCheckedValue(), checkBox.getCheckStyleForFalse().toString(), checkBox.getCheckStyleForTrue().toString(), checkBox.getContourColor().toHTML(), checkBox.getSize(), backColor.toHTML()));
                            }
                            StiText stiText = textBox = matrixCell.getComponent() instanceof StiText ? (StiText)matrixCell.getComponent() : null;
                            if (textBox != null) {
                                attr.append("Text");
                            }
                            StiRichText stiRichText = richTextBox = matrixCell.getComponent() instanceof StiRichText ? (StiRichText)matrixCell.getComponent() : null;
                            if (richTextBox != null) {
                                attr.append("RichText");
                            }
                            cell.setEditable(attr.toString());
                        }
                        if (exportImage == null) {
                            StiContainer cont;
                            StiText stiText;
                            StiGradientBrush grb = null;
                            StiGlareBrush glb = null;
                            StiGlassBrush gsb = null;
                            StiText stiText2 = stiText = matrixCell.getComponent() instanceof StiText ? (StiText)matrixCell.getComponent() : null;
                            if (stiText != null) {
                                if (stiText.getBrush() instanceof StiGradientBrush) {
                                    grb = (StiGradientBrush)stiText.getBrush();
                                }
                                if (stiText.getBrush() instanceof StiGlareBrush) {
                                    glb = (StiGlareBrush)stiText.getBrush();
                                }
                                if (stiText.getBrush() instanceof StiGlassBrush) {
                                    gsb = (StiGlassBrush)stiText.getBrush();
                                }
                            }
                            StiContainer stiContainer = cont = matrixCell.getComponent() instanceof StiContainer ? (StiContainer)matrixCell.getComponent() : null;
                            if (cont != null) {
                                if (cont.getBrush() instanceof StiGradientBrush) {
                                    grb = (StiGradientBrush)cont.getBrush();
                                }
                                if (cont.getBrush() instanceof StiGlareBrush) {
                                    glb = (StiGlareBrush)cont.getBrush();
                                }
                                if (cont.getBrush() instanceof StiGlassBrush) {
                                    gsb = (StiGlassBrush)cont.getBrush();
                                }
                            }
                            if (grb != null || glb != null) {
                                StiRectangle rectt;
                                String stAngle;
                                String backgroundStyle = "";
                                if (grb != null) {
                                    stAngle = Math.round(grb.getAngle()) + 90L + "deg";
                                    backgroundStyle = "linear-gradient(" + stAngle + ", " + grb.getStartColor().toHTML() + ", " + grb.getEndColor().toHTML() + ")";
                                }
                                if (glb != null) {
                                    stAngle = Math.round(glb.angle) + 90L + "deg";
                                    backgroundStyle = "linear-gradient(" + stAngle + ", " + glb.getStartColor().toHTML() + ", " + glb.getEndColor().toHTML() + "  " + Math.round(glb.getFocus() * 100.0f) + "%, " + glb.getStartColor().toHTML() + ")";
                                }
                                if ((rectt = this.matrix.getRange(this.htmlExport.getReport().getUnit().ConvertToHInches(matrixCell.getComponent().getClientRectangle()))).getTop() != -1.0) {
                                    boolean hasTopDiff;
                                    boolean hasLeftDiff = (double)matrixCell.getLeft() != rectt.getLeft();
                                    boolean bl = hasTopDiff = (double)matrixCell.getTop() != rectt.getTop();
                                    if (hasLeftDiff || hasTopDiff) {
                                        double leftDiff = ((Double)listX.get((int)rectt.getLeft()) - (Double)listX.get(columnIndex)) * this.htmlExport.getZoom();
                                        double topDiff = ((Double)listY.get((int)rectt.getTop()) - (Double)listY.get(rowIndex)) * this.htmlExport.getZoom();
                                        backgroundStyle = backgroundStyle + " " + StiHtmlUnit.newUnit(leftDiff, false) + " " + StiHtmlUnit.newUnit(topDiff, false);
                                    }
                                    if (rectt.width != (double)(matrixCell.getWidth() + 1) || rectt.height != (double)(matrixCell.getHeight() + 1)) {
                                        double componentWidth = ((Double)listX.get((int)rectt.getRight()) - (Double)listX.get((int)rectt.getLeft())) * this.htmlExport.getZoom();
                                        double componentHeight = ((Double)listY.get((int)rectt.getBottom()) - (Double)listY.get((int)rectt.getTop())) * this.htmlExport.getZoom();
                                        backgroundStyle = backgroundStyle + "; background-size: " + StiHtmlUnit.newUnit(componentWidth, false) + " " + StiHtmlUnit.newUnit(componentHeight, false);
                                    }
                                }
                                cell.getStyle().put("background", backgroundStyle);
                            }
                            if (gsb != null) {
                                cell.getStyle().put("background", "linear-gradient(" + gsb.getTopColor().toHTML() + ", " + gsb.getTopColor().toHTML() + " 49%, " + gsb.getBottomColor().toHTML() + " 50%, " + gsb.getBottomColor().toHTML() + " );");
                            }
                        }
                    }
                    boolean notImageProcessed = true;
                    if (!StiValidationUtil.isNullOrWhiteSpace(bookmarkValue) || !StiValidationUtil.isNullOrWhiteSpace(bookmarkGuid)) {
                        StiHtmlHyperlink bookmark = new StiHtmlHyperlink();
                        if (!StiValidationUtil.isNullOrWhiteSpace(bookmarkValue)) {
                            bookmark.getAttributes().put("name", bookmarkValue.replaceAll("'", ""));
                        }
                        if (!StiValidationUtil.isNullOrWhiteSpace(bookmarkGuid)) {
                            bookmark.getAttributes().put("guid", bookmarkGuid);
                        }
                        bookmark.setToolTip(tooltipValue);
                        bookmark.setNavigateUrl(hyperlinkValue);
                        if (isChart) {
                            cell.id = this.htmlExport.getGuid(matrixCell.getComponent());
                            cell.setText(this.htmlExport.prepareChartData(null, (StiChart)matrixCell.getComponent(), width, height));
                        } else if (isGauge) {
                            cell.id = this.htmlExport.getGuid(matrixCell.getComponent());
                            cell.setText(this.htmlExport.prepareGaugeData(null, (StiGauge)matrixCell.getComponent(), width, height));
                        } else if (isMap) {
                            cell.id = this.htmlExport.getGuid(matrixCell.getComponent());
                            cell.setText(this.htmlExport.prepareMapData(null, (StiMap)matrixCell.getComponent(), width, height));
                        } else if (exportImage != null) {
                            double zoom = (float)this.htmlExport.getZoom();
                            float resolution = this.htmlExport.getImageResolution();
                            if (!ExportOptions.Html.getUseImageResolution() || !(exportImage instanceof StiImage) || ((StiImage)matrixCell.getExportImage()).getImageBytesToDraw() != null) {
                                // empty if block
                            }
                            if (resolution != 100.0f) {
                                zoom *= (double)(resolution / 100.0f);
                            }
                            BufferedImage image = null;
                            IStiExportImageExtended exportImageExtended = (IStiExportImageExtended)exportImage;
                            image = exportImageExtended != null && exportImageExtended.isExportAsImage(StiExportFormat.Html) ? exportImageExtended.getImage(zoom, StiExportFormat.HtmlTable) : exportImage.getImage(zoom);
                            if (image != null) {
                                BufferedImage imgPart = this.matrix.getRealImageData(matrixCell, image);
                                if (imgPart != null) {
                                    image = imgPart;
                                }
                                if (hyperlinkValue != null && hyperlinkValue.length() > 0) {
                                    StiHtmlHyperlink hyperlink = new StiHtmlHyperlink();
                                    hyperlink.setNavigateUrl(hyperlinkValue);
                                    hyperlink.setToolTip(tooltipValue);
                                    if (this.htmlExport.getHtmlImageHost() != null) {
                                        hyperlink.setImageUrl(this.htmlExport.getHtmlImageHost().getImageString(image));
                                    }
                                    hyperlink.setCssClass(cell.getCssClass());
                                    hyperlink.setWidth(StiHtmlUnit.pixel((double)image.getWidth() / zoom * this.htmlExport.getZoom() / 2.0));
                                    hyperlink.setHeight(StiHtmlUnit.pixel((double)image.getHeight() / zoom * this.htmlExport.getZoom() / 2.0));
                                    hyperlink.setOpenLinksTarget(this.htmlExport.openLinksTarget);
                                    cell.getControls().add(hyperlink);
                                } else {
                                    StiImage imageComponent;
                                    String imageURLStr = null;
                                    if (matrixCell.getComponent() != null && matrixCell.getComponent() instanceof StiImage && (imageComponent = (StiImage)matrixCell.getComponent()).getStretch() && !imageComponent.getAspectRatio() && imageComponent.getImageRotation() == StiImageRotation.None) {
                                        imageURLStr = (String)imageComponent.getImageURLValue();
                                    }
                                    StiHtmlImage img = new StiHtmlImage();
                                    if (imageURLStr != null && imageURLStr.length() != 0) {
                                        img.setImageUrl(imageURLStr);
                                    } else if (this.htmlExport.getHtmlImageHost() != null) {
                                        img.setImageUrl(this.htmlExport.getHtmlImageHost().getImageString(image));
                                    }
                                    img.setToolTip(tooltipValue);
                                    img.setWidth(StiHtmlUnit.pixel((double)image.getWidth() / zoom * this.htmlExport.getZoom() / 2.0));
                                    img.setHeight(StiHtmlUnit.pixel((double)image.getHeight() / zoom * this.htmlExport.getZoom() / 2.0));
                                    cell.getControls().add(img);
                                }
                                notImageProcessed = false;
                            }
                        }
                        if (notImageProcessed && !isChart) {
                            bookmark.setText(cellText);
                            if (matrixCell.getComponent() != null && matrixCell.getComponent() instanceof IStiTextBrush) {
                                IStiTextBrush textBrush = (IStiTextBrush)((Object)matrixCell.getComponent());
                                color = StiBrush.ToColor((StiBrush)textBrush.getTextBrush());
                                bookmark.getStyle().put("color", this.htmlExport.formatColor(color));
                            }
                            if (matrixCell.getComponent() != null && matrixCell.getComponent() instanceof IStiFont) {
                                IStiFont font = (IStiFont)((Object)matrixCell.getComponent());
                                if (font.getFont().underline()) {
                                    bookmark.getStyle().put("text-decoration", "underline");
                                } else if (font.getFont().strikeout()) {
                                    bookmark.getStyle().put("text-decoration", "line-through");
                                } else {
                                    bookmark.getStyle().put("text-decoration", "none");
                                }
                            }
                        }
                        cell.getControls().add(bookmark);
                    } else if (isChart) {
                        if (!StiValidationUtil.isNullOrEmpty((String)hyperlinkValue)) {
                            StiHtmlHyperlink hyperlink = new StiHtmlHyperlink();
                            hyperlink.setToolTip(tooltipValue);
                            hyperlink.setNavigateUrl(hyperlinkValue);
                            hyperlink.setOpenLinksTarget(this.htmlExport.openLinksTarget);
                            hyperlink.getStyle().put("display", "block");
                            cell.getControls().add(hyperlink);
                        } else {
                            cell.setToolTip(tooltipValue);
                        }
                        cell.id = this.htmlExport.getGuid(matrixCell.getComponent());
                        cell.setText(this.htmlExport.prepareChartData(null, (StiChart)matrixCell.getComponent(), width, height));
                    } else if (isGauge) {
                        cell.id = this.htmlExport.getGuid(matrixCell.getComponent());
                        cell.setText(this.htmlExport.prepareGaugeData(null, (StiGauge)matrixCell.getComponent(), width, height));
                    } else if (isMap) {
                        cell.id = this.htmlExport.getGuid(matrixCell.getComponent());
                        cell.setText(this.htmlExport.prepareMapData(null, (StiMap)matrixCell.getComponent(), width, height));
                    } else if (exportImage == null) {
                        if (hyperlinkValue != null && hyperlinkValue.length() > 0) {
                            StiHtmlHyperlink hyperlink = new StiHtmlHyperlink();
                            hyperlink.setText(cellText);
                            hyperlink.setToolTip(tooltipValue);
                            hyperlink.setNavigateUrl(hyperlinkValue);
                            hyperlink.setOpenLinksTarget(this.htmlExport.openLinksTarget);
                            hyperlink.getStyle().put("display", "block");
                            if (matrixCell.getComponent() != null && matrixCell.getComponent() instanceof IStiTextBrush) {
                                IStiTextBrush textBrush = (IStiTextBrush)((Object)matrixCell.getComponent());
                                color = StiBrush.ToColor((StiBrush)textBrush.getTextBrush());
                                hyperlink.getStyle().put("color", this.htmlExport.formatColor(color));
                            }
                            if (matrixCell.getComponent() != null && matrixCell.getComponent() instanceof IStiFont) {
                                IStiFont font = (IStiFont)((Object)matrixCell.getComponent());
                                if (font.getFont().underline()) {
                                    hyperlink.getStyle().put("text-decoration", "underline");
                                } else if (font.getFont().strikeout()) {
                                    hyperlink.getStyle().put("text-decoration", "line-through");
                                } else {
                                    hyperlink.getStyle().put("text-decoration", "none");
                                }
                            }
                            cell.getControls().add(hyperlink);
                        } else {
                            StiText stiText;
                            if (matrixCell.getComponent() != null && ExportOptions.Html.getForceWysiwygWordwrap() && matrixCell.getComponent() instanceof StiText && !(stiText = (StiText)matrixCell.getComponent()).getAllowHtmlTags() && stiText.getTextQuality() == StiTextQuality.Wysiwyg && textOptions != null && textOptions.getTextOptions().getWordWrap()) {
                                List<StiLineInfo> newTextLines = StiTextRenderer.getTextLines(cellText, stiText.getFont(), this.htmlExport.getReport().convertToHInches(this.htmlExport.getReport().getUnit(), matrixCell.getComponent().ComponentToPage(matrixCell.getComponent().getClientRectangle())), textOptions.getTextOptions().getWordWrap());
                                StringBuilder sb = new StringBuilder();
                                for (int index = 0; index < newTextLines.size(); ++index) {
                                    String st = newTextLines.get(index).getText();
                                    sb.append(st);
                                    if (index >= newTextLines.size() - 1) continue;
                                    sb.append("\n");
                                }
                                cellText = sb.toString();
                            }
                            cell.setText(cellText);
                            cell.setToolTip(tooltipValue);
                        }
                    } else {
                        double zoom = this.htmlExport.getZoom();
                        float resolution = this.htmlExport.getImageResolution();
                        if (!ExportOptions.Html.getUseImageResolution() || !(exportImage instanceof StiImage) || ((StiImage)exportImage).getImageBytesToDraw() != null) {
                            // empty if block
                        }
                        if (resolution != 100.0f) {
                            zoom *= (double)(resolution / 100.0f);
                        }
                        BufferedImage image = null;
                        IStiExportImageExtended exportImageExtended = (IStiExportImageExtended)exportImage;
                        image = exportImageExtended != null && exportImageExtended.isExportAsImage(StiExportFormat.Html) ? exportImageExtended.getImage(zoom, StiExportFormat.HtmlTable) : exportImage.getImage(zoom);
                        if (image != null) {
                            BufferedImage imgPart = this.matrix.getRealImageData(matrixCell, image);
                            if (imgPart != null) {
                                image = imgPart;
                            }
                            if (hyperlinkValue != null && hyperlinkValue.length() > 0) {
                                StiHtmlHyperlink hyperlink = new StiHtmlHyperlink();
                                hyperlink.setNavigateUrl(hyperlinkValue);
                                hyperlink.setToolTip(tooltipValue);
                                if (this.htmlExport.getHtmlImageHost() != null) {
                                    hyperlink.setImageUrl(this.htmlExport.getHtmlImageHost().getImageString(image));
                                }
                                hyperlink.setCssClass(cell.getCssClass());
                                hyperlink.setWidth(StiHtmlUnit.pixel((int)((double)image.getWidth() / zoom * this.htmlExport.getZoom())));
                                hyperlink.setHeight(StiHtmlUnit.pixel((int)((double)image.getHeight() / zoom * this.htmlExport.getZoom())));
                                cell.getControls().add(hyperlink);
                            } else {
                                StiShape shape;
                                String stTemp;
                                StiImage imageComponent;
                                String imageURLStr = null;
                                if (matrixCell.getComponent() != null && matrixCell.getComponent() instanceof StiImage && (imageComponent = (StiImage)matrixCell.getComponent()).getStretch() && !imageComponent.getAspectRatio() && imageComponent.getImageRotation() == StiImageRotation.None && !StiHyperlinkProcessor.isResourceHyperlink(stTemp = (String)imageComponent.getImageURLValue())) {
                                    imageURLStr = stTemp;
                                }
                                StiHtmlImage img = new StiHtmlImage();
                                if (imageURLStr != null && imageURLStr.length() != 0) {
                                    img.setImageUrl(imageURLStr);
                                } else if (this.htmlExport.getHtmlImageHost() != null) {
                                    img.setImageUrl(this.htmlExport.getHtmlImageHost().getImageString(image));
                                }
                                img.setToolTip(tooltipValue);
                                StiShape stiShape = shape = matrixCell.getComponent() instanceof StiShape ? (StiShape)matrixCell.getComponent() : null;
                                if (shape == null) {
                                    img.setWidth(StiHtmlUnit.pixel((int)((double)image.getWidth() / zoom * this.htmlExport.getZoom())));
                                    img.setHeight(StiHtmlUnit.pixel((int)((double)image.getHeight() / zoom * this.htmlExport.getZoom())));
                                    img.setUseImageSize(StiOptions.Engine.isBarcodeImproveQualityHtmlExport() && matrixCell.getComponent() instanceof StiBarCode);
                                } else {
                                    int shift = (int)Math.round(shape.getSize() * zoom / 2.0);
                                    img.setMargin(StiHtmlUnit.pixel(-shift));
                                    img.setWidth(StiHtmlUnit.pixel((int)(((double)image.getWidth() + shape.getSize() * zoom) / zoom * this.htmlExport.getZoom())));
                                    img.setHeight(StiHtmlUnit.pixel((int)(((double)image.getHeight() + shape.getSize() * zoom) / zoom * this.htmlExport.getZoom())));
                                    cell.getStyle().put("overflow", "visible");
                                }
                                cell.getControls().add(img);
                            }
                            notImageProcessed = false;
                        }
                    }
                    if (!(matrixCell.getComponent() instanceof StiText) || (text = (StiText)matrixCell.getComponent()).getMargins().isEmpty() || !notImageProcessed) continue;
                    cell.getStyle().put("padding", String.format("%s %s %s %s", StiHtmlUnit.pixel((int)text.getMargins().getTop()), StiHtmlUnit.pixel((int)text.getMargins().getRight()), StiHtmlUnit.pixel((int)text.getMargins().getBottom()), StiHtmlUnit.pixel((int)text.getMargins().getLeft())));
                    continue;
                }
                if (this.htmlExport.getExportQuality() == StiHtmlExportQuality.High) {
                    cell.setWidth(StiHtmlUnit.pixel((int)width));
                    cell.setHeight(StiHtmlUnit.pixel((int)height));
                }
                if ((cellStyle = this.matrix.getCellStyles()[rowIndex][columnIndex]) != null && hashStyles.containsKey(cellStyle) && this.htmlExport.isUseStylesTable()) {
                    cell.setCssClass("s" + cellStyle.getStyleName());
                }
                if (!StiValidationUtil.isNullOrEmpty((String)cell.getCssClass())) continue;
                cell.getStyle().put("border", "0px");
            }
        }
        table.renderControl(this.htmlExport.getHtmlWriter());
    }

    public StiMatrix getMatrix() {
        return this.matrix;
    }

    public void setMatrix(StiMatrix matrix) {
        this.matrix = matrix;
    }
}

