/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.export.tools;

import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiGraphicsHelper;
import com.stimulsoft.base.drawing.StiHtmlState;
import com.stimulsoft.base.drawing.StiHtmlTagsState;
import com.stimulsoft.base.drawing.StiLineInfo;
import com.stimulsoft.base.drawing.enums.StiTextHorAlignment;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.lib.utils.StiValidationUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class StiTextRenderer {
    public static double PrecisionModeFactor;
    public static boolean PrecisionModeEnabled;
    public static boolean CorrectionEnabled;
    public static String StiForceWidthAlignTag;
    private static Hashtable<String, StiColor> htmlNameToColor;
    private static Object lockHtmlNameToColor;
    private static Hashtable<String, Character> htmlEscapeSequence;
    private static boolean optimizeBottomMargin;
    private static boolean interpreteFontSizeInHtmlTagsAsInHtml;
    private static Hashtable OutlineTextMetricsCache;
    private static Object lockOutlineTextMetricsCache;
    private static String bulletBlack;
    private static String bulletWhite;

    public static List<StiLineInfo> getTextLines(String text, StiFont font, StiRectangle rect, Boolean wordWrap) {
        ArrayList<StiLineInfo> result = new ArrayList<StiLineInfo>();
        StiGraphicsHelper.GRAPHICS.drawAttributedString(text, font.getAwtFont(1.0), rect, Boolean.valueOf(false), wordWrap, StiTextHorAlignment.Left, 1.0f, Boolean.valueOf(false), result, Boolean.valueOf(false));
        return result;
    }

    private static StiHtmlState parseStyleAttribute(String style, StiHtmlState state) {
        String[] pairs;
        if (StiValidationUtil.isNullOrEmpty((String)style)) {
            return state;
        }
        for (String pair : pairs = style.split(";")) {
            String value;
            String[] parts = pair.split(":");
            boolean hasValue = parts.length > 1;
            String key = parts[0].trim();
            String string = value = hasValue ? parts[1].trim() : null;
            if ("color".equals(key)) {
                try {
                    state.getTs().fontColor = StiTextRenderer.parseColor(value);
                    state.getTs().colorChanged = true;
                }
                catch (Exception exception) {}
                continue;
            }
            if ("background-color".equals(key)) {
                try {
                    state.getTs().backColor = StiTextRenderer.parseColor(value);
                    state.getTs().backcolorChanged = true;
                }
                catch (Exception exception) {}
                continue;
            }
            if ("text-decoration".equals(key)) {
                if ("underline".equals(value)) {
                    state.getTs().underline = true;
                }
                if ("line-through".equals(value)) {
                    state.getTs().strikeout = true;
                }
                if (!"none".equals(value)) continue;
                state.getTs().underline = false;
                state.getTs().strikeout = false;
                continue;
            }
            if ("font-weight".equals(key)) {
                state.getTs().bold = "bold".equals(value) || "bolder".equals(value) || "600".equals(value) || "700".equals(value) || "800".equals(value) || "900".equals(value);
                continue;
            }
            if ("font-style".equals(key)) {
                if ("normal".equals(value)) {
                    state.getTs().italic = false;
                }
                if (!"italic".equals(value) && !"oblique".equals(value)) continue;
                state.getTs().italic = true;
                continue;
            }
            if ("vertical-align".equals(key)) {
                if ("baseline".equals(value)) {
                    state.getTs().subscript = false;
                    state.getTs().superscript = false;
                }
                if ("sub".equals(value)) {
                    state.getTs().subscript = true;
                    state.getTs().superscript = false;
                }
                if (!"super".equals(value)) continue;
                state.getTs().subscript = false;
                state.getTs().superscript = true;
                continue;
            }
            if ("letter-spacing".equals(key)) {
                double letterSpacing = 0.0;
                if (!"normal".equals(value)) {
                    try {
                        letterSpacing = Double.parseDouble(value.replace(',', '.'));
                    }
                    catch (Exception e) {
                        letterSpacing = 0.0;
                    }
                }
                state.getTs().letterSpacing = letterSpacing;
                continue;
            }
            if ("word-spacing".equals(key)) {
                double wordSpacing = 0.0;
                if ("normal".equals(value)) {
                    try {
                        wordSpacing = Double.parseDouble(value.replace(',', '.'));
                    }
                    catch (Exception e) {
                        wordSpacing = 0.0;
                    }
                }
                state.getTs().wordSpacing = wordSpacing;
                continue;
            }
            if ("line-height".equals(key)) {
                double lineHeight = 1.0;
                if (value != "normal") {
                    try {
                        lineHeight = Double.parseDouble(value.replace(',', '.'));
                    }
                    catch (Exception e) {
                        lineHeight = 1.0;
                    }
                }
                if (lineHeight <= 0.0) {
                    lineHeight = 1.0;
                }
                state.getTs().lineHeight = lineHeight;
                continue;
            }
            if (!"text-align".equals(key)) continue;
            String align = value.toLowerCase();
            if ("left".equals(align)) {
                state.getTs().textAlign = StiTextHorAlignment.Left;
            }
            if ("right".equals(align)) {
                state.getTs().textAlign = StiTextHorAlignment.Right;
            }
            if ("center".equals(align)) {
                state.getTs().textAlign = StiTextHorAlignment.Center;
            }
            if (!"justify".equals(align)) continue;
            state.getTs().textAlign = StiTextHorAlignment.Width;
        }
        return state;
    }

    private static String colorToHtml(StiColor color) {
        String colorSt = color.toHTML();
        if (color.getA() != 255) {
            colorSt = "#ttt";
        }
        return colorSt;
    }

    private static String stackToString(List<StiHtmlTagsState> stack) {
        if (stack == null || stack.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        try {
            for (int index = 0; index < stack.size(); ++index) {
                boolean first;
                StiHtmlTagsState state = stack.get(index);
                StiHtmlTagsState prevState = new StiHtmlTagsState();
                boolean bl = first = index == 0;
                if (!first) {
                    prevState = stack.get(index - 1);
                }
                if (state.isBackcolorChanged()) {
                    sb.append(String.format("bc%s:", state.backColor.toArgbHTML().substring(1)));
                }
                if (state.bold && (first || state.bold != prevState.bold)) {
                    sb.append("bd:");
                }
                if (state.isColorChanged()) {
                    sb.append(String.format("fc%s:", state.fontColor.toArgbHTML().substring(1)));
                }
                if (!(StiValidationUtil.isNullOrEmpty((String)state.fontName) || !first && state.fontName.equals(prevState.fontName))) {
                    sb.append(String.format("fn%s:", state.fontName));
                }
                if (first || state.fontSize != prevState.fontSize) {
                    sb.append(String.format("fs%s:", Float.valueOf(state.fontSize)));
                }
                if (state.italic && (first || state.italic != prevState.italic)) {
                    sb.append("it:");
                }
                if (first || state.letterSpacing != prevState.letterSpacing) {
                    sb.append(String.format("ls%s:", state.letterSpacing));
                }
                if (first || state.lineHeight != prevState.lineHeight) {
                    sb.append(String.format("lh%s:", state.lineHeight));
                }
                if (state.strikeout && (first || state.strikeout != prevState.strikeout)) {
                    sb.append("st:");
                }
                if (state.subscript && (first || state.subscript != prevState.subscript)) {
                    sb.append("sb:");
                }
                if (state.superscript && (first || state.superscript != prevState.superscript)) {
                    sb.append("sp:");
                }
                if (first || state.tag != prevState.tag) {
                    sb.append(String.format("tg%S:", state.tag));
                }
                if (first || state.textAlign != prevState.textAlign) {
                    sb.append(String.format("ta%s:", state.textAlign));
                }
                if (state.underline && (first || state.underline != prevState.underline)) {
                    sb.append("un:");
                }
                if (first || state.wordSpacing != prevState.wordSpacing) {
                    sb.append(String.format("ws%s:", state.wordSpacing));
                }
                if (sb.charAt(sb.length() - 1) == ':') {
                    sb.deleteCharAt(sb.length() - 1);
                }
                if (index >= stack.size() - 1) continue;
                sb.append(";");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }

    private static String listLevelsToString(List<Integer> list, int indent) {
        if (list == null || list.size() == 0) {
            list = new ArrayList<Integer>();
        }
        StringBuilder sb = new StringBuilder();
        try {
            for (int index = 0; index < indent; ++index) {
                if (index < list.size()) {
                    sb.append(list.get(index).toString());
                } else {
                    sb.append("0");
                }
                if (index >= indent - 1) continue;
                sb.append(";");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }

    public static StringBuilder prepareStateText(StringBuilder stateText) {
        StringBuilder sbTemp = new StringBuilder();
        int indexChar = 0;
        while (indexChar < stateText.length()) {
            boolean flag = false;
            if (stateText.charAt(indexChar) == '&' && indexChar + 3 < stateText.length()) {
                int indexChar2;
                StringBuilder sbTemp2 = new StringBuilder();
                if (stateText.charAt(indexChar2) == '#') {
                    ++indexChar2;
                    while (indexChar2 < stateText.length() && Character.isDigit(stateText.charAt(indexChar2))) {
                        sbTemp2.append(stateText.charAt(indexChar2));
                        ++indexChar2;
                    }
                    if (sbTemp2.length() > 0 && indexChar2 < stateText.length() && stateText.charAt(indexChar2) == ';') {
                        sbTemp.append((char)Integer.parseInt(sbTemp2.toString()));
                        indexChar = ++indexChar2;
                        flag = true;
                    }
                } else {
                    Character es;
                    for (indexChar2 = indexChar + 1; indexChar2 < stateText.length() && Character.isLetterOrDigit(stateText.charAt(indexChar2)); ++indexChar2) {
                        sbTemp2.append(stateText.charAt(indexChar2));
                    }
                    if (sbTemp2.length() > 0 && indexChar2 < stateText.length() && stateText.charAt(indexChar2) == ';' && (es = htmlEscapeSequence.get("&" + sbTemp2 + ";")) != null) {
                        sbTemp.append(es.charValue());
                        indexChar = ++indexChar2;
                        flag = true;
                    }
                }
            }
            if (flag) continue;
            sbTemp.append(stateText.charAt(indexChar));
            ++indexChar;
        }
        String result = sbTemp.toString().replaceAll("&nbsp;", "\u00a0").replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&quot;", "\"").replaceAll("&amp;", "&");
        return new StringBuilder(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StiColor parseColor(String colorAttribute) {
        StiColor color = StiColorEnum.Transparent.color();
        if (colorAttribute.length() > 1) {
            if (colorAttribute.charAt(0) == '#') {
                String colorSt = colorAttribute.substring(1).toLowerCase();
                StringBuilder sbc = new StringBuilder();
                for (char ch : colorSt.toCharArray()) {
                    if (ch != '0' && ch != '1' && ch != '2' && ch != '3' && ch != '4' && ch != '5' && ch != '6' && ch != '7' && ch != '8' && ch != '9' && ch != 'a' && ch != 'b' && ch != 'c' && ch != 'd' && ch != 'e' && ch != 'f') continue;
                    sbc.append(ch);
                }
                colorSt = sbc.length() == 3 ? String.format("%s%s%s%s%s%s", Character.valueOf(sbc.charAt(0)), Character.valueOf(sbc.charAt(0)), Character.valueOf(sbc.charAt(1)), Character.valueOf(sbc.charAt(1)), Character.valueOf(sbc.charAt(2)), Character.valueOf(sbc.charAt(2))) : sbc.toString();
                if (colorSt.length() == 6) {
                    int colorInt = Integer.parseInt(colorSt, 16);
                    color = StiColor.parseIntRGB((int)colorInt);
                }
            } else if (colorAttribute.startsWith("rgb")) {
                String[] colors = colorAttribute.trim().substring(4, colorAttribute.length()).split(",");
                if (colors.length == 3) {
                    int[] colorsInt = new int[]{colors[0].endsWith("%") ? (int)Math.round((double)Integer.parseInt(colors[0].substring(0, colors[0].length() - 1)) * 2.55) : Integer.parseInt(colors[0]), colors[1].endsWith("%") ? (int)Math.round((double)Integer.parseInt(colors[1].substring(0, colors[1].length() - 1)) * 2.55) : Integer.parseInt(colors[1]), colors[2].endsWith("%") ? (int)Math.round((double)Integer.parseInt(colors[2].substring(0, colors[2].length() - 1)) * 2.55) : Integer.parseInt(colors[2])};
                    color = StiColor.fromArgb((int)255, (int)colorsInt[0], (int)colorsInt[1], (int)colorsInt[2]);
                }
            } else {
                Object colors = lockHtmlNameToColor;
                synchronized (colors) {
                    if (htmlNameToColor == null) {
                        String[][] initData = new String[][]{{"AliceBlue", "#F0F8FF"}, {"AntiqueWhite", "#FAEBD7"}, {"Aqua", "#00FFFF"}, {"Aquamarine", "#7FFFD4"}, {"Azure", "#F0FFFF"}, {"Beige", "#F5F5DC"}, {"Bisque", "#FFE4C4"}, {"Black", "#000000"}, {"BlanchedAlmond", "#FFEBCD"}, {"Blue", "#0000FF"}, {"BlueViolet", "#8A2BE2"}, {"Brown", "#A52A2A"}, {"BurlyWood", "#DEB887"}, {"CadetBlue", "#5F9EA0"}, {"Chartreuse", "#7FFF00"}, {"Chocolate", "#D2691E"}, {"Coral", "#FF7F50"}, {"CornflowerBlue", "#6495ED"}, {"Cornsilk", "#FFF8DC"}, {"Crimson", "#DC143C"}, {"Cyan", "#00FFFF"}, {"DarkBlue", "#00008B"}, {"DarkCyan", "#008B8B"}, {"DarkGoldenRod", "#B8860B"}, {"DarkGray", "#A9A9A9"}, {"DarkGrey", "#A9A9A9"}, {"DarkGreen", "#006400"}, {"DarkKhaki", "#BDB76B"}, {"DarkMagenta", "#8B008B"}, {"DarkOliveGreen", "#556B2F"}, {"Darkorange", "#FF8C00"}, {"DarkOrchid", "#9932CC"}, {"DarkRed", "#8B0000"}, {"DarkSalmon", "#E9967A"}, {"DarkSeaGreen", "#8FBC8F"}, {"DarkSlateBlue", "#483D8B"}, {"DarkSlateGray", "#2F4F4F"}, {"DarkSlateGrey", "#2F4F4F"}, {"DarkTurquoise", "#00CED1"}, {"DarkViolet", "#9400D3"}, {"DeepPink", "#FF1493"}, {"DeepSkyBlue", "#00BFFF"}, {"DimGray", "#696969"}, {"DimGrey", "#696969"}, {"DodgerBlue", "#1E90FF"}, {"FireBrick", "#B22222"}, {"FloralWhite", "#FFFAF0"}, {"ForestGreen", "#228B22"}, {"Fuchsia", "#FF00FF"}, {"Gainsboro", "#DCDCDC"}, {"GhostWhite", "#F8F8FF"}, {"Gold", "#FFD700"}, {"GoldenRod", "#DAA520"}, {"Gray", "#808080"}, {"Grey", "#808080"}, {"Green", "#008000"}, {"GreenYellow", "#ADFF2F"}, {"HoneyDew", "#F0FFF0"}, {"HotPink", "#FF69B4"}, {"IndianRed", "#CD5C5C"}, {"Indigo", "#4B0082"}, {"Ivory", "#FFFFF0"}, {"Khaki", "#F0E68C"}, {"Lavender", "#E6E6FA"}, {"LavenderBlush", "#FFF0F5"}, {"LawnGreen", "#7CFC00"}, {"LemonChiffon", "#FFFACD"}, {"LightBlue", "#ADD8E6"}, {"LightCoral", "#F08080"}, {"LightCyan", "#E0FFFF"}, {"LightGoldenRodYellow", "#FAFAD2"}, {"LightGray", "#D3D3D3"}, {"LightGrey", "#D3D3D3"}, {"LightGreen", "#90EE90"}, {"LightPink", "#FFB6C1"}, {"LightSalmon", "#FFA07A"}, {"LightSeaGreen", "#20B2AA"}, {"LightSkyBlue", "#87CEFA"}, {"LightSlateGray", "#778899"}, {"LightSlateGrey", "#778899"}, {"LightSteelBlue", "#B0C4DE"}, {"LightYellow", "#FFFFE0"}, {"Lime", "#00FF00"}, {"LimeGreen", "#32CD32"}, {"Linen", "#FAF0E6"}, {"Magenta", "#FF00FF"}, {"Maroon", "#800000"}, {"MediumAquaMarine", "#66CDAA"}, {"MediumBlue", "#0000CD"}, {"MediumOrchid", "#BA55D3"}, {"MediumPurple", "#9370D8"}, {"MediumSeaGreen", "#3CB371"}, {"MediumSlateBlue", "#7B68EE"}, {"MediumSpringGreen", "#00FA9A"}, {"MediumTurquoise", "#48D1CC"}, {"MediumVioletRed", "#C71585"}, {"MidnightBlue", "#191970"}, {"MintCream", "#F5FFFA"}, {"MistyRose", "#FFE4E1"}, {"Moccasin", "#FFE4B5"}, {"NavajoWhite", "#FFDEAD"}, {"Navy", "#000080"}, {"OldLace", "#FDF5E6"}, {"Olive", "#808000"}, {"OliveDrab", "#6B8E23"}, {"Orange", "#FFA500"}, {"OrangeRed", "#FF4500"}, {"Orchid", "#DA70D6"}, {"PaleGoldenRod", "#EEE8AA"}, {"PaleGreen", "#98FB98"}, {"PaleTurquoise", "#AFEEEE"}, {"PaleVioletRed", "#D87093"}, {"PapayaWhip", "#FFEFD5"}, {"PeachPuff", "#FFDAB9"}, {"Peru", "#CD853F"}, {"Pink", "#FFC0CB"}, {"Plum", "#DDA0DD"}, {"PowderBlue", "#B0E0E6"}, {"Purple", "#800080"}, {"Red", "#FF0000"}, {"RosyBrown", "#BC8F8F"}, {"RoyalBlue", "#4169E1"}, {"SaddleBrown", "#8B4513"}, {"Salmon", "#FA8072"}, {"SandyBrown", "#F4A460"}, {"SeaGreen", "#2E8B57"}, {"SeaShell", "#FFF5EE"}, {"Sienna", "#A0522D"}, {"Silver", "#C0C0C0"}, {"SkyBlue", "#87CEEB"}, {"SlateBlue", "#6A5ACD"}, {"SlateGray", "#708090"}, {"SlateGrey", "#708090"}, {"Snow", "#FFFAFA"}, {"SpringGreen", "#00FF7F"}, {"SteelBlue", "#4682B4"}, {"Tan", "#D2B48C"}, {"Teal", "#008080"}, {"Thistle", "#D8BFD8"}, {"Tomato", "#FF6347"}, {"Turquoise", "#40E0D0"}, {"Violet", "#EE82EE"}, {"Wheat", "#F5DEB3"}, {"White", "#FFFFFF"}, {"WhiteSmoke", "#F5F5F5"}, {"Yellow", "#FFFF00"}, {"YellowGreen", "#9ACD32"}};
                        htmlNameToColor = new Hashtable();
                        for (int index = 0; index < initData.length; ++index) {
                            String key = initData[index][0].toLowerCase();
                            int colorInt = Integer.parseInt(initData[index][1].substring(1), 16);
                            StiColor value = StiColor.parseIntRGB((int)colorInt);
                            htmlNameToColor.put(key, value);
                        }
                    }
                }
                String colorSt = colorAttribute.toLowerCase();
                if (htmlNameToColor.containsKey(colorSt)) {
                    color = htmlNameToColor.get(colorSt);
                }
            }
        }
        return color;
    }

    private static float parseFontSize(String fontSizeAttribute) {
        float ffontSize = 8.0f;
        try {
            ffontSize = Float.parseFloat(fontSizeAttribute.replace(',', '.'));
        }
        catch (Exception e) {
            ffontSize = 8.0f;
        }
        if ((double)ffontSize < 0.5) {
            ffontSize = 0.5f;
        }
        if (interpreteFontSizeInHtmlTagsAsInHtml) {
            switch (Math.round(ffontSize)) {
                case 1: {
                    ffontSize = 7.0f;
                    break;
                }
                case 2: {
                    ffontSize = 10.0f;
                    break;
                }
                case 3: {
                    ffontSize = 12.0f;
                    break;
                }
                case 4: {
                    ffontSize = 14.0f;
                    break;
                }
                case 5: {
                    ffontSize = 16.0f;
                    break;
                }
                case 6: {
                    ffontSize = 22.0f;
                    break;
                }
                case 7: {
                    ffontSize = 36.0f;
                }
            }
        }
        return ffontSize;
    }

    private static String stateToHtml(StiHtmlState state, String text, int lineInfoIndent) {
        StringBuilder sbb = new StringBuilder();
        sbb.append(String.format("<font name=\"%s\" size=\"%s\">", state.getTs().fontName, Float.valueOf(state.getTs().fontSize)));
        if (state.getTs().isColorChanged()) {
            sbb.append(String.format("<font-color=\"%s\">", StiTextRenderer.colorToHtml(state.getTs().fontColor)));
        }
        if (state.getTs().isBackcolorChanged()) {
            sbb.append(String.format("<background-color=\"%s\">", StiTextRenderer.colorToHtml(state.getTs().backColor)));
        }
        sbb.append(String.format("<%sb>", state.getTs().bold ? "" : "/"));
        sbb.append(String.format("<%si>", state.getTs().italic ? "" : "/"));
        sbb.append(String.format("<%su>", state.getTs().underline ? "" : "/"));
        sbb.append(String.format("<%ss>", state.getTs().strikeout ? "" : "/"));
        sbb.append(String.format("<%ssup>", state.getTs().superscript ? "" : "/"));
        sbb.append(String.format("<%ssub>", state.getTs().subscript ? "" : "/"));
        sbb.append(String.format("<letter-spacing=\"%s\">", state.getTs().letterSpacing));
        sbb.append(String.format("<word-spacing=\"%s\">", state.getTs().wordSpacing));
        sbb.append(String.format("<line-height=\"%s\">", state.getTs().lineHeight));
        String align = "left";
        if (state.getTs().textAlign == StiTextHorAlignment.Center) {
            align = "center";
        }
        if (state.getTs().textAlign == StiTextHorAlignment.Right) {
            align = "right";
        }
        if (state.getTs().textAlign == StiTextHorAlignment.Width) {
            align = "justify";
        }
        sbb.append(String.format("<text-align=\"%s\">", align));
        sbb.append("<StiHtml " + StiTextRenderer.stackToString(state.tagsStack) + ">");
        if (state.getTs().indent > 0) {
            sbb.append(String.format("<StiHtml2 %s %s>", lineInfoIndent, StiTextRenderer.listLevelsToString(state.listLevels, state.getTs().indent)));
        }
        if (text != null) {
            sbb.append(text);
        }
        return sbb.toString();
    }

    private static String getIndentString(int indent) {
        StringBuilder sb = new StringBuilder();
        for (int index = 0; index < indent; ++index) {
            sb.append("\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0");
        }
        return sb.toString();
    }

    private static void insertMarker(StringBuilder sb, Integer markerInt, int indent) {
        int offsetMarker;
        String marker = bulletBlack;
        if (markerInt > 0) {
            marker = markerInt.toString() + '.';
        } else {
            int markerInt2 = (0 - markerInt) % 2;
            if (markerInt2 == 1) {
                marker = bulletWhite;
            }
        }
        int n = offsetMarker = markerInt > 0 ? 2 : 3;
        if (sb.length() > 3) {
            if (marker.length() >= sb.length() - offsetMarker) {
                sb.delete(0, sb.length() - offsetMarker);
                sb.insert(0, marker);
            } else {
                int offset = sb.length() - offsetMarker - marker.length();
                for (int index = 0; index < marker.length(); ++index) {
                    sb.setCharAt(offset + index, marker.charAt(index));
                }
            }
        }
    }

    static {
        StiForceWidthAlignTag = "<forcewidth>";
        htmlNameToColor = null;
        lockHtmlNameToColor = new Object();
        htmlEscapeSequence = new Hashtable();
        optimizeBottomMargin = true;
        interpreteFontSizeInHtmlTagsAsInHtml = false;
        OutlineTextMetricsCache = new Hashtable();
        lockOutlineTextMetricsCache = new Object();
        htmlEscapeSequence.put("&quot;", Character.valueOf('\"'));
        htmlEscapeSequence.put("&amp;", Character.valueOf('&'));
        htmlEscapeSequence.put("&lt;", Character.valueOf('<'));
        htmlEscapeSequence.put("&gt;", Character.valueOf('>'));
        htmlEscapeSequence.put("&nbsp;", Character.valueOf('\u00a0'));
        htmlEscapeSequence.put("&iexcl;", Character.valueOf('\u00a1'));
        htmlEscapeSequence.put("&cent;", Character.valueOf('\u00a2'));
        htmlEscapeSequence.put("&pound;", Character.valueOf('\u00a3'));
        htmlEscapeSequence.put("&curren;", Character.valueOf('\u00a4'));
        htmlEscapeSequence.put("&yen;", Character.valueOf('\u00a5'));
        htmlEscapeSequence.put("&brvbar;", Character.valueOf('\u00a6'));
        htmlEscapeSequence.put("&sect;", Character.valueOf('\u00a7'));
        htmlEscapeSequence.put("&uml;", Character.valueOf('\u00a8'));
        htmlEscapeSequence.put("&copy;", Character.valueOf('\u00a9'));
        htmlEscapeSequence.put("&ordf;", Character.valueOf('\u00aa'));
        htmlEscapeSequence.put("&laquo;", Character.valueOf('\u00ab'));
        htmlEscapeSequence.put("&not;", Character.valueOf('\u00ac'));
        htmlEscapeSequence.put("&shy;", Character.valueOf('\u00ad'));
        htmlEscapeSequence.put("&reg;", Character.valueOf('\u00ae'));
        htmlEscapeSequence.put("&macr;", Character.valueOf('\u00af'));
        htmlEscapeSequence.put("&deg;", Character.valueOf('\u00b0'));
        htmlEscapeSequence.put("&plusmn;", Character.valueOf('\u00b1'));
        htmlEscapeSequence.put("&sup2;", Character.valueOf('\u00b2'));
        htmlEscapeSequence.put("&sup3;", Character.valueOf('\u00b3'));
        htmlEscapeSequence.put("&acute;", Character.valueOf('\u00b4'));
        htmlEscapeSequence.put("&micro;", Character.valueOf('\u00b5'));
        htmlEscapeSequence.put("&para;", Character.valueOf('\u00b6'));
        htmlEscapeSequence.put("&middot;", Character.valueOf('\u00b7'));
        htmlEscapeSequence.put("&cedil;", Character.valueOf('\u00b8'));
        htmlEscapeSequence.put("&sup1;", Character.valueOf('\u00b9'));
        htmlEscapeSequence.put("&ordm;", Character.valueOf('\u00ba'));
        htmlEscapeSequence.put("&raquo;", Character.valueOf('\u00bb'));
        htmlEscapeSequence.put("&frac14;", Character.valueOf('\u00bc'));
        htmlEscapeSequence.put("&frac12;", Character.valueOf('\u00bd'));
        htmlEscapeSequence.put("&frac34;", Character.valueOf('\u00be'));
        htmlEscapeSequence.put("&iquest;", Character.valueOf('\u00bf'));
        htmlEscapeSequence.put("&Agrave;", Character.valueOf('\u00c0'));
        htmlEscapeSequence.put("&Aacute;", Character.valueOf('\u00c1'));
        htmlEscapeSequence.put("&Acirc;", Character.valueOf('\u00c2'));
        htmlEscapeSequence.put("&Atilde;", Character.valueOf('\u00c3'));
        htmlEscapeSequence.put("&Auml;", Character.valueOf('\u00c4'));
        htmlEscapeSequence.put("&Aring;", Character.valueOf('\u00c5'));
        htmlEscapeSequence.put("&AElig;", Character.valueOf('\u00c6'));
        htmlEscapeSequence.put("&Ccedil;", Character.valueOf('\u00c7'));
        htmlEscapeSequence.put("&Egrave;", Character.valueOf('\u00c8'));
        htmlEscapeSequence.put("&Eacute;", Character.valueOf('\u00c9'));
        htmlEscapeSequence.put("&Ecirc;", Character.valueOf('\u00ca'));
        htmlEscapeSequence.put("&Euml;", Character.valueOf('\u00cb'));
        htmlEscapeSequence.put("&Igrave;", Character.valueOf('\u00cc'));
        htmlEscapeSequence.put("&Iacute;", Character.valueOf('\u00cd'));
        htmlEscapeSequence.put("&Icirc;", Character.valueOf('\u00ce'));
        htmlEscapeSequence.put("&Iuml;", Character.valueOf('\u00cf'));
        htmlEscapeSequence.put("&ETH;", Character.valueOf('\u00d0'));
        htmlEscapeSequence.put("&Ntilde;", Character.valueOf('\u00d1'));
        htmlEscapeSequence.put("&Ograve;", Character.valueOf('\u00d2'));
        htmlEscapeSequence.put("&Oacute;", Character.valueOf('\u00d3'));
        htmlEscapeSequence.put("&Ocirc;", Character.valueOf('\u00d4'));
        htmlEscapeSequence.put("&Otilde;", Character.valueOf('\u00d5'));
        htmlEscapeSequence.put("&Ouml;", Character.valueOf('\u00d6'));
        htmlEscapeSequence.put("&times;", Character.valueOf('\u00d7'));
        htmlEscapeSequence.put("&Oslash;", Character.valueOf('\u00d8'));
        htmlEscapeSequence.put("&Ugrave;", Character.valueOf('\u00d9'));
        htmlEscapeSequence.put("&Uacute;", Character.valueOf('\u00da'));
        htmlEscapeSequence.put("&Ucirc;", Character.valueOf('\u00db'));
        htmlEscapeSequence.put("&Uuml;", Character.valueOf('\u00dc'));
        htmlEscapeSequence.put("&Yacute;", Character.valueOf('\u00dd'));
        htmlEscapeSequence.put("&THORN;", Character.valueOf('\u00de'));
        htmlEscapeSequence.put("&szlig;", Character.valueOf('\u00df'));
        htmlEscapeSequence.put("&agrave;", Character.valueOf('\u00e0'));
        htmlEscapeSequence.put("&aacute;", Character.valueOf('\u00e1'));
        htmlEscapeSequence.put("&acirc;", Character.valueOf('\u00e2'));
        htmlEscapeSequence.put("&atilde;", Character.valueOf('\u00e3'));
        htmlEscapeSequence.put("&auml;", Character.valueOf('\u00e4'));
        htmlEscapeSequence.put("&aring;", Character.valueOf('\u00e5'));
        htmlEscapeSequence.put("&aelig;", Character.valueOf('\u00e6'));
        htmlEscapeSequence.put("&ccedil;", Character.valueOf('\u00e7'));
        htmlEscapeSequence.put("&egrave;", Character.valueOf('\u00e8'));
        htmlEscapeSequence.put("&eacute;", Character.valueOf('\u00e9'));
        htmlEscapeSequence.put("&ecirc;", Character.valueOf('\u00ea'));
        htmlEscapeSequence.put("&euml;", Character.valueOf('\u00eb'));
        htmlEscapeSequence.put("&igrave;", Character.valueOf('\u00ec'));
        htmlEscapeSequence.put("&iacute;", Character.valueOf('\u00ed'));
        htmlEscapeSequence.put("&icirc;", Character.valueOf('\u00ee'));
        htmlEscapeSequence.put("&iuml;", Character.valueOf('\u00ef'));
        htmlEscapeSequence.put("&eth;", Character.valueOf('\u00f0'));
        htmlEscapeSequence.put("&ntilde;", Character.valueOf('\u00f1'));
        htmlEscapeSequence.put("&ograve;", Character.valueOf('\u00f2'));
        htmlEscapeSequence.put("&oacute;", Character.valueOf('\u00f3'));
        htmlEscapeSequence.put("&ocirc;", Character.valueOf('\u00f4'));
        htmlEscapeSequence.put("&otilde;", Character.valueOf('\u00f5'));
        htmlEscapeSequence.put("&ouml;", Character.valueOf('\u00f6'));
        htmlEscapeSequence.put("&divide;", Character.valueOf('\u00f7'));
        htmlEscapeSequence.put("&oslash;", Character.valueOf('\u00f8'));
        htmlEscapeSequence.put("&ugrave;", Character.valueOf('\u00f9'));
        htmlEscapeSequence.put("&uacute;", Character.valueOf('\u00fa'));
        htmlEscapeSequence.put("&ucirc;", Character.valueOf('\u00fb'));
        htmlEscapeSequence.put("&uuml;", Character.valueOf('\u00fc'));
        htmlEscapeSequence.put("&yacute;", Character.valueOf('\u00fd'));
        htmlEscapeSequence.put("&thorn;", Character.valueOf('\u00fe'));
        htmlEscapeSequence.put("&yuml;", Character.valueOf('\u00ff'));
        htmlEscapeSequence.put("&OElig;", Character.valueOf('\u0152'));
        htmlEscapeSequence.put("&oelig;", Character.valueOf('\u0153'));
        htmlEscapeSequence.put("&Scaron;", Character.valueOf('\u0160'));
        htmlEscapeSequence.put("&scaron;", Character.valueOf('\u0161'));
        htmlEscapeSequence.put("&Yuml;", Character.valueOf('\u0178'));
        htmlEscapeSequence.put("&fnof;", Character.valueOf('\u0192'));
        htmlEscapeSequence.put("&circ;", Character.valueOf('\u02c6'));
        htmlEscapeSequence.put("&tilde;", Character.valueOf('\u02dc'));
        htmlEscapeSequence.put("&Alpha;", Character.valueOf('\u0391'));
        htmlEscapeSequence.put("&Beta;", Character.valueOf('\u0392'));
        htmlEscapeSequence.put("&Gamma;", Character.valueOf('\u0393'));
        htmlEscapeSequence.put("&Delta;", Character.valueOf('\u0394'));
        htmlEscapeSequence.put("&Epsilon;", Character.valueOf('\u0395'));
        htmlEscapeSequence.put("&Zeta;", Character.valueOf('\u0396'));
        htmlEscapeSequence.put("&Eta;", Character.valueOf('\u0397'));
        htmlEscapeSequence.put("&Theta;", Character.valueOf('\u0398'));
        htmlEscapeSequence.put("&Iota;", Character.valueOf('\u0399'));
        htmlEscapeSequence.put("&Kappa;", Character.valueOf('\u039a'));
        htmlEscapeSequence.put("&Lambda;", Character.valueOf('\u039b'));
        htmlEscapeSequence.put("&Mu;", Character.valueOf('\u039c'));
        htmlEscapeSequence.put("&Nu;", Character.valueOf('\u039d'));
        htmlEscapeSequence.put("&Xi;", Character.valueOf('\u039e'));
        htmlEscapeSequence.put("&Omicron;", Character.valueOf('\u039f'));
        htmlEscapeSequence.put("&Pi;", Character.valueOf('\u03a0'));
        htmlEscapeSequence.put("&Rho;", Character.valueOf('\u03a1'));
        htmlEscapeSequence.put("&Sigma;", Character.valueOf('\u03a3'));
        htmlEscapeSequence.put("&Tau;", Character.valueOf('\u03a4'));
        htmlEscapeSequence.put("&Upsilon;", Character.valueOf('\u03a5'));
        htmlEscapeSequence.put("&Phi;", Character.valueOf('\u03a6'));
        htmlEscapeSequence.put("&Chi;", Character.valueOf('\u03a7'));
        htmlEscapeSequence.put("&Psi;", Character.valueOf('\u03a8'));
        htmlEscapeSequence.put("&Omega;", Character.valueOf('\u03a9'));
        htmlEscapeSequence.put("&alpha;", Character.valueOf('\u03b1'));
        htmlEscapeSequence.put("&beta;", Character.valueOf('\u03b2'));
        htmlEscapeSequence.put("&gamma;", Character.valueOf('\u03b3'));
        htmlEscapeSequence.put("&delta;", Character.valueOf('\u03b4'));
        htmlEscapeSequence.put("&epsilon;", Character.valueOf('\u03b5'));
        htmlEscapeSequence.put("&zeta;", Character.valueOf('\u03b6'));
        htmlEscapeSequence.put("&eta;", Character.valueOf('\u03b7'));
        htmlEscapeSequence.put("&theta;", Character.valueOf('\u03b8'));
        htmlEscapeSequence.put("&iota;", Character.valueOf('\u03b9'));
        htmlEscapeSequence.put("&kappa;", Character.valueOf('\u03ba'));
        htmlEscapeSequence.put("&lambda;", Character.valueOf('\u03bb'));
        htmlEscapeSequence.put("&mu;", Character.valueOf('\u03bc'));
        htmlEscapeSequence.put("&nu;", Character.valueOf('\u03bd'));
        htmlEscapeSequence.put("&xi;", Character.valueOf('\u03be'));
        htmlEscapeSequence.put("&omicron;", Character.valueOf('\u03bf'));
        htmlEscapeSequence.put("&pi;", Character.valueOf('\u03c0'));
        htmlEscapeSequence.put("&rho;", Character.valueOf('\u03c1'));
        htmlEscapeSequence.put("&sigmaf;", Character.valueOf('\u03c2'));
        htmlEscapeSequence.put("&sigma;", Character.valueOf('\u03c3'));
        htmlEscapeSequence.put("&tau;", Character.valueOf('\u03c4'));
        htmlEscapeSequence.put("&upsilon;", Character.valueOf('\u03c5'));
        htmlEscapeSequence.put("&phi;", Character.valueOf('\u03c6'));
        htmlEscapeSequence.put("&chi;", Character.valueOf('\u03c7'));
        htmlEscapeSequence.put("&psi;", Character.valueOf('\u03c8'));
        htmlEscapeSequence.put("&omega;", Character.valueOf('\u03c9'));
        htmlEscapeSequence.put("&thetasym;", Character.valueOf('\u03d1'));
        htmlEscapeSequence.put("&upsih;", Character.valueOf('\u03d2'));
        htmlEscapeSequence.put("&piv;", Character.valueOf('\u03d6'));
        htmlEscapeSequence.put("&ensp;", Character.valueOf('\u2002'));
        htmlEscapeSequence.put("&emsp;", Character.valueOf('\u2003'));
        htmlEscapeSequence.put("&thinsp;", Character.valueOf('\u2009'));
        htmlEscapeSequence.put("&zwnj;", Character.valueOf('\u200c'));
        htmlEscapeSequence.put("&zwj;", Character.valueOf('\u200d'));
        htmlEscapeSequence.put("&lrm;", Character.valueOf('\u200e'));
        htmlEscapeSequence.put("&rlm;", Character.valueOf('\u200f'));
        htmlEscapeSequence.put("&ndash;", Character.valueOf('\u2013'));
        htmlEscapeSequence.put("&mdash;", Character.valueOf('\u2014'));
        htmlEscapeSequence.put("&lsquo;", Character.valueOf('\u2018'));
        htmlEscapeSequence.put("&rsquo;", Character.valueOf('\u2019'));
        htmlEscapeSequence.put("&sbquo;", Character.valueOf('\u201a'));
        htmlEscapeSequence.put("&ldquo;", Character.valueOf('\u201c'));
        htmlEscapeSequence.put("&rdquo;", Character.valueOf('\u201d'));
        htmlEscapeSequence.put("&bdquo;", Character.valueOf('\u201e'));
        htmlEscapeSequence.put("&dagger;", Character.valueOf('\u2020'));
        htmlEscapeSequence.put("&Dagger;", Character.valueOf('\u2021'));
        htmlEscapeSequence.put("&bull;", Character.valueOf('\u2022'));
        htmlEscapeSequence.put("&hellip;", Character.valueOf('\u2026'));
        htmlEscapeSequence.put("&permil;", Character.valueOf('\u2030'));
        htmlEscapeSequence.put("&prime;", Character.valueOf('\u2032'));
        htmlEscapeSequence.put("&Prime;", Character.valueOf('\u2033'));
        htmlEscapeSequence.put("&lsaquo;", Character.valueOf('\u2039'));
        htmlEscapeSequence.put("&rsaquo;", Character.valueOf('\u203a'));
        htmlEscapeSequence.put("&oline;", Character.valueOf('\u203e'));
        htmlEscapeSequence.put("&frasl;", Character.valueOf('\u2044'));
        htmlEscapeSequence.put("&euro;", Character.valueOf('\u20ac'));
        htmlEscapeSequence.put("&image;", Character.valueOf('\u20ad'));
        htmlEscapeSequence.put("&weierp;", Character.valueOf('\u2118'));
        htmlEscapeSequence.put("&real;", Character.valueOf('\u211c'));
        htmlEscapeSequence.put("&trade;", Character.valueOf('\u2122'));
        htmlEscapeSequence.put("&alefsym;", Character.valueOf('\u2135'));
        htmlEscapeSequence.put("&larr;", Character.valueOf('\u2190'));
        htmlEscapeSequence.put("&uarr;", Character.valueOf('\u2191'));
        htmlEscapeSequence.put("&rarr;", Character.valueOf('\u2192'));
        htmlEscapeSequence.put("&darr;", Character.valueOf('\u2193'));
        htmlEscapeSequence.put("&harr;", Character.valueOf('\u2194'));
        htmlEscapeSequence.put("&crarr;", Character.valueOf('\u21b5'));
        htmlEscapeSequence.put("&lArr;", Character.valueOf('\u21d0'));
        htmlEscapeSequence.put("&uArr;", Character.valueOf('\u21d1'));
        htmlEscapeSequence.put("&rArr;", Character.valueOf('\u21d2'));
        htmlEscapeSequence.put("&dArr;", Character.valueOf('\u21d3'));
        htmlEscapeSequence.put("&hArr;", Character.valueOf('\u21d4'));
        htmlEscapeSequence.put("&forall;", Character.valueOf('\u2200'));
        htmlEscapeSequence.put("&part;", Character.valueOf('\u2202'));
        htmlEscapeSequence.put("&exist;", Character.valueOf('\u2203'));
        htmlEscapeSequence.put("&empty;", Character.valueOf('\u2205'));
        htmlEscapeSequence.put("&nabla;", Character.valueOf('\u2207'));
        htmlEscapeSequence.put("&isin;", Character.valueOf('\u2208'));
        htmlEscapeSequence.put("&notin;", Character.valueOf('\u2209'));
        htmlEscapeSequence.put("&ni;", Character.valueOf('\u220b'));
        htmlEscapeSequence.put("&prod;", Character.valueOf('\u220f'));
        htmlEscapeSequence.put("&sum;", Character.valueOf('\u2211'));
        htmlEscapeSequence.put("&minus;", Character.valueOf('\u2212'));
        htmlEscapeSequence.put("&lowast;", Character.valueOf('\u2217'));
        htmlEscapeSequence.put("&radic;", Character.valueOf('\u221a'));
        htmlEscapeSequence.put("&prop;", Character.valueOf('\u221d'));
        htmlEscapeSequence.put("&infin;", Character.valueOf('\u221e'));
        htmlEscapeSequence.put("&ang;", Character.valueOf('\u2220'));
        htmlEscapeSequence.put("&and;", Character.valueOf('\u2227'));
        htmlEscapeSequence.put("&or;", Character.valueOf('\u2228'));
        htmlEscapeSequence.put("&cap;", Character.valueOf('\u2229'));
        htmlEscapeSequence.put("&cup;", Character.valueOf('\u222a'));
        htmlEscapeSequence.put("&int;", Character.valueOf('\u222b'));
        htmlEscapeSequence.put("&there4;", Character.valueOf('\u2234'));
        htmlEscapeSequence.put("&sim;", Character.valueOf('\u223c'));
        htmlEscapeSequence.put("&cong;", Character.valueOf('\u2245'));
        htmlEscapeSequence.put("&asymp;", Character.valueOf('\u2248'));
        htmlEscapeSequence.put("&ne;", Character.valueOf('\u2260'));
        htmlEscapeSequence.put("&equiv;", Character.valueOf('\u2261'));
        htmlEscapeSequence.put("&le;", Character.valueOf('\u2264'));
        htmlEscapeSequence.put("&ge;", Character.valueOf('\u2265'));
        htmlEscapeSequence.put("&sub;", Character.valueOf('\u2282'));
        htmlEscapeSequence.put("&sup;", Character.valueOf('\u2283'));
        htmlEscapeSequence.put("&nsub;", Character.valueOf('\u2284'));
        htmlEscapeSequence.put("&sube;", Character.valueOf('\u2286'));
        htmlEscapeSequence.put("&supe;", Character.valueOf('\u2287'));
        htmlEscapeSequence.put("&oplus;", Character.valueOf('\u2295'));
        htmlEscapeSequence.put("&otimes;", Character.valueOf('\u2297'));
        htmlEscapeSequence.put("&perp;", Character.valueOf('\u22a5'));
        htmlEscapeSequence.put("&sdot;", Character.valueOf('\u22c5'));
        htmlEscapeSequence.put("&lceil;", Character.valueOf('\u2308'));
        htmlEscapeSequence.put("&rceil;", Character.valueOf('\u2309'));
        htmlEscapeSequence.put("&lfloor;", Character.valueOf('\u230a'));
        htmlEscapeSequence.put("&rfloor;", Character.valueOf('\u230b'));
        htmlEscapeSequence.put("&lang;", Character.valueOf('\u2329'));
        htmlEscapeSequence.put("&rang;", Character.valueOf('\u232a'));
        htmlEscapeSequence.put("&loz;", Character.valueOf('\u25ca'));
        htmlEscapeSequence.put("&spades;", Character.valueOf('\u2660'));
        htmlEscapeSequence.put("&clubs;", Character.valueOf('\u2663'));
        htmlEscapeSequence.put("&hearts;", Character.valueOf('\u2665'));
        htmlEscapeSequence.put("&diams;", Character.valueOf('\u2666'));
        bulletBlack = new String("\u2022");
        bulletWhite = new String("\u25e6");
    }

    static class StiPair<K, V> {
        K key;
        V value;

        StiPair() {
        }

        public K getKey() {
            return this.key;
        }

        public void setKey(K key) {
            this.key = key;
        }

        public V getValue() {
            return this.value;
        }

        public void setValue(V value) {
            this.value = value;
        }
    }
}

