/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.export.tools;

import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiPen;
import com.stimulsoft.base.drawing.enums.StiTextHorAlignment;
import com.stimulsoft.base.drawing.enums.StiVertAlignment;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.base.utils.StiStringBuilder;
import com.stimulsoft.report.components.simplecomponents.StiImage;
import com.stimulsoft.report.export.EmfTextAlignmentMode;
import com.stimulsoft.report.export.service.helper.StiChartSvgHelper;
import com.stimulsoft.report.export.service.helper.StiContextSvgHelper;
import com.stimulsoft.report.export.tools.IStiExportGeomWriter;
import java.io.IOException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StiSvgGeomWriter
implements IStiExportGeomWriter {
    private Element element;
    private Element element2;
    private Document document;

    public StiSvgGeomWriter(Element element, Document document) {
        this.element = element;
        this.document = document;
    }

    @Override
    public void beginPath() {
    }

    @Override
    public void closeFigure() {
    }

    @Override
    public void drawImage(StiImage img, StiRectangle rect) {
    }

    @Override
    public void drawLineTo(StiPoint pointTo, StiPen pen) {
    }

    @Override
    public void drawPolygon(StiPoint[] points, StiPen pen) {
    }

    @Override
    public void drawPolylineTo(StiPoint[] points, StiPen pen) {
    }

    @Override
    public void drawRectangle(StiRectangle rect, StiPen pen) {
    }

    @Override
    public void drawString(String st, StiFont font, StiBrush brush, StiRectangle rect, StiTextHorAlignment horAlignment, StiVertAlignment vertAlignment) {
        Element text = this.document.createElement("text");
        this.element.appendChild(text);
        StiPoint point = new StiPoint();
        switch (horAlignment) {
            case Left: {
                point.x = rect.x;
                break;
            }
            case Center: {
                point.x = rect.x + rect.width / 2.0;
                break;
            }
            case Width: 
            case Right: {
                point.x = rect.x + rect.width;
            }
        }
        switch (vertAlignment) {
            case Top: {
                point.y = rect.y;
                break;
            }
            case Center: {
                point.y = rect.y + rect.height / 2.0;
                break;
            }
            case Bottom: {
                point.y = rect.y + rect.height;
            }
        }
        text.setAttribute("transform", String.format("translate(%s, %s)", point.getX().toString().replace(',', '.'), point.getY().toString().replace(',', '.')));
        text.setAttribute("width", String.valueOf(rect.getWidth()).replace(',', '.'));
        text.setAttribute("height", String.valueOf(rect.getHeight()).replace(',', '.'));
        StringBuilder style = new StringBuilder();
        style.append(String.format("font-size:%spt;", font.getSize()));
        style.append(String.format("font-family:'%s';", font.getName()));
        if (font.bold()) {
            style.append("font-weight:bold;");
        }
        if (font.italic()) {
            style.append("font-style:italic;");
        }
        if (font.underline()) {
            style.append("text-decoration:underline;");
        }
        style.append(StiChartSvgHelper.writeFillBrush(this.element, brush, rect, 0.0, 0.0, this.document));
        switch (horAlignment) {
            case Left: {
                style.append("text-anchor:start;");
                break;
            }
            case Center: {
                style.append("text-anchor:middle;");
                break;
            }
            case Width: 
            case Right: {
                style.append("text-anchor:end;");
            }
        }
        switch (vertAlignment) {
            case Top: {
                text.setAttribute("dy", "1em");
                break;
            }
            case Center: {
                text.setAttribute("dy", "0.5em");
                break;
            }
        }
        text.setAttribute("style", style.toString());
        text.setTextContent(st);
    }

    @Override
    public void drawText(StiPoint basePoint, String text, int[] charsOffset, StiFont font, StiColor textColor, double angle, EmfTextAlignmentMode textAlign) {
    }

    @Override
    public void endPath() {
    }

    @Override
    public void fillPolygon(StiPoint[] points, Object brush) {
        StringBuilder style = new StringBuilder();
        style.append(StiChartSvgHelper.writeFillBrush(this.element, brush, new StiRectangle(), 0.0, 0.0, this.document));
        String pointsText = "";
        for (StiPoint point : points) {
            pointsText = pointsText + String.format("%s,%s ", String.valueOf(point.x).replace(',', '.'), String.valueOf(point.y).replace(',', '.'));
        }
        Element polygonEl = this.document.createElement("polygon");
        this.element.appendChild(polygonEl);
        polygonEl.setAttribute("points", pointsText);
        polygonEl.setAttribute("style", style.toString());
    }

    public void fillRectangle(StiRectangle rect, StiBrush brush) {
        StringBuilder style = new StringBuilder();
        style.append(StiChartSvgHelper.writeFillBrush(this.element, brush, rect, 0.0, 0.0, this.document));
        Element rectE = this.document.createElement("rect");
        this.element.appendChild(rectE);
        rectE.setAttribute("x", String.valueOf(rect.x).replace(',', '.'));
        rectE.setAttribute("y", String.valueOf(rect.y).replace(',', '.'));
        rectE.setAttribute("width", String.valueOf(rect.width).replace(',', '.'));
        rectE.setAttribute("height", String.valueOf(rect.height).replace(',', '.'));
        rectE.setAttribute("fill", "red");
        rectE.setAttribute("style", style.toString());
        rectE.setAttribute("shape-rendering", "crispEdges");
    }

    @Override
    public void fillRectangle(StiRectangle rect, StiColor color) {
    }

    @Override
    public StiSize measureString(String st, StiFont font) {
        return new StiSize();
    }

    @Override
    public void moveTo(StiPoint point) {
    }

    @Override
    public void restoreState() {
    }

    @Override
    public void rotateTransform(double angle) {
        Element g = this.document.createElement("g");
        this.element.appendChild(g);
        g.setAttribute("transform", String.format("rotate(%s)", String.valueOf(angle).replace(',', '.')));
        if (this.element2 == null) {
            this.element2 = this.element;
        }
        this.element = g;
    }

    @Override
    public void saveState() {
    }

    @Override
    public void setPixel(StiPoint point, StiColor color) {
    }

    @Override
    public void translateTransform(double x, double y) {
        Element g = this.document.createElement("g");
        this.element.appendChild(g);
        g.setAttribute("transform", String.format("translate(%s,%s)", String.valueOf(x).replace(',', '.'), String.valueOf(y).replace(',', '.')));
        if (this.element2 == null) {
            this.element2 = this.element;
        }
        this.element = g;
    }

    public void endTransform() {
        this.element = this.element2;
        this.element2 = null;
    }

    @Override
    public void fillEllipse(StiRectangle rect, Object brush) {
        StringBuilder style = new StringBuilder();
        style.append(StiChartSvgHelper.writeFillBrush(this.element, brush, rect, 0.0, 0.0, this.document));
        Element ellipseEl = this.document.createElement("ellipse");
        this.element.appendChild(ellipseEl);
        ellipseEl.setAttribute("cx", String.valueOf(rect.x + rect.width / 2.0).replace(',', '.'));
        ellipseEl.setAttribute("cy", String.valueOf(rect.y + rect.height / 2.0).replace(',', '.'));
        ellipseEl.setAttribute("rx", String.valueOf(rect.width / 2.0).replace(',', '.'));
        ellipseEl.setAttribute("ry", String.valueOf(rect.height / 2.0).replace(',', '.'));
        ellipseEl.setAttribute("style", style.toString());
    }

    @Override
    public void fillPath(Object brush) throws IOException {
    }

    @Override
    public void strokePath(Object pen) throws IOException {
    }

    @Override
    public void drawLine(StiPoint pointFrom, StiPoint pointTo, Object pen) throws IOException {
    }

    @Override
    public void drawPolyline(StiPoint[] points, Object pen) throws IOException {
    }

    @Override
    public void drawBezier(StiPoint p1, StiPoint p2, StiPoint p3, StiPoint p4, Object pen) throws IOException {
    }

    @Override
    public void drawBezierTo(StiPoint p2, StiPoint p3, StiPoint p4, Object pen) throws IOException {
    }

    @Override
    public void drawArc(StiRectangle rect, float startAngle, float sweepAngle) throws IOException {
    }

    @Override
    public void fillRectangle(StiRectangle rect, Object brush) throws Exception {
        StiStringBuilder style = new StiStringBuilder();
        style.append(StiContextSvgHelper.writeFillBrush(this.element, brush, rect, this.document));
        Element rectEl = this.document.createElement("rect");
        this.element.appendChild(rectEl);
        rectEl.setAttribute("x", String.valueOf(rect.x).replace(',', '.'));
        rectEl.setAttribute("y", String.valueOf(rect.y).replace(',', '.'));
        rectEl.setAttribute("width", String.valueOf(rect.width).replace(',', '.'));
        rectEl.setAttribute("height", String.valueOf(rect.height).replace(',', '.'));
        rectEl.setAttribute("style", style.toString());
        rectEl.setAttribute("shape-rendering", "crispEdges");
    }
}

