/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.export.service.pdf;

import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiHatchBrush;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.base.utils.StiBidirectionalConvert;
import com.stimulsoft.base.utils.StiMath;
import com.stimulsoft.base.utils.StiOutputStreamWriter;
import com.stimulsoft.report.StiImageCache;
import com.stimulsoft.report.export.tools.StiColorImageFormat;
import com.stimulsoft.report.export.tools.StiImageResolutionMode;
import com.stimulsoft.report.export.tools.StiMonochromeDitheringType;
import com.stimulsoft.report.export.tools.StiPdfAutoPrintMode;
import com.stimulsoft.report.export.tools.pdf.PdfFonts;
import com.stimulsoft.report.export.tools.pdf.StiPdfEncryptionKeyLength;
import com.stimulsoft.report.export.tools.pdf.StiPdfImageCompressionMethod;
import com.stimulsoft.report.options.ExportOptions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.SortedMap;
import java.util.Stack;

public class StiPdfTextRender {
    private static final char A_CH = '\u0007';
    private static int[] CODE_PAGE_1252_PART_80AF = new int[]{8364, 8226, 8218, 402, 8222, 8230, 8224, 8225, 710, 8240, 352, 8249, 338, 8226, 381, 8226, 8226, 8216, 8217, 8220, 8221, 8226, 8211, 8212, 732, 8482, 353, 8250, 339, 8226, 382, 376};
    private final double HI_TO_TWIPS = 0.72;
    private final int PRECISION_DIGITS_FONT = 3;
    private final float PDF_CKT = 0.56f;
    private final float ITALIC_ANGLE_TAN_VALUE = 0.325f;
    private final float BOLD_FONT_STROKE_WIDTH = 0.031f;
    private static final byte[] paddingString = new byte[]{40, -65, 78, 94, 78, 117, -118, 65, 100, 0, 78, 86, -1, -6, 1, 8, 46, 46, 0, -74, -48, 104, 62, -128, 47, 12, -87, -2, 100, 83, 105, 122};
    private float imageQuality = 0.75f;
    private StiOutputStreamWriter sw = null;
    private OutputStream stream2 = null;
    private ByteArrayOutputStream memoryPageStream = null;
    private StiOutputStreamWriter pageStream = null;
    private StiImageCache imageCache = null;
    private Hashtable<Integer, Boolean> imageInterpolationTable = null;
    private int imagesCounter;
    private int imagesCurrent;
    private int fontsCounter;
    private int bookmarksCounter;
    private int patternsCounter;
    private int linksCounter;
    private int annotsCounter;
    private int annotsCurrent;
    private int annots2Counter;
    private int shadingCounter;
    private int shadingCurrent;
    private int hatchCounter;
    private int tooltipsCounter;
    private final String[] colorTable = new String[256];
    private final boolean[] alphaTable = new boolean[256];
    public PdfFonts pdfFont = null;
    private StiBidirectionalConvert bidi = null;
    private int precision_digits = 3;
    private boolean clipLongTextLines;
    private boolean standardPdfFonts = true;
    private boolean embeddedFonts = false;
    private boolean useUnicodeMode = false;
    private boolean reduceFontSize = true;
    private final boolean compressed = false;
    private boolean compressedFonts = false;
    private boolean encrypted = false;
    private boolean usePdfA = false;
    private StiPdfImageCompressionMethod imageCompressionMethod = StiPdfImageCompressionMethod.Jpeg;
    private StiColorImageFormat imageFormat = StiColorImageFormat.Color;
    private StiMonochromeDitheringType monochromeDitheringType = StiMonochromeDitheringType.FloydSteinberg;
    private boolean[] fontGlyphsReduceNotNeed = null;
    private SortedMap<Integer, String> xref;
    private ArrayList<StiHatchBrush> hatchArray;
    private boolean haveBookmarks = false;
    private boolean haveLinks = false;
    private boolean haveAnnots = false;
    private boolean haveDigitalSignature = false;
    private boolean haveTooltips = false;
    private int offsetSignatureData = 0;
    private int xpageOffset;
    private int ximageOffset;
    private int xfontOffset;
    private int xbookmarkOffset;
    private int xpatternOffset;
    private int xlinkOffset;
    private int xencodeOffset;
    private int xextgstateOffset;
    private int xannotOffset;
    private int xannot2Offset;
    private int xsignatureOffset;
    private int xtooltipOffset;
    private int xMetadataOffset;
    private int xColorSpaceOffset;
    private int xAutoPrintOffset;
    private final int[] CodePage1252 = new int[256];
    private final double hiToTwips = 0.72;
    private BigInteger securityFlags = BigInteger.ZERO;
    private StiPdfEncryptionKeyLength keyLength = StiPdfEncryptionKeyLength.Bit40;
    private byte[] IDValue = null;
    private String IDValueString = "";
    private String IDValueStringMeta = "";
    private String currentDateTime = "";
    private String currentDateTimeMeta = "";
    private final String producerName = "Stimulsoft Reports";
    private String creatorName = "";
    private String keywords = "";
    private final byte[] ownerValue = new byte[48];
    private final byte[] userValue = new byte[48];
    private int lastColorStrokeA = 255;
    private int lastColorNonStrokeA = 255;
    private Stack<Integer> colorStack = null;
    private final int signatureDataLen = 6400;
    private StiRectangle signaturePlacement;
    private final int signaturePageNumber = 0;
    public static boolean compatibleMode160 = false;
    private StiPdfAutoPrintMode autoPrint = StiPdfAutoPrintMode.None;
    private String passwordOwner = "";
    private String passwordUser = "";
    private byte[] userExtendedValue = new byte[32];
    private byte[] ownerExtendedValue = new byte[32];
    private byte[] encryptionKey = null;
    private byte[] permsValue = new byte[16];
    private int currentObjectNumber;
    private int currentGenerationNumber;
    private StiImageResolutionMode imageResolutionMode = StiImageResolutionMode.Exactly;
    private int precision_digits_font = 3;
    private static double fontCorrectValue = 0.955;

    public void pushColorToStack() {
        this.colorStack.push(this.lastColorStrokeA);
        this.colorStack.push(this.lastColorNonStrokeA);
    }

    public void popColorFromStack() {
        this.lastColorNonStrokeA = this.colorStack.pop();
        this.lastColorStrokeA = this.colorStack.pop();
    }

    private String convertToString(Double value) {
        return this.convertToString(value, this.precision_digits);
    }

    private String convertToString(double value, int precision) {
        if (value == (double)((int)value)) {
            return String.valueOf((int)value);
        }
        String result = StiMath.roundS((double)value, (int)precision);
        if (result.indexOf(46) != -1) {
            if (precision > 0) {
                while (result.indexOf(46) != result.length() - precision - 1) {
                    result = result + "0";
                }
            } else {
                result = result.substring(0, result.indexOf(46));
            }
        }
        return result;
    }

    public void setNonStrokeColor(StiColor tempColor) throws IOException {
        this.pageStream.write(String.format("%s %s %s rg", this.colorTable[tempColor.getR()], this.colorTable[tempColor.getG()], this.colorTable[tempColor.getB()]) + "\r\n");
        int alpha = tempColor.getA();
        if (alpha != this.lastColorNonStrokeA && ExportOptions.Pdf.getAllowExtGState() && !this.usePdfA) {
            this.pageStream.writeLine(String.format("/GS%02xN gs", alpha));
            this.lastColorNonStrokeA = alpha;
            this.alphaTable[alpha] = true;
        }
    }

    public static String convertToEscapeSequencePlusTabs(String value) {
        String escapeChars = "()\\\r\n\t\b\f";
        String replaceChars = "()\\rntbf";
        if (value == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int index = 0; index < value.length(); ++index) {
            boolean flg = false;
            for (int index2 = 0; index2 < escapeChars.length(); ++index2) {
                if (value.charAt(index) != escapeChars.charAt(index2)) continue;
                sb.append("\\" + replaceChars.charAt(index2));
                flg = true;
                break;
            }
            if (flg) continue;
            sb.append(value.charAt(index));
        }
        return sb.toString();
    }

    public void setStrokeColor(StiColor tempColor) throws IOException {
        this.pageStream.write(String.format("%s %s %s RG", this.colorTable[tempColor.getR()], this.colorTable[tempColor.getG()], this.colorTable[tempColor.getB()]) + "\r\n");
        int alpha = tempColor.getA();
        if (alpha != this.lastColorStrokeA && ExportOptions.Pdf.getAllowExtGState() && !this.usePdfA) {
            this.pageStream.writeLine("/GS%02xS gs", new Object[]{alpha});
            this.lastColorStrokeA = alpha;
            this.alphaTable[alpha] = true;
        }
    }
}

