/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.export.service;

import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.enums.StiTextHorAlignment;
import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.licenses.StiLicenseKeyValidator;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.utils.StiRtfHelper;
import com.stimulsoft.lib.utils.StiStringUtil;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiPagesCollection;
import com.stimulsoft.report.components.simplecomponents.StiRichText;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.enums.StiExportFormat;
import com.stimulsoft.report.export.service.StiExportService;
import com.stimulsoft.report.export.settings.StiDataExportSettings;
import com.stimulsoft.report.export.settings.StiExportSettings;
import com.stimulsoft.report.export.tools.StiCell;
import com.stimulsoft.report.export.tools.StiExportUtils;
import com.stimulsoft.report.export.tools.StiMapUtil;
import com.stimulsoft.report.export.tools.StiMatrix;
import com.stimulsoft.report.export.tools.StiPagesRange;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;

public class StiSylkExportService
extends StiExportService {
    private static final double HI_TO_TWIPS = 14.688;
    private static final double TWIPS_TO_SYMBOLS = 0.008699796000000001;
    private final int COLOR_TABLE_SIZE = 64;
    private int[] COLOR_TABLE = new int[]{0, 0xFEFEFE, 0xFF0000, 65280, 255, 0xFFFF00, 0xFF00FF, 65535, 0, 0xFEFEFE, 0xFF0000, 65280, 255, 0xFFFF00, 0xFF00FF, 65535, 0x800000, 32768, 128, 0x808000, 0x800080, 32896, 0xC0C0C0, 0x808080, 0x9999FF, 0x993366, 0xFFFFCC, 0xCCFFFF, 0x660066, 0xFF8080, 26316, 0xCCCCFF, 128, 0xFF00FF, 0xFFFF00, 65535, 0x800080, 0x800000, 32896, 255, 52479, 0xCCFFFF, 0xCCFFCC, 0xFFFF99, 0x99CCFF, 0xFF99CC, 0xCC99FF, 0xFFCC99, 0x3366FF, 0x33CCCC, 0x99CC00, 0xFFCC00, 0xFF9900, 0xFF6600, 0x666699, 0x969696, 13158, 0x339966, 13056, 0x333300, 0x993300, 0x993366, 0x333399, 0x333333};
    private Writer writer;
    private ArrayList<String> formatList = null;
    private ArrayList<DataFont> fontList = null;
    private Hashtable<Integer, Integer> colorHash = null;

    private int getFontNumber(DataFont dataIn) {
        if (this.fontList.size() > 4) {
            for (int index = 4; index < this.fontList.size(); ++index) {
                if (!this.fontList.get(index).equals(dataIn)) continue;
                return index;
            }
        }
        this.fontList.add(dataIn);
        int temp = this.fontList.size() - 1;
        return temp;
    }

    private int getFormatNumber(String dataIn) {
        if (this.formatList.size() > 0) {
            for (int index = 0; index < this.formatList.size(); ++index) {
                if (!this.formatList.get(index).equals(dataIn)) continue;
                return index;
            }
        }
        this.formatList.add(dataIn);
        int temp = this.formatList.size() - 1;
        return temp;
    }

    private int getColorIndex(StiColor color) {
        if (color.equals(StiColorEnum.Transparent.color())) {
            return 0;
        }
        int colorValue = color.getAwtColor().getRGB();
        if (this.colorHash.containsKey(colorValue)) {
            return this.colorHash.get(colorValue);
        }
        int offset = 768;
        int colorIndex = 0;
        for (int index = 0; index < 64; ++index) {
            int tempColor = this.COLOR_TABLE[index];
            int tempOffset = Math.abs(color.getR() - (tempColor >> 16 & 0xFF)) + Math.abs(color.getG() - (tempColor >> 8 & 0xFF)) + Math.abs(color.getB() - (tempColor & 0xFF));
            if (tempOffset >= offset) continue;
            colorIndex = index;
            offset = tempOffset;
        }
        this.colorHash.put(colorValue, ++colorIndex);
        return colorIndex;
    }

    @Override
    public void export(StiReport report, OutputStream outputStream, StiExportSettings exportSettings) throws StiException {
        this.exportSylk(report, outputStream, (StiDataExportSettings)exportSettings);
    }

    public void exportSylk(StiReport report, OutputStream exportOutputStream, StiDataExportSettings settings) throws StiException {
        try {
            report.invokeExporting(settings.getExportFormat());
            this.exportSylkException(report, exportOutputStream, settings);
            report.invokeExported(settings.getExportFormat());
        }
        catch (Exception e) {
            throw new StiException((Throwable)e);
        }
    }

    private void exportSylkException(StiReport report, OutputStream exportOutputStream, StiDataExportSettings settings) throws IOException {
        int rowIndex;
        StiLicenseKeyValidator.isValidOnJavaFramework(null);
        if (settings == null) {
            throw new IllegalArgumentException("The 'settings' argument cannot be equal in null.");
        }
        StiPagesRange pageRange = settings.getPageRange();
        boolean exportDataOnly = settings.isExportDataOnly();
        boolean useDefaultSystemEncoding = settings.isUseDefaultSystemEncoding();
        Charset encoding = settings.getEncoding();
        this.fontList = new ArrayList();
        DataFont standardFont = new DataFont("Arial", false, false, false, 200, 0);
        this.getFontNumber(standardFont);
        this.getFontNumber(standardFont);
        this.getFontNumber(standardFont);
        this.getFontNumber(standardFont);
        this.colorHash = new Hashtable();
        this.formatList = new ArrayList();
        this.getFormatNumber("General");
        if (useDefaultSystemEncoding) {
            encoding = Charset.defaultCharset();
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.writer = new OutputStreamWriter((OutputStream)outputStream, encoding);
        this.setStatusString(StiLocalization.getValue((String)"Export", (String)"ExportingCreatingDocument"));
        StiPagesCollection pages = pageRange.getSelectedPages(report.getRenderedPages());
        StiMatrix matrix = new StiMatrix(pages, true, this);
        if (this.isStoped()) {
            return;
        }
        if (exportDataOnly) {
            matrix.scanComponentsPlacement(true, false);
            int linesCount = 0;
            Hashtable<String, String> headerNames = new Hashtable<String, String>();
            String lastParentBandName = null;
            for (int rowIndex2 = 0; rowIndex2 < matrix.getCoordY().size() - 1; ++rowIndex2) {
                boolean isHeader = false;
                if (matrix.getLinePlacement()[rowIndex2] == StiMatrix.StiTableLineInfo.HeaderD || matrix.getLinePlacement()[rowIndex2] == StiMatrix.StiTableLineInfo.HeaderAP) {
                    String parentBandName;
                    String tempSt = matrix.getParentBandName()[rowIndex2];
                    int symPos = tempSt.indexOf(31);
                    if (symPos != -1 && (parentBandName = tempSt.substring(0, symPos)) != lastParentBandName) {
                        lastParentBandName = parentBandName;
                        headerNames.clear();
                    }
                    if (!headerNames.containsKey(tempSt)) {
                        isHeader = true;
                        headerNames.put(tempSt, tempSt);
                    }
                }
                if (matrix.getLinePlacement()[rowIndex2] != StiMatrix.StiTableLineInfo.Data && !isHeader) continue;
                for (int columnIndex = 0; columnIndex < matrix.getCoordX().size() - 1; ++columnIndex) {
                    matrix.getCells()[linesCount][columnIndex] = matrix.getCells()[rowIndex2][columnIndex];
                    if (matrix.getCells()[linesCount][columnIndex] != null) {
                        matrix.getCells()[linesCount][columnIndex].setTop(linesCount);
                    }
                    if (linesCount == 0 || matrix.getBordersX()[rowIndex2][columnIndex] != null) {
                        matrix.getBordersX()[linesCount][columnIndex] = matrix.getBordersX()[rowIndex2][columnIndex];
                    }
                    matrix.getBordersX()[linesCount + 1][columnIndex] = matrix.getBordersX()[rowIndex2 + 1][columnIndex];
                    matrix.getBordersY()[linesCount][columnIndex] = matrix.getBordersY()[rowIndex2][columnIndex];
                    matrix.getBookmarks()[linesCount][columnIndex] = matrix.getBookmarks()[rowIndex2][columnIndex];
                }
                matrix.getBordersY()[linesCount][matrix.getCoordX().size() - 1] = matrix.getBordersY()[rowIndex2][matrix.getCoordX().size() - 1];
                double lineHeight = (Double)StiMapUtil.getByIndex(matrix.getCoordY(), rowIndex2 + 1) - (Double)StiMapUtil.getByIndex(matrix.getCoordY(), rowIndex2);
                StiMapUtil.setByIndex(matrix.getCoordY(), linesCount + 1, (Double)StiMapUtil.getByIndex(matrix.getCoordY(), linesCount) + lineHeight);
                ++linesCount;
            }
            int numAbove = matrix.getCoordY().size() - 1 - linesCount;
            if (numAbove > 0) {
                for (int tempIndex = 0; tempIndex < numAbove; ++tempIndex) {
                    StiMapUtil.removeAt(matrix.getCoordY(), linesCount + 1);
                }
            }
        }
        for (rowIndex = 0; rowIndex < matrix.getCoordY().size() - 1; ++rowIndex) {
            this.invokeExporting(rowIndex, matrix.getCoordY().size() - 1);
            if (this.isStoped()) {
                return;
            }
            int brushCount = 0;
            for (int columnIndex = 0; columnIndex < matrix.getCoordX().size() - 1; ++columnIndex) {
                boolean needBorderBottom;
                StiCell cell;
                String text = null;
                String style = null;
                String format = null;
                String picture = null;
                StiFont font = null;
                int colorIndex = 0;
                boolean isNumber = false;
                boolean needBrush = false;
                if (brushCount > 0) {
                    needBrush = true;
                    --brushCount;
                }
                if ((cell = matrix.getCells()[rowIndex][columnIndex]) != null) {
                    StiRichText rtf;
                    StiText textComp = cell.getComponent() instanceof StiText ? (StiText)cell.getComponent() : null;
                    StiRichText stiRichText = rtf = cell.getComponent() instanceof StiRichText ? (StiRichText)cell.getComponent() : null;
                    if (cell.getText() != null && cell.getText().length() > 0) {
                        text = cell.getText();
                    }
                    if (rtf != null && !"".equals(rtf.unpackRTF())) {
                        text = StiRtfHelper.rtfToPlain((String)rtf.unpackRTF());
                    }
                    if (text == null) {
                        text = "";
                    }
                    StringBuilder sbTemp = new StringBuilder();
                    for (int indexChar = 0; indexChar < text.length(); ++indexChar) {
                        char sym = text.charAt(indexChar);
                        if (sym < ' ') {
                            String st = String.format("\u001b%s%s", Character.valueOf((char)(32 + (sym >> 4 & 0xF))), Character.valueOf((char)(48 + (sym & 0xF))));
                            sbTemp.append(st);
                            continue;
                        }
                        sbTemp.append(sym);
                    }
                    text = StiExportUtils.trimEndWhiteSpace(sbTemp.toString());
                    font = cell.getCellStyle().getFont();
                    colorIndex = this.getColorIndex(cell.getCellStyle().getTextColor());
                    if (!StiColorEnum.Transparent.color().equals(cell.getCellStyle().getColor()) && cell.getCellStyle().getColor().getR() + cell.getCellStyle().getColor().getG() + cell.getCellStyle().getColor().getB() < 544) {
                        needBrush = true;
                        brushCount = cell.getWidth();
                    }
                    String inputFormat = "";
                    if (textComp != null) {
                        inputFormat = textComp.getFormat();
                    }
                    boolean isFormatCurrency = false;
                    boolean isFormatNumeric = false;
                    boolean isFormatPercent = false;
                    boolean isFormatDate = false;
                    boolean isFormatTime = false;
                    String outputFormat = "";
                    int decimalDigits = 2;
                    int groupDigits = 0;
                    String currencySymbol = "$";
                    boolean currencyPositionBefore = false;
                    boolean negativeBraces = false;
                    if (inputFormat != null && inputFormat.length() > 0) {
                        if (inputFormat.charAt(0) == 'C') {
                            isFormatCurrency = true;
                        }
                        if (inputFormat.charAt(0) == 'N') {
                            isFormatNumeric = true;
                        }
                        if (inputFormat.charAt(0) == 'P') {
                            isFormatPercent = true;
                        }
                        if (inputFormat.charAt(0) == 'D') {
                            isFormatDate = true;
                        }
                        if (inputFormat.charAt(0) == 'T') {
                            isFormatTime = true;
                        }
                        if (inputFormat.length() > 1 && (isFormatCurrency || isFormatNumeric || isFormatPercent)) {
                            int indexPos = 1;
                            if (Character.isDigit(inputFormat.charAt(indexPos))) {
                                StringBuilder decimalSB = new StringBuilder();
                                while (indexPos < inputFormat.length() && Character.isDigit(inputFormat.charAt(indexPos))) {
                                    decimalSB.append(inputFormat.charAt(indexPos));
                                    ++indexPos;
                                }
                                decimalDigits = Integer.parseInt(decimalSB.toString());
                            }
                            if (indexPos < inputFormat.length() && inputFormat.charAt(indexPos) == 'G') {
                                ++indexPos;
                                groupDigits = 3;
                            }
                            if (indexPos < inputFormat.length() && inputFormat.charAt(indexPos) == '(') {
                                ++indexPos;
                                negativeBraces = true;
                            }
                            if (indexPos < inputFormat.length() && (inputFormat.charAt(indexPos) == '+' || inputFormat.charAt(indexPos) == '-')) {
                                if (inputFormat.charAt(indexPos) == '+') {
                                    currencyPositionBefore = true;
                                }
                                if (++indexPos < inputFormat.length()) {
                                    currencySymbol = inputFormat.substring(indexPos);
                                }
                            }
                        }
                    }
                    if (isFormatCurrency || isFormatNumeric || isFormatPercent) {
                        StringBuilder outputSB = new StringBuilder();
                        if (isFormatCurrency && currencyPositionBefore) {
                            outputSB.append("\"");
                            outputSB.append(currencySymbol);
                            outputSB.append("\"");
                        }
                        if (groupDigits > 1) {
                            outputSB.append("#,");
                            outputSB.append(StiStringUtil.repeatString((String)"#", (int)(groupDigits - 1)));
                        }
                        outputSB.append('0');
                        if (decimalDigits > 0) {
                            outputSB.append(".");
                            outputSB.append(StiStringUtil.repeatString((String)"0", (int)decimalDigits));
                        }
                        if (isFormatCurrency && !currencyPositionBefore) {
                            outputSB.append("\"");
                            outputSB.append(currencySymbol);
                            outputSB.append("\"");
                        }
                        if (isFormatPercent) {
                            outputSB.append("%");
                        }
                        outputFormat = outputSB.toString();
                        String negativePattern = (negativeBraces ? "(" : "-") + outputFormat + (negativeBraces ? ")" : "");
                        if (textComp != null && textComp.getHideZeros()) {
                            outputFormat = outputFormat + ";" + negativePattern + ";";
                        } else if (negativeBraces) {
                            outputFormat = outputFormat + ";" + negativePattern;
                        }
                    }
                    if (isFormatDate) {
                        outputFormat = "dd/mm/yyyy";
                    }
                    if (isFormatTime) {
                        outputFormat = "[$-F400]h:mm:ss\\ AM/PM";
                    }
                    if (!"".equals(outputFormat)) {
                        picture = String.format("P%s;", this.getFormatNumber(outputFormat));
                    }
                    String formatInfo = "G0";
                    if (isFormatNumeric) {
                        formatInfo = String.format("F%s", decimalDigits);
                    }
                    if (isFormatCurrency) {
                        formatInfo = String.format("$%s", decimalDigits);
                    }
                    if (isFormatPercent) {
                        formatInfo = String.format("%s", decimalDigits);
                    }
                    String justify = "L";
                    if (cell.getCellStyle().getHorAlignment() == StiTextHorAlignment.Right) {
                        justify = "R";
                    }
                    if (cell.getCellStyle().getHorAlignment() == StiTextHorAlignment.Center) {
                        justify = "C";
                    }
                    if (cell.getCellStyle().getHorAlignment() == StiTextHorAlignment.Width) {
                        justify = "X";
                    }
                    format = String.format("F%s%s;", formatInfo, justify);
                    if (textComp != null && textComp.getExcelDataValue() != null && textComp.getExcelDataValue() != "-") {
                        Double number = 0.0;
                        String value = textComp.getExcelDataValue();
                        isNumber = true;
                        try {
                            if (isFormatDate || isFormatTime) {
                                DateFormat dateFormat = DateFormat.getDateTimeInstance();
                                dateFormat.setLenient(false);
                                Date date = dateFormat.parse(value);
                                SimpleDateFormat sdf = new SimpleDateFormat(((SimpleDateFormat)dateFormat).toPattern());
                                if (sdf.format(date).trim().equals(value.trim())) {
                                    if (isFormatDate) {
                                        number = (double)((date.getTime() + 3600000L + 2208972528000L) / 86400000L) + 2.0;
                                    } else {
                                        Calendar calendar = Calendar.getInstance();
                                        calendar.setTime(date);
                                        number = (double)(calendar.get(11) * 60 * 60 + calendar.get(12) * 60 + calendar.get(13)) / 86400.0;
                                    }
                                } else {
                                    isNumber = false;
                                }
                            } else {
                                number = Double.parseDouble(value.replaceAll(",", "."));
                            }
                        }
                        catch (Exception e) {
                            isNumber = false;
                        }
                        if (isNumber) {
                            text = number.toString().replaceAll(",", ".");
                        }
                    }
                }
                boolean needBorderLeft = matrix.getBordersY()[rowIndex][columnIndex] != null;
                boolean needBorderRight = matrix.getBordersY()[rowIndex][columnIndex + 1] != null;
                boolean needBorderTop = matrix.getBordersX()[rowIndex][columnIndex] != null;
                boolean bl = needBorderBottom = matrix.getBordersX()[rowIndex + 1][columnIndex] != null;
                if (needBorderLeft || needBorderRight || needBorderTop || needBorderBottom || font != null || needBrush) {
                    int fontIndex = 0;
                    if (font != null) {
                        fontIndex = this.getFontNumber(new DataFont(font.getName(), font.bold(), font.italic(), font.underline(), (int)(font.getSize() * 20.0), colorIndex));
                    }
                    style = String.format("S%s%s%s%s%s%s%s%s;", font != null && font.bold() ? "D" : "", font != null && font.italic() ? "I" : "", needBorderLeft ? "L" : "", needBorderRight ? "R" : "", needBorderTop ? "T" : "", needBorderBottom ? "B" : "", needBrush ? "S" : "", font != null ? String.format("M%s", fontIndex + 1) : "");
                }
                if (format == null && style == null && text == null && picture == null) continue;
                this.writer.write(String.format("F;%s%s%sY%s;X%s", this.getNotNull(picture), this.getNotNull(format), this.getNotNull(style), rowIndex + 1, columnIndex + 1) + "\r\n");
                if (text == null || text.length() <= 0) continue;
                if (isNumber) {
                    this.writer.write(String.format("C;K%s", text) + "\r\n");
                    continue;
                }
                this.writer.write(String.format("C;K\"%s\"", text) + "\r\n");
            }
        }
        this.writer.flush();
        this.writer = new OutputStreamWriter(exportOutputStream, encoding);
        this.writer.write("ID;PWXL;N;E\r\n");
        for (int index = 0; index < this.formatList.size(); ++index) {
            this.writer.write(String.format("P;P%s", this.formatList.get(index)) + "\r\n");
        }
        for (int indexFont = 0; indexFont < this.fontList.size(); ++indexFont) {
            DataFont tempFont = this.fontList.get(indexFont);
            StringBuilder sbFont = new StringBuilder("P;");
            sbFont.append(String.format("%s%S;M%s", indexFont < 4 ? "F" : "E", tempFont.Name, tempFont.Height));
            if (tempFont.Bold || tempFont.Italic || tempFont.Underlined) {
                sbFont.append(";S");
                if (tempFont.Bold) {
                    sbFont.append("B");
                }
                if (tempFont.Italic) {
                    sbFont.append("I");
                }
                if (tempFont.Underlined) {
                    sbFont.append("U");
                }
            }
            if (tempFont.Color != 0) {
                sbFont.append(String.format(";L%s", tempFont.Color));
            }
            this.writer.write(sbFont.toString() + "\r\n");
        }
        this.writer.write("F;P0;DG0G8;M255\r\n");
        this.writer.write(String.format("B;Y%s;X%s;D0 0 %s %s", matrix.getCoordY().size() - 1, matrix.getCoordX().size() - 1, matrix.getCoordY().size() - 2, matrix.getCoordX().size() - 2) + "\r\n");
        for (int columnIndex = 1; columnIndex < matrix.getCoordX().size(); ++columnIndex) {
            double value1;
            double value2 = (Double)StiMapUtil.getByIndex(matrix.getCoordX(), columnIndex);
            int width = (int)Math.round((value2 - (value1 = ((Double)StiMapUtil.getByIndex(matrix.getCoordX(), columnIndex - 1)).doubleValue())) * 14.688 * 0.008699796000000001);
            if (width == 0) {
                ++width;
            }
            this.writer.write(String.format("F;W%s %s %s", columnIndex, columnIndex, width) + "\r\n");
        }
        for (rowIndex = 1; rowIndex < matrix.getCoordY().size(); ++rowIndex) {
            int height = (int)Math.round(((Double)StiMapUtil.getByIndex(matrix.getCoordY(), rowIndex) - (Double)StiMapUtil.getByIndex(matrix.getCoordY(), rowIndex - 1)) * 14.688);
            if (height == 0) {
                ++height;
            }
            this.writer.write(String.format("F;M%s;R%s", height, rowIndex) + "\r\n");
        }
        this.writer.flush();
        outputStream.writeTo(exportOutputStream);
        outputStream.close();
        this.writer.write("E\r\n");
        this.writer.flush();
        this.writer.close();
        if (matrix != null) {
            matrix.clear();
            matrix = null;
        }
        this.formatList = null;
        this.fontList = null;
        this.colorHash = null;
        this.closeProgress();
    }

    private String getNotNull(String value) {
        return value == null ? "" : value;
    }

    @Override
    public StiExportFormat getExportFormat() {
        return StiExportFormat.Sylk;
    }

    @Override
    public boolean getMultipleFiles() {
        return false;
    }

    private class DataFont {
        public String Name;
        public boolean Bold;
        public boolean Italic;
        public boolean Underlined;
        public int Height;
        public int Color;

        public DataFont(String Name, boolean Bold, boolean Italic, boolean Underlined, int Height, int Color2) {
            this.Name = Name;
            this.Bold = Bold;
            this.Italic = Italic;
            this.Underlined = Underlined;
            this.Height = Height;
            this.Color = Color2;
        }

        public boolean equals(DataFont dataFont) {
            return StiStringUtil.stringsEquals((String)this.Name, (String)dataFont.Name) && this.Bold == dataFont.Bold && this.Italic == dataFont.Italic && this.Underlined == dataFont.Underlined && this.Height == dataFont.Height && this.Color == dataFont.Color;
        }
    }
}

