/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.export.service;

import com.stimulsoft.base.StiAttribute;
import com.stimulsoft.base.drawing.StiBorderSide;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.enums.StiTextHorAlignment;
import com.stimulsoft.base.drawing.enums.StiVertAlignment;
import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.licenses.StiLicenseKeyValidator;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.system.StiDateTime;
import com.stimulsoft.base.utils.StiMath;
import com.stimulsoft.base.utils.StiXmlTextWriter;
import com.stimulsoft.base.utils.StiZipWriter20;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiImageCache;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.StiPagesCollection;
import com.stimulsoft.report.components.enums.StiPageOrientation;
import com.stimulsoft.report.components.interfaces.IStiExportImage;
import com.stimulsoft.report.components.simplecomponents.StiCheckBox;
import com.stimulsoft.report.components.simplecomponents.StiImageHelper;
import com.stimulsoft.report.components.simplecomponents.StiRichText;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.enums.StiExportFormat;
import com.stimulsoft.report.export.StiSegmentPagesDivider;
import com.stimulsoft.report.export.service.StiExportService;
import com.stimulsoft.report.export.settings.StiExportSettings;
import com.stimulsoft.report.export.settings.StiOdsExportSettings;
import com.stimulsoft.report.export.tools.StiCell;
import com.stimulsoft.report.export.tools.StiCellStyle;
import com.stimulsoft.report.export.tools.StiExportUtils;
import com.stimulsoft.report.export.tools.StiImageFormat;
import com.stimulsoft.report.export.tools.StiMapUtil;
import com.stimulsoft.report.export.tools.StiMatrix;
import com.stimulsoft.report.export.tools.StiPagesRange;
import com.stimulsoft.report.options.ExportOptions;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Currency;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;

public class StiOdsExportService
extends StiExportService {
    private static final Logger LOGGER = Logger.getLogger("com.stimulsoft.report.export.service.StiOdsExportService");
    private StiReport report;
    private String fileName;
    private StiMatrix matrix = null;
    private StiImageCache imageCache = null;
    private ArrayList<CellStyleData> cellStyleList = null;
    private ArrayList dataStyleList = null;
    private ArrayList sheetNameList = null;
    private ArrayList<StiMatrix> matrixList = null;
    private ArrayList firstPageIndexList = null;
    private ArrayList minRowList = null;
    private ArrayList maxRowList = null;
    private ArrayList cellStyleTableList = null;
    private int xmlIndentation = 1;
    private float imageQuality = 0.75f;
    private float imageResolution = 96.0f;
    private boolean exportEachPageToSheet = false;

    private static String doubleToString(double number) {
        return String.valueOf(StiMath.round((double)(number / 100.0), (int)4)).replace(',', '.') + "in";
    }

    private static String getColumnName(int column) {
        int columnHigh = column / 26;
        int columnLow = column % 26;
        StringBuilder output = new StringBuilder();
        if (columnHigh > 0) {
            output.append((char)(65 + columnHigh - 1));
        }
        output.append((char)(65 + columnLow));
        return output.toString();
    }

    private static String getColorString(StiColor color) {
        return color.toHTML();
    }

    private int getCellStyleNumber(int indexRow, int indexColumn, int height, int width) {
        int index;
        CellStyleData style = new CellStyleData();
        boolean needBorderLeft = true;
        boolean needBorderRight = true;
        for (int index2 = 0; index2 < height; ++index2) {
            if (this.matrix.getBordersY()[indexRow + index2][indexColumn] == null) {
                needBorderLeft = false;
            }
            if (this.matrix.getBordersY()[indexRow + index2][indexColumn + width] != null) continue;
            needBorderRight = false;
        }
        boolean needBorderTop = true;
        boolean needBorderBottom = true;
        for (index = 0; index < width; ++index) {
            if (this.matrix.getBordersX()[indexRow][indexColumn + index] == null) {
                needBorderTop = false;
            }
            if (this.matrix.getBordersX()[indexRow + height][indexColumn + index] != null) continue;
            needBorderBottom = false;
        }
        if (needBorderTop) {
            style.BorderTop = StiOdsExportService.getStringFromBorder(this.matrix.getBordersX()[indexRow][indexColumn]);
        }
        if (needBorderLeft) {
            style.BorderLeft = StiOdsExportService.getStringFromBorder(this.matrix.getBordersY()[indexRow][indexColumn]);
        }
        if (needBorderBottom) {
            style.BorderBottom = StiOdsExportService.getStringFromBorder(this.matrix.getBordersX()[indexRow + height][indexColumn]);
        }
        if (needBorderRight) {
            style.BorderRight = StiOdsExportService.getStringFromBorder(this.matrix.getBordersY()[indexRow][indexColumn + width]);
        }
        if (this.matrix.getCells()[indexRow][indexColumn] != null) {
            StiCell cell = this.matrix.getCells()[indexRow][indexColumn];
            StiCellStyle cellStyle = cell.getCellStyle();
            style.FontName = cellStyle.getFont().getName();
            style.FontSize = (float)cellStyle.getFont().getSize();
            style.Bold = cellStyle.getFont().bold();
            style.Italic = cellStyle.getFont().italic();
            style.Underline = cellStyle.getFont().underline();
            style.FontColor = cellStyle.getTextColor();
            style.BackColor = cellStyle.getColor();
            style.VertAlign = cellStyle.getVertAlignment();
            style.HorAlign = cellStyle.getHorAlignment();
            double textAngle = 0.0;
            if (cellStyle.getTextOptions() != null) {
                textAngle = cellStyle.getTextOptions().getAngle();
                style.Wordwrap = cellStyle.getTextOptions().getWordWrap();
            }
            style.Angle = (int)Math.round(textAngle);
            if (cell.getComponent() != null) {
                StiCheckBox checkComp;
                StiText textComp;
                StiText stiText = textComp = cell.getComponent() instanceof StiText ? (StiText)cell.getComponent() : null;
                if (textComp != null) {
                    style.DataStyle = this.getDataStyleNumber(textComp);
                }
                StiCheckBox stiCheckBox = checkComp = cell.getComponent() instanceof StiCheckBox ? (StiCheckBox)cell.getComponent() : null;
                if (checkComp != null && !StiValidationUtil.isNullOrEmpty((String)checkComp.getExcelDataValue())) {
                    style.FontName = ExportOptions.CheckBoxReplacementForExcelValue.Font.getName();
                    style.FontSize = (float)ExportOptions.CheckBoxReplacementForExcelValue.Font.size;
                    style.Bold = ExportOptions.CheckBoxReplacementForExcelValue.Font.bold();
                    style.Italic = ExportOptions.CheckBoxReplacementForExcelValue.Font.italic();
                    style.Underline = ExportOptions.CheckBoxReplacementForExcelValue.Font.underline();
                    style.VertAlign = ExportOptions.CheckBoxReplacementForExcelValue.VertAlignment;
                    style.HorAlign = ExportOptions.CheckBoxReplacementForExcelValue.HorAlignment;
                }
            }
        }
        if (this.cellStyleList.size() > 0) {
            for (index = 0; index < this.cellStyleList.size(); ++index) {
                CellStyleData tempStyle = this.cellStyleList.get(index);
                if (tempStyle.BorderLeft != style.BorderLeft || tempStyle.BorderRight != style.BorderRight || tempStyle.BorderTop != style.BorderTop || tempStyle.BorderBottom != style.BorderBottom || tempStyle.BackColor != style.BackColor || tempStyle.VertAlign != style.VertAlign || tempStyle.FontName != style.FontName || tempStyle.FontSize != style.FontSize || tempStyle.Bold != style.Bold || tempStyle.Italic != style.Italic || tempStyle.Underline != style.Underline || tempStyle.FontColor != style.FontColor || tempStyle.HorAlign != style.HorAlign || tempStyle.Angle != style.Angle || tempStyle.Wordwrap != style.Wordwrap || tempStyle.DataStyle != style.DataStyle) continue;
                return index;
            }
        }
        this.cellStyleList.add(style);
        int temp = this.cellStyleList.size() - 1;
        return temp;
    }

    private static String getStringFromBorder(StiBorderSide border) {
        return String.format("%s solid %s", StiOdsExportService.doubleToString(border.getSize()), StiOdsExportService.getColorString(border.getColor()));
    }

    private int getDataStyleNumber(StiText textComp) {
        DataStyleData style = new DataStyleData();
        String inputFormat = textComp.getFormat();
        if (!StiValidationUtil.isNullOrEmpty((String)inputFormat)) {
            if (inputFormat.charAt(0) == 'C') {
                style.isCurrency = true;
            }
            if (inputFormat.charAt(0) == 'N') {
                style.isNumeric = true;
            }
            if (inputFormat.charAt(0) == 'P') {
                style.isPercent = true;
            }
            if (inputFormat.charAt(0) == 'D') {
                style.isDate = true;
                if (inputFormat.length() > 1) {
                    style.DateTimeFormatString = inputFormat.substring(1);
                }
            }
            if (inputFormat.charAt(0) == 'T') {
                style.isTime = true;
                if (inputFormat.length() > 1) {
                    style.DateTimeFormatString = inputFormat.substring(1);
                }
            }
            if (inputFormat.length() == 1) {
                style.isDefaultFormat = true;
            } else if (style.isCurrency || style.isNumeric || style.isPercent) {
                int indexPos = 1;
                if (Character.isDigit(inputFormat.charAt(indexPos))) {
                    StringBuilder decimalSB = new StringBuilder();
                    while (indexPos < inputFormat.length() && Character.isDigit(inputFormat.charAt(indexPos))) {
                        decimalSB.append(inputFormat.charAt(indexPos));
                        ++indexPos;
                    }
                    style.DecimalDigits = Integer.parseInt(decimalSB.toString());
                }
                if (indexPos < inputFormat.length() && inputFormat.charAt(indexPos) == 'G') {
                    ++indexPos;
                    style.GroupDigits = 3;
                }
                if (indexPos < inputFormat.length() && inputFormat.charAt(indexPos) == '(') {
                    ++indexPos;
                    style.NegativeBraces = true;
                }
                if (indexPos < inputFormat.length() && (inputFormat.charAt(indexPos) == '.' || inputFormat.charAt(indexPos) == ',')) {
                    style.DecimalComma = inputFormat.charAt(indexPos);
                    ++indexPos;
                }
                if (indexPos < inputFormat.length() && (inputFormat.charAt(indexPos) == '+' || inputFormat.charAt(indexPos) == '-')) {
                    if (inputFormat.charAt(indexPos) == '+') {
                        style.CurrencyPositionBefore = true;
                    }
                    if (++indexPos < inputFormat.length()) {
                        style.CurrencySymbol = inputFormat.substring(indexPos);
                    }
                }
            }
        } else {
            return -1;
        }
        if (textComp.getHideZeros() && !StiValidationUtil.isNullOrEmpty((String)inputFormat)) {
            style.isDefaultFormat = false;
        }
        if (this.dataStyleList.size() > 0) {
            for (int index = 0; index < this.dataStyleList.size(); ++index) {
                DataStyleData tempStyle = (DataStyleData)this.dataStyleList.get(index);
                if (tempStyle.isNumeric != style.isNumeric || tempStyle.isCurrency != style.isCurrency || tempStyle.isPercent != style.isPercent || tempStyle.isDate != style.isDate || tempStyle.isTime != style.isTime || tempStyle.isDefaultFormat != style.isDefaultFormat || tempStyle.DecimalDigits != style.DecimalDigits || tempStyle.DecimalComma != style.DecimalComma || tempStyle.GroupDigits != style.GroupDigits || tempStyle.CurrencySymbol != style.CurrencySymbol || tempStyle.CurrencyPositionBefore != style.CurrencyPositionBefore || tempStyle.DateTimeFormatString != style.DateTimeFormatString) continue;
                return index;
            }
        }
        this.dataStyleList.add(style);
        int temp = this.dataStyleList.size() - 1;
        return temp;
    }

    private byte[] writeMimetype() {
        return "application/vnd.oasis.opendocument.spreadsheet".getBytes();
    }

    private Document writeMeta() throws ParserConfigurationException {
        StiXmlTextWriter writer = new StiXmlTextWriter();
        writer.writeStartDocument();
        writer.writeStartElement("office:document-meta");
        writer.writeAttributeString("xmlns:office", "urn:oasis:names:tc:opendocument:xmlns:office:1.0");
        writer.writeAttributeString("xmlns:xlink", "http://www.w3.org/1999/xlink");
        writer.writeAttributeString("xmlns:dc", "http://purl.org/dc/elements/1.1/");
        writer.writeAttributeString("xmlns:meta", "urn:oasis:names:tc:opendocument:xmlns:meta:1.0");
        writer.writeAttributeString("xmlns:ooo", "http://openoffice.org/2004/office");
        writer.writeAttributeString("office:version", "1.1");
        writer.writeStartElement("office:meta");
        String dateTime = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.ENGLISH).format(new Date());
        String creator = StiAttribute.getVersion();
        writer.writeElementString("meta:generator", creator);
        writer.writeElementString("meta:creation-date", dateTime);
        writer.writeElementString("dc:date", dateTime);
        writer.writeElementString("meta:editing-cycles", "1");
        writer.writeElementString("meta:editing-duration", "PT0M0S");
        writer.writeStartElement("meta:user-defined");
        writer.writeAttributeString("meta:name", "Info 1");
        writer.writeEndElement();
        writer.writeStartElement("meta:user-defined");
        writer.writeAttributeString("meta:name", "Info 2");
        writer.writeEndElement();
        writer.writeStartElement("meta:user-defined");
        writer.writeAttributeString("meta:name", "Info 3");
        writer.writeEndElement();
        writer.writeStartElement("meta:user-defined");
        writer.writeAttributeString("meta:name", "Info 4");
        writer.writeEndElement();
        writer.writeStartElement("meta:document-statistic");
        writer.writeAttributeString("meta:table-count", "1");
        writer.writeAttributeString("meta:cell-count", "1");
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        return writer.getDocument();
    }

    private Document writeManifest() throws ParserConfigurationException {
        StiXmlTextWriter writer = new StiXmlTextWriter();
        writer.writeStartDocument();
        writer.writeStartElement("manifest:manifest");
        writer.writeAttributeString("xmlns:manifest", "urn:oasis:names:tc:opendocument:xmlns:manifest:1.0");
        writer.writeStartElement("manifest:file-entry");
        writer.writeAttributeString("manifest:media-type", "application/vnd.oasis.opendocument.spreadsheet");
        writer.writeAttributeString("manifest:full-path", "/");
        writer.writeEndElement();
        for (int index = 0; index < this.imageCache.imageStore.size(); ++index) {
            writer.writeStartElement("manifest:file-entry");
            writer.writeAttributeString("manifest:media-type", "image/jpeg");
            writer.writeAttributeString("manifest:full-path", String.format("Pictures/%05d.jpg", index + 1));
            writer.writeEndElement();
        }
        writer.writeStartElement("manifest:file-entry");
        writer.writeAttributeString("manifest:media-type", "text/xml");
        writer.writeAttributeString("manifest:full-path", "content.xml");
        writer.writeEndElement();
        writer.writeStartElement("manifest:file-entry");
        writer.writeAttributeString("manifest:media-type", "text/xml");
        writer.writeAttributeString("manifest:full-path", "styles.xml");
        writer.writeEndElement();
        writer.writeStartElement("manifest:file-entry");
        writer.writeAttributeString("manifest:media-type", "text/xml");
        writer.writeAttributeString("manifest:full-path", "meta.xml");
        writer.writeEndElement();
        writer.writeStartElement("manifest:file-entry");
        writer.writeAttributeString("manifest:media-type", "text/xml");
        writer.writeAttributeString("manifest:full-path", "settings.xml");
        writer.writeEndElement();
        writer.writeFullEndElement();
        return writer.getDocument();
    }

    private byte[] writeImage(int number) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StiImageHelper.saveWithDPI(this.imageCache.getImageByIndex(number), out, StiImageFormat.Jpeg, (Integer)72, this.imageQuality);
        byte[] bytes = out.toByteArray();
        out.close();
        return bytes;
    }

    private Document writeSettings() throws ParserConfigurationException {
        StiXmlTextWriter writer = new StiXmlTextWriter();
        writer.writeStartDocument();
        writer.writeStartElement("office:document-settings");
        writer.writeAttributeString("xmlns:office", "urn:oasis:names:tc:opendocument:xmlns:office:1.0");
        writer.writeAttributeString("xmlns:xlink", "http://www.w3.org/1999/xlink");
        writer.writeAttributeString("xmlns:config", "urn:oasis:names:tc:opendocument:xmlns:config:1.0");
        writer.writeAttributeString("xmlns:ooo", "http://openoffice.org/2004/office");
        writer.writeAttributeString("office:version", "1.1");
        writer.writeStartElement("office:settings");
        writer.writeStartElement("config:config-item-set");
        writer.writeAttributeString("config:name", "ooo:view-settings");
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "VisibleAreaTop");
        writer.writeAttributeString("config:type", "int");
        writer.writeString("0");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "VisibleAreaLeft");
        writer.writeAttributeString("config:type", "int");
        writer.writeString("-10107");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "VisibleAreaWidth");
        writer.writeAttributeString("config:type", "int");
        writer.writeString("43208");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "VisibleAreaHeight");
        writer.writeAttributeString("config:type", "int");
        writer.writeString("22174");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item-map-indexed");
        writer.writeAttributeString("config:name", "Views");
        writer.writeStartElement("config:config-item-map-entry");
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "ViewId");
        writer.writeAttributeString("config:type", "string");
        writer.writeString("View1");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item-map-named");
        writer.writeAttributeString("config:name", "Tables");
        writer.writeStartElement("config:config-item-map-entry");
        writer.writeAttributeString("config:name", "Sheet1");
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "CursorPositionX");
        writer.writeAttributeString("config:type", "int");
        writer.writeString("1");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "CursorPositionY");
        writer.writeAttributeString("config:type", "int");
        writer.writeString("1");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "HorizontalSplitMode");
        writer.writeAttributeString("config:type", "short");
        writer.writeString("0");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "VerticalSplitMode");
        writer.writeAttributeString("config:type", "short");
        writer.writeString("0");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "HorizontalSplitPosition");
        writer.writeAttributeString("config:type", "int");
        writer.writeString("0");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "VerticalSplitPosition");
        writer.writeAttributeString("config:type", "int");
        writer.writeString("0");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "ActiveSplitRange");
        writer.writeAttributeString("config:type", "short");
        writer.writeString("2");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "PositionLeft");
        writer.writeAttributeString("config:type", "int");
        writer.writeString("0");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "PositionRight");
        writer.writeAttributeString("config:type", "int");
        writer.writeString("0");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "PositionTop");
        writer.writeAttributeString("config:type", "int");
        writer.writeString("0");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "PositionBottom");
        writer.writeAttributeString("config:type", "int");
        writer.writeString("0");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "ActiveTable");
        writer.writeAttributeString("config:type", "string");
        writer.writeString("Sheet1");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "HorizontalScrollbarWidth");
        writer.writeAttributeString("config:type", "int");
        writer.writeString("270");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "ZoomType");
        writer.writeAttributeString("config:type", "short");
        writer.writeString("0");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "ZoomValue");
        writer.writeAttributeString("config:type", "int");
        writer.writeString("100");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "PageViewZoomValue");
        writer.writeAttributeString("config:type", "int");
        writer.writeString("60");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "ShowPageBreakPreview");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("false");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "ShowZeroValues");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("true");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "ShowNotes");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("true");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "ShowGrid");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("true");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "GridColor");
        writer.writeAttributeString("config:type", "long");
        writer.writeString("12632256");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "ShowPageBreaks");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("true");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "HasColumnRowHeaders");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("true");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "HasSheetTabs");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("true");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "IsOutlineSymbolsSet");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("true");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "IsSnapToRaster");
        writer.writeAttributeString("config:type", "long");
        writer.writeString("false");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "RasterIsVisible");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("false");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "RasterResolutionX");
        writer.writeAttributeString("config:type", "int");
        writer.writeString("1000");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "RasterResolutionY");
        writer.writeAttributeString("config:type", "int");
        writer.writeString("1000");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "RasterSubdivisionX");
        writer.writeAttributeString("config:type", "int");
        writer.writeString("1");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "RasterSubdivisionY");
        writer.writeAttributeString("config:type", "int");
        writer.writeString("1");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "IsRasterAxisSynchronized");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("true");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("config:config-item-set");
        writer.writeAttributeString("config:name", "ooo:configuration-settings");
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "ShowZeroValues");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("true");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "ShowNotes");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("true");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "ShowGrid");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("true");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "GridColor");
        writer.writeAttributeString("config:type", "long");
        writer.writeString("12632256");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "ShowPageBreaks");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("true");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "LinkUpdateMode");
        writer.writeAttributeString("config:type", "short");
        writer.writeString("3");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "HasColumnRowHeaders");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("true");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "HasSheetTabs");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("true");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "IsOutlineSymbolsSet");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("true");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "IsSnapToRaster");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("false");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "RasterIsVisible");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("false");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "RasterResolutionX");
        writer.writeAttributeString("config:type", "int");
        writer.writeString("1000");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "RasterResolutionY");
        writer.writeAttributeString("config:type", "int");
        writer.writeString("1000");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "RasterSubdivisionX");
        writer.writeAttributeString("config:type", "int");
        writer.writeString("1");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "RasterSubdivisionY");
        writer.writeAttributeString("config:type", "int");
        writer.writeString("1");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "IsRasterAxisSynchronized");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("true");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "AutoCalculate");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("true");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "PrinterName");
        writer.writeAttributeString("config:type", "string");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "PrinterSetup");
        writer.writeAttributeString("config:type", "base64Binary");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "ApplyUserData");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("true");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "CharacterCompressionType");
        writer.writeAttributeString("config:type", "short");
        writer.writeString("0");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "IsKernAsianPunctuation");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("false");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "SaveVersionOnClose");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("false");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "UpdateFromTemplate");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("true");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "AllowPrintJobCancel");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("true");
        writer.writeEndElement();
        writer.writeStartElement("config:config-item");
        writer.writeAttributeString("config:name", "LoadReadonly");
        writer.writeAttributeString("config:type", "boolean");
        writer.writeString("false");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeFullEndElement();
        return writer.getDocument();
    }

    private Document writeStyles(StiPagesCollection pages) throws ParserConfigurationException {
        StiXmlTextWriter writer = new StiXmlTextWriter();
        writer.writeStartDocument();
        writer.writeStartElement("office:document-styles");
        writer.writeAttributeString("xmlns:office", "urn:oasis:names:tc:opendocument:xmlns:office:1.0");
        writer.writeAttributeString("xmlns:style", "urn:oasis:names:tc:opendocument:xmlns:style:1.0");
        writer.writeAttributeString("xmlns:text", "urn:oasis:names:tc:opendocument:xmlns:text:1.0");
        writer.writeAttributeString("xmlns:table", "urn:oasis:names:tc:opendocument:xmlns:table:1.0");
        writer.writeAttributeString("xmlns:draw", "urn:oasis:names:tc:opendocument:xmlns:drawing:1.0");
        writer.writeAttributeString("xmlns:fo", "urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0");
        writer.writeAttributeString("xmlns:xlink", "http://www.w3.org/1999/xlink");
        writer.writeAttributeString("xmlns:dc", "http://purl.org/dc/elements/1.1/");
        writer.writeAttributeString("xmlns:meta", "urn:oasis:names:tc:opendocument:xmlns:meta:1.0");
        writer.writeAttributeString("xmlns:number", "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0");
        writer.writeAttributeString("xmlns:presentation", "urn:oasis:names:tc:opendocument:xmlns:presentation:1.0");
        writer.writeAttributeString("xmlns:svg", "urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0");
        writer.writeAttributeString("xmlns:chart", "urn:oasis:names:tc:opendocument:xmlns:chart:1.0");
        writer.writeAttributeString("xmlns:dr3d", "urn:oasis:names:tc:opendocument:xmlns:dr3d:1.0");
        writer.writeAttributeString("xmlns:math", "http://www.w3.org/1998/Math/MathML");
        writer.writeAttributeString("xmlns:form", "urn:oasis:names:tc:opendocument:xmlns:form:1.0");
        writer.writeAttributeString("xmlns:script", "urn:oasis:names:tc:opendocument:xmlns:script:1.0");
        writer.writeAttributeString("xmlns:ooo", "http://openoffice.org/2004/office");
        writer.writeAttributeString("xmlns:ooow", "http://openoffice.org/2004/writer");
        writer.writeAttributeString("xmlns:oooc", "http://openoffice.org/2004/calc");
        writer.writeAttributeString("xmlns:dom", "http://www.w3.org/2001/xml-events");
        writer.writeAttributeString("office:version", "1.1");
        writer.writeStartElement("office:font-face-decls");
        writer.writeStartElement("style:font-face");
        writer.writeAttributeString("style:name", "Arial");
        writer.writeAttributeString("svg:font-family", "Arial");
        writer.writeEndElement();
        writer.writeStartElement("style:font-face");
        writer.writeAttributeString("style:name", "Tahoma");
        writer.writeAttributeString("svg:font-family", "Tahoma");
        writer.writeAttributeString("style:font-family-generic", "system");
        writer.writeAttributeString("style:font-pitch", "variable");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("office:styles");
        writer.writeStartElement("style:default-style");
        writer.writeAttributeString("style:family", "table-cell");
        writer.writeStartElement("style:table-cell-properties");
        writer.writeAttributeString("style:decimal-places", "2");
        writer.writeEndElement();
        writer.writeStartElement("style:paragraph-properties");
        writer.writeAttributeString("style:tab-stop-distance", "1.25cm");
        writer.writeEndElement();
        writer.writeStartElement("style:text-properties");
        writer.writeAttributeString("style:font-name", "Arial");
        writer.writeAttributeString("fo:language", "ru");
        writer.writeAttributeString("fo:country", "RU");
        writer.writeAttributeString("style:font-name-asian", "Lucida Sans Unicode");
        writer.writeAttributeString("style:language-asian", "zxx");
        writer.writeAttributeString("style:country-asian", "none");
        writer.writeAttributeString("style:font-name-complex", "Tahoma");
        writer.writeAttributeString("style:language-complex", "zxx");
        writer.writeAttributeString("style:country-complex", "none");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("number:number-style");
        writer.writeAttributeString("style:name", "N0");
        writer.writeStartElement("number:number");
        writer.writeAttributeString("number:min-integer-digits", "1");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("style:style");
        writer.writeAttributeString("style:name", "Default");
        writer.writeAttributeString("style:family", "table-cell");
        writer.writeEndElement();
        writer.writeStartElement("style:style");
        writer.writeAttributeString("style:name", "Result");
        writer.writeAttributeString("style:family", "table-cell");
        writer.writeAttributeString("style:parent-style-name", "Default");
        writer.writeStartElement("style:text-properties");
        writer.writeAttributeString("fo:font-style", "italic");
        writer.writeAttributeString("style:text-underline-style", "solid");
        writer.writeAttributeString("style:text-underline-width", "auto");
        writer.writeAttributeString("style:text-underline-color", "font-color");
        writer.writeAttributeString("fo:font-weight", "bold");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("style:style");
        writer.writeAttributeString("style:name", "Heading");
        writer.writeAttributeString("style:family", "table-cell");
        writer.writeAttributeString("style:parent-style-name", "Default");
        writer.writeStartElement("style:table-cell-properties");
        writer.writeAttributeString("style:text-align-source", "fix");
        writer.writeAttributeString("style:repeat-content", "false");
        writer.writeEndElement();
        writer.writeStartElement("style:paragraph-properties");
        writer.writeAttributeString("fo:text-align", "center");
        writer.writeEndElement();
        writer.writeStartElement("style:text-properties");
        writer.writeAttributeString("fo:font-size", "16pt");
        writer.writeAttributeString("fo:font-style", "italic");
        writer.writeAttributeString("fo:font-weight", "bold");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("style:style");
        writer.writeAttributeString("style:name", "Heading1");
        writer.writeAttributeString("style:family", "table-cell");
        writer.writeAttributeString("style:parent-style-name", "Heading");
        writer.writeStartElement("style:table-cell-properties");
        writer.writeAttributeString("style:rotation-angle", "90");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("office:automatic-styles");
        StiPage page = pages.get(0);
        double pageHeight = page.getUnit().ConvertToHInches(page.getPageHeight() * (double)page.getSegmentPerHeight());
        double pageWidth = page.getUnit().ConvertToHInches(page.getPageWidth() * (double)page.getSegmentPerWidth());
        double mgLeft = page.getUnit().ConvertToHInches(page.getMargins().getLeft());
        double mgRight = page.getUnit().ConvertToHInches(page.getMargins().getRight());
        double mgTop = page.getUnit().ConvertToHInches(page.getMargins().getTop());
        double mgBottom = page.getUnit().ConvertToHInches(page.getMargins().getBottom()) - 4.0;
        if (mgBottom < 0.0) {
            mgBottom = 0.0;
        }
        writer.writeStartElement("style:page-layout");
        writer.writeAttributeString("style:name", "pm1");
        writer.writeStartElement("style:page-layout-properties");
        writer.writeAttributeString("fo:page-width", StiOdsExportService.doubleToString(pageWidth));
        writer.writeAttributeString("fo:page-height", StiOdsExportService.doubleToString(pageHeight));
        writer.writeAttributeString("style:num-format", "1");
        writer.writeAttributeString("style:print-orientation", page.getOrientation() == StiPageOrientation.Portrait ? "portrait" : "landscape");
        writer.writeAttributeString("fo:margin-top", StiOdsExportService.doubleToString(mgTop));
        writer.writeAttributeString("fo:margin-bottom", StiOdsExportService.doubleToString(mgBottom));
        writer.writeAttributeString("fo:margin-left", StiOdsExportService.doubleToString(mgLeft));
        writer.writeAttributeString("fo:margin-right", StiOdsExportService.doubleToString(mgRight));
        writer.writeAttributeString("style:writing-mode", "lr-tb");
        writer.writeEndElement();
        writer.writeStartElement("style:header-style");
        writer.writeStartElement("style:header-footer-properties");
        writer.writeAttributeString("fo:min-height", "0.101cm");
        writer.writeAttributeString("fo:margin-left", "0cm");
        writer.writeAttributeString("fo:margin-right", "0cm");
        writer.writeAttributeString("fo:margin-bottom", "0cm");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("style:footer-style");
        writer.writeStartElement("style:header-footer-properties");
        writer.writeAttributeString("fo:min-height", "0.101cm");
        writer.writeAttributeString("fo:margin-left", "0cm");
        writer.writeAttributeString("fo:margin-right", "0cm");
        writer.writeAttributeString("fo:margin-top", "0cm");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeFullEndElement();
        writer.writeStartElement("office:master-styles");
        writer.writeStartElement("style:master-page");
        writer.writeAttributeString("style:name", "Default");
        writer.writeAttributeString("style:page-layout-name", "pm1");
        writer.writeStartElement("style:header");
        writer.writeAttributeString("style:display", "false");
        writer.writeStartElement("text:p");
        writer.writeStartElement("text:sheet-name");
        writer.writeString("Sheet1");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("style:header-left");
        writer.writeAttributeString("style:display", "false");
        writer.writeEndElement();
        writer.writeStartElement("style:footer");
        writer.writeAttributeString("style:display", "false");
        writer.writeStartElement("text:p");
        writer.writeString("Page ");
        writer.writeStartElement("text:page-number");
        writer.writeString("1");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("style:footer-left");
        writer.writeAttributeString("style:display", "false");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeFullEndElement();
        return writer.getDocument();
    }

    private Document writeContent(StiReport report, StiPagesCollection allPages) throws ParserConfigurationException {
        int indexStyle;
        int maxRowIndex;
        int minRowIndex;
        StiXmlTextWriter writer = new StiXmlTextWriter();
        writer.writeStartDocument();
        writer.writeStartElement("office:document-content");
        writer.writeAttributeString("xmlns:office", "urn:oasis:names:tc:opendocument:xmlns:office:1.0");
        writer.writeAttributeString("xmlns:style", "urn:oasis:names:tc:opendocument:xmlns:style:1.0");
        writer.writeAttributeString("xmlns:text", "urn:oasis:names:tc:opendocument:xmlns:text:1.0");
        writer.writeAttributeString("xmlns:table", "urn:oasis:names:tc:opendocument:xmlns:table:1.0");
        writer.writeAttributeString("xmlns:draw", "urn:oasis:names:tc:opendocument:xmlns:drawing:1.0");
        writer.writeAttributeString("xmlns:fo", "urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0");
        writer.writeAttributeString("xmlns:xlink", "http://www.w3.org/1999/xlink");
        writer.writeAttributeString("xmlns:dc", "http://purl.org/dc/elements/1.1/");
        writer.writeAttributeString("xmlns:meta", "urn:oasis:names:tc:opendocument:xmlns:meta:1.0");
        writer.writeAttributeString("xmlns:number", "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0");
        writer.writeAttributeString("xmlns:presentation", "urn:oasis:names:tc:opendocument:xmlns:presentation:1.0");
        writer.writeAttributeString("xmlns:svg", "urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0");
        writer.writeAttributeString("xmlns:chart", "urn:oasis:names:tc:opendocument:xmlns:chart:1.0");
        writer.writeAttributeString("xmlns:dr3d", "urn:oasis:names:tc:opendocument:xmlns:dr3d:1.0");
        writer.writeAttributeString("xmlns:math", "http://www.w3.org/1998/Math/MathML");
        writer.writeAttributeString("xmlns:form", "urn:oasis:names:tc:opendocument:xmlns:form:1.0");
        writer.writeAttributeString("xmlns:script", "urn:oasis:names:tc:opendocument:xmlns:script:1.0");
        writer.writeAttributeString("xmlns:ooo", "http://openoffice.org/2004/office");
        writer.writeAttributeString("xmlns:ooow", "http://openoffice.org/2004/writer");
        writer.writeAttributeString("xmlns:oooc", "http://openoffice.org/2004/calc");
        writer.writeAttributeString("xmlns:dom", "http://www.w3.org/2001/xml-events");
        writer.writeAttributeString("xmlns:xforms", "http://www.w3.org/2002/xforms");
        writer.writeAttributeString("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
        writer.writeAttributeString("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        writer.writeAttributeString("office:version", "1.1");
        for (int indexPage = 0; indexPage < allPages.size(); ++indexPage) {
            StiPagesCollection pages = new StiPagesCollection(report);
            pages.add(allPages.get(indexPage));
            int firstPageIndex = indexPage;
            if (!this.exportEachPageToSheet) {
                String pageName = allPages.get(indexPage).getExcelSheetValue();
                while (indexPage < allPages.size() - 1 && StiValidationUtil.equals((Object)allPages.get(indexPage + 1).getExcelSheetValue(), (Object)pageName)) {
                    pages.add(allPages.get(++indexPage));
                }
            }
            pages.cacheMode = report.getRenderedPages().getCacheMode();
            String sheetName = pages.get(0).getExcelSheetValue();
            if (StiValidationUtil.isNullOrEmpty((String)sheetName)) {
                sheetName = String.format("Page %s", this.sheetNameList.size() + 1);
            }
            String sheetSuffix = "";
            int sheetIndex = 1;
            this.matrix = new StiMatrix(pages, ExportOptions.OpenDocumentCalc.DivideBigCells, this);
            if (this.isStoped()) {
                return null;
            }
            minRowIndex = 0;
            do {
                this.firstPageIndexList.add(firstPageIndex);
                this.matrixList.add(this.matrix);
                maxRowIndex = this.matrix.getCoordY().size() - 1;
                if (maxRowIndex - minRowIndex > ExportOptions.OpenDocumentCalc.MaximumSheetHeight) {
                    maxRowIndex = minRowIndex + ExportOptions.OpenDocumentCalc.MaximumSheetHeight;
                } else {
                    this.matrix = null;
                }
                this.minRowList.add(minRowIndex);
                this.maxRowList.add(maxRowIndex);
                minRowIndex = maxRowIndex;
                if (this.matrix != null || sheetSuffix.length() > 0) {
                    sheetSuffix = String.format(" part%s", sheetIndex++);
                }
                this.sheetNameList.add(sheetName + sheetSuffix);
                if (!this.isStoped()) continue;
                return null;
            } while (this.matrix != null);
        }
        Hashtable<Double, Integer> rowHeightList = new Hashtable<Double, Integer>();
        Hashtable<Integer, Double> rowHeightList2 = new Hashtable<Integer, Double>();
        Hashtable<Double, Integer> colWidthList = new Hashtable<Double, Integer>();
        Hashtable<Integer, Double> colWidthList2 = new Hashtable<Integer, Double>();
        for (int indexSheet = 0; indexSheet < this.matrixList.size(); ++indexSheet) {
            int listPos;
            this.matrix = this.matrixList.get(indexSheet);
            minRowIndex = (Integer)this.minRowList.get(indexSheet);
            maxRowIndex = (Integer)this.maxRowList.get(indexSheet);
            boolean[][] readyCells = new boolean[this.matrix.getCoordY().size()][this.matrix.getCoordX().size()];
            int[][] cellStyleTable = new int[this.matrix.getCoordY().size()][this.matrix.getCoordX().size()];
            for (int indexColumn = 0; indexColumn < this.matrix.getCoordX().size() - 1; ++indexColumn) {
                double columnWidth = (Double)StiMapUtil.getByIndex(this.matrix.getCoordX(), indexColumn + 1) - (Double)StiMapUtil.getByIndex(this.matrix.getCoordX(), indexColumn);
                if (colWidthList.containsKey(columnWidth)) continue;
                listPos = colWidthList.size();
                colWidthList.put(columnWidth, listPos);
                colWidthList2.put(listPos, columnWidth);
            }
            for (int indexRow = minRowIndex + 1; indexRow < maxRowIndex + 1; ++indexRow) {
                double rowHeight = (Double)StiMapUtil.getByIndex(this.matrix.getCoordY(), indexRow) - (Double)StiMapUtil.getByIndex(this.matrix.getCoordY(), indexRow - 1);
                if (!rowHeightList.containsKey(rowHeight)) {
                    listPos = rowHeightList.size();
                    rowHeightList.put(rowHeight, listPos);
                    rowHeightList2.put(listPos, rowHeight);
                }
                for (int indexColumn = 1; indexColumn < this.matrix.getCoordX().size(); ++indexColumn) {
                    StiCell cell = this.matrix.getCells()[indexRow - 1][indexColumn - 1];
                    if (readyCells[indexRow][indexColumn]) continue;
                    if (cell != null) {
                        for (int yy = 0; yy <= cell.getHeight(); ++yy) {
                            for (int xx = 0; xx <= cell.getWidth(); ++xx) {
                                readyCells[indexRow + yy][indexColumn + xx] = true;
                            }
                        }
                        cellStyleTable[indexRow - 1][indexColumn - 1] = this.getCellStyleNumber(indexRow - 1, indexColumn - 1, cell.getHeight() + 1, cell.getWidth() + 1);
                        continue;
                    }
                    cellStyleTable[indexRow - 1][indexColumn - 1] = this.getCellStyleNumber(indexRow - 1, indexColumn - 1, 1, 1);
                }
            }
            this.cellStyleTableList.add(cellStyleTable);
        }
        writer.writeStartElement("office:scripts");
        writer.writeEndElement();
        Hashtable<String, String> fonts = new Hashtable<String, String>();
        for (CellStyleData tempStyle : this.cellStyleList) {
            fonts.put(tempStyle.FontName, tempStyle.FontName);
        }
        writer.writeStartElement("office:font-face-decls");
        for (CellStyleData key : fonts.keySet()) {
            String fontName = (String)fonts.get(key);
            writer.writeStartElement("style:font-face");
            writer.writeAttributeString("style:name", fontName);
            writer.writeAttributeString("svg:font-family", fontName);
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.writeStartElement("office:automatic-styles");
        for (int indexColumn = 0; indexColumn < colWidthList.size(); ++indexColumn) {
            writer.writeStartElement("style:style");
            writer.writeAttributeString("style:name", String.format("co%s", indexColumn + 1));
            writer.writeAttributeString("style:family", "table-column");
            writer.writeStartElement("style:table-column-properties");
            writer.writeAttributeString("fo:break-before", "auto");
            double columnWidth = (Double)colWidthList2.get(indexColumn);
            writer.writeAttributeString("style:column-width", StiOdsExportService.doubleToString(columnWidth));
            writer.writeEndElement();
            writer.writeEndElement();
        }
        for (int indexRow = 0; indexRow < rowHeightList.size(); ++indexRow) {
            writer.writeStartElement("style:style");
            writer.writeAttributeString("style:name", String.format("ro%s", indexRow + 1));
            writer.writeAttributeString("style:family", "table-row");
            writer.writeStartElement("style:table-row-properties");
            double rowHeight = (Double)rowHeightList2.get(indexRow);
            writer.writeAttributeString("style:row-height", StiOdsExportService.doubleToString(rowHeight));
            writer.writeAttributeString("fo:break-before", "auto");
            writer.writeAttributeString("style:use-optimal-row-height", "false");
            writer.writeEndElement();
            writer.writeEndElement();
        }
        writer.writeStartElement("style:style");
        writer.writeAttributeString("style:name", "ta1");
        writer.writeAttributeString("style:family", "table");
        writer.writeAttributeString("style:master-page-name", "Default");
        writer.writeStartElement("style:table-properties");
        writer.writeAttributeString("table:display", "true");
        writer.writeAttributeString("style:writing-mode", "lr-tb");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("style:style");
        writer.writeAttributeString("style:name", "gr1");
        writer.writeAttributeString("style:family", "graphic");
        writer.writeStartElement("style:graphic-properties");
        writer.writeAttributeString("draw:stroke", "none");
        writer.writeAttributeString("draw:fill", "none");
        writer.writeAttributeString("draw:textarea-horizontal-align", "center");
        writer.writeAttributeString("draw:textarea-vertical-align", "middle");
        writer.writeAttributeString("draw:color-mode", "standard");
        writer.writeAttributeString("draw:luminance", "0%");
        writer.writeAttributeString("draw:contrast", "0%");
        writer.writeAttributeString("draw:gamma", "100%");
        writer.writeAttributeString("draw:red", "0%");
        writer.writeAttributeString("draw:green", "0%");
        writer.writeAttributeString("draw:blue", "0%");
        writer.writeAttributeString("fo:clip", "rect(0cm 0cm 0cm 0cm)");
        writer.writeAttributeString("draw:image-opacity", "100%");
        writer.writeAttributeString("style:mirror", "none");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("style:style");
        writer.writeAttributeString("style:name", "P1");
        writer.writeAttributeString("style:family", "paragraph");
        writer.writeStartElement("style:paragraph-properties");
        writer.writeAttributeString("fo:text-align", "center");
        writer.writeEndElement();
        writer.writeEndElement();
        for (indexStyle = 0; indexStyle < this.dataStyleList.size(); ++indexStyle) {
            DataStyleData style = (DataStyleData)this.dataStyleList.get(indexStyle);
            if (style.isNumeric) {
                writer.writeStartElement("number:number-style");
                if (style.NegativeBraces) {
                    writer.writeAttributeString("style:name", String.format("N%sP0", indexStyle + 1));
                    writer.writeAttributeString("style:volatile", "true");
                } else {
                    writer.writeAttributeString("style:name", String.format("N%s", indexStyle + 1));
                }
                if (style.DecimalComma != ' ') {
                    writer.writeAttributeString("number:language", style.DecimalComma == ',' ? "ru" : "en");
                    writer.writeAttributeString("number:country", style.DecimalComma == ',' ? "RU" : "US");
                }
                writer.writeStartElement("number:number");
                writer.writeAttributeString("number:decimal-places", style.DecimalDigits.toString());
                writer.writeAttributeString("number:min-integer-digits", "1");
                writer.writeAttributeString("number:grouping", style.GroupDigits == 3 ? "true" : "false");
                writer.writeEndElement();
                writer.writeEndElement();
                if (style.NegativeBraces) {
                    writer.writeStartElement("number:number-style");
                    writer.writeAttributeString("style:name", String.format("N%s", indexStyle + 1));
                    if (style.DecimalComma != ' ') {
                        writer.writeAttributeString("number:language", style.DecimalComma == ',' ? "ru" : "en");
                        writer.writeAttributeString("number:country", style.DecimalComma == ',' ? "RU" : "US");
                    }
                    writer.writeElementString("number:text", "(");
                    writer.writeStartElement("number:number");
                    writer.writeAttributeString("number:decimal-places", style.DecimalDigits.toString());
                    writer.writeAttributeString("number:min-integer-digits", "1");
                    writer.writeAttributeString("number:grouping", style.GroupDigits == 3 ? "true" : "false");
                    writer.writeEndElement();
                    writer.writeElementString("number:text", ")");
                    writer.writeStartElement("style:map");
                    writer.writeAttributeString("style:condition", "value()>=0");
                    writer.writeAttributeString("style:apply-style-name", String.format("N%sP0", indexStyle + 1));
                    writer.writeEndElement();
                    writer.writeEndElement();
                }
            }
            if (style.isPercent) {
                writer.writeStartElement("number:percentage-style");
                writer.writeAttributeString("style:name", String.format("N%s", indexStyle + 1));
                if (style.DecimalComma != ' ') {
                    writer.writeAttributeString("number:language", style.DecimalComma == ',' ? "ru" : "en");
                    writer.writeAttributeString("number:country", style.DecimalComma == ',' ? "RU" : "US");
                }
                writer.writeStartElement("number:number");
                writer.writeAttributeString("number:decimal-places", style.DecimalDigits.toString());
                writer.writeAttributeString("number:min-integer-digits", "1");
                if (style.GroupDigits == 3) {
                    writer.writeAttributeString("number:grouping", "true");
                }
                writer.writeEndElement();
                writer.writeElementString("number:text", "%");
                writer.writeEndElement();
            }
            if (style.isCurrency) {
                writer.writeStartElement("number:currency-style");
                writer.writeAttributeString("style:name", String.format("N%s", indexStyle + 1));
                if (style.DecimalComma != ' ') {
                    writer.writeAttributeString("number:language", style.DecimalComma == ',' ? "ru" : "en");
                    writer.writeAttributeString("number:country", style.DecimalComma == ',' ? "RU" : "US");
                }
                if (style.CurrencyPositionBefore) {
                    writer.writeElementString("number:currency-symbol", style.CurrencySymbol);
                }
                writer.writeStartElement("number:number");
                writer.writeAttributeString("number:decimal-places", style.DecimalDigits.toString());
                writer.writeAttributeString("number:min-integer-digits", "1");
                writer.writeAttributeString("number:grouping", style.GroupDigits == 3 ? "true" : "false");
                writer.writeEndElement();
                if (!style.CurrencyPositionBefore) {
                    writer.writeElementString("number:currency-symbol", style.CurrencySymbol);
                }
                writer.writeEndElement();
            }
            if (style.isDate) {
                writer.writeStartElement("number:date-style");
                writer.writeAttributeString("style:name", String.format("N%s", indexStyle + 1));
                if (StiValidationUtil.isNullOrEmpty((String)style.DateTimeFormatString) || style.DateTimeFormatString.indexOf("ddd") == -1) {
                    writer.writeAttributeString("number:automatic-order", "true");
                }
                this.writeDateTimeFormatString(writer, style.DateTimeFormatString, "d");
                writer.writeEndElement();
            }
            if (!style.isTime) continue;
            writer.writeStartElement("number:time-style");
            writer.writeAttributeString("style:name", String.format("N%s", indexStyle + 1));
            if (!StiValidationUtil.isNullOrEmpty((String)style.DateTimeFormatString) && style.DateTimeFormatString.indexOf("h") != -1) {
                writer.writeAttributeString("number:language", "en");
                writer.writeAttributeString("number:country", "US");
            }
            this.writeDateTimeFormatString(writer, style.DateTimeFormatString, "t");
            writer.writeEndElement();
        }
        for (indexStyle = 0; indexStyle < this.cellStyleList.size(); ++indexStyle) {
            CellStyleData style = this.cellStyleList.get(indexStyle);
            writer.writeStartElement("style:style");
            writer.writeAttributeString("style:name", String.format("ce%s", indexStyle + 1));
            writer.writeAttributeString("style:family", "table-cell");
            writer.writeAttributeString("style:parent-style-name", "Default");
            if (style.DataStyle != -1) {
                writer.writeAttributeString("style:data-style-name", String.format("N%s", style.DataStyle + 1));
            }
            writer.writeStartElement("style:table-cell-properties");
            if (!style.BackColor.equals(StiColorEnum.Transparent.color())) {
                writer.writeAttributeString("fo:background-color", StiOdsExportService.getColorString(style.BackColor));
            } else {
                writer.writeAttributeString("fo:background-color", "transparent");
            }
            if (style.VertAlign == StiVertAlignment.Center) {
                writer.writeAttributeString("style:vertical-align", "middle");
            }
            if (style.VertAlign == StiVertAlignment.Top) {
                writer.writeAttributeString("style:vertical-align", "top");
            }
            writer.writeAttributeString("style:text-align-source", "fix");
            writer.writeAttributeString("style:repeat-content", "false");
            if (style.Wordwrap) {
                writer.writeAttributeString("fo:wrap-option", "wrap");
            }
            writer.writeAttributeString("fo:padding", "0in");
            writer.writeAttributeString("fo:border-left", style.BorderLeft);
            writer.writeAttributeString("fo:border-right", style.BorderRight);
            writer.writeAttributeString("fo:border-top", style.BorderTop);
            writer.writeAttributeString("fo:border-bottom", style.BorderBottom);
            if (style.Angle != 0) {
                writer.writeAttributeString("style:rotation-angle", String.format("%s", style.Angle));
                writer.writeAttributeString("style:rotation-align", "none");
            }
            writer.writeEndElement();
            writer.writeStartElement("style:paragraph-properties");
            if (style.HorAlign == StiTextHorAlignment.Left) {
                writer.writeAttributeString("fo:text-align", "start");
            }
            if (style.HorAlign == StiTextHorAlignment.Center) {
                writer.writeAttributeString("fo:text-align", "center");
            }
            if (style.HorAlign == StiTextHorAlignment.Right) {
                writer.writeAttributeString("fo:text-align", "end");
            }
            if (style.HorAlign == StiTextHorAlignment.Width) {
                writer.writeAttributeString("fo:text-align", "justify");
            }
            writer.writeAttributeString("fo:margin-left", "0cm");
            writer.writeEndElement();
            writer.writeStartElement("style:text-properties");
            writer.writeAttributeString("fo:color", StiOdsExportService.getColorString(style.FontColor));
            writer.writeAttributeString("style:font-name", style.FontName);
            String fontSizeSt = String.format("%spt", Float.valueOf(style.FontSize)).replace(',', '.');
            writer.writeAttributeString("fo:font-size", fontSizeSt);
            writer.writeAttributeString("fo:font-size-asian", fontSizeSt);
            writer.writeAttributeString("fo:font-size-complex", fontSizeSt);
            if (style.Italic) {
                writer.writeAttributeString("fo:font-style", "italic");
                writer.writeAttributeString("fo:font-style-asian", "italic");
                writer.writeAttributeString("fo:font-style-complex", "italic");
            }
            if (style.Underline) {
                writer.writeAttributeString("style:text-underline-style", "solid");
                writer.writeAttributeString("style:text-underline-width", "auto");
                writer.writeAttributeString("style:text-underline-color", "font-color");
            }
            if (style.Bold) {
                writer.writeAttributeString("fo:font-weight", "bold");
                writer.writeAttributeString("fo:font-weight-asian", "bold");
                writer.writeAttributeString("fo:font-weight-complex", "bold");
            }
            writer.writeEndElement();
            writer.writeEndElement();
        }
        writer.writeFullEndElement();
        writer.writeStartElement("office:body");
        writer.writeStartElement("office:spreadsheet");
        writer.writeStartElement("table:calculation-settings");
        writer.writeAttributeString("table:use-regular-expressions", "false");
        writer.writeEndElement();
        this.currentPassNumber = ExportOptions.OpenDocumentCalc.DivideSegmentPages ? 3 : 2;
        for (int indexSheet = 0; indexSheet < this.matrixList.size(); ++indexSheet) {
            this.writeTableFromMatrix(writer, indexSheet, rowHeightList, colWidthList);
        }
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeFullEndElement();
        return writer.getDocument();
    }

    private String getPattern(int style) {
        try {
            SimpleDateFormat dateFormatter = (SimpleDateFormat)DateFormat.getDateInstance(style, Locale.getDefault());
            return dateFormatter.toPattern();
        }
        catch (Exception e) {
            if (StiOptions.Engine.logLevel >= 10) {
                e.printStackTrace();
            }
            return "dd/MM/yyyy";
        }
    }

    private void writeDateTimeFormatString(StiXmlTextWriter writer, String formatString, String defaultFormatString) {
        if (StiValidationUtil.isNullOrEmpty((String)formatString)) {
            formatString = defaultFormatString;
        }
        if (formatString.length() == 1) {
            if (formatString.equals("d")) {
                formatString = this.getPattern(3);
            } else if (formatString.equals("D")) {
                formatString = this.getPattern(1);
            } else if (formatString.equals("f")) {
                formatString = this.getPattern(3) + " hh:mm:ss";
            } else if (formatString.equals("F")) {
                formatString = this.getPattern(0);
            } else if (formatString.equals("g")) {
                formatString = this.getPattern(3) + " hh:mm:ss";
            } else if (formatString.equals("G")) {
                formatString = this.getPattern(3) + " hh:mm:ss";
            } else if (formatString.equals("m") || formatString.equals("M")) {
                formatString = this.getPattern(3);
            } else if (formatString.equals("r") || formatString.equals("R")) {
                formatString = this.getPattern(3);
            } else if (formatString.equals("s")) {
                formatString = this.getPattern(3);
            } else if (formatString.equals("t")) {
                formatString = "hh:mm:ss";
            } else if (formatString.equals("T")) {
                formatString = "hh:mm:ss";
            } else if (formatString.equals("u")) {
                formatString = this.getPattern(0);
            } else if (formatString.equals("U")) {
                formatString = this.getPattern(0);
            } else if (formatString.equals("y") || formatString.equals("Y")) {
                formatString = this.getPattern(2);
            }
            formatString = formatString.replaceAll("\"", "").replaceAll("'", "");
        }
        int index = 0;
        block8: while (index < formatString.length()) {
            char ch = formatString.charAt(index);
            int counter = 1;
            while (index + 1 < formatString.length() && formatString.charAt(index + 1) == ch) {
                ++index;
                ++counter;
            }
            ++index;
            switch (ch) {
                case 'd': {
                    if (counter == 1) {
                        writer.writeStartElement("number:day");
                        writer.writeEndElement();
                    }
                    if (counter == 2) {
                        writer.writeStartElement("number:day");
                        writer.writeAttributeString("number:style", "long");
                        writer.writeEndElement();
                    }
                    if (counter == 3) {
                        writer.writeStartElement("number:day-of-week");
                        writer.writeEndElement();
                    }
                    if (counter != 4) continue block8;
                    writer.writeStartElement("number:day-of-week");
                    writer.writeAttributeString("number:style", "long");
                    writer.writeEndElement();
                    continue block8;
                }
                case 'M': {
                    if (counter == 1) {
                        writer.writeStartElement("number:month");
                        writer.writeEndElement();
                    }
                    if (counter == 2) {
                        writer.writeStartElement("number:month");
                        writer.writeAttributeString("number:style", "long");
                        writer.writeEndElement();
                    }
                    if (counter == 3) {
                        writer.writeStartElement("number:month");
                        writer.writeAttributeString("number:textual", "true");
                        writer.writeEndElement();
                    }
                    if (counter != 4) continue block8;
                    writer.writeStartElement("number:month");
                    writer.writeAttributeString("number:style", "long");
                    writer.writeAttributeString("number:textual", "true");
                    writer.writeEndElement();
                    continue block8;
                }
                case 'y': {
                    if (counter == 1 || counter == 2) {
                        writer.writeStartElement("number:year");
                        writer.writeEndElement();
                    }
                    if (counter != 3 && counter != 4) continue block8;
                    writer.writeStartElement("number:year");
                    writer.writeAttributeString("number:style", "long");
                    writer.writeEndElement();
                    continue block8;
                }
                case 's': {
                    if (counter == 1) {
                        writer.writeStartElement("number:seconds");
                        writer.writeEndElement();
                    }
                    if (counter != 2) continue block8;
                    writer.writeStartElement("number:seconds");
                    writer.writeAttributeString("number:style", "long");
                    writer.writeEndElement();
                    continue block8;
                }
                case 'm': {
                    if (counter == 1) {
                        writer.writeStartElement("number:minutes");
                        writer.writeEndElement();
                    }
                    if (counter != 2) continue block8;
                    writer.writeStartElement("number:minutes");
                    writer.writeAttributeString("number:style", "long");
                    writer.writeEndElement();
                    continue block8;
                }
                case 'H': 
                case 'h': {
                    if (counter == 1) {
                        writer.writeStartElement("number:hours");
                        writer.writeEndElement();
                    }
                    if (counter != 2) continue block8;
                    writer.writeStartElement("number:hours");
                    writer.writeAttributeString("number:style", "long");
                    writer.writeEndElement();
                    continue block8;
                }
            }
            writer.writeElementString("number:text", Character.toString(ch));
        }
    }

    private Document writeTableFromMatrix(StiXmlTextWriter writer, int indexSheet, Hashtable rowHeightList, Hashtable colWidthList) {
        StiMatrix matrix = this.matrixList.get(indexSheet);
        int minRowIndex = (Integer)this.minRowList.get(indexSheet);
        int maxRowIndex = (Integer)this.maxRowList.get(indexSheet);
        int[][] cellStyleTable = (int[][])this.cellStyleTableList.get(indexSheet);
        String sheetName = (String)this.sheetNameList.get(indexSheet);
        boolean[][] readyCells = new boolean[matrix.getCoordY().size()][matrix.getCoordX().size()];
        Object richtextForConvert = null;
        writer.writeStartElement("table:table");
        writer.writeAttributeString("table:name", sheetName);
        writer.writeAttributeString("table:style-name", "ta1");
        writer.writeAttributeString("table:print", "false");
        for (int indexColumn = 0; indexColumn < matrix.getCoordX().size() - 1; ++indexColumn) {
            double columnWidth = (Double)StiMapUtil.getByIndex(matrix.getCoordX(), indexColumn + 1) - (Double)StiMapUtil.getByIndex(matrix.getCoordX(), indexColumn);
            int columnStyle = (Integer)colWidthList.get(columnWidth);
            writer.writeStartElement("table:table-column");
            writer.writeAttributeString("table:style-name", String.format("co%s", columnStyle + 1));
            writer.writeAttributeString("table:default-cell-style-name", "Default");
            writer.writeEndElement();
        }
        for (int indexRow = minRowIndex + 1; indexRow < maxRowIndex + 1; ++indexRow) {
            double rowHeightDouble = (Double)StiMapUtil.getByIndex(matrix.getCoordY(), indexRow) - (Double)StiMapUtil.getByIndex(matrix.getCoordY(), indexRow - 1);
            int rowStyle = (Integer)rowHeightList.get(rowHeightDouble);
            writer.writeStartElement("table:table-row");
            writer.writeAttributeString("table:style-name", String.format("ro%s", rowStyle + 1));
            for (int indexColumn = 1; indexColumn < matrix.getCoordX().size(); ++indexColumn) {
                StiCell cell = matrix.getCells()[indexRow - 1][indexColumn - 1];
                if (!readyCells[indexRow][indexColumn]) {
                    int cellStyleIndex;
                    if (cell != null) {
                        StiCheckBox checkComp;
                        for (int yy = 0; yy <= cell.getHeight(); ++yy) {
                            for (int xx = 0; xx <= cell.getWidth(); ++xx) {
                                readyCells[indexRow + yy][indexColumn + xx] = true;
                            }
                        }
                        cellStyleIndex = cellStyleTable[indexRow - 1][indexColumn - 1];
                        int dataStyleIndex = this.cellStyleList.get((int)cellStyleIndex).DataStyle;
                        writer.writeStartElement("table:table-cell");
                        writer.writeAttributeString("table:style-name", String.format("ce%s", cellStyleIndex + 1));
                        if (cell.getWidth() > 0 || cell.getHeight() > 0) {
                            writer.writeAttributeString("table:number-columns-spanned", String.format("%s", cell.getWidth() + 1));
                            writer.writeAttributeString("table:number-rows-spanned", String.format("%s", cell.getHeight() + 1));
                        }
                        StiRichText rtf = cell.getComponent() instanceof StiRichText ? (StiRichText)cell.getComponent() : null;
                        StiText textComp = cell.getComponent() instanceof StiText ? (StiText)cell.getComponent() : null;
                        String str = cell.getText();
                        if (rtf == null || StiValidationUtil.isNotNullOrEmpty((String)rtf.getRtfText())) {
                            // empty if block
                        }
                        StiCheckBox stiCheckBox = checkComp = cell.getComponent() instanceof StiCheckBox ? (StiCheckBox)cell.getComponent() : null;
                        if (checkComp != null && !StiValidationUtil.isNullOrEmpty((String)checkComp.getExcelDataValue())) {
                            str = checkComp.getExcelDataValue();
                        }
                        if (!cell.getComponent().isExportAsImage(StiExportFormat.Ods) && (!StiValidationUtil.isNullOrEmpty((String)str) || textComp != null && textComp.getExcelDataValue() != null)) {
                            String value;
                            boolean isNumber = false;
                            Double Number2 = 0.0;
                            StiDateTime dt = new StiDateTime();
                            DataStyleData dataStyle = null;
                            if (dataStyleIndex != -1 && textComp != null && textComp.getExcelDataValue() != null && !textComp.getExcelDataValue().equals("-")) {
                                value = textComp.getExcelDataValue();
                                char sep = '.';
                                String value2 = value.replace('.', ',').replace(',', sep);
                                dataStyle = (DataStyleData)this.dataStyleList.get(dataStyleIndex);
                                isNumber = true;
                                try {
                                    if (dataStyle.isDate || dataStyle.isTime) {
                                        try {
                                            dt = StiDateTime.Parse((String)value);
                                        }
                                        catch (Exception e) {
                                            isNumber = false;
                                        }
                                    } else {
                                        try {
                                            Number2 = Double.parseDouble(value2);
                                        }
                                        catch (Exception e) {
                                            isNumber = false;
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    isNumber = false;
                                }
                                if (!isNumber && str == null) {
                                    str = value;
                                }
                            }
                            if (isNumber) {
                                if (dataStyle.isDate) {
                                    writer.writeAttributeString("office:value-type", "date");
                                    writer.writeAttributeString("office:date-value", dt.toString("yyyy-MM-dd"));
                                } else if (dataStyle.isTime) {
                                    writer.writeAttributeString("office:value-type", "time");
                                    writer.writeAttributeString("office:time-value", "PTHH" + dt.toString("HH:mm:ss"));
                                } else {
                                    value = Number2.toString().replace(',', '.');
                                    if (dataStyle.isNumeric) {
                                        writer.writeAttributeString("office:value-type", "float");
                                    }
                                    if (dataStyle.isPercent) {
                                        writer.writeAttributeString("office:value-type", "percentage");
                                    }
                                    if (dataStyle.isCurrency) {
                                        writer.writeAttributeString("office:value-type", "currency");
                                    }
                                    writer.writeAttributeString("office:value", value);
                                }
                            } else {
                                writer.writeAttributeString("office:value-type", "string");
                            }
                            ArrayList<String> stringList = StiExportUtils.splitString(str, true);
                            for (int indexLine = 0; indexLine < stringList.size(); ++indexLine) {
                                String textLine = stringList.get(indexLine);
                                writer.writeStartElement("text:p");
                                writer.writeString(textLine);
                                writer.writeEndElement();
                            }
                        }
                        if (cell.getComponent().isExportAsImage(StiExportFormat.Ods)) {
                            float rsImageResolution;
                            BufferedImage image;
                            IStiExportImage exportImage;
                            writer.writeAttributeString("office:value-type", "string");
                            IStiExportImage iStiExportImage = exportImage = cell.getComponent() instanceof IStiExportImage ? (IStiExportImage)((Object)cell.getComponent()) : null;
                            if (exportImage != null && (image = exportImage.getImage(Double.valueOf(rsImageResolution = this.imageResolution))) != null) {
                                BufferedImage img = matrix.getRealImageData(cell, image);
                                if (img == null) {
                                    img = image;
                                }
                                int indexImage = this.imageCache.addImageInt(img);
                                double imageWidth = (Double)StiMapUtil.getByIndex(matrix.getCoordX(), indexColumn + cell.getWidth()) - (Double)StiMapUtil.getByIndex(matrix.getCoordX(), indexColumn - 1);
                                double imageHeight = (Double)StiMapUtil.getByIndex(matrix.getCoordY(), indexRow + cell.getHeight()) - (Double)StiMapUtil.getByIndex(matrix.getCoordY(), indexRow - 1);
                                String endCellAddress = String.format("'%s'.%s%s", sheetName, StiOdsExportService.getColumnName(cell.getLeft() + cell.getWidth() + 1), cell.getTop() + cell.getHeight() + 1 + 1);
                                writer.writeStartElement("draw:frame");
                                writer.writeAttributeString("table:end-cell-address", endCellAddress);
                                writer.writeAttributeString("table:end-x", "0in");
                                writer.writeAttributeString("table:end-y", "0in");
                                writer.writeAttributeString("draw:z-index", "0");
                                writer.writeAttributeString("draw:name", String.format("Picture%s", indexImage + 1));
                                writer.writeAttributeString("draw:style-name", "gr1");
                                writer.writeAttributeString("draw:text-style-name", "P1");
                                writer.writeAttributeString("text:anchor-type", "paragraph");
                                writer.writeAttributeString("svg:x", StiOdsExportService.doubleToString(0.0));
                                writer.writeAttributeString("svg:y", StiOdsExportService.doubleToString(0.0));
                                writer.writeAttributeString("svg:width", StiOdsExportService.doubleToString(imageWidth));
                                writer.writeAttributeString("svg:height", StiOdsExportService.doubleToString(imageHeight));
                                writer.writeStartElement("draw:image");
                                writer.writeAttributeString("xlink:href", String.format("Pictures/%05d.jpg", indexImage + 1));
                                writer.writeAttributeString("xlink:type", "simple");
                                writer.writeAttributeString("xlink:show", "embed");
                                writer.writeAttributeString("xlink:actuate", "onLoad");
                                writer.writeStartElement("text:p");
                                writer.writeEndElement();
                                writer.writeEndElement();
                                writer.writeEndElement();
                            }
                        }
                        writer.writeEndElement();
                        continue;
                    }
                    cellStyleIndex = cellStyleTable[indexRow - 1][indexColumn - 1];
                    writer.writeStartElement("table:table-cell");
                    writer.writeAttributeString("table:style-name", String.format("ce%s", cellStyleIndex + 1));
                    writer.writeEndElement();
                    continue;
                }
                writer.writeStartElement("table:covered-table-cell");
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
        return writer.getDocument();
    }

    public void exportOds(StiReport report, OutputStream outputStream, StiOdsExportSettings settings) throws StiException {
        try {
            report.invokeExporting(settings.getExportFormat());
            this.exportOdsException(report, outputStream, settings);
            report.invokeExported(settings.getExportFormat());
        }
        catch (Exception e) {
            throw new StiException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportOdsException(StiReport report, OutputStream outputStream, StiOdsExportSettings settings) throws IOException, TransformerException, ParserConfigurationException {
        StiLicenseKeyValidator.isValidOnJavaFramework(null);
        StiPagesRange pageRange = settings.getPageRange();
        this.imageResolution = settings.getImageResolution();
        this.imageQuality = settings.getImageQuality();
        this.xmlIndentation = 1;
        if (this.imageQuality < 0.0f) {
            this.imageQuality = 0.0f;
        }
        if (this.imageQuality > 1.0f) {
            this.imageQuality = 1.0f;
        }
        if (this.imageResolution < 10.0f) {
            this.imageResolution = 10.0f;
        }
        this.imageResolution /= 100.0f;
        try {
            this.imageCache = new StiImageCache(ExportOptions.OpenDocumentCalc.AllowImageComparer, StiImageFormat.Jpeg, this.imageQuality);
            this.cellStyleList = new ArrayList();
            this.dataStyleList = new ArrayList();
            this.sheetNameList = new ArrayList();
            this.matrixList = new ArrayList();
            this.firstPageIndexList = new ArrayList();
            this.minRowList = new ArrayList();
            this.maxRowList = new ArrayList();
            this.cellStyleTableList = new ArrayList();
            this.currentPassNumber = 0;
            this.maximumPassNumber = ExportOptions.OpenDocumentCalc.DivideSegmentPages ? 4 : 3;
            StiPagesCollection pages = pageRange.getSelectedPages(report.getRenderedPages());
            if (ExportOptions.OpenDocumentCalc.DivideSegmentPages) {
                pages = StiSegmentPagesDivider.divide(pages, this);
                this.currentPassNumber = 1;
            }
            if (this.isStoped()) {
                return;
            }
            this.setStatusString(StiLocalization.Get((String)"Export", (String)"ExportingCreatingDocument"));
            StiZipWriter20 zip = new StiZipWriter20(outputStream);
            zip.addFile("", "content.xml", this.writeContent(report, pages));
            this.setStatusString(StiLocalization.Get((String)"Export", (String)"ExportingCreatingDocument") + " 2");
            zip.addFile("", "mimetype", this.writeMimetype());
            zip.addFile("", "meta.xml", this.writeMeta());
            zip.addFile("META-INF/", "manifest.xml", this.writeManifest());
            zip.addFile("", "settings.xml", this.writeSettings());
            zip.addFile("", "styles.xml", this.writeStyles(pages));
            if (this.imageCache.imageStore.size() > 0) {
                for (int index = 0; index < this.imageCache.imageStore.size(); ++index) {
                    zip.addFile("Pictures/", String.format("%05d.jpg", index + 1), this.writeImage(index));
                }
            }
            zip.finish();
        }
        finally {
            this.sheetNameList.clear();
            this.sheetNameList = null;
            this.firstPageIndexList.clear();
            this.firstPageIndexList = null;
            this.minRowList.clear();
            this.minRowList = null;
            this.maxRowList.clear();
            this.maxRowList = null;
            for (StiMatrix matrix1 : this.matrixList) {
                if (matrix1 == null) continue;
                matrix1.clear();
            }
            this.matrixList.clear();
            this.matrixList = null;
            this.cellStyleTableList.clear();
            this.cellStyleTableList = null;
            this.dataStyleList.clear();
            this.dataStyleList = null;
            this.cellStyleList.clear();
            this.cellStyleList = null;
            this.imageCache.clear();
            this.imageCache = null;
        }
    }

    @Override
    public void export(StiReport report, OutputStream outputStream, StiExportSettings settings) throws StiException {
        this.exportOds(report, outputStream, (StiOdsExportSettings)settings);
    }

    @Override
    public boolean getMultipleFiles() {
        return false;
    }

    @Override
    public StiExportFormat getExportFormat() {
        return StiExportFormat.Ods;
    }

    private class DataStyleData {
        public boolean isNumeric = false;
        public boolean isCurrency = false;
        public boolean isPercent = false;
        public boolean isDate = false;
        public boolean isTime = false;
        public boolean isDefaultFormat = false;
        public Integer DecimalDigits = 2;
        public char DecimalComma = (char)32;
        public int GroupDigits = 0;
        public String CurrencySymbol;
        public boolean CurrencyPositionBefore;
        public boolean NegativeBraces;
        public String DateTimeFormatString;

        public DataStyleData() {
            Currency currency = Currency.getInstance("USD");
            try {
                currency = Currency.getInstance(Locale.getDefault());
            }
            catch (Exception e) {
                LOGGER.warning("the country of the given Locale.getDefault() is not a supported ISO 3166 country code.");
            }
            this.CurrencySymbol = currency.getSymbol();
            this.CurrencyPositionBefore = false;
            this.NegativeBraces = false;
            this.DateTimeFormatString = null;
        }
    }

    private class CellStyleData {
        public String BorderLeft = "none";
        public String BorderRight = "none";
        public String BorderTop = "none";
        public String BorderBottom = "none";
        public StiColor BackColor = StiColorEnum.Transparent.color();
        public StiVertAlignment VertAlign = StiVertAlignment.Bottom;
        public String FontName = "Arial";
        public float FontSize = 6.0f;
        public boolean Bold = false;
        public boolean Italic = false;
        public boolean Underline = false;
        public StiColor FontColor = StiColorEnum.Black.color();
        public StiTextHorAlignment HorAlign = StiTextHorAlignment.Left;
        public int Angle = 0;
        public boolean Wordwrap = false;
        public int DataStyle = -1;
    }
}

