/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.export;

import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.system.StiGuid;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.StiPagesCollection;
import com.stimulsoft.report.export.service.StiExportService;

public class StiSegmentPagesDivider {
    public static StiPagesCollection divide(StiPagesCollection pages) {
        return StiSegmentPagesDivider.divide(pages, null);
    }

    public static StiPagesCollection divide(StiPagesCollection pages, StiExportService service) {
        boolean finded = false;
        for (StiPage page : pages) {
            if (page.getSegmentPerWidth() <= 1 && page.getSegmentPerHeight() <= 1) continue;
            finded = true;
            break;
        }
        if (!finded) {
            return pages;
        }
        if (service != null) {
            service.setStatusString(StiLocalization.getValue((String)"Export", (String)"PreparingReport"));
        }
        StiPagesCollection newPages = new StiPagesCollection(pages.getReport());
        newPages.setCacheMode(pages.getCacheMode());
        if (newPages.cacheMode) {
            newPages.canUseCacheMode = true;
        }
        for (StiPage page : pages) {
            pages.GetPage(page);
            if (service != null) {
                service.invokeExporting(page, pages);
            }
            if (page.getSegmentPerWidth() > 1 || page.getSegmentPerHeight() > 1) {
                for (int x = 0; x < page.getSegmentPerWidth(); ++x) {
                    for (int y = 0; y < page.getSegmentPerHeight(); ++y) {
                        StiPage newPage = (StiPage)page.clone(false, false);
                        newPage.setGuid(StiGuid.newGuidString());
                        newPage.setSegmentPerWidth(1);
                        newPage.setSegmentPerHeight(1);
                        StiRectangle rect = new StiRectangle((double)x * newPage.getWidth(), (double)y * newPage.getHeight(), newPage.getWidth(), newPage.getHeight());
                        for (StiComponent comp : page.getComponents()) {
                            if (!comp.getEnabled() || !rect.contains(comp.getLeft(), comp.getTop())) continue;
                            if (rect.getLeft() == 0.0 && rect.getTop() == 0.0) {
                                newPage.getComponents().add(comp);
                                continue;
                            }
                            StiComponent newComp = (StiComponent)comp.clone();
                            newComp.setLeft(newComp.getLeft() - rect.getLeft());
                            newComp.setTop(newComp.getTop() - rect.getTop());
                            newPage.getComponents().add(newComp);
                        }
                        newPages.addV2Internal(newPage);
                    }
                }
                continue;
            }
            newPages.canUseCacheMode = false;
            newPages.addV2Internal(page);
            newPages.canUseCacheMode = newPages.cacheMode;
        }
        newPages.canUseCacheMode = false;
        return newPages;
    }
}

