/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.export;

import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.utils.StiSerializTypeConverter;
import com.stimulsoft.report.export.StiExportSettingsCreator;
import com.stimulsoft.report.export.settings.StiExportSettings;
import com.stimulsoft.report.export.tools.StiUserAccessPrivileges;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class StiExportSettingsHelper {
    public static Map<String, Object> serialise(StiExportSettings settings) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("Ident", (Object)settings.getIdent());
        try {
            Method[] allMethods;
            StiExportSettings defaultSettings = (StiExportSettings)settings.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            defaultSettings.setOpenAfterExport(true);
            for (Method method : allMethods = settings.getClass().getMethods()) {
                String name = method.getName();
                if (!Modifier.isPublic(method.getModifiers()) || !name.startsWith("get") && !name.startsWith("is") || method.getParameterCount() != 0 || name.equals("getClass") || name.equals("getPageRange")) continue;
                Object methodResult = method.invoke((Object)settings, null);
                result.put(StiExportSettingsHelper.getName(method), String.valueOf(methodResult));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static StiExportSettings deserialise(JSONObject json) {
        StiExportSettings settings = null;
        try {
            settings = StiExportSettingsCreator.New(json.getString("Ident"));
            Class<?> clazz = settings.getClass();
            Iterator keys = json.keys();
            while (keys.hasNext()) {
                Object value;
                Method setter;
                block12: {
                    String key = keys.next().toString();
                    setter = StiExportSettingsHelper.findMethod(clazz, key);
                    if (setter == null) continue;
                    String strValue = json.getString(key);
                    value = null;
                    if ("UserAccessPrivileges".equals(key)) {
                        value = StiSerializTypeConverter.stringToEnums(StiUserAccessPrivileges.class, (String)strValue);
                    } else {
                        try {
                            value = StiSerializTypeConverter.getDataFromString(setter.getParameterTypes()[0], (String)strValue);
                        }
                        catch (UnsupportedCharsetException u) {
                            if ("1200".equals(strValue)) {
                                value = Charset.forName("UTF-16");
                            }
                            if ("65001".equals(strValue)) {
                                value = Charset.forName("UTF-8");
                            }
                            if ("65000".equals(strValue)) {
                                value = Charset.forName("UTF-7");
                            }
                            if ("12000".equals(strValue)) {
                                value = Charset.forName("UTF-32");
                            }
                            if ("20127".equals(strValue)) {
                                value = Charset.forName("US-ASCII");
                            }
                            if (!"1201".equals(strValue)) break block12;
                            value = Charset.forName("UTF-16BE");
                        }
                    }
                }
                setter.invoke((Object)settings, value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return settings;
    }

    private static Method findMethod(Class<?> clazz, String name) {
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals("set" + name)) continue;
            return method;
        }
        return null;
    }

    private static String getName(Method method) {
        String result = method.getName().substring(method.getName().startsWith("get") ? 3 : 2);
        return result.substring(0, 1).toUpperCase() + result.substring(1);
    }
}

