/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.engine.parser.enums;

import java.util.concurrent.ConcurrentHashMap;

public enum StiMethodType {
    Substring(1000),
    ToString(1001),
    ToLower(1002),
    ToUpper(1003),
    IndexOf(1004),
    StartsWith(1005),
    EndsWith(1006),
    Parse(1007),
    Contains(1008),
    MethodNameSpace(1009),
    GetCurrentConditionValue(1010),
    GetData(1011),
    ToQueryString(1012),
    Count(1013),
    AddYears(1014),
    AddMonths(1015),
    AddDays(1016),
    AddHours(1017),
    AddMinutes(1017),
    AddSeconds(1018),
    AddMilliseconds(1019),
    Replace(1020);

    private final int intValue;
    private static ConcurrentHashMap<Integer, StiMethodType> mappings;
    private static ConcurrentHashMap<String, StiMethodType> methodsList;

    private static synchronized ConcurrentHashMap<Integer, StiMethodType> getMappings() {
        if (mappings == null) {
            mappings = new ConcurrentHashMap();
        }
        return mappings;
    }

    private StiMethodType(int value) {
        this.intValue = value;
        StiMethodType.getMappings().put(value, this);
    }

    public int getValue() {
        return this.intValue;
    }

    public static StiMethodType forValue(int value) {
        return StiMethodType.getMappings().get(value);
    }

    public static StiMethodType forValue(String name) {
        return StiMethodType.getMappings().get(name);
    }

    public static synchronized ConcurrentHashMap<String, StiMethodType> getMethodsList() {
        if (methodsList == null) {
            methodsList = new ConcurrentHashMap();
            methodsList.put("Substring", Substring);
            methodsList.put("ToString", ToString);
            methodsList.put("toString", ToString);
            methodsList.put("ToLower", ToLower);
            methodsList.put("ToUpper", ToUpper);
            methodsList.put("IndexOf", IndexOf);
            methodsList.put("StartsWith", StartsWith);
            methodsList.put("EndsWith", EndsWith);
            methodsList.put("Parse", Parse);
            methodsList.put("Contains", Contains);
            methodsList.put("GetCurrentConditionValue", GetCurrentConditionValue);
            methodsList.put("GetData", GetData);
            methodsList.put("ToQueryString", ToQueryString);
            methodsList.put("AddYears", AddYears);
            methodsList.put("AddMonths", AddMonths);
            methodsList.put("AddDays", AddDays);
            methodsList.put("AddHours", AddHours);
            methodsList.put("AddMinutes", AddMinutes);
            methodsList.put("AddSeconds", AddSeconds);
            methodsList.put("AddMilliseconds", AddMilliseconds);
            methodsList.put("Replace", Replace);
        }
        return methodsList;
    }

    static {
        methodsList = null;
    }
}

