/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.engine.parser;

import com.stimulsoft.base.system.StiDateTime;
import com.stimulsoft.base.system.StiTimeSpan;
import com.stimulsoft.lib.utils.StiTypeConverter;
import com.stimulsoft.report.Func;
import com.stimulsoft.report.engine.operations.StiOperationError;
import java.math.RoundingMode;
import java.time.ZonedDateTime;

public class StiParserAsmOperations {
    public static Object op_Add(Object par1, Object par2) {
        int category1 = StiTypeConverter.getCategoryClass((Object)par1);
        int category2 = StiTypeConverter.getCategoryClass((Object)par2);
        if (category1 <= 1 || category2 <= 1) {
            return Func.Convert.toString(par1) + Func.Convert.toString(par2);
        }
        if (category1 == 2 || category2 == 2) {
            return Func.Convert.toBigDecimal(par1).add(Func.Convert.toBigDecimal(par2));
        }
        if (category1 == 3 || category2 == 3) {
            return Func.Convert.toDouble(par1) + Func.Convert.toDouble(par2);
        }
        if (category1 >= 4 && category1 <= 6 || category2 >= 4 && category2 <= 6) {
            return Func.Convert.toInt32(par1) + Func.Convert.toInt32(par2);
        }
        if (!(category1 != 10 && category1 != 8 || category2 != 10 && category2 != 8)) {
            return new StiTimeSpan(StiParserAsmOperations.getTicks(par1) + StiParserAsmOperations.getTicks(par2));
        }
        throw StiOperationError.notApplyToTypes.getError("+", par1.getClass().toString(), par2.getClass().toString());
    }

    public static Object op_Sub(Object par1, Object par2) {
        int category1 = StiTypeConverter.getCategoryClass((Object)par1);
        int category2 = StiTypeConverter.getCategoryClass((Object)par2);
        if (category1 <= 1 || category2 <= 1) {
            throw StiOperationError.notApplyToTypes.getError("-", par1.getClass().toString(), par2.getClass().toString());
        }
        if (category1 == 2 || category2 == 2) {
            return Func.Convert.toBigDecimal(par1).subtract(Func.Convert.toBigDecimal(par2));
        }
        if (category1 == 3 || category2 == 3) {
            return Func.Convert.toDouble(par1) - Func.Convert.toDouble(par2);
        }
        if (category1 >= 4 && category1 <= 6 || category2 >= 4 && category2 <= 6) {
            return Func.Convert.toInt32(par1) - Func.Convert.toInt32(par2);
        }
        if (!(category1 != 10 && category1 != 8 || category2 != 10 && category2 != 8)) {
            return new StiTimeSpan(StiParserAsmOperations.getTicks(par1) - StiParserAsmOperations.getTicks(par2));
        }
        throw StiOperationError.notApplyToTypes.getError("-", par1.getClass().toString(), par2.getClass().toString());
    }

    public static Object op_Mult(Object par1, Object par2) {
        int category1 = StiTypeConverter.getCategoryClass((Object)par1);
        int category2 = StiTypeConverter.getCategoryClass((Object)par2);
        if (category1 <= 1 || category2 <= 1) {
            throw StiOperationError.notApplyToTypes.getError("*", par1.getClass().toString(), par2.getClass().toString());
        }
        if (category1 == 2 || category2 == 2) {
            return Func.Convert.toBigDecimal(par1).multiply(Func.Convert.toBigDecimal(par2));
        }
        if (category1 == 3 || category2 == 3) {
            return Func.Convert.toDouble(par1) * Func.Convert.toDouble(par2);
        }
        if (category1 >= 4 && category1 <= 6 || category2 >= 4 && category2 <= 6) {
            return Func.Convert.toInt32(par1) * Func.Convert.toInt32(par2);
        }
        if (!(category1 != 10 && category1 != 8 || category2 != 10 && category2 != 8)) {
            return new StiTimeSpan(StiParserAsmOperations.getTicks(par1) * StiParserAsmOperations.getTicks(par2));
        }
        throw StiOperationError.notApplyToTypes.getError("*", par1.getClass().toString(), par2.getClass().toString());
    }

    public static Object op_Div(Object par1, Object par2) {
        int category1 = StiTypeConverter.getCategoryClass((Object)par1);
        int category2 = StiTypeConverter.getCategoryClass((Object)par2);
        if (category1 <= 1 || category2 <= 1) {
            throw StiOperationError.notApplyToTypes.getError("/", par1.getClass().toString(), par2.getClass().toString());
        }
        if (category1 == 2 || category2 == 2) {
            return Func.Convert.toBigDecimal(par1).divide(Func.Convert.toBigDecimal(par2), 20, RoundingMode.HALF_UP);
        }
        if (category1 == 3 || category2 == 3) {
            return Func.Convert.toDouble(par1) / Func.Convert.toDouble(par2);
        }
        if (category1 >= 4 && category1 <= 6 || category2 >= 4 && category2 <= 6) {
            return Func.Convert.toInt32(par1) / Func.Convert.toInt32(par2);
        }
        throw StiOperationError.notApplyToTypes.getError("/", par1.getClass().toString(), par2.getClass().toString());
    }

    static StiDateTime toStiDateTime(Object obj) {
        return obj instanceof StiDateTime ? (StiDateTime)obj : new StiDateTime((ZonedDateTime)obj);
    }

    static long getTicks(Object obj) {
        if (obj instanceof StiDateTime) {
            return ((StiDateTime)obj).getTicks();
        }
        if (obj instanceof ZonedDateTime) {
            return ((ZonedDateTime)obj).toInstant().toEpochMilli();
        }
        if (obj instanceof StiTimeSpan) {
            return ((StiTimeSpan)obj).getTicks();
        }
        return 0L;
    }
}

