/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.engine.parser;

import com.stimulsoft.base.DBNull;
import com.stimulsoft.base.drawing.StiHatchStyle;
import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.system.StiDateTime;
import com.stimulsoft.base.system.StiFontStyle;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.system.StiTimeSpan;
import com.stimulsoft.base.utils.StiLoggingUtil;
import com.stimulsoft.base.utils.StiMath;
import com.stimulsoft.data.functons.Funcs;
import com.stimulsoft.lib.base64.StiBase64EncoderUtil;
import com.stimulsoft.lib.utils.StiCalendarUtil;
import com.stimulsoft.lib.utils.StiStringUtil;
import com.stimulsoft.lib.utils.StiTypeConverter;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.CalendarWeekRule;
import com.stimulsoft.report.DayOfWeek;
import com.stimulsoft.report.Func;
import com.stimulsoft.report.StiCustomFunction;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.StiTotals;
import com.stimulsoft.report.dictionary.StiFunctionsDate;
import com.stimulsoft.report.dictionary.StiFunctionsStrings;
import com.stimulsoft.report.dictionary.StiUserFunction;
import com.stimulsoft.report.dictionary.StiUserFunctionArgument;
import com.stimulsoft.report.dictionary.dataSources.StiDataSource;
import com.stimulsoft.report.dictionary.functions.StiFunction;
import com.stimulsoft.report.dictionary.functions.StiFunctions;
import com.stimulsoft.report.dictionary.functions.StiFunctionsData;
import com.stimulsoft.report.dictionary.functions.StiFunctionsDateTime;
import com.stimulsoft.report.dictionary.functions.StiFunctionsDrawing;
import com.stimulsoft.report.dictionary.functions.StiFunctionsMath;
import com.stimulsoft.report.dictionary.functions.StiFunctionsPrintState;
import com.stimulsoft.report.dictionary.functions.StiFunctionsProgramming;
import com.stimulsoft.report.dictionary.userFunction.helpers.StiUserFunctionHelper;
import com.stimulsoft.report.engine.parser.ParserErrorCode;
import com.stimulsoft.report.engine.parser.StiAsmCommand;
import com.stimulsoft.report.engine.parser.StiParser;
import com.stimulsoft.report.engine.parser.StiParserData;
import com.stimulsoft.report.engine.parser.StiParserMethodInfo;
import com.stimulsoft.report.engine.parser.enums.StiFunctionType;
import com.stimulsoft.report.engine.parser.enums.StiParserDataType;
import com.stimulsoft.report.helpers.StiNullValuesHelper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.logging.Logger;

public class StiCallFunction {
    private static final Logger LOG = Logger.getLogger(StiCallFunction.class.getName());
    private static String[] errorsList = new String[]{"Syntax error", "", "The expression is empty", "Division by zero", "Unexpected end of expression", "The name '%s' does not exist in the current context", "Syntax error - unprocessed lexemes remain", "( expected", ") expected", "Field, method, or property is not found: '%s'", "Operator '%s' cannot be applied to operands of type '%s' and type '%s'", "The function is not found: '%s'", "No overload for method '%s' takes '%s' arguments", "The '%s' function has invalid argument '%s': cannot convert from '%s' to '%s'", "The '%s' function is not yet implemented", "The '%s' method has invalid argument '%s': cannot convert from '%s' to '%s'", "'%s' does not contain a definition for '%s'"};

    public static Object callFunc(StiFunctionType name, List argsList, StiReport report, StiParser parser, StiAsmCommand command) {
        try {
            StiFunctionType functionType = name;
            int overload = StiCallFunction.checkParserMethodInfo(name, argsList);
            switch (name) {
                case Count: {
                    return StiTotals.Count(argsList.get(0));
                }
                case CountAllLevels: {
                    return StiTotals.Count(argsList.get(0));
                }
                case CountDistinct: {
                    return StiTotals.CountDistinct(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case Avg: {
                    return StiTotals.Avg(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case AvgD: {
                    return StiTotals.AvgD(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case AvgDate: {
                    return StiTotals.Avg(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case AvgI: {
                    return StiTotals.AvgI(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case AvgTime: {
                    return StiTotals.Avg(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case Max: {
                    return StiTotals.Max(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case MaxD: {
                    return StiTotals.MaxD(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case MaxDate: {
                    return StiTotals.MaxDate(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case MaxI: {
                    return StiTotals.MaxI(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case MaxStr: {
                    return StiTotals.MaxStr(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case MaxTime: {
                    return StiTotals.MaxDate(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case Median: {
                    return StiTotals.Median(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case MedianD: {
                    return StiTotals.MedianD(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case MedianI: {
                    return StiTotals.MedianI(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case Min: {
                    return StiTotals.Min(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case MinD: {
                    return StiTotals.MinD(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case MinDate: {
                    return StiTotals.MinDate(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case MinI: {
                    return StiTotals.MinI(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case MinStr: {
                    return StiTotals.MinStr(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case MinTime: {
                    return StiTotals.MinDate(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case Mode: {
                    return StiTotals.Mode(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case ModeD: {
                    return StiTotals.ModeD(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case ModeI: {
                    return StiTotals.ModeI(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case Sum: {
                    return StiTotals.Sum(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case SumD: {
                    return StiTotals.SumD(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case SumDistinct: {
                    StiParserData dataSumDistinct = new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser);
                    dataSumDistinct.AsmList2 = (ArrayList)argsList.get(2);
                    return StiTotals.SumDistinct(dataSumDistinct, report, null);
                }
                case SumI: {
                    return StiTotals.SumI(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case SumTime: {
                    return StiTotals.Sum(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case First: {
                    return StiTotals.First(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case Last: {
                    return StiTotals.Last(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cCount: {
                    return StiTotals.cCount(argsList.get(0));
                }
                case cCountDistinct: {
                    return StiTotals.cCountDistinct(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cAvg: {
                    return StiTotals.cAvg(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cAvgD: {
                    return StiTotals.cAvgD(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cAvgDate: {
                    return StiTotals.cAvg(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cAvgI: {
                    return StiTotals.cAvgI(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cAvgTime: {
                    return StiTotals.cAvg(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cMax: {
                    return StiTotals.cMax(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cMaxD: {
                    return StiTotals.cMaxD(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cMaxDate: {
                    return StiTotals.cMaxDate(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cMaxI: {
                    return StiTotals.cMaxI(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cMaxStr: {
                    return StiTotals.cMaxStr(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cMaxTime: {
                    return StiTotals.cMaxDate(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cMedian: {
                    return StiTotals.cMedian(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cMedianD: {
                    return StiTotals.cMedianD(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cMedianI: {
                    return StiTotals.cMedianI(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cMin: {
                    return StiTotals.cMin(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cMinD: {
                    return StiTotals.cMinD(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cMinDate: {
                    return StiTotals.cMinDate(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cMinI: {
                    return StiTotals.cMinI(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cMinStr: {
                    return StiTotals.cMinStr(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cMinTime: {
                    return StiTotals.cMinDate(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cMode: {
                    return StiTotals.cMode(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cModeD: {
                    return StiTotals.cModeD(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cModeI: {
                    return StiTotals.cModeI(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cSum: {
                    return StiTotals.cSum(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cSumD: {
                    return StiTotals.cSumD(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cSumDistinct: {
                    return StiTotals.cSum(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cSumI: {
                    return StiTotals.cSumI(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cSumTime: {
                    return StiTotals.cSum(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cFirst: {
                    return StiTotals.cFirst(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case cLast: {
                    return StiTotals.cLast(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rCount: {
                    return StiTotals.cCountRunning(argsList.get(0));
                }
                case rCountDistinct: {
                    return StiTotals.cCountDistinctRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rAvg: {
                    return StiTotals.cAvgRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rAvgD: {
                    return StiTotals.cAvgDRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rAvgDate: {
                    return StiTotals.cAvgRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rAvgI: {
                    return StiTotals.cAvgIRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rAvgTime: {
                    return StiTotals.cAvgRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rMax: {
                    return StiTotals.cMaxRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rMaxD: {
                    return StiTotals.cMaxDRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rMaxDate: {
                    return StiTotals.cMaxDate(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rMaxI: {
                    return StiTotals.cMaxIRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rMaxStr: {
                    return StiTotals.cMaxStr(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rMaxTime: {
                    return StiTotals.cMaxDate(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rMedian: {
                    return StiTotals.cMedianRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rMedianD: {
                    return StiTotals.cMedianDRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rMedianI: {
                    return StiTotals.cMedianIRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rMin: {
                    return StiTotals.cMinRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rMinD: {
                    return StiTotals.cMinDRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rMinDate: {
                    return StiTotals.cMinDate(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rMinI: {
                    return StiTotals.cMinIRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rMinStr: {
                    return StiTotals.cMinStr(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rMinTime: {
                    return StiTotals.cMinDate(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rMode: {
                    return StiTotals.cModeRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rModeD: {
                    return StiTotals.cModeDRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rModeI: {
                    return StiTotals.cModeIRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rSum: {
                    return StiTotals.cSumRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rSumD: {
                    return StiTotals.cSumDRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rSumDistinct: {
                    return StiTotals.cSum(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rSumI: {
                    return StiTotals.cSumIRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rSumTime: {
                    return StiTotals.cSumRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rFirst: {
                    return StiTotals.cFirstRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case rLast: {
                    return StiTotals.cLastRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser), report, null);
                }
                case iCount: {
                    return StiTotals.Count(new StiParserData(argsList.get(0), null, parser, (ArrayList)argsList.get(1)), report, null);
                }
                case iCountDistinct: {
                    return StiTotals.CountDistinct(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iAvg: {
                    return StiTotals.Avg(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iAvgD: {
                    return StiTotals.AvgD(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iAvgDate: {
                    return StiTotals.Avg(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iAvgI: {
                    return StiTotals.AvgI(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iAvgTime: {
                    return StiTotals.Avg(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iMax: {
                    return StiTotals.Max(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iMaxD: {
                    return StiTotals.MaxD(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iMaxDate: {
                    return StiTotals.MaxDate(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iMaxI: {
                    return StiTotals.MaxI(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iMaxStr: {
                    return StiTotals.MaxStr(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iMaxTime: {
                    return StiTotals.MaxDate(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iMedian: {
                    return StiTotals.Median(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iMedianD: {
                    return StiTotals.MedianD(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iMedianI: {
                    return StiTotals.MedianI(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iMin: {
                    return StiTotals.Min(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iMinD: {
                    return StiTotals.MinD(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iMinDate: {
                    return StiTotals.MinDate(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iMinI: {
                    return StiTotals.MinI(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iMinStr: {
                    return StiTotals.MinStr(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iMinTime: {
                    return StiTotals.MinDate(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iMode: {
                    return StiTotals.Mode(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iModeD: {
                    return StiTotals.ModeD(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iModeI: {
                    return StiTotals.ModeI(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iSum: {
                    return StiTotals.Sum(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iSumD: {
                    return StiTotals.SumD(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iSumDistinct: {
                    return StiTotals.SumDistinct(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iSumI: {
                    return StiTotals.SumI(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iSumTime: {
                    return StiTotals.Sum(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iFirst: {
                    return StiTotals.First(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case iLast: {
                    return StiTotals.Last(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciCount: {
                    return StiTotals.cCount(new StiParserData(argsList.get(0), null, parser, (ArrayList)argsList.get(1)), report, null);
                }
                case ciCountDistinct: {
                    return StiTotals.cCountDistinct(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciAvg: {
                    return StiTotals.cAvg(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciAvgD: {
                    return StiTotals.cAvgD(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciAvgDate: {
                    return StiTotals.cAvg(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciAvgI: {
                    return StiTotals.cAvgI(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciAvgTime: {
                    return StiTotals.cAvg(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciMax: {
                    return StiTotals.cMax(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciMaxD: {
                    return StiTotals.cMaxD(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciMaxDate: {
                    return StiTotals.cMaxDate(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciMaxI: {
                    return StiTotals.cMaxI(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciMaxStr: {
                    return StiTotals.cMaxStr(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciMaxTime: {
                    return StiTotals.cMaxDate(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciMedian: {
                    return StiTotals.cMedian(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciMedianD: {
                    return StiTotals.cMedianD(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciMedianI: {
                    return StiTotals.cMedianI(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciMin: {
                    return StiTotals.cMin(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciMinD: {
                    return StiTotals.cMinD(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciMinDate: {
                    return StiTotals.cMinDate(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciMinI: {
                    return StiTotals.cMinI(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciMinStr: {
                    return StiTotals.cMinStr(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciMinTime: {
                    return StiTotals.cMinDate(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciMode: {
                    return StiTotals.cMode(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciModeD: {
                    return StiTotals.cModeD(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciModeI: {
                    return StiTotals.cModeI(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciSum: {
                    return StiTotals.cSum(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciSumD: {
                    return StiTotals.cSumD(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciSumDistinct: {
                    return StiTotals.cSum(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciSumI: {
                    return StiTotals.cSumI(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciSumTime: {
                    return StiTotals.cSum(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciFirst: {
                    return StiTotals.cFirst(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case ciLast: {
                    return StiTotals.cLast(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riCount: {
                    return StiTotals.cCountRunning(new StiParserData(argsList.get(0), null, parser, (ArrayList)argsList.get(1)), report, null);
                }
                case riCountDistinct: {
                    return StiTotals.cCountDistinctRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riAvg: {
                    return StiTotals.cAvgRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riAvgD: {
                    return StiTotals.cAvgDRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riAvgDate: {
                    return StiTotals.cAvgRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riAvgI: {
                    return StiTotals.cAvgIRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riAvgTime: {
                    return StiTotals.cAvgRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riMax: {
                    return StiTotals.cMaxRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riMaxD: {
                    return StiTotals.cMaxDRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riMaxDate: {
                    return StiTotals.cMaxDate(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riMaxI: {
                    return StiTotals.cMaxIRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riMaxStr: {
                    return StiTotals.cMaxStr(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riMaxTime: {
                    return StiTotals.cMaxDate(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riMedian: {
                    return StiTotals.cMedianRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riMedianD: {
                    return StiTotals.cMedianDRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riMedianI: {
                    return StiTotals.cMedianIRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riMin: {
                    return StiTotals.cMinRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riMinD: {
                    return StiTotals.cMinDRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riMinDate: {
                    return StiTotals.cMinDate(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riMinI: {
                    return StiTotals.cMinIRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riMinStr: {
                    return StiTotals.cMinStr(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riMinTime: {
                    return StiTotals.cMinDate(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riMode: {
                    return StiTotals.cModeRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riModeD: {
                    return StiTotals.cModeDRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riModeI: {
                    return StiTotals.cModeIRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riSum: {
                    return StiTotals.cSumRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riSumD: {
                    return StiTotals.cSumDRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riSumDistinct: {
                    return StiTotals.cSum(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riSumI: {
                    return StiTotals.cSumIRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riSumTime: {
                    return StiTotals.cSumRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riFirst: {
                    return StiTotals.cFirstRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case riLast: {
                    return StiTotals.cLastRunning(new StiParserData(argsList.get(0), (ArrayList)argsList.get(1), parser, (ArrayList)argsList.get(2)), report, null);
                }
                case Abs: {
                    int category = StiTypeConverter.getCategoryClass(argsList.get(0));
                    if (category <= 1 || category >= 8) {
                        StiCallFunction.ThrowError(13, "Abs", "1", argsList.get(0).getClass().toString(), "double");
                    } else {
                        if (category == 2) {
                            return StiTypeConverter.ToDecimal(argsList.get(0)).abs();
                        }
                        if (category == 3) {
                            return Math.abs(StiTypeConverter.parseDouble(argsList.get(0)));
                        }
                    }
                    return Math.abs(StiTypeConverter.parseInt(argsList.get(0)));
                }
                case Acos: {
                    int category = StiTypeConverter.getCategoryClass(argsList.get(0));
                    if (category <= 1 || category >= 8) {
                        StiCallFunction.ThrowError(13, "Acos", "1", argsList.get(0).getClass().toString(), "double");
                    }
                    return Math.acos(StiTypeConverter.parseDouble(argsList.get(0)));
                }
                case Asin: {
                    int category = StiTypeConverter.getCategoryClass(argsList.get(0));
                    if (category <= 1 || category >= 8) {
                        StiCallFunction.ThrowError(13, "Asin", "1", argsList.get(0).getClass().toString(), "double");
                    }
                    return Math.asin(StiTypeConverter.parseDouble(argsList.get(0)));
                }
                case Atan: {
                    int category = StiTypeConverter.getCategoryClass(argsList.get(0));
                    if (category <= 1 || category >= 8) {
                        StiCallFunction.ThrowError(13, "Atan", "1", argsList.get(0).getClass().toString(), "double");
                    }
                    return Math.atan(StiTypeConverter.parseDouble(argsList.get(0)));
                }
                case Ceiling: {
                    int category = StiTypeConverter.getCategoryClass(argsList.get(0));
                    if (category <= 1 || category >= 8) {
                        StiCallFunction.ThrowError(13, "Ceiling", "1", argsList.get(0).getClass().toString(), "double");
                    } else if (category == 2) {
                        return StiTypeConverter.ToDecimal(argsList.get(0)).setScale(0, RoundingMode.CEILING);
                    }
                    return Math.ceil(StiTypeConverter.parseDouble(argsList.get(0)));
                }
                case Cos: {
                    int category = StiTypeConverter.getCategoryClass(argsList.get(0));
                    if (category <= 1 || category >= 8) {
                        StiCallFunction.ThrowError(13, "Cos", "1", argsList.get(0).getClass().toString(), "double");
                    }
                    return Math.cos(StiTypeConverter.parseDouble(argsList.get(0)));
                }
                case Div: {
                    int category = StiTypeConverter.getCategoryClass(argsList.get(0));
                    int category2 = StiTypeConverter.getCategoryClass(argsList.get(1));
                    if (category <= 1 || category >= 8) {
                        StiCallFunction.ThrowError(13, "Div", "1", argsList.get(0).getClass().toString(), "double");
                    } else if (category2 <= 1 || category2 >= 8) {
                        StiCallFunction.ThrowError(13, "Div", "2", argsList.get(1).getClass().toString(), "double");
                    } else {
                        if (argsList.size() == 3) {
                            if (category == 2) {
                                BigDecimal value1 = StiTypeConverter.ToDouble(argsList.get(1));
                                if (value1.equals(BigDecimal.ZERO)) {
                                    return StiTypeConverter.ToDouble(argsList.get(2));
                                }
                                BigDecimal value0 = StiTypeConverter.ToDouble(argsList.get(0));
                                return value0.divide(value1, 32, RoundingMode.HALF_UP).doubleValue();
                            }
                            if (StiTypeConverter.parseDouble(argsList.get(1)) == 0.0) {
                                return StiTypeConverter.parseDouble(argsList.get(2));
                            }
                            return StiTypeConverter.parseDouble(argsList.get(0)) / StiTypeConverter.parseDouble(argsList.get(1));
                        }
                        if (argsList.size() == 2) {
                            BigDecimal value0 = StiTypeConverter.ToDouble(argsList.get(0));
                            BigDecimal value1 = StiTypeConverter.ToDouble(argsList.get(1));
                            if (value1.doubleValue() == 0.0) {
                                return 0.0;
                            }
                            return value0.divide(value1, 32, RoundingMode.HALF_UP).doubleValue();
                        }
                    }
                    StiCallFunction.ThrowError(12, "Div", argsList.size());
                    break;
                }
                case Exp: {
                    int category = StiTypeConverter.getCategoryClass(argsList.get(0));
                    if (category <= 1 || category >= 8) {
                        StiCallFunction.ThrowError(13, "Exp", "1", argsList.get(0).getClass().toString(), "double");
                    }
                    return Math.exp(StiTypeConverter.parseDouble(argsList.get(0)));
                }
                case Floor: {
                    int category = StiTypeConverter.getCategoryClass(argsList.get(0));
                    if (category <= 1 || category >= 4) {
                        StiCallFunction.ThrowError(13, "Floor", "1", argsList.get(0).getClass().toString(), "double");
                    }
                    if (category == 2) {
                        return StiTypeConverter.ToDouble(argsList.get(0)).setScale(0, RoundingMode.FLOOR);
                    }
                    return Math.floor(StiTypeConverter.parseDouble(argsList.get(0)));
                }
                case Log: {
                    int category = StiTypeConverter.getCategoryClass(argsList.get(0));
                    if (category <= 1 || category >= 8) {
                        StiCallFunction.ThrowError(13, "Log", "1", argsList.get(0).getClass().toString(), "double");
                    }
                    return Math.log(StiTypeConverter.parseDouble(argsList.get(0)));
                }
                case Maximum: {
                    if (argsList.size() != 2) {
                        StiCallFunction.ThrowError(12, "Maximum", argsList.size());
                    }
                    int category = StiTypeConverter.getCategoryClass(argsList.get(0));
                    int category2 = StiTypeConverter.getCategoryClass(argsList.get(1));
                    if (category <= 1 || category >= 8) {
                        StiCallFunction.ThrowError(13, "Maximum", "1", argsList.get(0).getClass().toString(), "double");
                    } else if (category2 <= 1 || category2 >= 8) {
                        StiCallFunction.ThrowError(13, "Maximum", "2", argsList.get(1).getClass().toString(), "double");
                    } else {
                        if (category == 2) {
                            return StiTypeConverter.ToDouble(argsList.get(0)).max(StiTypeConverter.ToDouble(argsList.get(1)));
                        }
                        if (category == 3) {
                            return Math.max(StiTypeConverter.parseDouble(argsList.get(0)), StiTypeConverter.parseDouble(argsList.get(1)));
                        }
                    }
                    return Math.max(StiTypeConverter.parseLong(argsList.get(0)), StiTypeConverter.parseLong(argsList.get(1)));
                }
                case Minimum: {
                    if (argsList.size() != 2) {
                        StiCallFunction.ThrowError(12, "Minimum", argsList.size());
                    }
                    int category = StiTypeConverter.getCategoryClass(argsList.get(0));
                    int category2 = StiTypeConverter.getCategoryClass(argsList.get(1));
                    if (category <= 1 || category >= 8) {
                        StiCallFunction.ThrowError(13, "Minimum", "1", argsList.get(0).getClass().toString(), "double");
                    } else if (category2 <= 1 || category2 >= 8) {
                        StiCallFunction.ThrowError(13, "Minimum", "2", argsList.get(1).getClass().toString(), "double");
                    } else {
                        if (category == 2) {
                            return StiTypeConverter.ToDecimal(argsList.get(0)).min(StiTypeConverter.ToDecimal(argsList.get(1)));
                        }
                        if (category == 3) {
                            return Math.min(StiTypeConverter.parseDouble(argsList.get(0)), StiTypeConverter.parseDouble(argsList.get(1)));
                        }
                    }
                    return Math.min(StiTypeConverter.parseLong(argsList.get(0)), StiTypeConverter.parseLong(argsList.get(1)));
                }
                case Frac: {
                    int category = StiTypeConverter.getCategoryClass(argsList.get(0));
                    if (category > 1 && category < 8) {
                        if (argsList.get(0) instanceof BigDecimal) {
                            return StiFunctionsMath.frac((BigDecimal)argsList.get(0));
                        }
                        return StiFunctionsMath.frac(StiTypeConverter.parseDouble(argsList.get(0)));
                    }
                    StiCallFunction.ThrowError(13, "Frac", "1", argsList.get(0).getClass().toString(), "double");
                    StiCallFunction.ThrowError(12, "Frac", argsList.size());
                    break;
                }
                case Round: {
                    int category = StiTypeConverter.getCategoryClass(argsList.get(0));
                    if (category <= 1 || category >= 8) {
                        StiCallFunction.ThrowError(13, "Round", "1", argsList.get(0).getClass().toString(), "double");
                    } else {
                        if (argsList.size() == 1) {
                            if (category == 2) {
                                return StiTypeConverter.ToDecimal(argsList.get(0)).setScale(0, RoundingMode.HALF_UP);
                            }
                            return Math.round(StiTypeConverter.parseDouble(argsList.get(0)));
                        }
                        if (argsList.size() == 2) {
                            int category2 = StiTypeConverter.getCategoryClass(argsList.get(1));
                            if (category2 < 4 || category2 > 7) {
                                StiCallFunction.ThrowError(13, "Round", "2", argsList.get(1).getClass().toString(), "int");
                            }
                            if (category == 2) {
                                BigDecimal value0 = StiTypeConverter.ToDecimal(argsList.get(0));
                                BigDecimal value1 = StiTypeConverter.ToDecimal(argsList.get(1));
                                return value0.setScale(value1.intValue(), RoundingMode.HALF_UP);
                            }
                            return (double)Math.round(StiTypeConverter.parseDouble(argsList.get(0)) * Math.pow(10.0, StiTypeConverter.parseInt(argsList.get(1)))) / Math.pow(10.0, StiTypeConverter.parseInt(argsList.get(1)));
                        }
                        if (argsList.size() == 3) {
                            int category2 = StiTypeConverter.getCategoryClass(argsList.get(1));
                            if (category2 < 4 || category2 > 7) {
                                StiCallFunction.ThrowError(13, "Round", "2", argsList.get(1).getClass().toString(), "int");
                            }
                            BigDecimal value0 = StiTypeConverter.ToDecimal(argsList.get(0));
                            BigDecimal value1 = StiTypeConverter.ToDecimal(argsList.get(1));
                            String midpointRounding = argsList.get(2).toString();
                            if (midpointRounding.equalsIgnoreCase("ToEven")) {
                                return value0.setScale(value1.intValue(), RoundingMode.HALF_EVEN);
                            }
                            return value0.setScale(value1.intValue(), RoundingMode.HALF_UP);
                        }
                    }
                    StiCallFunction.ThrowError(12, "Round", argsList.size());
                    break;
                }
                case Sign: {
                    int category = StiTypeConverter.getCategoryClass(argsList.get(0));
                    if (category <= 1 || category >= 8) {
                        StiCallFunction.ThrowError(13, "Sign", "1", argsList.get(0).getClass().toString(), "double");
                    } else {
                        if (category == 2) {
                            return Math.sin(StiTypeConverter.ToDecimal(argsList.get(0)).doubleValue());
                        }
                        if (category == 3) {
                            return Math.sin(StiTypeConverter.parseDouble(argsList.get(0)));
                        }
                    }
                    return Math.sin(StiTypeConverter.parseInt(argsList.get(0)));
                }
                case Sin: {
                    int category = StiTypeConverter.getCategoryClass(argsList.get(0));
                    if (category <= 1 || category >= 8) {
                        StiCallFunction.ThrowError(13, "Sin", "1", argsList.get(0).getClass().toString(), "double");
                    }
                    return Math.sin(StiTypeConverter.parseDouble(argsList.get(0)));
                }
                case Sqrt: {
                    int category = StiTypeConverter.getCategoryClass(argsList.get(0));
                    if (category <= 1 || category >= 8) {
                        StiCallFunction.ThrowError(13, "Sqrt", "1", argsList.get(0).getClass().toString(), "double");
                    }
                    return Math.sqrt(StiTypeConverter.parseDouble(argsList.get(0)));
                }
                case Tan: {
                    int category = StiTypeConverter.getCategoryClass(argsList.get(0));
                    if (category <= 1 || category >= 8) {
                        StiCallFunction.ThrowError(13, "Tan", "1", argsList.get(0).getClass().toString(), "double");
                    }
                    return Math.tan(StiTypeConverter.parseDouble(argsList.get(0)));
                }
                case Truncate: {
                    int category = StiTypeConverter.getCategoryClass(argsList.get(0));
                    if (category <= 1 || category >= 4) {
                        StiCallFunction.ThrowError(13, "Truncate", "1", argsList.get(0).getClass().toString(), "double");
                    } else if (category == 2) {
                        return StiTypeConverter.ToDecimal(argsList.get(0)).setScale(0, 1);
                    }
                    return (int)StiTypeConverter.parseDouble(argsList.get(0));
                }
                case DateDiff: {
                    if (argsList.size() != 2) {
                        StiCallFunction.ThrowError(12, "DateDiff", argsList.size());
                    }
                    int category = StiTypeConverter.getCategoryClass(argsList.get(0));
                    int category2 = StiTypeConverter.getCategoryClass(argsList.get(1));
                    if (category != 8) {
                        StiCallFunction.ThrowError(13, "DateDiff", "1", argsList.get(0).getClass().toString(), "DateTime");
                        break;
                    }
                    if (category2 != 8) {
                        StiCallFunction.ThrowError(13, "DateDiff", "2", argsList.get(1).getClass().toString(), "DateTime");
                        break;
                    }
                    StiDateTime dateTime1 = StiCallFunction.toDateTime(argsList.get(0));
                    StiDateTime dateTime2 = StiCallFunction.toDateTime(argsList.get(1));
                    return dateTime1.subtract(dateTime2);
                }
                case DateSerial: {
                    if (argsList.size() == 3) {
                        int year = StiTypeConverter.parseInt(argsList.get(0));
                        int month = StiTypeConverter.parseInt(argsList.get(1));
                        int date = StiTypeConverter.parseInt(argsList.get(2));
                        return new StiDateTime(StiCalendarUtil.create((int)year, (int)month, (int)date));
                    }
                    if (argsList.size() == 1) {
                        long ticks = StiTypeConverter.parseLong(argsList.get(0));
                        return new StiDateTime(ZonedDateTime.ofInstant(Instant.ofEpochMilli(ticks), ZoneId.systemDefault()));
                    }
                    StiCallFunction.ThrowError(12, "DateSerial", argsList.size());
                }
                case Day: {
                    int category;
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(12, "Day", argsList.size());
                    }
                    if ((category = StiTypeConverter.getCategoryClass(argsList.get(0))) != 8) {
                        StiCallFunction.ThrowError(13, "Day", "1", argsList.get(0).getClass().toString(), "DateTime");
                    }
                    return StiCallFunction.toDateTime(argsList.get(0)).day();
                }
                case DayOfWeek: {
                    int category = StiTypeConverter.getCategoryClass(argsList.get(0));
                    if (category != 8) {
                        StiCallFunction.ThrowError(13, "DayOfWeek", "1", argsList.get(0).getClass().toString(), "DateTime");
                    }
                    if (argsList.size() == 1) {
                        return StiFunctionsDate.dayOfWeek(StiCallFunction.toDateTime(argsList.get(0)));
                    }
                    if (argsList.size() == 2) {
                        category = StiTypeConverter.getCategoryClass(argsList.get(1));
                        if (category == 1) {
                            return StiFunctionsDate.dayOfWeek(StiCallFunction.toDateTime(argsList.get(0)), argsList.get(1).toString());
                        }
                        if (category == 9) {
                            return StiFunctionsDate.dayOfWeek(StiCallFunction.toDateTime(argsList.get(0)), Boolean.parseBoolean(argsList.get(1).toString().toLowerCase()));
                        }
                        StiCallFunction.ThrowError(13, "DayOfWeek", "2", argsList.get(0).getClass().toString(), "Boolean or String");
                    } else if (argsList.size() == 3) {
                        if (StiTypeConverter.getCategoryClass(argsList.get(1)) != 1) {
                            StiCallFunction.ThrowError(13, "DayOfWeek", "2", argsList.get(0).getClass().toString(), "String");
                        }
                        if (StiTypeConverter.getCategoryClass(argsList.get(2)) != 9) {
                            StiCallFunction.ThrowError(13, "DayOfWeek", "3", argsList.get(0).getClass().toString(), "Boolean");
                        }
                        return StiFunctionsDate.dayOfWeek(StiCallFunction.toDateTime(argsList.get(0)), argsList.get(1).toString(), Boolean.parseBoolean(argsList.get(2).toString().toLowerCase()));
                    }
                    StiCallFunction.ThrowError(12, "DayOfWeek", argsList.size());
                    break;
                }
                case DayOfYear: {
                    int category = StiTypeConverter.getCategoryClass(argsList.get(0));
                    if (category != 8) {
                        StiCallFunction.ThrowError(13, "DayOfYear", "1", argsList.get(0).getClass().toString(), "DateTime");
                    }
                    if (argsList.size() == 1) {
                        return StiCallFunction.toDateTime(argsList.get(0)).zonedDateTime().getDayOfYear();
                    }
                    StiCallFunction.ThrowError(12, "DayOfYear", argsList.size());
                    break;
                }
                case DaysInMonth: {
                    switch (overload) {
                        case 1: {
                            return (long)StiDateTime.daysInMonth((long)Func.Convert.toDateTime(argsList.get(0)).year(), (long)Func.Convert.toDateTime(argsList.get(0)).month());
                        }
                        case 3: {
                            return (long)StiDateTime.daysInMonth((long)Func.Convert.toInt32(argsList.get(0)), (long)Func.Convert.toInt32(argsList.get(1)));
                        }
                        case 2: {
                            return (long)StiDateTime.daysInMonth((long)((StiDateTime)argsList.get(0)).year(), (long)Func.Convert.toDateTime(argsList.get(0)).month());
                        }
                        case 4: {
                            StiDateTime date = Func.Convert.toDateTime(argsList.get(0));
                            return (long)StiDateTime.daysInMonth((long)date.year(), (long)date.month());
                        }
                    }
                    break;
                }
                case MonthName: {
                    switch (overload) {
                        case 1: {
                            return StiFunctionsDate.monthName(Func.Convert.toDateTime(argsList.get(0)), report != null ? report.getLocale() : Locale.getDefault());
                        }
                        case 2: {
                            return StiFunctionsDate.monthName(Func.Convert.toDateTime(argsList.get(0)), Func.Convert.toBoolean(argsList.get(1)));
                        }
                        case 3: {
                            return StiFunctionsDate.monthName(Func.Convert.toDateTime(argsList.get(0)), Func.Convert.toString(argsList.get(1)));
                        }
                        case 4: {
                            return StiFunctionsDate.monthName(Func.Convert.toDateTime(argsList.get(0)), Func.Convert.toString(argsList.get(1)), Func.Convert.toBoolean(argsList.get(2)));
                        }
                    }
                    break;
                }
                case DaysInYear: {
                    switch (overload) {
                        case 1: {
                            return (long)(StiDateTime.isLeapYear((long)Func.Convert.toDateTime(argsList.get(0)).year()) ? 366 : 365);
                        }
                        case 3: {
                            return (long)(StiDateTime.isLeapYear((long)Func.Convert.toInt32(argsList.get(0))) ? 366 : 365);
                        }
                        case 2: {
                            return (long)(StiDateTime.isLeapYear((long)((StiDateTime)argsList.get(0)).year()) ? 366 : 365);
                        }
                    }
                    break;
                }
                case Hour: {
                    int category;
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(12, "Hour", argsList.size());
                    }
                    if ((category = StiTypeConverter.getCategoryClass(argsList.get(0))) != 8) {
                        StiCallFunction.ThrowError(13, "Hour", "1", argsList.get(0).getClass().toString(), "DateTime");
                    }
                    return StiCallFunction.toDateTime(argsList.get(0)).hour();
                }
                case Minute: {
                    int category;
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(12, "Minute", argsList.size());
                    }
                    if ((category = StiTypeConverter.getCategoryClass(argsList.get(0))) != 8) {
                        StiCallFunction.ThrowError(13, "Minute", "1", argsList.get(0).getClass().toString(), "DateTime");
                    }
                    return StiCallFunction.toDateTime(argsList.get(0)).minute();
                }
                case Month: {
                    int category;
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(12, "Month", argsList.size());
                    }
                    if ((category = StiTypeConverter.getCategoryClass(argsList.get(0))) != 8) {
                        StiCallFunction.ThrowError(13, "Month", "1", argsList.get(0).getClass().toString(), "DateTime");
                    }
                    return StiCallFunction.toDateTime(argsList.get(0)).month();
                }
                case Second: {
                    int category;
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(12, "Second", argsList.size());
                    }
                    if ((category = StiTypeConverter.getCategoryClass(argsList.get(0))) != 8) {
                        StiCallFunction.ThrowError(13, "Second", "1", argsList.get(0).getClass().toString(), "DateTime");
                    }
                    return StiCallFunction.toDateTime(argsList.get(0)).second();
                }
                case TimeSerial: {
                    if (argsList.size() != 3) {
                        StiCallFunction.ThrowError(12, "TimeSerial", argsList.size());
                    }
                    if (!StiTypeConverter.isInegral(argsList.get(0))) {
                        StiCallFunction.ThrowError(13, "TimeSerial", "1", argsList.get(0).getClass().toString(), "int");
                    }
                    if (!StiTypeConverter.isInegral(argsList.get(1))) {
                        StiCallFunction.ThrowError(13, "TimeSerial", "2", argsList.get(0).getClass().toString(), "int");
                    }
                    if (!StiTypeConverter.isInegral(argsList.get(2))) {
                        StiCallFunction.ThrowError(13, "TimeSerial", "3", argsList.get(0).getClass().toString(), "int");
                    }
                    return new StiTimeSpan(StiTypeConverter.parseInt(argsList.get(0)), StiTypeConverter.parseInt(argsList.get(1)), StiTypeConverter.parseInt(argsList.get(2)));
                }
                case MonthIdent: {
                    return Funcs.monthIdentObject(argsList.get(0));
                }
                case WeekOfYear: {
                    if (argsList.size() == 1) {
                        return StiFunctionsDateTime.weekOfYear(Func.Convert.toDateTime(argsList.get(0)));
                    }
                    if (argsList.size() == 2) {
                        return StiFunctionsDateTime.weekOfYear(Func.Convert.toDateTime(argsList.get(0)), (DayOfWeek)((Object)argsList.get(1)));
                    }
                    if (argsList.size() == 3) {
                        return StiFunctionsDateTime.weekOfYear(Func.Convert.toDateTime(argsList.get(0)), (DayOfWeek)((Object)argsList.get(1)), (CalendarWeekRule)((Object)argsList.get(2)));
                    }
                    break;
                }
                case FontValue: {
                    if (argsList.size() == 2) {
                        return StiFunctionsDrawing.fontValue(argsList.get(0).toString(), Func.Convert.toDouble(argsList.get(1)));
                    }
                    if (argsList.size() == 3) {
                        int style = argsList.get(2) instanceof StiFontStyle ? ((StiFontStyle)argsList.get((int)2)).intValue : (Integer)argsList.get(2);
                        return StiFunctionsDrawing.fontValue(argsList.get(0).toString(), Func.Convert.toDouble(argsList.get(1)), style);
                    }
                    break;
                }
                case WeekOfMonth: {
                    if (argsList.size() == 1) {
                        return StiFunctionsDateTime.weekOfMonth(Func.Convert.toDateTime(argsList.get(0)));
                    }
                    if (argsList.size() == 2) {
                        return StiFunctionsDateTime.weekOfMonth(Func.Convert.toDateTime(argsList.get(0)), (DayOfWeek)((Object)argsList.get(1)));
                    }
                    if (argsList.size() == 3) {
                        return StiFunctionsDateTime.weekOfMonth(Func.Convert.toDateTime(argsList.get(0)), (DayOfWeek)((Object)argsList.get(1)), (CalendarWeekRule)((Object)argsList.get(2)));
                    }
                    break;
                }
                case Year: {
                    int category;
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(12, "Year", argsList.size());
                    }
                    if ((category = StiTypeConverter.getCategoryClass(argsList.get(0))) != 8) {
                        StiCallFunction.ThrowError(13, "Year", "1", argsList.get(0).getClass().toString(), "DateTime");
                    }
                    return StiCallFunction.toDateTime(argsList.get(0)).year();
                }
                case DateToStr: {
                    StiCallFunction.ThrowError(14, "DateToStr");
                    break;
                }
                case Insert: {
                    int category;
                    if (argsList.get(0) == null) {
                        return "";
                    }
                    if (argsList.get(2) == null) {
                        return argsList.get(0);
                    }
                    if (argsList.size() != 3) {
                        StiCallFunction.ThrowError(12, "Insert", argsList.size());
                    }
                    if ((category = StiTypeConverter.getCategoryClass(argsList.get(0))) != 1) {
                        StiCallFunction.ThrowError(13, "Insert", "1", argsList.get(0).getClass().toString(), "string");
                    }
                    if (!StiTypeConverter.isInegral(argsList.get(1))) {
                        StiCallFunction.ThrowError(13, "Insert", "2", argsList.get(0).getClass().toString(), "int");
                    }
                    if ((category = StiTypeConverter.getCategoryClass(argsList.get(2))) != 1) {
                        StiCallFunction.ThrowError(13, "Insert", "3", argsList.get(0).getClass().toString(), "string");
                    }
                    return new StringBuffer((String)argsList.get(0)).insert(StiTypeConverter.parseInt(argsList.get(1)), String.valueOf(argsList.get(2))).toString();
                }
                case Length: {
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(12, "Length", argsList.size());
                    }
                    return argsList.get(0) == null ? 0 : argsList.get(0).toString().length();
                }
                case Remove: {
                    int category;
                    if (argsList.get(0) == null) {
                        return "";
                    }
                    if (argsList.size() != 3 && argsList.size() != 2) {
                        StiCallFunction.ThrowError(12, "Remove", argsList.size());
                    }
                    if ((category = StiTypeConverter.getCategoryClass(argsList.get(0))) != 1) {
                        StiCallFunction.ThrowError(13, "Remove", "1", argsList.get(0).getClass().toString(), "string");
                    }
                    if (!StiTypeConverter.isInegral(argsList.get(1))) {
                        StiCallFunction.ThrowError(13, "Remove", "2", argsList.get(0).getClass().toString(), "int");
                    }
                    if (argsList.size() == 3 && !StiTypeConverter.isInegral(argsList.get(2))) {
                        StiCallFunction.ThrowError(13, "Remove", "3", argsList.get(0).getClass().toString(), "int");
                    }
                    String tempVar = StiTypeConverter.ToString(argsList.get(0));
                    try {
                        if (argsList.size() == 2) {
                            return tempVar.substring(0, StiTypeConverter.parseInt(argsList.get(1)));
                        }
                        return tempVar.substring(0, StiTypeConverter.parseInt(argsList.get(1))) + tempVar.substring(StiTypeConverter.parseInt(argsList.get(1)) + StiTypeConverter.parseInt(argsList.get(2)));
                    }
                    catch (Exception e) {
                        if (StiOptions.Engine.logLevel >= 10) {
                            e.printStackTrace();
                        }
                        return "";
                    }
                }
                case Rand: {
                    return StiFunctionsProgramming.rand();
                }
                case ConvertToBase64String: {
                    if (argsList.get(0) instanceof String) {
                        return StiBase64EncoderUtil.encode((String)((String)argsList.get(0)));
                    }
                    if (argsList.get(0) instanceof byte[]) {
                        return StiBase64EncoderUtil.encode((byte[])((byte[])argsList.get(0)));
                    }
                }
                case Compare: {
                    return StiFunctionsStrings.compare(argsList.get(0).toString(), argsList.get(1).toString());
                }
                case Replace: {
                    if (argsList.get(0) == null) {
                        return "";
                    }
                    if (argsList.size() != 3) {
                        StiCallFunction.ThrowError(12, "Replace", argsList.size());
                    }
                    if (argsList.get(1) == null || argsList.get(2) == null) {
                        return argsList.get(0);
                    }
                    int category = StiTypeConverter.getCategoryClass(argsList.get(0));
                    if (category != 1) {
                        StiCallFunction.ThrowError(13, "Replace", "1", argsList.get(0).getClass().toString(), "string");
                    }
                    if ((category = StiTypeConverter.getCategoryClass(argsList.get(1))) != 1) {
                        StiCallFunction.ThrowError(13, "Replace", "2", argsList.get(0).getClass().toString(), "string");
                    }
                    if ((category = StiTypeConverter.getCategoryClass(argsList.get(2))) != 1) {
                        StiCallFunction.ThrowError(13, "Replace", "3", argsList.get(0).getClass().toString(), "string");
                    }
                    try {
                        return String.valueOf(argsList.get(0)).replace(String.valueOf(argsList.get(1)), String.valueOf(argsList.get(2)));
                    }
                    catch (Exception e) {
                        if (StiOptions.Engine.logLevel >= 10) {
                            e.printStackTrace();
                        }
                        return "";
                    }
                }
                case Roman: {
                    int category;
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(12, "Roman", argsList.size());
                    }
                    if ((category = StiTypeConverter.getCategoryClass(argsList.get(0))) >= 3 && category <= 7) {
                        return StiFunctionsStrings.roman(Func.Convert.toInt(argsList.get(0)));
                    }
                    StiCallFunction.ThrowError(13, "Roman", "1", argsList.get(0).getClass().toString(), "int");
                    break;
                }
                case Substring: {
                    if (argsList.get(0) == null) {
                        return "";
                    }
                    if (argsList.size() != 3) {
                        StiCallFunction.ThrowError(12, "Substring", argsList.size());
                    }
                    int beginIndex = (int)Func.Convert.toInt32(argsList.get(1));
                    int endIndex = Math.min((int)Func.Convert.toInt32(argsList.get(1)) + (int)Func.Convert.toInt32(argsList.get(2)), argsList.get(0).toString().length());
                    return String.valueOf(argsList.get(0)).substring(beginIndex, endIndex);
                }
                case ToCurrencyWords: {
                    try {
                        switch (overload) {
                            case 1: {
                                return StiFunctionsStrings.toCurrencyWords(Func.Convert.toBigDecimal(argsList.get(0)));
                            }
                            case 2: {
                                return StiFunctionsStrings.toCurrencyWords(Func.Convert.toBigDecimal(argsList.get(0)));
                            }
                            case 3: {
                                return StiFunctionsStrings.toCurrencyWords(Func.Convert.toBigDecimal(argsList.get(0)));
                            }
                            case 4: {
                                return StiFunctionsStrings.toCurrencyWords(Func.Convert.toBigDecimal(argsList.get(0)), Func.Convert.toBoolean(argsList.get(1)));
                            }
                            case 5: {
                                return StiFunctionsStrings.toCurrencyWords(Func.Convert.toBigDecimal(argsList.get(0)), Func.Convert.toBoolean(argsList.get(1)));
                            }
                            case 6: {
                                return StiFunctionsStrings.toCurrencyWords(Func.Convert.toBigDecimal(argsList.get(0)), Func.Convert.toBoolean(argsList.get(1)));
                            }
                            case 7: {
                                return StiFunctionsStrings.toCurrencyWords(Func.Convert.toBigDecimal(argsList.get(0)), Func.Convert.toBoolean(argsList.get(1)), Func.Convert.toBoolean(argsList.get(2)));
                            }
                            case 8: {
                                return StiFunctionsStrings.toCurrencyWords(Func.Convert.toBigDecimal(argsList.get(0)), Func.Convert.toBoolean(argsList.get(1)), Func.Convert.toBoolean(argsList.get(2)));
                            }
                            case 9: {
                                return StiFunctionsStrings.toCurrencyWords(Func.Convert.toBigDecimal(argsList.get(0)), Func.Convert.toBoolean(argsList.get(1)), Func.Convert.toBoolean(argsList.get(2)));
                            }
                            case 10: {
                                return StiFunctionsStrings.toCurrencyWords(Func.Convert.toBigDecimal(argsList.get(0)), Func.Convert.toBoolean(argsList.get(1)), Func.Convert.toBoolean(argsList.get(2)), Func.Convert.toString(argsList.get(3)), Func.Convert.toString(argsList.get(4)));
                            }
                            case 11: {
                                return StiFunctionsStrings.toCurrencyWords(Func.Convert.toBigDecimal(argsList.get(0)), Func.Convert.toBoolean(argsList.get(1)), Func.Convert.toBoolean(argsList.get(2)), Func.Convert.toString(argsList.get(3)), Func.Convert.toString(argsList.get(4)));
                            }
                            case 12: {
                                return StiFunctionsStrings.toCurrencyWords(Func.Convert.toBigDecimal(argsList.get(0)), Func.Convert.toBoolean(argsList.get(1)), Func.Convert.toBoolean(argsList.get(2)), Func.Convert.toString(argsList.get(3)), Func.Convert.toString(argsList.get(4)));
                            }
                        }
                        StiCallFunction.ThrowError(0, "ToCurrencyWords");
                    }
                    catch (Exception e) {
                        if (StiOptions.Engine.logLevel >= 10) {
                            e.printStackTrace();
                        }
                        return "";
                    }
                    StiCallFunction.ThrowError(12, "ToCurrencyWords", argsList.size());
                    break;
                }
                case ParseLong: {
                    return StiFunctionsStrings.parseLong(Func.Convert.toString(argsList.get(0)));
                }
                case ToCurrencyWordsEs: {
                    try {
                        if (argsList.size() == 3) {
                            return StiFunctionsStrings.toCurrencyWordsEs(Func.Convert.toBigDecimal(argsList.get(0)), Func.Convert.toString(argsList.get(1)), Func.Convert.toInt32(argsList.get(2)));
                        }
                        if (argsList.size() == 4) {
                            return StiFunctionsStrings.toCurrencyWordsEs(Func.Convert.toBigDecimal(argsList.get(0)), Func.Convert.toString(argsList.get(1)), Func.Convert.toInt32(argsList.get(2)), Func.Convert.toBoolean(argsList.get(3)));
                        }
                    }
                    catch (Exception e) {
                        if (StiOptions.Engine.logLevel >= 10) {
                            e.printStackTrace();
                        }
                        return "";
                    }
                    StiCallFunction.ThrowError(12, "ToCurrencyWordsEs", argsList.size());
                    break;
                }
                case ToCurrencyWordsZh: {
                    try {
                        if (argsList.size() == 1) {
                            return StiFunctionsStrings.toCurrencyWordsZh(Func.Convert.toBigDecimal(argsList.get(0)));
                        }
                    }
                    catch (Exception e) {
                        if (StiOptions.Engine.logLevel >= 10) {
                            e.printStackTrace();
                        }
                        return "";
                    }
                    StiCallFunction.ThrowError(12, "ToCurrencyWordsZh", argsList.size());
                    break;
                }
                case ToCurrencyWordsRu: {
                    try {
                        switch (overload) {
                            case 1: {
                                return StiFunctionsStrings.toCurrencyWordsRu(Func.Convert.toBigDecimal(argsList.get(0)));
                            }
                            case 4: {
                                return StiFunctionsStrings.toCurrencyWordsRu(Func.Convert.toBigDecimal(argsList.get(0)), Func.Convert.toBoolean(argsList.get(1)));
                            }
                            case 7: {
                                return StiFunctionsStrings.toCurrencyWordsRu(Func.Convert.toBigDecimal(argsList.get(0)), Func.Convert.toBoolean(argsList.get(1)), argsList.get(2).toString());
                            }
                            case 10: {
                                return StiFunctionsStrings.toCurrencyWordsRu(Func.Convert.toBigDecimal(argsList.get(0)), argsList.get(1).toString(), Func.Convert.toBoolean(argsList.get(2)));
                            }
                        }
                        StiCallFunction.ThrowError(0, "ToCurrencyWordsRu");
                    }
                    catch (Exception e) {
                        if (StiOptions.Engine.logLevel >= 10) {
                            e.printStackTrace();
                        }
                        return "";
                    }
                    StiCallFunction.ThrowError(12, "ToCurrencyWordsRu", argsList.size());
                    break;
                }
                case ToCurrencyWordsPtBr: {
                    try {
                        switch (overload) {
                            case 1: {
                                return StiFunctionsStrings.toCurrencyWordsPtBr(Func.Convert.toBigDecimal(argsList.get(0)));
                            }
                            case 2: {
                                return StiFunctionsStrings.toCurrencyWordsPtBr(Func.Convert.toBigDecimal(argsList.get(0)), Func.Convert.toBoolean(argsList.get(1)), argsList.get(2).toString(), argsList.get(3).toString());
                            }
                            case 3: {
                                return StiFunctionsStrings.toCurrencyWordsPtBr(Func.Convert.toDecimal(argsList.get(0)));
                            }
                            case 4: {
                                return StiFunctionsStrings.toCurrencyWordsPtBr(Func.Convert.toDecimal(argsList.get(0)), Func.Convert.toBoolean(argsList.get(1)), argsList.get(2).toString(), argsList.get(3).toString());
                            }
                        }
                        StiCallFunction.ThrowError(0, "ToCurrencyWordsPtBr");
                    }
                    catch (Exception e) {
                        if (StiOptions.Engine.logLevel >= 10) {
                            e.printStackTrace();
                        }
                        return "";
                    }
                    StiCallFunction.ThrowError(12, "ToCurrencyWordsRu", argsList.size());
                    break;
                }
                case ToLowerCase: {
                    int category;
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(12, "ToLowerCase", argsList.size());
                    }
                    if ((category = StiTypeConverter.getCategoryClass(argsList.get(0))) != 1) {
                        StiCallFunction.ThrowError(13, "ToLowerCase", "1", argsList.get(0).getClass().toString(), "string");
                    }
                    return String.valueOf(argsList.get(0)).toLowerCase();
                }
                case ToProperCase: {
                    int category;
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(12, "ToProperCase", argsList.size());
                    }
                    if ((category = StiTypeConverter.getCategoryClass(argsList.get(0))) != 1) {
                        StiCallFunction.ThrowError(13, "ToProperCase", "1", argsList.get(0).getClass().toString(), "string");
                    }
                    return StiStringUtil.toTitleCase((String)argsList.get(0).toString().toLowerCase());
                }
                case ToUpperCase: {
                    int category;
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(12, "ToUpperCase", argsList.size());
                    }
                    if ((category = StiTypeConverter.getCategoryClass(argsList.get(0))) != 1) {
                        StiCallFunction.ThrowError(13, "ToUpperCase", "1", argsList.get(0).getClass().toString(), "string");
                    }
                    return String.valueOf(argsList.get(0)).toUpperCase();
                }
                case ToWords: {
                    switch (overload) {
                        case 1: 
                        case 2: 
                        case 3: {
                            return StiFunctionsStrings.toWords(StiTypeConverter.ToDouble(argsList.get(0)));
                        }
                        case 4: 
                        case 5: 
                        case 6: {
                            return StiFunctionsStrings.toWords(StiTypeConverter.ToDouble(argsList.get(0)), StiTypeConverter.parseBoolean(argsList.get(1)));
                        }
                    }
                    break;
                }
                case ToWordsRu: {
                    switch (overload) {
                        case 1: 
                        case 2: 
                        case 3: {
                            return StiFunctionsStrings.toWordsRu(StiTypeConverter.ToDouble(argsList.get(0)));
                        }
                        case 4: 
                        case 5: 
                        case 6: {
                            return StiFunctionsStrings.toWordsRu(StiTypeConverter.ToDouble(argsList.get(0)), StiTypeConverter.parseBoolean(argsList.get(1)));
                        }
                    }
                    break;
                }
                case ToWordsZh: {
                    switch (overload) {
                        case 1: 
                        case 2: 
                        case 3: {
                            return Func.Zh.toWordsZh(StiTypeConverter.ToDouble(argsList.get(0)));
                        }
                    }
                    break;
                }
                case ToWordsUa: {
                    switch (overload) {
                        case 1: 
                        case 2: 
                        case 3: {
                            return StiFunctionsStrings.toWordsUa(StiTypeConverter.ToDouble(argsList.get(0)));
                        }
                        case 4: 
                        case 5: 
                        case 6: {
                            return StiFunctionsStrings.toWordsUa(StiTypeConverter.ToDouble(argsList.get(0)), StiTypeConverter.parseBoolean(argsList.get(1)));
                        }
                    }
                    break;
                }
                case Trim: {
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(12, "Trim", argsList.size());
                    }
                    return argsList.get(0) == null ? "" : argsList.get(0).toString().trim();
                }
                case TryParseDecimal: {
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(12, "TryParseDecimal", argsList.size());
                    }
                    try {
                        BigDecimal tempVar2 = new BigDecimal(String.valueOf(argsList.get(0)));
                        return true;
                    }
                    catch (Exception e) {
                        if (StiOptions.Engine.logLevel >= 10) {
                            e.printStackTrace();
                        }
                        return false;
                    }
                }
                case TryParseDouble: {
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(12, "TryStiTypeConverter.parseDouble", argsList.size());
                    }
                    try {
                        StiTypeConverter.parseDouble((Object)String.valueOf(argsList.get(0)));
                        return true;
                    }
                    catch (Exception e) {
                        if (StiOptions.Engine.logLevel >= 10) {
                            e.printStackTrace();
                        }
                        return false;
                    }
                }
                case IsNullOrEmpty: {
                    if (argsList.size() == 1) {
                        return StiFunctionsData.isNullOrEmpty(argsList.get(0));
                    }
                    if (argsList.size() == 2) {
                        try {
                            return StiFunctionsData.isNullOrEmpty(argsList.get(0), String.valueOf(argsList.get(1)));
                        }
                        catch (StiException e) {
                            StiCallFunction.ThrowError(12, "IsNullOrEmpty", e.getMessage());
                        }
                    }
                    StiCallFunction.ThrowError(12, "IsNullOrEmpty", argsList.size());
                }
                case ToDateTime: {
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(12, "ToDateTime", argsList.size());
                    }
                    return new StiDateTime(new Date(String.valueOf(argsList.get(0))));
                }
                case ToChar: {
                    String val;
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(12, "ToChar", argsList.size());
                    }
                    return StiValidationUtil.isNotNullOrEmpty((String)(val = String.valueOf(argsList.get(0)))) && val.length() > 0 ? Character.valueOf(val.charAt(0)) : null;
                }
                case ToBoolean: {
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(12, "ToBoolean", argsList.size());
                    }
                    return Boolean.parseBoolean(String.valueOf(argsList.get(0)).toLowerCase());
                }
                case IsNullOrWhiteSpace: {
                    if (argsList.size() == 1) {
                        return StiFunctionsData.isNullOrWhiteSpace(argsList.get(0));
                    }
                    if (argsList.size() == 2) {
                        try {
                            return StiFunctionsData.isNullOrWhiteSpace(argsList.get(0), String.valueOf(argsList.get(1)));
                        }
                        catch (StiException e) {
                            StiCallFunction.ThrowError(12, "IsNullOrWhiteSpace", e.getMessage());
                        }
                    }
                    StiCallFunction.ThrowError(12, "IsNullOrWhiteSpace", argsList.size());
                }
                case TryParseLong: {
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(12, "TryStiTypeConverter.parseLong", argsList.size());
                    }
                    return StiFunctionsStrings.tryParseLong(argsList.get(0).toString());
                }
                case ToDecimal: {
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(12, "TryParseDecimal", argsList.size());
                    }
                    BigDecimal tempToDecimal = new BigDecimal(0);
                    BigDecimal tempVar22 = new BigDecimal(String.valueOf(argsList.get(0)));
                    return tempVar22;
                }
                case ToDouble: 
                case ToSingle: {
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(12, name.toString(), argsList.size());
                    }
                    Double tempVar33 = StiTypeConverter.parseDouble((Object)String.valueOf(argsList.get(0)));
                    return tempVar33;
                }
                case ToLong: 
                case ToByte: 
                case ToSByte: 
                case ToInt16: 
                case ToInt32: 
                case ToInt64: {
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(12, name.toString(), argsList.size());
                    }
                    Long tempVar44 = StiTypeConverter.parseLong((Object)String.valueOf(argsList.get(0)));
                    return tempVar44;
                }
                case Arabic: {
                    int category;
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(12, "Arabic", argsList.size());
                    }
                    if ((category = StiTypeConverter.getCategoryClass(argsList.get(0))) == 1) {
                        return StiFunctionsStrings.arabic(String.valueOf(argsList.get(0)));
                    }
                    if (category >= 4 && category <= 7) {
                        return StiFunctionsStrings.arabic(StiTypeConverter.parseInt(argsList.get(0)));
                    }
                    StiCallFunction.ThrowError(13, "Arabic", "1", argsList.get(0).getClass().toString(), "string");
                    break;
                }
                case Persian: {
                    int category;
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(12, "Persian", argsList.size());
                    }
                    if ((category = StiTypeConverter.getCategoryClass(argsList.get(0))) == 1) {
                        return StiFunctionsStrings.persian(String.valueOf(argsList.get(0)));
                    }
                    if (category >= 4 && category <= 7) {
                        return StiFunctionsStrings.persian(StiTypeConverter.parseInt(argsList.get(0)));
                    }
                    StiCallFunction.ThrowError(13, "Persian", "1", argsList.get(0).getClass().toString(), "string");
                    break;
                }
                case ToOrdinal: {
                    int category;
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(12, "ToOrdinal", argsList.size());
                    }
                    if ((category = StiTypeConverter.getCategoryClass(argsList.get(0))) >= 3 && category <= 7) {
                        return StiFunctionsStrings.toOrdinal(Func.Convert.toInt32(argsList.get(0)));
                    }
                    StiCallFunction.ThrowError(13, "ToOrdinal", "1", argsList.get(0).getClass().toString(), "int");
                    break;
                }
                case VLookup: {
                    if (argsList.size() == 4) {
                        return StiFunctionsData.vLookup(argsList.get(0), argsList.get(1), StiTypeConverter.parseString(argsList.get(2)), StiTypeConverter.parseString(argsList.get(3)));
                    }
                    if (argsList.size() == 6) {
                        return StiFunctionsData.vLookup(argsList.get(0), argsList.get(1), StiTypeConverter.parseString(argsList.get(2)), StiTypeConverter.parseString(argsList.get(3)), StiTypeConverter.parseBoolean(argsList.get(4)), StiTypeConverter.parseBoolean(argsList.get(5)));
                    }
                    StiCallFunction.ThrowError(12, "VLookup");
                    break;
                }
                case Coalesce: {
                    return StiFunctionsData.coalesce(argsList.toArray());
                }
                case CoalesceStr: {
                    return StiFunctionsData.coalesceStr(argsList.toArray());
                }
                case VLookupStr: {
                    if (argsList.size() == 5) {
                        return StiFunctionsData.vLookupStr(argsList.get(0), argsList.get(1), StiTypeConverter.parseString(argsList.get(2)), StiTypeConverter.parseString(argsList.get(3)), StiTypeConverter.parseBoolean(argsList.get(4)));
                    }
                    StiCallFunction.ThrowError(12, "VLookupStr");
                    break;
                }
                case JoinColumnContent: {
                    if (argsList.size() == 3) {
                        return StiFunctionsData.joinColumnContent(argsList.get(0), StiTypeConverter.parseString(argsList.get(1)), StiTypeConverter.parseString(argsList.get(2)));
                    }
                    if (argsList.size() == 4) {
                        return StiFunctionsData.joinColumnContent(argsList.get(0), StiTypeConverter.parseString(argsList.get(1)), StiTypeConverter.parseString(argsList.get(2)), StiTypeConverter.parseBoolean(argsList.get(3)));
                    }
                    StiCallFunction.ThrowError(12, "JoinColumnContent", argsList.size());
                }
                case IsAllDataRowNullOrEmpty: {
                    if (argsList.size() != 2) {
                        StiCallFunction.ThrowError(12, "IsAllDataRowNullOrEmpty", argsList.size());
                    }
                    try {
                        return StiFunctionsData.isAllDataRowNullOrEmpty(argsList.get(0), StiTypeConverter.parseString(argsList.get(1)));
                    }
                    catch (StiException e) {
                        StiCallFunction.ThrowError(12, "IsAllDataRowNullOrEmpty", e.getMessage());
                    }
                }
                case IsDataEmpty: {
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(12, "IsDataEmpty", argsList.size());
                    }
                    try {
                        return StiFunctionsData.isDataEmpty(argsList.get(0));
                    }
                    catch (StiException e) {
                        StiCallFunction.ThrowError(12, "IsDataEmpty", e.getMessage());
                    }
                }
                case IsNumeric: {
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(12, "IsNumeric", argsList.size());
                    }
                    return StiFunctionsData.isNumeric(argsList.get(0));
                }
                case Left: {
                    if (argsList.get(0) == null) {
                        return "";
                    }
                    if (overload == 1) {
                        return StiFunctionsStrings.left(String.valueOf(argsList.get(0)), StiTypeConverter.parseInt(argsList.get(1)));
                    }
                    break;
                }
                case Right: {
                    if (argsList.get(0) == null) {
                        return "";
                    }
                    if (overload == 1) {
                        return StiFunctionsStrings.right(String.valueOf(argsList.get(0)), StiTypeConverter.parseInt(argsList.get(1)));
                    }
                    break;
                }
                case Mid: {
                    if (argsList.get(0) == null) {
                        return "";
                    }
                    if (overload == 1) {
                        return StiFunctionsStrings.mid(String.valueOf(argsList.get(0)), StiTypeConverter.parseInt(argsList.get(1)), StiTypeConverter.parseInt(argsList.get(2)));
                    }
                    break;
                }
                case IIF: {
                    return StiTypeConverter.parseBoolean(argsList.get(0)) ? argsList.get(1) : argsList.get(2);
                }
                case Choose: {
                    int chooseIndex;
                    if (argsList.size() < 2 || argsList.get(0) == null) {
                        return null;
                    }
                    if (!StiTypeConverter.isInegral(argsList.get(0))) {
                        StiCallFunction.ThrowError(13, "Choose", "1", argsList.get(0).getClass().toString(), "int");
                    }
                    if ((chooseIndex = StiTypeConverter.parseInt(argsList.get(0))) > 0 && chooseIndex < argsList.size()) {
                        return argsList.get(chooseIndex);
                    }
                    return null;
                }
                case Switch: {
                    if (argsList.size() < 2) {
                        StiCallFunction.ThrowError(12, "Switch", argsList.size());
                    }
                    int switchIndex = 0;
                    while (switchIndex + 1 < argsList.size()) {
                        if (argsList.get(switchIndex) != null && StiTypeConverter.parseBoolean(argsList.get(switchIndex))) {
                            return argsList.get(switchIndex + 1);
                        }
                        switchIndex += 2;
                    }
                    return null;
                }
                case ToString: {
                    if (argsList.get(0) == null || argsList.get(0) == DBNull.Value) {
                        return "";
                    }
                    return argsList.get(0).toString();
                }
                case EngineHelperToQueryString: {
                    switch (overload) {
                        case 1: {
                            if (!(argsList.get(0) instanceof List)) break;
                            try {
                                return null;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    break;
                }
                case Format: {
                    int category;
                    if (argsList.size() != 2) {
                        StiCallFunction.ThrowError(12, "Format", argsList.size());
                    }
                    if ((category = StiTypeConverter.getCategoryClass(argsList.get(0))) != 1) {
                        StiCallFunction.ThrowError(13, "Format", "1", argsList.get(0).getClass().toString(), "string");
                    }
                    return StiStringUtil.format((String)String.valueOf(argsList.get(0)), argsList.get(1) instanceof StiDateTime ? ((StiDateTime)argsList.get(1)).zonedDateTime() : argsList.get(1), (Locale)report.getLocale(), (String)report.getCulture());
                }
                case SystemConvertToBoolean: {
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(ParserErrorCode.NoOverloadForMethodTakesNArguments, "System.Convert.ToBoolean", argsList.size());
                    }
                    return Func.Convert.toBoolean(argsList.get(0));
                }
                case SystemConvertToByte: {
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(ParserErrorCode.NoOverloadForMethodTakesNArguments, "System.Convert.ToByte", argsList.size());
                    }
                    return Func.Convert.toInt32(argsList.get(0));
                }
                case SystemConvertToChar: {
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(ParserErrorCode.NoOverloadForMethodTakesNArguments, "System.Convert.ToChar", argsList.size());
                    }
                    return Character.valueOf(Func.Convert.toChar(argsList.get(0)));
                }
                case SystemConvertToDateTime: {
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(ParserErrorCode.NoOverloadForMethodTakesNArguments, "System.Convert.ToDateTime", argsList.size());
                    }
                    return Func.Convert.toDateTime(argsList.get(0));
                }
                case SystemConvertToDecimal: {
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(ParserErrorCode.NoOverloadForMethodTakesNArguments, "System.Convert.ToDecimal", argsList.size());
                    }
                    return Func.Convert.toSingle(argsList.get(0));
                }
                case SystemConvertToDouble: {
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(ParserErrorCode.NoOverloadForMethodTakesNArguments, "System.Convert.ToDouble", argsList.size());
                    }
                    return Func.Convert.toSingle(argsList.get(0));
                }
                case SystemConvertToInt16: {
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(ParserErrorCode.NoOverloadForMethodTakesNArguments, "System.Convert.ToInt16", argsList.size());
                    }
                    return Func.Convert.toInt32(argsList.get(0));
                }
                case SystemConvertToInt32: {
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(ParserErrorCode.NoOverloadForMethodTakesNArguments, "System.Convert.ToInt32", argsList.size());
                    }
                    return Func.Convert.toInt32(argsList.get(0));
                }
                case SystemConvertToInt64: {
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(ParserErrorCode.NoOverloadForMethodTakesNArguments, "System.Convert.ToInt64", argsList.size());
                    }
                    return Func.Convert.toInt32(argsList.get(0));
                }
                case SystemConvertToSByte: {
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(ParserErrorCode.NoOverloadForMethodTakesNArguments, "System.Convert.ToSByte", argsList.size());
                    }
                    return Func.Convert.toInt32(argsList.get(0));
                }
                case SystemConvertToSingle: {
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(ParserErrorCode.NoOverloadForMethodTakesNArguments, "System.Convert.ToSingle", argsList.size());
                    }
                    return Func.Convert.toSingle(argsList.get(0));
                }
                case SystemConvertToString: {
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(ParserErrorCode.NoOverloadForMethodTakesNArguments, "System.Convert.toString", argsList.size());
                    }
                    return Func.Convert.toString(argsList.get(0));
                }
                case SystemConvertToUInt16: {
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(ParserErrorCode.NoOverloadForMethodTakesNArguments, "System.Convert.ToUInt16", argsList.size());
                    }
                    return Func.Convert.toInt32(argsList.get(0));
                }
                case SystemConvertToUInt32: {
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(ParserErrorCode.NoOverloadForMethodTakesNArguments, "System.Convert.ToUInt32", argsList.size());
                    }
                    return Func.Convert.toInt32(argsList.get(0));
                }
                case SystemConvertToUInt64: {
                    if (argsList.size() != 1) {
                        StiCallFunction.ThrowError(ParserErrorCode.NoOverloadForMethodTakesNArguments, "System.Convert.ToUInt64", argsList.size());
                    }
                    return Func.Convert.toInt32(argsList.get(0));
                }
                case MathRound: {
                    switch (overload) {
                        case 1: {
                            return Math.round(Func.Convert.toDouble(argsList.get(0)));
                        }
                        case 2: {
                            return StiMath.round((double)Func.Convert.toDouble(argsList.get(0)), (int)((Integer)argsList.get(1)));
                        }
                        case 3: 
                        case 4: {
                            return StiMath.round((double)Func.Convert.toDouble(argsList.get(0)), (int)((int)Func.Convert.toInt32(argsList.get(1))));
                        }
                        case 5: {
                            return Math.round(Func.Convert.toDecimal(argsList.get(0)));
                        }
                        case 6: {
                            return StiMath.round((double)Func.Convert.toDecimal(argsList.get(0)), (int)((Integer)argsList.get(1)));
                        }
                        case 7: 
                        case 8: {
                            return StiMath.round((double)Func.Convert.toDecimal(argsList.get(0)), (int)((int)Func.Convert.toInt32(argsList.get(1))));
                        }
                    }
                    break;
                }
                case MathPow: {
                    switch (overload) {
                        case 1: {
                            return Math.pow(Func.Convert.toDouble(argsList.get(0)), Func.Convert.toDouble(argsList.get(1)));
                        }
                    }
                    break;
                }
                case GetAnchorPageNumber: {
                    switch (overload) {
                        case 1: {
                            return report.getAnchorPageNumber(argsList.get(0));
                        }
                    }
                    break;
                }
                case GetAnchorPageNumberThrough: {
                    switch (overload) {
                        case 1: {
                            return report.getAnchorPageNumberThrough(argsList.get(0));
                        }
                    }
                    break;
                }
                case ParseDateTime: {
                    switch (overload) {
                        case 1: {
                            try {
                                return StiDateTime.Parse((String)Func.Convert.toString(argsList.get(0)));
                            }
                            catch (Exception e) {
                                return null;
                            }
                        }
                    }
                    break;
                }
                case ParseDecimal: {
                    switch (overload) {
                        case 1: {
                            return BigDecimal.valueOf(Double.parseDouble(Func.Convert.toString(argsList.get(0))));
                        }
                    }
                    break;
                }
                case ParseDouble: {
                    switch (overload) {
                        case 1: {
                            return Double.valueOf(Func.Convert.toString(argsList.get(0)));
                        }
                    }
                    break;
                }
                case ParseInt: {
                    switch (overload) {
                        case 1: {
                            return Integer.valueOf(Func.Convert.toString(argsList.get(0)));
                        }
                    }
                    break;
                }
                case StringIsNullOrEmpty: {
                    if (overload == 1) {
                        return StiValidationUtil.isNullOrEmpty((String)Func.Convert.toString(argsList.get(0)));
                    }
                    break;
                }
                case StringIsNullOrWhiteSpace: {
                    if (overload == 1) {
                        return StiValidationUtil.isNullOrWhiteSpace((String)Func.Convert.toString(argsList.get(0)));
                    }
                    break;
                }
                case IsNull: {
                    if (overload == 1) {
                        return StiFunctionsPrintState.isNull(argsList.get(0), Func.Convert.toString(argsList.get(1)));
                    }
                    break;
                }
                case Next: {
                    if (overload == 1) {
                        return StiFunctionsPrintState.next(argsList.get(0), Func.Convert.toString(argsList.get(1)));
                    }
                    break;
                }
                case NextIsNull: {
                    if (overload == 1) {
                        return StiFunctionsPrintState.nextIsNull(argsList.get(0), Func.Convert.toString(argsList.get(1)));
                    }
                    break;
                }
                case Previous: {
                    if (overload == 1) {
                        return StiFunctionsPrintState.previous(argsList.get(0), Func.Convert.toString(argsList.get(1)));
                    }
                    break;
                }
                case PreviousIsNull: {
                    if (overload == 1) {
                        return StiFunctionsPrintState.previousIsNull(argsList.get(0), Func.Convert.toString(argsList.get(1)));
                    }
                    break;
                }
                case StiNullValuesHelperIsNull: {
                    switch (overload) {
                        case 1: {
                            return StiNullValuesHelper.isNull((StiReport)argsList.get(0), Func.Convert.toString(argsList.get(1)));
                        }
                    }
                    break;
                }
                case TimeSpanFromDays: {
                    switch (overload) {
                        case 1: {
                            return StiTimeSpan.fromDays((double)Func.Convert.toDouble(argsList.get(0)));
                        }
                    }
                    break;
                }
                case TimeSpanFromHours: {
                    switch (overload) {
                        case 1: {
                            return StiTimeSpan.fromHours((double)Func.Convert.toDouble(argsList.get(0)));
                        }
                    }
                    break;
                }
                case TimeSpanFromMilliseconds: {
                    switch (overload) {
                        case 1: {
                            return StiTimeSpan.fromMilliseconds((double)Func.Convert.toDouble(argsList.get(0)));
                        }
                    }
                    break;
                }
                case TimeSpanFromMinutes: {
                    switch (overload) {
                        case 1: {
                            return StiTimeSpan.fromMinutes((double)Func.Convert.toDouble(argsList.get(0)));
                        }
                    }
                    break;
                }
                case TimeSpanFromSeconds: {
                    switch (overload) {
                        case 1: {
                            return StiTimeSpan.fromSeconds((double)((float)Func.Convert.toDouble(argsList.get(0))));
                        }
                    }
                    break;
                }
                case TimeSpanFromTicks: {
                    switch (overload) {
                        case 1: {
                            return StiTimeSpan.fromTicks((double)Func.Convert.toDouble(argsList.get(0)));
                        }
                    }
                    break;
                }
                case TryParseDateTime: {
                    try {
                        StiDateTime.Parse((String)argsList.get(0).toString());
                    }
                    catch (Exception e) {
                        return false;
                    }
                    return true;
                }
                case StrToDateTime: {
                    try {
                        return StiDateTime.Parse((String)argsList.get(0).toString());
                    }
                    catch (Exception e) {
                        return StiDateTime.now();
                    }
                }
                case StrToNullableDateTime: {
                    try {
                        return StiDateTime.Parse((String)argsList.get(0).toString());
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
                case GetLabel: {
                    return report.getLabel(Func.Convert.toString(argsList.get(0)));
                }
                case GetParam: {
                    return report.getParam(Func.Convert.toString(argsList.get(0)));
                }
                case ARGB: {
                    return StiFunctionsDrawing.ARGB((int)Func.Convert.toInt32(argsList.get(0)), (int)Func.Convert.toInt32(argsList.get(1)), (int)Func.Convert.toInt32(argsList.get(2)), (int)Func.Convert.toInt32(argsList.get(3)));
                }
                case RGB: {
                    return StiFunctionsDrawing.RGB((int)Func.Convert.toInt32(argsList.get(0)), (int)Func.Convert.toInt32(argsList.get(1)), (int)Func.Convert.toInt32(argsList.get(2)));
                }
                case ColorValue: {
                    return StiFunctionsDrawing.colorValue(argsList.get(0).toString());
                }
                case ColorFade: {
                    return StiFunctionsDrawing.colorFade(argsList.get(0), Func.Convert.toDouble(argsList.get(1)));
                }
                case SolidBrushValue: {
                    return StiFunctionsDrawing.solidBrushValue(argsList.get(0));
                }
                case GradientBrushValue: {
                    return StiFunctionsDrawing.gradientBrushValue(argsList.get(0), argsList.get(1), Func.Convert.toDouble(argsList.get(2)));
                }
                case GlareBrushValue: {
                    return StiFunctionsDrawing.glareBrushValue(argsList.get(0), argsList.get(1), Func.Convert.toDouble(argsList.get(2)), Func.Convert.toDouble(argsList.get(3)), Func.Convert.toDouble(argsList.get(4)));
                }
                case GlassBrushValue: {
                    return StiFunctionsDrawing.glassBrushValue(argsList.get(0), Func.Convert.toBoolean(argsList.get(1)), Func.Convert.toDouble(argsList.get(2)));
                }
                case HatchBrushValue: {
                    return StiFunctionsDrawing.hatchBrushValue((StiHatchStyle)argsList.get(0), argsList.get(1), argsList.get(2));
                }
                case GetRealPageNumber: {
                    return StiFunctionsData.getRealPageNumber(argsList.get(0));
                }
                case GetCrossTabColumnValue: {
                    switch (overload) {
                        case 1: {
                            return StiFunctionsData.getCrossTabColumnValue(argsList.get(0));
                        }
                    }
                    break;
                }
                case GetCrossTabRowValue: {
                    switch (overload) {
                        case 1: {
                            return StiFunctionsData.getCrossTabRowValue(argsList.get(0));
                        }
                    }
                    break;
                }
                case Eval: {
                    return StiFunctionsProgramming.eval(argsList.get(0), argsList.get(1).toString());
                }
                case EvalLong: {
                    return StiFunctionsProgramming.evalLong(argsList.get(0), argsList.get(1).toString());
                }
                case EvalDouble: {
                    return StiFunctionsProgramming.evalDouble(argsList.get(0), argsList.get(1).toString());
                }
                case EvalDecimal: {
                    return StiFunctionsProgramming.evalDecimal(argsList.get(0), argsList.get(1).toString());
                }
                default: {
                    int value;
                    if (!StiValidationUtil.isNullOrEmpty((String)command.getCustomFunctionName())) {
                        return StiCallFunction.invokeCustomFunction((Object)name, argsList, report, parser, command.getCustomFunctionName());
                    }
                    if (functionType.intValue >= StiFunctionType.UserFunction2.intValue) {
                        String funcName = null;
                        for (String key : parser.getUserFunctionsList().keySet()) {
                            value = parser.getUserFunctionsList().get(key);
                            if (value != functionType.intValue) continue;
                            funcName = key;
                            break;
                        }
                        Iterator iterator = report.getDictionary().getUserFunctions().iterator();
                        while (iterator.hasNext()) {
                            StiUserFunction function = (StiUserFunction)iterator.next();
                            if (!Objects.equals(function.getName(), funcName)) continue;
                            HashMap arguments = new HashMap();
                            int count = Math.min(argsList.size(), function.getArguments().size());
                            for (int index = 0; index < count; ++index) {
                                arguments.put(((StiUserFunctionArgument)function.getArguments().get(index)).getName(), argsList.get(index));
                            }
                            try {
                                return StiUserFunctionHelper.invokeFunction(function, report, argsList.toArray());
                            }
                            catch (Exception ex) {
                                throw new RuntimeException(ex.getMessage() + function.getName());
                            }
                        }
                    }
                    if (functionType.intValue >= StiFunctionType.UserFunction.intValue) {
                        String functionName = null;
                        for (String key : parser.getUserFunctionsList().keySet()) {
                            value = parser.getUserFunctionsList().get(key);
                            if (value != functionType.intValue) continue;
                            functionName = key;
                            break;
                        }
                        if (functionName != null) {
                            StiFunction[] functions;
                            int count = argsList.size();
                            Class[] types = new Class[count];
                            Object[] args = new Object[count];
                            for (int index = 0; index < count; ++index) {
                                args[index] = argsList.get(index);
                                if (args[index] instanceof StiRefObject) {
                                    args[index] = ((StiRefObject)args[index]).argvalue;
                                }
                                types[index] = args[index] == null ? Object.class : args[index].getClass();
                            }
                            for (StiFunction func : functions = StiFunctions.getFunctions(false)) {
                                if (!Objects.equals(func.getFunctionName(), functionName) || (func.getArgumentTypes() != null ? func.getArgumentTypes().length : 0) != count) continue;
                                boolean bl = true;
                            }
                        }
                    }
                    break;
                }
            }
        }
        catch (RuntimeException e) {
            StringBuilder info = new StringBuilder();
            for (Object obj : argsList) {
                info.append(" " + obj);
            }
            if (report != null) {
                report.WriteToReportRenderingMessages("Error: argList=" + info.toString() + ", objName=" + (Object)((Object)name) + ", customFunctionName=" + command.getCustomFunctionName() + " " + (e.getMessage() != null ? e.getMessage() : e.getStackTrace()[0].toString()));
            }
            StiLoggingUtil.showWarning((String)("Error: argList=" + info.toString() + ", objName=" + (Object)((Object)name) + ", customFunctionName=" + command.getCustomFunctionName()), (Exception)e);
            return "";
        }
        return "";
    }

    private static StiParserDataType get_category2(Object par) {
        if (par == null) {
            return StiParserDataType.None;
        }
        boolean category = false;
        if (par instanceof String) {
            return StiParserDataType.String;
        }
        if (par instanceof Character) {
            return StiParserDataType.Char;
        }
        if (par instanceof BigDecimal) {
            return StiParserDataType.Decimal;
        }
        if (par instanceof Double) {
            return StiParserDataType.Double;
        }
        if (par instanceof Float) {
            return StiParserDataType.Double;
        }
        if (par instanceof Long) {
            return StiParserDataType.Int;
        }
        if (par instanceof Integer) {
            return StiParserDataType.Int;
        }
        if (par instanceof Short) {
            return StiParserDataType.Int;
        }
        if (par instanceof Byte) {
            return StiParserDataType.Int;
        }
        if (par instanceof Calendar || par instanceof StiDateTime || par instanceof ZonedDateTime) {
            return StiParserDataType.DateTime;
        }
        if (par instanceof Boolean) {
            return StiParserDataType.Bool;
        }
        if (par instanceof StiDataSource) {
            return StiParserDataType.StiDataSource;
        }
        return StiParserDataType.None;
    }

    public static int checkParserMethodInfo(StiFunctionType type, List args) {
        if (!StiParser.getMethodsHash().containsKey((Object)type)) {
            return 0;
        }
        List<StiParserMethodInfo> methods = StiParser.getMethodsHash().get((Object)type);
        int count = args.size();
        StiParserDataType[] types = new StiParserDataType[count];
        for (int index = 0; index < count; ++index) {
            types[index] = StiCallFunction.get_category2(args.get(index));
        }
        boolean flag1 = false;
        for (StiParserMethodInfo methodInfo : methods) {
            if (methodInfo.getArguments().length != count) continue;
            flag1 = true;
            boolean flag2 = true;
            for (int index = 0; index < count; ++index) {
                if ((types[index].getValue() & methodInfo.getArguments()[index].getValue()) != 0 || methodInfo.getArguments()[index] == StiParserDataType.Object) continue;
                flag2 = false;
                break;
            }
            if (!flag2) continue;
            return methodInfo.getNumber();
        }
        if (!flag1) {
            StiCallFunction.ThrowError(12, StiFunctionType.getFunctionsList().get((Object)type).toString(), count);
        }
        StringBuilder sb = new StringBuilder();
        for (int index = 0; index < count; ++index) {
            sb.append(types[index].toString());
            if (index >= count - 1) continue;
            sb.append(",");
        }
        StiCallFunction.ThrowError(17, StiFunctionType.getFunctionsList().get(type.name()).toString(), sb.toString());
        return 0;
    }

    private static Object invokeCustomFunction(Object name, List argsList, StiReport report, StiParser parser, String customFunctionName) {
        if (customFunctionName != null) {
            for (StiCustomFunction function : report.getCustomFunctions()) {
                if (!customFunctionName.equals(function.getFunctionName()) || !StiCallFunction.isParamsEqual(argsList, function.getParametersList())) continue;
                return function.invoke(argsList);
            }
            String params = "";
            for (Object par : argsList) {
                params = params + par.getClass().getName() + " ";
            }
            throw new RuntimeException("Custom function: " + customFunctionName + " with parameters [" + params.trim() + "] not found in report custom functions list");
        }
        return null;
    }

    private static boolean isParamsEqual(List argsList, List<Class> paramsList) {
        if ((paramsList == null || paramsList.size() == 0) && argsList.size() == 0) {
            return true;
        }
        if (paramsList != null && paramsList.size() != argsList.size() || paramsList == null && argsList.size() > 0) {
            return false;
        }
        for (int i = 0; i < argsList.size(); ++i) {
            if (argsList.get(i) == null || argsList.get(i).getClass().equals(paramsList.get(i))) continue;
            return false;
        }
        return true;
    }

    private static void ThrowError(int code, String message, int size) {
        throw new RuntimeException("code '" + code + "', message '" + message + "', size '" + size);
    }

    private void ThrowError(int code) {
        StiCallFunction.ThrowError(code, "", "", "", "");
    }

    private static void ThrowError(int code, String message1) {
        StiCallFunction.ThrowError(code, message1, "", "", "");
    }

    private static void ThrowError(int code, String message1, String message2) {
        StiCallFunction.ThrowError(code, message1, message2, "", "");
    }

    private void ThrowError(int code, String message1, String message2, String message3) {
        StiCallFunction.ThrowError(code, message1, message2, message3, "");
    }

    private static void ThrowError(int code, String message1, String message2, String message3, String message4) {
        String errorMessage = "Parser error: Unknown error";
        if (code < errorsList.length) {
            errorMessage = "Parser error: " + String.format(errorsList[code], message1, message2, message3, message4);
        }
        throw new RuntimeException(errorMessage);
    }

    public static StiDateTime toDateTime(Object par1) {
        if (par1 instanceof Calendar) {
            return new StiDateTime((Calendar)par1);
        }
        if (par1 instanceof ZonedDateTime) {
            return new StiDateTime((ZonedDateTime)par1);
        }
        return (StiDateTime)par1;
    }
}

