/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.engine.engineV2;

import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.simplecomponents.StiText;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class StiPageLineHelper {
    static final String Ident = "[%@&";
    private static ConcurrentHashMap<String, String> textToIdentCache = new ConcurrentHashMap();

    public static String getIdent(StiReport report) {
        return StiPageLineHelper.getIdent(report, null);
    }

    public static String getIdent(StiReport report, String key) {
        if (report != null && report.getEngine() != null) {
            key = report.getEngine().getUniqueShortName(key);
        }
        return StiValidationUtil.isNullOrEmpty((String)key) ? "[%@&]" : Ident + key + "]";
    }

    public static void pushPageLineNumber(StiPage page) {
        if (page == null || page.getReport().getEngine() == null || !page.getReport().getEngine().pageLineRenderingEnabled) {
            return;
        }
        List comps = page.GetComponents().stream().filter(c -> c instanceof StiText).map(StiText.class::cast).filter(t -> t.getText() != null && t.getText().getValue() != null && t.getText().getValue().contains(Ident)).collect(Collectors.toList());
        Map<Object, List<StiText>> groups = comps.stream().collect(Collectors.groupingBy(c -> StiPageLineHelper.getIdent(c.getText().getValue())));
        for (Object key : groups.keySet()) {
            String text = key.toString();
            int index = text.indexOf(Ident);
            int lastIndex = text.indexOf("]", index + 1);
            int pageLine = 1;
            for (StiText c2 : groups.get(key)) {
                c2.getText().setValue(c2.getText().getValue().substring(0, index) + pageLine + c2.getText().getValue().substring(lastIndex + 1));
                ++pageLine;
            }
        }
    }

    private static String getIdent(String text) {
        if (textToIdentCache.containsKey(text)) {
            return textToIdentCache.get(text);
        }
        int index = text.indexOf(Ident);
        int lastIndex = text.indexOf("]", index + 1);
        String ident = text.substring(index, lastIndex + 1);
        textToIdentCache.put(text, ident);
        return ident;
    }
}

