/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.engine.engineV2;

import com.stimulsoft.base.EventArgs;
import com.stimulsoft.base.StiEnumSet;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.enums.StiBorderSides;
import com.stimulsoft.base.enums.StiPaperKind;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.StiRuntimeVariables;
import com.stimulsoft.report.components.StiBookmark;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentsCollection;
import com.stimulsoft.report.components.StiMargins;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.bands.StiBand;
import com.stimulsoft.report.components.bands.StiChildBand;
import com.stimulsoft.report.components.bands.StiColumnHeaderBand;
import com.stimulsoft.report.components.bands.StiDataBand;
import com.stimulsoft.report.components.bands.StiFooterBand;
import com.stimulsoft.report.components.bands.StiGroupFooterBand;
import com.stimulsoft.report.components.bands.StiGroupHeaderBand;
import com.stimulsoft.report.components.bands.StiHeaderBand;
import com.stimulsoft.report.components.bands.StiPageFooterBand;
import com.stimulsoft.report.components.complexcomponents.StiContainer;
import com.stimulsoft.report.components.enums.StiColumnDirection;
import com.stimulsoft.report.components.enums.StiComponentType;
import com.stimulsoft.report.components.enums.StiDockStyle;
import com.stimulsoft.report.components.enums.StiPrintOnEvenOddPagesType;
import com.stimulsoft.report.components.enums.StiProcessAt;
import com.stimulsoft.report.components.enums.StiTextQuality;
import com.stimulsoft.report.components.interfaces.IStiBorder;
import com.stimulsoft.report.components.interfaces.IStiBrush;
import com.stimulsoft.report.components.interfaces.IStiFont;
import com.stimulsoft.report.components.interfaces.IStiPageBreak;
import com.stimulsoft.report.components.interfaces.IStiPrintAtBottom;
import com.stimulsoft.report.components.interfaces.IStiPrintOnEvenOddPages;
import com.stimulsoft.report.components.interfaces.IStiTextBrush;
import com.stimulsoft.report.components.simplecomponents.StiSimpleText;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.components.table.IStiTableCell;
import com.stimulsoft.report.components.table.StiTable;
import com.stimulsoft.report.engine.StiOddEvenStylesHelper;
import com.stimulsoft.report.engine.StiRenderState;
import com.stimulsoft.report.engine.engineV2.StiBandsOnAllPages;
import com.stimulsoft.report.engine.engineV2.StiBreakableHelper;
import com.stimulsoft.report.engine.engineV2.StiColumnsContainer;
import com.stimulsoft.report.engine.engineV2.StiColumnsOnDataBand;
import com.stimulsoft.report.engine.engineV2.StiColumnsOnPanel;
import com.stimulsoft.report.engine.engineV2.StiEmptyBandsV2Helper;
import com.stimulsoft.report.engine.engineV2.StiFooterMarkerContainer;
import com.stimulsoft.report.engine.engineV2.StiFootersOnAllPages;
import com.stimulsoft.report.engine.engineV2.StiIndex;
import com.stimulsoft.report.engine.engineV2.StiLevelEndContainer;
import com.stimulsoft.report.engine.engineV2.StiLevelStartContainer;
import com.stimulsoft.report.engine.engineV2.StiNewPageContainer;
import com.stimulsoft.report.engine.engineV2.StiPageHelper;
import com.stimulsoft.report.engine.engineV2.StiPageLineHelper;
import com.stimulsoft.report.engine.engineV2.StiPageNumberHelper;
import com.stimulsoft.report.engine.engineV2.StiPrintAtBottom;
import com.stimulsoft.report.engine.engineV2.StiProgressHelper;
import com.stimulsoft.report.engine.engineV2.StiRenderProviderV2;
import com.stimulsoft.report.engine.engineV2.StiReportRenderingStopException;
import com.stimulsoft.report.engine.engineV2.StiStaticBandsHelper;
import com.stimulsoft.report.engine.engineV2.StiStopBeforePageException;
import com.stimulsoft.report.engine.engineV2.StiStopBeforePrintException;
import com.stimulsoft.report.engine.engineV2.StiThreads;
import com.stimulsoft.report.engine.engineV2.builders.StiBandV2Builder;
import com.stimulsoft.report.options.EngineOptions;
import com.stimulsoft.report.styles.StiBaseStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Logger;

public class StiEngine {
    private static Logger LOG = Logger.getLogger("com.stimulsoft.report.engine.engineV2.StiEngine");
    private boolean dockPageFooterToBottom = true;
    public static final boolean OldWYSIWYG = false;
    public boolean isDynamicBookmarksMode = false;
    public boolean isCrossBandsMode = false;
    private boolean isFirstDataBandOnPage = false;
    private boolean isLastDataBandOnPage = false;
    private final Hashtable printOnAllPagesIgnoreList = new Hashtable();
    private final Hashtable printOnAllPagesIgnoreList2 = new Hashtable();
    private StiProgressHelper progressHelper = null;
    private StiBandsOnAllPages bandsOnAllPages = null;
    private boolean denyRenderMasterComponentsInContainer = false;
    private StiPrintAtBottom printAtBottom = null;
    private StiFootersOnAllPages footersOnAllPages = null;
    public StiStaticBandsHelper staticBands = null;
    private StiThreads threads = null;
    private StiDataBand lastRenderedDataBand;
    private StiBreakableHelper breakable = null;
    private boolean denyChangeThread = false;
    private final Hashtable slaveEngines = new Hashtable();
    public StiEngine masterEngine = null;
    public HashMap<StiComponent, StiSize> hashCheckSize;
    public StiEmptyBandsV2Helper emptyBands = null;
    public StiPageNumberHelper pageNumbers = null;
    private StiColumnsOnDataBand columnsOnDataBand = null;
    private HashMap<String, String> shortNameMap;
    public StiDataBand currentDataBandOfPageLine;
    public boolean pageLineRenderingEnabled;
    public StiColumnsOnPanel columnsOnPanel = null;
    private double freeSpace = 0.0;
    private double crossFreeSpace = 0.0;
    private double positionX = 0.0;
    private double positionY = 0.0;
    public double positionBottomY = 0.0;
    public StiContainer containerForRender = null;
    public Map<String, Integer> hashDataBandLastLine = new HashMap<String, Integer>();
    private StiPage page = null;
    public StiPage templatePage = null;
    public StiContainer templateContainer = null;
    public StiReport report;
    private StiReport masterReport = null;
    private boolean ignoreUnlimitedHeightForNewPage = false;
    public int StartIndexPageForPageTotal = -1;
    public int IndexPageForPageTotal = -1;
    private Hashtable childsBandHash = null;
    public boolean SilentMode = false;
    public StiRenderState RenderState = null;
    public StiIndex IndexOfLatestDataBand = null;
    public boolean generateNewPageBeforeBand = false;
    public boolean ignoreSkipFirst = false;
    public boolean generateNewColumnBeforeBand = false;
    public Hashtable pageBreakSkipFirstCollection = new Hashtable();
    public int IndexOfStartList = 0;
    public boolean skipFirstPageBeforePrintEvent = false;
    public boolean FirstCallNewPage = false;
    public boolean DenyClearPrintOnAllPagesIgnoreList = false;
    public Hashtable<String, String> duplicatesLastValues = null;
    private Hashtable _parserConversionStore = null;
    public Object lastInvokeTextProcessValueEventArgsValue = null;
    public boolean atLeastOneDatabandRenderedOnPage = false;
    private double lastFreeSpaceOnPageAfterNewList;
    public ArrayList<StiBand> bandsInProgress = new ArrayList();
    public boolean AllowEndOfPageProcessing = false;
    private boolean flagRenderColumnsOnDataBandOnNewPage = false;
    public double offsetNewColumnY = 0.0;
    private HashMap<StiDataBand, StiDataBand> keepFirstDetailTogetherList = new HashMap();
    private Hashtable<StiComponent, StiBaseStyle> hashParentStyles = null;
    private Hashtable<StiComponent, Boolean> hashUseParentStyles = new Hashtable();
    public Hashtable<String, String> anchorsArguments;
    public StiBookmark firstPassPointer;

    public StiEngine(StiReport report) {
        this.pageNumbers = new StiPageNumberHelper(this);
        this.emptyBands = new StiEmptyBandsV2Helper(this);
        this.bandsOnAllPages = new StiBandsOnAllPages(this);
        this.printAtBottom = new StiPrintAtBottom(this);
        this.progressHelper = new StiProgressHelper(this);
        this.footersOnAllPages = new StiFootersOnAllPages(this);
        this.columnsOnDataBand = new StiColumnsOnDataBand(this);
        this.columnsOnPanel = new StiColumnsOnPanel(this);
        this.staticBands = new StiStaticBandsHelper(this);
        this.breakable = new StiBreakableHelper(this);
        this.threads = new StiThreads(this);
        this.report = report;
    }

    public StiTextQuality getDefaultTextQualityMode() {
        return StiTextQuality.Standard;
    }

    public void setDockPageFooterToBottom(boolean dockPageFooterToBottom) {
        this.dockPageFooterToBottom = dockPageFooterToBottom;
    }

    public boolean isDockPageFooterToBottom() {
        return this.dockPageFooterToBottom;
    }

    public StiPaperKind getDefaultPaperSize() {
        return StiPaperKind.Custom;
    }

    public final boolean getIsDynamicBookmarksMode() {
        return this.isDynamicBookmarksMode;
    }

    public final void setIsDynamicBookmarksMode(boolean value) {
        this.isDynamicBookmarksMode = value;
    }

    public final boolean getIsCrossBandsMode() {
        return this.isCrossBandsMode;
    }

    public final void setIsCrossBandsMode(boolean value) {
        this.isCrossBandsMode = value;
    }

    public final boolean getIsFirstDataBandOnPage() {
        return this.isFirstDataBandOnPage;
    }

    public final void setIsFirstDataBandOnPage(boolean value) {
        this.isFirstDataBandOnPage = value;
    }

    public final boolean getIsLastDataBandOnPage() {
        return this.isLastDataBandOnPage;
    }

    public final void setIsLastDataBandOnPage(boolean value) {
        this.isLastDataBandOnPage = value;
    }

    public StiDataBand getLastRenderedDataBand() {
        return this.lastRenderedDataBand;
    }

    public void setLastRenderedDataBand(StiDataBand lastRenderedDataBand) {
        this.lastRenderedDataBand = lastRenderedDataBand;
    }

    public final Hashtable getPrintOnAllPagesIgnoreList() {
        return this.printOnAllPagesIgnoreList;
    }

    public final StiProgressHelper getProgressHelper() {
        return this.progressHelper;
    }

    public final StiBandsOnAllPages getBandsOnAllPages() {
        return this.bandsOnAllPages;
    }

    public final boolean getDenyRenderMasterComponentsInContainer() {
        return this.denyRenderMasterComponentsInContainer;
    }

    public final void setDenyRenderMasterComponentsInContainer(boolean value) {
        this.denyRenderMasterComponentsInContainer = value;
    }

    public final StiPrintAtBottom getPrintAtBottom() {
        return this.printAtBottom;
    }

    public final StiFootersOnAllPages getFootersOnAllPages() {
        return this.footersOnAllPages;
    }

    public final StiStaticBandsHelper getStaticBands() {
        return this.staticBands;
    }

    public final StiThreads getThreads() {
        return this.threads;
    }

    public final StiBreakableHelper getBreakable() {
        return this.breakable;
    }

    public final boolean getDenyChangeThread() {
        return this.denyChangeThread;
    }

    public final void setDenyChangeThread(boolean value) {
        this.denyChangeThread = value;
    }

    public final Hashtable<String, StiEngine> getSlaveEngines() {
        return this.slaveEngines;
    }

    public final StiEngine getMasterEngine() {
        return this.masterEngine;
    }

    public final void setMasterEngine(StiEngine value) {
        this.masterEngine = value;
    }

    public final StiEmptyBandsV2Helper getEmptyBands() {
        return this.emptyBands;
    }

    public final StiPageNumberHelper getPageNumbers() {
        return this.pageNumbers;
    }

    public final StiColumnsOnDataBand getColumnsOnDataBand() {
        return this.columnsOnDataBand;
    }

    public final StiColumnsOnPanel getColumnsOnPanel() {
        return this.columnsOnPanel;
    }

    public final double getFreeSpace() {
        return this.freeSpace;
    }

    public final void setFreeSpace(double value) {
        this.freeSpace = Math.abs(value) < 1.0E-4 ? 0.0 : value;
    }

    public final double getCrossFreeSpace() {
        return this.crossFreeSpace;
    }

    public final void setCrossFreeSpace(double value) {
        if (this.crossFreeSpace != value) {
            this.crossFreeSpace = value;
        }
    }

    public final double getPositionX() {
        return this.positionX;
    }

    public final void setPositionX(double value) {
        if (this.positionX != value) {
            this.positionX = value;
        }
    }

    public final double getPositionY() {
        return this.positionY;
    }

    public final void setPositionY(double value) {
        this.positionY = value;
    }

    public final double getPositionBottomY() {
        return this.positionBottomY;
    }

    public final void setPositionBottomY(double value) {
        if (this.positionBottomY != value) {
            this.positionBottomY = value;
        }
    }

    public final StiContainer getContainerForRender() {
        return this.containerForRender;
    }

    public final void setContainerForRender(StiContainer value) {
        if (this.containerForRender != value) {
            this.containerForRender = value;
        }
    }

    public final StiPage getPage() {
        return this.page;
    }

    public final void setPage(StiPage value) {
        if (this.page != value) {
            this.page = value;
        }
    }

    public final StiPage getTemplatePage() {
        return this.templatePage;
    }

    public final void setTemplatePage(StiPage value) {
        if (this.templatePage != value) {
            this.templatePage = value;
        }
    }

    public final StiContainer getTemplateContainer() {
        return this.templateContainer;
    }

    public final void setTemplateContainer(StiContainer value) {
        if (this.templateContainer != value) {
            this.templateContainer = value;
        }
    }

    public final StiReport getReport() {
        return this.report;
    }

    public final void setReport(StiReport value) {
        if (this.report != value) {
            this.report = value;
        }
    }

    public final StiReport getMasterReport() {
        return this.masterReport;
    }

    public final void setMasterReport(StiReport value) {
        if (this.masterReport != value) {
            this.masterReport = value;
        }
    }

    public final boolean getIgnoreUnlimitedHeightForNewPage() {
        return this.ignoreUnlimitedHeightForNewPage;
    }

    public final void setIgnoreUnlimitedHeightForNewPage(boolean value) {
        this.ignoreUnlimitedHeightForNewPage = value;
    }

    public final Hashtable getparserConversionStore() {
        if (this._parserConversionStore == null) {
            this._parserConversionStore = new Hashtable();
        }
        return this._parserConversionStore;
    }

    public final void setparserConversionStore(Hashtable value) {
        this._parserConversionStore = value;
    }

    public final void NewList() {
        this.NewList(false);
    }

    public final void NewList(boolean skipStaticBands) {
        if (this.getContainerForRender() == null) {
            return;
        }
        if (!(skipStaticBands || this.getColumnsOnPanel().getCurrentColumn() != 1 && this.getColumnsOnPanel().getCount() >= 2)) {
            this.getStaticBands().Render();
        }
        this.IndexOfLatestDataBand = null;
        this.getBandsOnAllPages().Render();
        if (this.hashCheckSize != null && this.hashCheckSize.size() > EngineOptions.ReportCache.getAmountOfProcessedPagesForStartGCCollect() * 2500) {
            this.hashCheckSize.clear();
        }
    }

    public final void NewColumn() {
        this.NewColumn(true);
    }

    public final void NewColumn(boolean ignoreKeepContainers) {
        this.getColumnsOnPanel().setCurrentColumn(this.getColumnsOnPanel().getCurrentColumn() + 1);
        if (this.getColumnsOnPanel().getCurrentColumn() > this.getColumnsOnPanel().getCount() && StiOptions.Engine.getForceNewPageForExtraColumns() || this.getIsCrossBandsMode()) {
            if (!this.getIsCrossBandsMode()) {
                this.getColumnsOnPanel().setCurrentColumn(1);
                this.setPositionX(0.0);
            }
            this.NewPage(ignoreKeepContainers);
        } else {
            StiContainer oldContainerForRender = this.getContainerForRender();
            this.FinishColumns(oldContainerForRender);
            StiContainer selectedContainer = this.SearchStartOfKeepContainer(oldContainerForRender, this.IndexOfStartList);
            if (ignoreKeepContainers) {
                selectedContainer = null;
            }
            if (oldContainerForRender != null && selectedContainer != null && oldContainerForRender.getComponents().indexOf(selectedContainer) == 0) {
                selectedContainer = null;
            }
            this.ChangeEngineParamsByKeep(oldContainerForRender, selectedContainer);
            this.RenderFootersOnAllPages(this.getContainerForRender(), this.IndexOfStartList, selectedContainer);
            this.RenderPrintAtBottom(this.getContainerForRender(), this.IndexOfStartList, selectedContainer);
            this.RenderEmptyBands(oldContainerForRender, selectedContainer);
            this.SetNewColumnParameters();
            if (this.getColumnsOnPanel().getCurrentColumn() > this.getColumnsOnPanel().getCount() && !StiOptions.Engine.getForceNewPageForExtraColumns() && this.getContainerForRender() == oldContainerForRender) {
                this.getColumnsOnPanel().setCurrentColumn(1);
                if (this.getColumnsOnPanel().getRightToLeft()) {
                    this.setPositionX(this.getTemplateContainer().getWidth() - this.getColumnsOnPanel().GetColumnWidth());
                } else {
                    this.setPositionX(0.0);
                }
                double maxBottom = 0.0;
                for (StiComponent comp : oldContainerForRender.getComponents()) {
                    if (!(comp.getBottom() > maxBottom)) continue;
                    maxBottom = comp.getBottom();
                }
                this.offsetNewColumnY = maxBottom - this.getStaticBands().getReservedPositionY();
                this.positionY = maxBottom;
            }
            this.NewList();
            this.MoveKeepComponentsOnNextContainer(oldContainerForRender, selectedContainer);
            this.IndexOfStartList = this.getContainerForRender().getComponents().size() > 0 ? this.getContainerForRender().getComponents().size() - 1 : 0;
            this.FinishResetPageNumberContainer(oldContainerForRender, false);
            this.FinishContainer(oldContainerForRender);
        }
    }

    public final void NewPage() {
        this.NewPage(true);
    }

    public final void NewPage(boolean ignoreKeepContainers) {
        long koef = 99999999900L;
        if (!this.getIsCrossBandsMode() && this.getContainerForRender() != null && this.getContainerForRender().getHeight() > (double)koef && !StiOptions.Engine.getForceNewPageInSubReports()) {
            StiNewPageContainer newPageCont = new StiNewPageContainer();
            newPageCont.setTop(this.positionY);
            newPageCont.setHeight(this.getTemplatePage().getHeight());
            this.positionY += newPageCont.getHeight();
            this.freeSpace -= newPageCont.getHeight();
            this.containerForRender.getComponents().add(newPageCont);
            this.offsetNewColumnY = this.positionY - this.getStaticBands().getReservedPositionY();
            return;
        }
        if (this.getThreads().IsActive) {
            this.NewContainer(ignoreKeepContainers);
        } else {
            if (this.getIsCrossBandsMode() && this.getPage() != null) {
                double pageWidth = this.getPage().getPageWidth() - this.getPage().getMargins().getLeft() - this.getPage().getMargins().getRight();
                while (this.positionX + pageWidth > this.getPage().getWidth()) {
                    StiPage stiPage = this.getPage();
                    Integer n = stiPage.segmentPerWidth;
                    Integer n2 = stiPage.segmentPerWidth = Integer.valueOf(stiPage.segmentPerWidth + 1);
                }
                if (this.getTemplatePage().getUnlimitedBreakable()) {
                    this.setPositionX(this.getPositionX() + this.getCrossFreeSpace());
                    this.setCrossFreeSpace(this.getTemplatePage().getWidth());
                } else {
                    this.setCrossFreeSpace(this.getCrossFreeSpace() + this.getTemplatePage().getWidth());
                }
                return;
            }
            if (this.getPage() != null && this.getTemplatePage().getUnlimitedHeight() && !this.FirstCallNewPage && !this.ignoreUnlimitedHeightForNewPage) {
                Integer n;
                Integer n3;
                StiPage pageWidth;
                while ((int)(this.getPositionY() / this.getTemplatePage().getHeight() + 1.0) > this.getPage().segmentPerHeight) {
                    pageWidth = this.getPage();
                    n3 = pageWidth.segmentPerHeight;
                    n = pageWidth.segmentPerHeight = Integer.valueOf(pageWidth.segmentPerHeight + 1);
                    if (this.getTemplatePage().getUnlimitedBreakable()) continue;
                    this.setFreeSpace(this.getFreeSpace() + this.getTemplatePage().getHeight());
                }
                if (this.getTemplatePage().getUnlimitedBreakable()) {
                    if (this.getFreeSpace() > 0.0) {
                        this.setPositionY(this.getPositionY() + this.getTemplatePage().getHeight() - this.getPositionY() % this.getTemplatePage().getHeight());
                    } else {
                        this.setPositionY(this.getPositionY() + this.getFreeSpace());
                    }
                    this.setFreeSpace(this.getPositionBottomY());
                    while ((int)(this.getPositionY() / this.getTemplatePage().getHeight() + 1.0) > this.getPage().segmentPerHeight) {
                        pageWidth = this.getPage();
                        n3 = pageWidth.segmentPerHeight;
                        n = pageWidth.segmentPerHeight = Integer.valueOf(pageWidth.segmentPerHeight + 1);
                    }
                }
                return;
            }
            this.lastFreeSpaceOnPageAfterNewList = 0.0;
            this.FirstCallNewPage = false;
            if (!this.atLeastOneDatabandRenderedOnPage && this.getPrintOnAllPagesIgnoreList().size() > 0) {
                this.getPrintOnAllPagesIgnoreList().clear();
            }
            this.getColumnsOnPanel().setCurrentColumn(1);
            StiContainer oldContainerForRender = this.getContainerForRender();
            this.getTemplatePage().InvokeRendering();
            StiPage storedPage = this.getPage();
            boolean storedCacheMode = this.getReport().getRenderedPages().getCacheMode();
            if (this.getPage() != null) {
                this.ProcessPageAfterRendering(this.getPage(), false);
            }
            this.setPage(StiPageHelper.GetPageFromTemplate(this.getTemplatePage()));
            this.getPageNumbers().AddPageNumber(this.getReport().getCurrentPrintPage(), this.getPage().segmentPerWidth, this.getPage().segmentPerHeight);
            this.ProcessRendering();
            StiPage renderedPage = this.getPage().getReport().getRenderedPages().size() > 0 ? this.getPage().getReport().getRenderedPages().get(this.getPage().getReport().getRenderedPages().size() - 1) : null;
            this.AddPageToRenderedPages(this.getPage());
            this.FinishColumns(oldContainerForRender);
            StiPageHelper.preparePointer(this.getPage());
            StiContainer selectedContainer = this.SearchStartOfKeepContainer(oldContainerForRender, this.IndexOfStartList);
            if (ignoreKeepContainers) {
                selectedContainer = null;
            }
            if (oldContainerForRender != null && selectedContainer != null && oldContainerForRender.getComponents().indexOf(selectedContainer) == 0) {
                selectedContainer = null;
            }
            this.ChangeEngineParamsByKeep(oldContainerForRender, selectedContainer);
            this.RenderFootersOnAllPages(oldContainerForRender, this.IndexOfStartList, selectedContainer);
            this.RenderPrintAtBottom(oldContainerForRender, this.IndexOfStartList, selectedContainer);
            this.RenderEmptyBands(oldContainerForRender, selectedContainer);
            this.offsetNewColumnY = 0.0;
            this.SetNewPageParameters();
            this.setContainerForRender(this.getPage());
            this.CorrectPrintOnAllPagesIgnoreListBeforeNewList(oldContainerForRender, selectedContainer, false);
            this.NewList();
            this.CorrectPrintOnAllPagesIgnoreListBeforeNewList(oldContainerForRender, selectedContainer, true);
            this.atLeastOneDatabandRenderedOnPage = false;
            this.lastFreeSpaceOnPageAfterNewList = this.getFreeSpace();
            this.MoveKeepComponentsOnNextContainer(oldContainerForRender, selectedContainer);
            this.IndexOfStartList = 0;
            this.FinishResetPageNumberContainer(oldContainerForRender, false);
            this.FinishContainer(oldContainerForRender);
            StiPageLineHelper.pushPageLineNumber(renderedPage);
        }
    }

    private void NewContainer(boolean ignoreKeepContainers) {
        this.getColumnsOnPanel().setCurrentColumn(1);
        StiContainer oldContainerForRender = this.getContainerForRender();
        this.FinishColumns(oldContainerForRender);
        StiContainer selectedContainer = this.SearchStartOfKeepContainer(oldContainerForRender, this.IndexOfStartList);
        if (ignoreKeepContainers) {
            selectedContainer = null;
        }
        if (oldContainerForRender != null && selectedContainer != null && oldContainerForRender.getComponents().indexOf(selectedContainer) == 0) {
            selectedContainer = null;
        }
        this.ChangeEngineParamsByKeep(oldContainerForRender, selectedContainer);
        this.RenderFootersOnAllPages(oldContainerForRender, this.IndexOfStartList, selectedContainer);
        this.RenderPrintAtBottom(oldContainerForRender, this.IndexOfStartList, selectedContainer);
        this.RenderEmptyBands(oldContainerForRender, selectedContainer);
        this.getThreads().NewPage();
        this.NewList();
        this.MoveKeepComponentsOnNextContainer(oldContainerForRender, selectedContainer);
        this.IndexOfStartList = 0;
        this.FinishResetPageNumberContainer(oldContainerForRender, false);
        this.FinishContainer(oldContainerForRender);
    }

    public final void NewDestination() {
        this.NewDestination(false);
    }

    public final void NewDestination(boolean ignoreKeepContainers) {
        if (this.getColumnsOnPanel().getCount() > 1) {
            this.NewColumn(ignoreKeepContainers);
        } else {
            this.NewPage(ignoreKeepContainers);
        }
    }

    public final void AddFooterMarker(StiFooterBand footerMaster) {
        StiFooterMarkerContainer footerMarker = new StiFooterMarkerContainer();
        footerMarker.setTop(this.getPositionY());
        footerMarker.setLeft(this.getPositionX());
        footerMarker.setWidth(footerMarker.getWidth());
        footerMarker.setHeight(0.0);
        footerMarker.setName(footerMaster.getName());
        this.AddContainerToDestination(footerMarker);
    }

    public final void AddKeepLevelAtLatestDataBand() {
        if (this.IndexOfLatestDataBand != null) {
            StiContainer container = this.getContainerForRender();
            int index = this.IndexOfLatestDataBand.Index;
            if (this.IndexOfLatestDataBand.IndexInColumnContainer != -1) {
                container = (StiContainer)(container.getComponents().get(this.IndexOfLatestDataBand.IndexInColumnContainer) instanceof StiContainer ? (StiComponent)container.getComponents().get(this.IndexOfLatestDataBand.IndexInColumnContainer) : null);
                StiColumnsContainer columns = (StiColumnsContainer)(container instanceof StiColumnsContainer ? container : null);
                if (columns.ColumnDirection == StiColumnDirection.AcrossThenDown) {
                    index -= columns.GetLengthOfLastRow() - 1;
                }
            }
            if (index < container.getComponents().size() && index >= 0) {
                container.getComponents().add(index, new StiLevelStartContainer());
            }
        }
    }

    public final void AddLevel() {
        if (this.getColumnsOnDataBand().getEnabled()) {
            StiColumnsContainer columns = this.getColumnsOnDataBand().GetColumns();
            columns.AddContainer(new StiLevelStartContainer());
        } else {
            this.AddContainerToDestination(new StiLevelStartContainer());
        }
    }

    public final void RemoveLevel() {
        if (this.getColumnsOnDataBand().getEnabled()) {
            StiColumnsContainer columns = this.getColumnsOnDataBand().GetColumns();
            columns.AddContainer(new StiLevelEndContainer());
        } else {
            this.AddContainerToDestination(new StiLevelEndContainer());
        }
    }

    private StiComponentsCollection GetChildBands(StiBand band) {
        StiComponentsCollection childs;
        if (this.childsBandHash == null) {
            this.childsBandHash = new Hashtable();
        }
        if ((childs = (StiComponentsCollection)(this.childsBandHash.get(band) instanceof StiComponentsCollection ? this.childsBandHash.get(band) : null)) != null) {
            return childs;
        }
        childs = StiBandV2Builder.GetChildBands(band);
        this.childsBandHash.put(band, childs);
        return childs;
    }

    public final void ClearPageBreakSkipFirst() {
        this.pageBreakSkipFirstCollection.clear();
    }

    public final boolean CanGenerateNewContainer(IStiPageBreak pageBreak) {
        if (pageBreak == null) {
            return true;
        }
        if (!pageBreak.getSkipFirst()) {
            return true;
        }
        if (this.pageBreakSkipFirstCollection.get(pageBreak) != null) {
            return true;
        }
        this.pageBreakSkipFirstCollection.put(pageBreak, pageBreak);
        return false;
    }

    public final void RemoveBandFromPageBreakSkipList(IStiPageBreak pageBreak) {
        if (pageBreak == null) {
            return;
        }
        if (this.pageBreakSkipFirstCollection.get(pageBreak) != null) {
            this.pageBreakSkipFirstCollection.remove(pageBreak);
        }
    }

    public void ProcessPageAfterRendering(StiPage page, boolean isFinal) {
        if (this.AllowEndOfPageProcessing) {
            StiComponentsCollection comps = page.GetComponents();
            for (StiComponent comp : comps) {
                StiText text = (StiText)(comp instanceof StiText ? comp : null);
                if (text != null && text.getProcessAt() != StiProcessAt.EndOfPage) continue;
            }
        }
        StiRenderState state = this.RenderState;
        if (this.getMasterEngine() != null) {
            state = this.getMasterEngine().RenderState;
        }
        StiRenderProviderV2.ProcessPageToCache(this.getReport(), page, isFinal);
        if (state != null) {
            StiRenderProviderV2.ClearPagesWhichLessThenFromPageAndGreaterThenToPage(this.getReport(), state);
        }
        StiRenderProviderV2.ClearPagesForFirstPass(this.getReport());
    }

    public final void ProcessLastPageAfterRendering() {
        StiPage page = this.getReport().getRenderedPages().get(this.getReport().getRenderedPages().size() - 1);
        this.ProcessPageAfterRendering(page, false);
    }

    private void ProcessRendering() {
        if (this.getReport().getStop()) {
            throw new StiReportRenderingStopException();
        }
        if (this.getReport().getStop()) {
            throw new StiReportRenderingStopException();
        }
        this.getReport().InvokeRendering();
        if (this.getMasterReport() != null) {
            this.getMasterReport().InvokeRendering();
            if (this.getMasterReport().getStop()) {
                throw new StiReportRenderingStopException();
            }
            if (this.getMasterReport().getStop()) {
                throw new StiReportRenderingStopException();
            }
        }
        this.getProgressHelper().Process();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ReprocessRuntimeVariables(StiContainer container) {
        StiComponentsCollection comps;
        StiComponentsCollection stiComponentsCollection = comps = container.GetComponents();
        synchronized (stiComponentsCollection) {
            for (StiComponent comp : comps) {
                ArrayList list;
                if (!(comp instanceof StiSimpleText) || (list = (ArrayList)(this.report.getTotals().get(comp.getName()) instanceof ArrayList ? this.report.getTotals().get(comp.getName()) : null)) == null || list.isEmpty()) continue;
                ArrayList arrayList = list;
                synchronized (arrayList) {
                    for (StiRuntimeVariables runtime : list) {
                        if (runtime.TextBox != comp) continue;
                        runtime.setPageIndex(this.report.getRenderedPages().size());
                        runtime.CurrentPrintPage = this.report.getRenderedPages().size();
                    }
                }
            }
        }
    }

    public final void FinalClear() {
        this.ChangeEngineParamsByKeep(this.getContainerForRender(), null);
        StiContainer tempCont = null;
        this.RenderFootersOnAllPages(null, 0, tempCont);
        this.RenderPrintAtBottom(null, 0, null);
        this.RenderEmptyBands(this.getContainerForRender(), null);
        this.FinishColumns(this.getContainerForRender());
        this.FinishResetPageNumberContainer(this.getContainerForRender(), true);
        this.FinishContainer(null);
        this.getEmptyBands().Clear();
        if (this.childsBandHash != null) {
            this.childsBandHash.clear();
            this.childsBandHash = null;
        }
        if (this.duplicatesLastValues != null) {
            this.duplicatesLastValues.clear();
            this.duplicatesLastValues = null;
        }
        this.IndexOfLatestDataBand = null;
        if (this.hashCheckSize != null) {
            this.hashCheckSize.clear();
            this.hashCheckSize = null;
        }
        this.ClearPageBreakSkipFirst();
    }

    private boolean IsPrintAtBottomOrFooterOnAllPages(StiContainer container) {
        if (container == null) {
            return false;
        }
        IStiPrintAtBottom printAtBottom = (IStiPrintAtBottom)((Object)(container.getContainerInfoV2().getParentBand() instanceof IStiPrintAtBottom ? container.getContainerInfoV2().getParentBand() : null));
        if (printAtBottom != null && printAtBottom.getPrintAtBottom()) {
            return true;
        }
        StiFooterBand footer = (StiFooterBand)(container.getContainerInfoV2().getParentBand() instanceof StiFooterBand ? container.getContainerInfoV2().getParentBand() : null);
        return footer != null && footer.getPrintOnAllPages();
    }

    private void ChangeEngineParamsByKeep(StiContainer containerForRender, StiContainer selectedContainer) {
        int startIndex;
        if (selectedContainer == null) {
            return;
        }
        for (int index = startIndex = containerForRender.getComponents().indexOf(selectedContainer); index < containerForRender.getComponents().size(); ++index) {
            StiComponent cont;
            StiComponent stiComponent = cont = containerForRender.getComponents().get(index) instanceof StiComponent ? (StiComponent)containerForRender.getComponents().get(index) : null;
            if (cont instanceof StiContainer && !this.IsPrintAtBottomOrFooterOnAllPages((StiContainer)(cont instanceof StiContainer ? cont : null))) {
                this.setPositionY(this.getPositionY() - cont.getHeight());
            }
            this.setFreeSpace(this.getFreeSpace() + cont.getHeight());
        }
    }

    private void SetNewColumnParameters() {
        if (this.getIsCrossBandsMode()) {
            this.setCrossFreeSpace(this.getStaticBands().getReservedCrossFreeSpace());
            this.setPositionX(this.getStaticBands().getReservedPositionX());
            this.setPositionY(this.getStaticBands().getReservedPositionY());
        } else {
            this.setFreeSpace(this.getStaticBands().getReservedFreeSpace());
            if (this.getColumnsOnPanel().getRightToLeft()) {
                this.setPositionX(this.getPositionX() - this.getColumnsOnPanel().GetColumnWidth() + this.getColumnsOnPanel().getColumnGaps());
            } else {
                this.setPositionX(this.getPositionX() + this.getColumnsOnPanel().GetColumnWidth() + this.getColumnsOnPanel().getColumnGaps());
            }
            this.setPositionY(this.getStaticBands().getReservedPositionY() + this.offsetNewColumnY);
            this.setPositionBottomY(this.getStaticBands().getReservedPositionBottomY());
        }
    }

    public final void SetNewPageParameters() {
        if (this.getIsCrossBandsMode()) {
            this.setCrossFreeSpace(this.getTemplateContainer().getWidth());
            this.setPositionX(0.0);
            this.setPositionY(0.0);
        } else {
            this.setFreeSpace(this.getTemplateContainer().getHeight());
            if (this.getColumnsOnPanel().getRightToLeft()) {
                this.setPositionX(this.getTemplateContainer().getWidth() - this.getColumnsOnPanel().GetColumnWidth());
            } else {
                this.setPositionX(0.0);
            }
            this.setPositionY(0.0);
            this.setPositionBottomY(this.getTemplateContainer().getHeight());
        }
        this.getColumnsOnPanel().setCurrentColumn(1);
    }

    private void ProcessNewContainerBefore(StiBand band) {
        if (this.generateNewPageBeforeBand) {
            this.generateNewPageBeforeBand = false;
            boolean canGenerateNewContainer = this.CanGenerateNewContainer((IStiPageBreak)((Object)(band instanceof IStiPageBreak ? band : null)));
            if (this.ignoreSkipFirst) {
                this.ignoreSkipFirst = false;
                this.NewPage();
            } else if (canGenerateNewContainer) {
                this.NewPage();
            }
        } else if (this.generateNewColumnBeforeBand) {
            this.generateNewColumnBeforeBand = false;
            boolean canGenerateNewContainer = this.CanGenerateNewContainer((IStiPageBreak)((Object)(band instanceof IStiPageBreak ? band : null)));
            if (this.ignoreSkipFirst) {
                this.ignoreSkipFirst = false;
                this.NewColumn();
            } else if (canGenerateNewContainer) {
                this.NewColumn();
            }
        } else {
            IStiPageBreak pageBreak = (IStiPageBreak)((Object)(band instanceof IStiPageBreak ? band : null));
            if (pageBreak == null) {
                return;
            }
            if (pageBreak.getNewPageBefore() || pageBreak.getNewColumnBefore()) {
                double factor = 100.0 * this.getFreeSpace() / this.getContainerForRender().getHeight();
                if ((double)pageBreak.getBreakIfLessThan() > factor || pageBreak.getBreakIfLessThan() == 100.0f) {
                    if (pageBreak.getNewPageBefore() && this.CanGenerateNewContainer((IStiPageBreak)((Object)(band instanceof IStiPageBreak ? band : null)))) {
                        this.NewPage();
                        this.ProcessNewContainerInDetailBands(band, true, false);
                    } else if (pageBreak.getNewColumnBefore() && this.CanGenerateNewContainer((IStiPageBreak)((Object)(band instanceof IStiPageBreak ? band : null)))) {
                        this.NewColumn();
                        this.ProcessNewContainerInDetailBands(band, false, true);
                    }
                }
            }
        }
    }

    private void ProcessNewContainerAfter(StiBand band) {
        IStiPageBreak pageBreak = (IStiPageBreak)((Object)(band instanceof IStiPageBreak ? band : null));
        if (pageBreak == null) {
            return;
        }
        if (pageBreak.getNewPageAfter() || pageBreak.getNewColumnAfter()) {
            double factor = 100.0 * this.getFreeSpace() / this.getContainerForRender().getHeight();
            if ((double)pageBreak.getBreakIfLessThan() > factor || pageBreak.getBreakIfLessThan() == 100.0f) {
                if (pageBreak.getNewPageAfter()) {
                    this.generateNewPageBeforeBand = true;
                    this.ignoreSkipFirst = true;
                } else if (pageBreak.getNewColumnAfter()) {
                    this.generateNewColumnBeforeBand = true;
                    this.ignoreSkipFirst = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ProcessNewContainerInDetailBands(StiBand band, boolean newPage, boolean newColumn) {
        StiDataBand dataBand = (StiDataBand)(band instanceof StiDataBand ? band : null);
        if (dataBand != null) {
            ArrayList<StiDataBand> arrayList = dataBand.getDataBandInfoV2().DetailDataBands;
            synchronized (arrayList) {
                for (StiComponent stiComponent : dataBand.getDataBandInfoV2().DetailDataBands) {
                    StiEngine masterEngine;
                    StiEngine slaveEngine;
                    StiBand detailBand = (StiBand)stiComponent;
                    if (detailBand.getParent() == dataBand.getParent() || (slaveEngine = (masterEngine = this.getMasterEngine() != null ? this.getMasterEngine() : this).getSlaveEngines().get(detailBand.getParent().getName())) == null) continue;
                    if (newPage) {
                        slaveEngine.NewPage();
                        continue;
                    }
                    if (!newColumn) continue;
                    if (band.getPage() != null && band.getPage().getColumns() < 2) {
                        slaveEngine.NewPage();
                        continue;
                    }
                    slaveEngine.NewColumn();
                }
            }
        }
    }

    private StiContainer SearchStartOfKeepContainer(StiContainer cont, int oldIndexOfStartList) {
        if (cont == null) {
            return null;
        }
        int index = oldIndexOfStartList;
        int level = -1;
        int selectedStartContIndex = -1;
        StiContainer selectedStartCont = null;
        while (index < cont.getComponents().size()) {
            StiLevelEndContainer idEndCont;
            StiComponent component = (StiComponent)cont.getComponents().get(index);
            StiLevelStartContainer idStartCont = (StiLevelStartContainer)(component instanceof StiLevelStartContainer ? component : null);
            if (idStartCont != null) {
                if (level == -1) {
                    selectedStartCont = idStartCont;
                    selectedStartContIndex = index;
                }
                ++level;
            }
            if ((idEndCont = (StiLevelEndContainer)(component instanceof StiLevelEndContainer ? component : null)) != null && --level < 0) {
                level = -1;
                selectedStartCont = null;
                selectedStartContIndex = -1;
            }
            if (idStartCont != null || idEndCont != null) {
                cont.getComponents().remove(index);
                continue;
            }
            ++index;
        }
        if (selectedStartCont != null) {
            selectedStartCont = selectedStartContIndex >= cont.getComponents().size() ? null : (StiContainer)(cont.getComponents().get(selectedStartContIndex) instanceof StiContainer ? (StiComponent)cont.getComponents().get(selectedStartContIndex) : null);
        }
        return selectedStartCont;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void MoveKeepComponentsOnNextContainer(StiContainer cont, StiContainer selectedStartCont) {
        if (cont == null) {
            return;
        }
        if (selectedStartCont != null) {
            StiContainer latestContainer;
            int countOfComponents;
            int selectedStartIndex = cont.getComponents().indexOf(selectedStartCont);
            ArrayList<Object> newList = new ArrayList<Object>();
            block3: for (int indexCont = selectedStartIndex; indexCont < cont.getComponents().size(); ++indexCont) {
                StiContainer container = (StiContainer)(cont.getComponents().get(indexCont) instanceof StiContainer ? (StiComponent)cont.getComponents().get(indexCont) : null);
                if (container == null || container instanceof StiFooterMarkerContainer || container.getContainerInfoV2().IsAutoRendered) continue;
                newList.add(container);
                for (int i = indexCont + 1; i < cont.getComponents().size(); ++i) {
                    boolean flag2;
                    StiContainer contt = (StiContainer)(cont.getComponents().get(i) instanceof StiContainer ? (StiComponent)cont.getComponents().get(i) : null);
                    boolean flagColumnHeader = false;
                    if (contt != null) {
                        IStiPrintAtBottom printAtBottom;
                        if (contt.getContainerInfoV2().getParentBand() instanceof StiColumnHeaderBand) {
                            flagColumnHeader = true;
                        }
                        if ((printAtBottom = (IStiPrintAtBottom)((Object)(contt.getContainerInfoV2().getParentBand() instanceof IStiPrintAtBottom ? contt.getContainerInfoV2().getParentBand() : null))) != null && printAtBottom.getPrintAtBottom()) continue block3;
                    }
                    boolean bl = flag2 = ((StiComponent)cont.getComponents().get(i)).getTop() > container.getTop();
                    if (flagColumnHeader || !flag2) continue;
                    ((StiComponent)cont.getComponents().get(i)).decrementTop(container.getHeight());
                }
            }
            ArrayList<Object> indexCont = newList;
            synchronized (indexCont) {
                for (StiContainer stiContainer : newList) {
                    this.getBreakable().SetCanBreak(stiContainer);
                    cont.getComponents().remove(stiContainer);
                    stiContainer.setParent(null);
                    if (this.IsNeedToSkip(stiContainer.getContainerInfoV2().getParentBand())) continue;
                    this.RenderContainer(stiContainer, this.getPrintAtBottom().CanProcess(stiContainer.getContainerInfoV2().getParentBand()), this.getFootersOnAllPages().CanProcess(stiContainer.getContainerInfoV2().getParentBand()));
                }
            }
            if (this.getContainerForRender() != null && (countOfComponents = this.getContainerForRender().getComponents().size()) > 0 && (latestContainer = (StiContainer)(this.getContainerForRender().getComponents().get(countOfComponents - 1) instanceof StiContainer ? (StiComponent)this.getContainerForRender().getComponents().get(countOfComponents - 1) : null)) != null && latestContainer.getContainerInfoV2().getParentBand() instanceof StiDataBand) {
                this.getPrintOnAllPagesIgnoreList().clear();
                this.atLeastOneDatabandRenderedOnPage = true;
            }
        }
    }

    private void CorrectPrintOnAllPagesIgnoreListBeforeNewList(StiContainer cont, StiContainer selectedStartCont, boolean clear) {
        if (!clear) {
            int selectedStartIndex;
            if (cont == null || selectedStartCont == null) {
                return;
            }
            this.printOnAllPagesIgnoreList2.clear();
            for (int indexCont = selectedStartIndex = cont.getComponents().indexOf(selectedStartCont); indexCont < cont.getComponents().size(); ++indexCont) {
                StiContainer container = (StiContainer)(cont.getComponents().get(indexCont) instanceof StiContainer ? (StiComponent)cont.getComponents().get(indexCont) : null);
                if (container == null || container.getContainerInfoV2().IsAutoRendered || !this.getBandsOnAllPages().IsBandInBandsList(container.getContainerInfoV2().getParentBand()) && (!(container.getContainerInfoV2().getParentBand() instanceof StiChildBand) || !this.getBandsOnAllPages().IsBandInBandsList(((StiChildBand)container.getContainerInfoV2().getParentBand()).GetMaster()))) continue;
                if (!this.getPrintOnAllPagesIgnoreList().containsKey(container.getContainerInfoV2().getParentBand())) {
                    this.printOnAllPagesIgnoreList2.put(container.getContainerInfoV2().getParentBand(), container.getContainerInfoV2().getParentBand());
                }
                this.getPrintOnAllPagesIgnoreList().put(container.getContainerInfoV2().getParentBand(), container.getContainerInfoV2().getParentBand());
            }
        } else {
            for (Object key : this.printOnAllPagesIgnoreList2.keySet()) {
                this.getPrintOnAllPagesIgnoreList().remove(key);
            }
            this.printOnAllPagesIgnoreList2.clear();
        }
    }

    private boolean IsNeedToPrintOddEven(StiBand band) {
        IStiPrintOnEvenOddPages bandEvenOdd = (IStiPrintOnEvenOddPages)((Object)(band instanceof IStiPrintOnEvenOddPages ? band : null));
        if (bandEvenOdd == null) {
            return true;
        }
        int pageEvenOdd = this.getReport().getPageNumber() & 1;
        if (bandEvenOdd.getPrintOnEvenOddPages() == StiPrintOnEvenOddPagesType.Ignore) {
            return true;
        }
        if (bandEvenOdd.getPrintOnEvenOddPages() == StiPrintOnEvenOddPagesType.PrintOnEvenPages && pageEvenOdd == 0) {
            return true;
        }
        return bandEvenOdd.getPrintOnEvenOddPages() == StiPrintOnEvenOddPagesType.PrintOnOddPages && pageEvenOdd == 1;
    }

    private boolean IsNeedToSkip(StiBand band) {
        StiContainer cont;
        StiComponentsCollection comps;
        if (band == null) {
            return false;
        }
        if (this.getPrintOnAllPagesIgnoreList().get(band) != null) {
            return true;
        }
        return band instanceof StiDataBand && this.getContainerForRender() != null && (comps = this.getContainerForRender().getComponents()).size() > 0 && (cont = (StiContainer)(comps.get(comps.size() - 1) instanceof StiContainer ? (StiComponent)comps.get(comps.size() - 1) : null)) != null && cont.getContainerInfoV2().getParentBand() == band && cont.getContainerInfoV2().IsAutoRendered;
    }

    public final void RenderFootersOnAllPages(StiContainer outContainer, int startIndex, StiContainer markerContainer) {
        if (outContainer != null) {
            this.getFootersOnAllPages().Render(outContainer, startIndex, markerContainer);
        } else {
            this.getFootersOnAllPages().Render(this.getContainerForRender(), startIndex, markerContainer);
        }
    }

    private void RenderFootersOnAllPages() {
        StiContainer tempCont = null;
        this.RenderFootersOnAllPages(this.getContainerForRender(), this.IndexOfStartList, tempCont);
    }

    public final void RenderEmptyBands(StiContainer containerForRender, StiContainer selectedContainer) {
        if (containerForRender != null) {
            this.getEmptyBands().Render(containerForRender, selectedContainer);
        }
    }

    public final void RenderPrintAtBottom(StiContainer container, int startIndex, StiContainer markerContainer) {
        if (container != null) {
            this.getPrintAtBottom().Render(container, startIndex, markerContainer);
        } else {
            this.getPrintAtBottom().Render(this.getContainerForRender(), startIndex, markerContainer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void FinishContainer(StiContainer containerForRender) {
        if (containerForRender == null) {
            return;
        }
        StiComponentsCollection stiComponentsCollection = containerForRender.getComponents();
        synchronized (stiComponentsCollection) {
            for (StiComponent component : containerForRender.getComponents()) {
                StiContainer container = (StiContainer)(component instanceof StiContainer ? component : null);
                if (container == null) continue;
                container.getContainerInfoV2().setParentBand(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void FinishResetPageNumberContainer(StiContainer containerForRender, boolean isFinal) {
        if (containerForRender == null) {
            return;
        }
        StiComponentsCollection stiComponentsCollection = containerForRender.getComponents();
        synchronized (stiComponentsCollection) {
            for (StiComponent component : containerForRender.getComponents()) {
                StiContainer container = (StiContainer)(component instanceof StiContainer ? component : null);
                if (container == null || container.getContainerInfoV2().getParentBand() == null || !container.getContainerInfoV2().getParentBand().getResetPageNumber() || container.getContainerInfoV2().IgnoreResetPageNumber || container.getContainerInfoV2().IsAutoRendered) continue;
                int indexOfLastPage = this.getReport().getRenderedPages().size() - 2;
                if (isFinal) {
                    ++indexOfLastPage;
                }
                this.getPageNumbers().ResetPageNumber(indexOfLastPage);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void FinishColumns(StiContainer containerForRender) {
        if (containerForRender == null) {
            return;
        }
        int index = 0;
        while (index < containerForRender.getComponents().size()) {
            StiColumnsContainer columnsCont = (StiColumnsContainer)(containerForRender.getComponents().get(index) instanceof StiColumnsContainer ? (StiComponent)containerForRender.getComponents().get(index) : null);
            if (columnsCont != null) {
                columnsCont.FinishColumns();
                containerForRender.getComponents().remove(columnsCont);
                StiComponentsCollection stiComponentsCollection = columnsCont.getComponents();
                synchronized (stiComponentsCollection) {
                    for (StiComponent comp : columnsCont.getComponents()) {
                        comp.setLeft(comp.getLeft() + columnsCont.getLeft());
                        comp.top += columnsCont.top;
                        comp.setParent(containerForRender);
                        containerForRender.getComponents().add(index, comp);
                        ++index;
                    }
                    continue;
                }
            }
            ++index;
        }
    }

    public final void AddContainerToDestination(StiContainer container) {
        if (this.containerForRender == null) {
            return;
        }
        if (container.getContainerInfoV2().getSetSegmentPerWidth() != -1 && this.getPage() != null && container.getContainerInfoV2().getSetSegmentPerWidth() > this.getPage().segmentPerWidth) {
            this.getPage().segmentPerWidth = container.getContainerInfoV2().getSetSegmentPerWidth();
        }
        this.getContainerForRender().getComponents().add(container);
    }

    public final void InvokePageAfterPrint() {
        if (this.templatePage != null && this.templatePage.getReport() != null && this.templatePage.getReport().getRenderedPages().size() != 0) {
            StiPage prevPage = this.getReport().getRenderedPages().get(this.getReport().getRenderedPages().size() - 1);
            if (StiOptions.Engine.getUseTemplateForPagePrintEvents()) {
                prevPage.InvokeAfterPrint(this.templatePage, EventArgs.Empty);
            } else {
                prevPage.InvokeAfterPrint(prevPage, EventArgs.Empty);
            }
        }
    }

    public final void AddPageToRenderedPages(StiPage page) {
        this.InvokePageAfterPrint();
        if (this.getTemplatePage().getStopBeforePrint() != 0 && this.getTemplatePage().getPageInfoV2().RenderedCount - 1 == this.getTemplatePage().getStopBeforePrint()) {
            throw new StiStopBeforePrintException();
        }
        if (this.getReport().getStopBeforePage() != 0 && this.getReport().getStopBeforePage() <= this.getReport().getCurrentPrintPage()) {
            throw new StiStopBeforePageException();
        }
        this.getReport().getRenderedPages().add(page);
        this.getReport().setCurrentPrintPage(this.getReport().getCurrentPrintPage() + 1);
        if (this.getPage().getReport().getRenderedPages().size() != 0) {
            if (!this.skipFirstPageBeforePrintEvent) {
                if (StiOptions.Engine.getUseTemplateForPagePrintEvents()) {
                    this.getPage().InvokeBeforePrint(this.getTemplatePage(), EventArgs.Empty);
                } else {
                    this.getPage().InvokeBeforePrint(this.getPage(), EventArgs.Empty);
                }
            }
            this.skipFirstPageBeforePrintEvent = false;
            this.getPage().setPaperSize(this.getTemplatePage().getPaperSize());
            this.getPage().setOrientation(this.getTemplatePage().getOrientation());
            this.getPage().setPageWidth(this.getTemplatePage().getPageWidth());
            this.getPage().setPageHeight(this.getTemplatePage().getPageHeight());
            this.getPage().setMargins(new StiMargins(this.getTemplatePage().getMargins().getLeft(), this.getTemplatePage().getMargins().getRight(), this.getTemplatePage().getMargins().getTop(), this.getTemplatePage().getMargins().getBottom()));
        }
    }

    private boolean CheckFreeSpace(StiContainer container) {
        if (this.getIsCrossBandsMode()) {
            return this.CheckFreeSpace(container.getWidth());
        }
        boolean result = this.CheckFreeSpace(container.getHeight());
        if (result) {
            this.getBreakable().SetCanBreak(container);
            return false;
        }
        return result;
    }

    private boolean CheckFreeSpace(double value) {
        if (this.getIsCrossBandsMode()) {
            if (value > this.getCrossFreeSpace()) {
                this.NewDestination();
                return !(value > this.getCrossFreeSpace());
            }
        } else if (value > this.getFreeSpace()) {
            if (this.getTemplatePage().getUnlimitedHeight() && this.getTemplatePage().getColumns() < 2) {
                if (this.getPage() == null) {
                    this.setFreeSpace(this.getFreeSpace() + this.getTemplatePage().getPageHeight() - this.getTemplatePage().getMargins().getTop() - this.getTemplatePage().getMargins().getBottom());
                    return false;
                }
                while ((int)((this.getPositionY() + value) / this.getTemplatePage().getHeight() + 1.0) > this.getPage().segmentPerHeight) {
                    StiPage stiPage = this.getPage();
                    Integer n = stiPage.segmentPerHeight;
                    Integer n2 = stiPage.segmentPerHeight = Integer.valueOf(stiPage.segmentPerHeight + 1);
                    if (this.getTemplatePage().getUnlimitedBreakable()) continue;
                    this.setFreeSpace(this.getFreeSpace() + this.getTemplatePage().getHeight());
                }
                if (value > this.getFreeSpace() + (this.getTemplatePage().getHeight() - this.getPositionBottomY())) {
                    if (this.getTemplatePage().getUnlimitedBreakable()) {
                        if (this.getPositionY() > 0.0) {
                            this.setFreeSpace(this.getFreeSpace() + this.getTemplatePage().getHeight() - this.getPositionBottomY());
                            boolean storedValue = this.ignoreUnlimitedHeightForNewPage;
                            this.ignoreUnlimitedHeightForNewPage = false;
                            this.NewDestination();
                            this.ignoreUnlimitedHeightForNewPage = storedValue;
                        }
                        if (value > this.getTemplatePage().getHeight()) {
                            return true;
                        }
                    }
                    return false;
                }
            } else {
                this.NewDestination();
                return true;
            }
        }
        return false;
    }

    private void StoreLatestDataBand(StiBand band) {
        if (band instanceof StiDataBand) {
            if (this.getColumnsOnDataBand().getEnabled()) {
                StiColumnsContainer columns = this.getColumnsOnDataBand().GetColumns();
                if (columns == null) {
                    this.IndexOfLatestDataBand = new StiIndex(0, this.getContainerForRender().getComponents().size());
                } else {
                    int indexOfColumns = this.getContainerForRender().getComponents().indexOf(columns);
                    this.IndexOfLatestDataBand = new StiIndex(columns.getComponents().size(), indexOfColumns);
                }
            } else {
                this.IndexOfLatestDataBand = new StiIndex(this.getContainerForRender().getComponents().size());
            }
        }
    }

    private void SetReportVariables(StiBand band) {
        band.SetReportVariables();
        if (this.getColumnsOnDataBand().getEnabled() && band instanceof StiDataBand) {
            StiColumnsContainer columns = this.getColumnsOnDataBand().GetColumns();
            if (columns != null) {
                this.getReport().setColumn(columns.GetCurrentColumn());
            }
        } else {
            this.getReport().setColumn(this.getColumnsOnPanel().getCurrentColumn());
        }
    }

    public boolean checkForDuplicate(String textName, String value, String tag) {
        if (this.duplicatesLastValues == null) {
            this.duplicatesLastValues = new Hashtable();
        }
        if (this.duplicatesLastValues.containsKey(textName) && this.duplicatesLastValues.get(textName).equals(value) && this.duplicatesLastValues.get(textName + "_tag").equals(tag)) {
            return true;
        }
        this.duplicatesLastValues.put(textName, value);
        this.duplicatesLastValues.put(textName + "_tag", tag);
        return false;
    }

    public final void ResetProcessingDuplicates(String componentName) {
        if (this.duplicatesLastValues != null && this.duplicatesLastValues.containsKey(componentName)) {
            this.duplicatesLastValues.put(componentName, null);
        }
    }

    public final StiComponentsCollection RenderBand(StiBand band) {
        return this.RenderBand(band, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final StiComponentsCollection RenderBand(StiBand band, boolean ignorePageBreaks, boolean allowRenderingEvents) {
        this.bandsInProgress.add(band);
        try {
            StiComponentsCollection stiComponentsCollection;
            StiRefObject isChildsEnabled;
            StiContainer container;
            StiComponentsCollection renderedContainers = new StiComponentsCollection();
            boolean allowChilds = true;
            if (band instanceof StiDataBand && ((StiDataBand)band).getColumns() > 1) {
                allowChilds = false;
            }
            StiComponentsCollection childs = null;
            if (allowChilds) {
                StiComponentsCollection stiComponentsCollection2 = childs = this.GetChildBands(band);
                synchronized (stiComponentsCollection2) {
                    for (StiComponent child : childs) {
                        StiChildBand childBand = (StiChildBand)child;
                        if (!childBand.getKeepChildTogether()) continue;
                        this.AddLevel();
                    }
                }
            }
            if ((container = this.InternalRenderBand(band, ignorePageBreaks, allowRenderingEvents, (StiRefObject<Boolean>)(isChildsEnabled = new StiRefObject((Object)true)))) != null) {
                renderedContainers.add(container);
            }
            if (allowChilds) {
                stiComponentsCollection = childs;
                synchronized (stiComponentsCollection) {
                    for (StiComponent child : childs) {
                        StiRefObject tempEnabled;
                        StiContainer childContainer;
                        boolean saveEnabled = child.getEnabled();
                        StiChildBand childBand = (StiChildBand)child;
                        if (!((Boolean)isChildsEnabled.argvalue).booleanValue() && !childBand.getPrintIfParentDisabled()) {
                            child.setEnabled(false);
                        }
                        if ((childContainer = this.InternalRenderBand(childBand, ignorePageBreaks, allowRenderingEvents, (StiRefObject<Boolean>)(tempEnabled = new StiRefObject((Object)((Boolean)isChildsEnabled.argvalue != false || childBand.getPrintIfParentDisabled() ? 1 : 0))))) != null) {
                            renderedContainers.add(childContainer);
                        }
                        if (childBand.getKeepChildTogether()) {
                            this.RemoveLevel();
                        }
                        child.setEnabled(saveEnabled);
                    }
                }
            }
            stiComponentsCollection = renderedContainers;
            return stiComponentsCollection;
        }
        finally {
            this.bandsInProgress.remove(this.bandsInProgress.size() - 1);
        }
    }

    private StiContainer InternalRenderBand(StiBand band) {
        StiRefObject isChildsEnabled = new StiRefObject((Object)true);
        StiContainer tempVar = this.InternalRenderBand(band, false, false, (StiRefObject<Boolean>)isChildsEnabled);
        return tempVar;
    }

    private StiContainer InternalRenderBand(StiBand band, boolean ignorePageBreaks, boolean allowRenderingEvents, StiRefObject<Boolean> isChildsEnabled) {
        StiBaseStyle tempStyle;
        StiContainer renderedContainer = null;
        this.StoreLatestDataBand(band);
        IStiTextBrush textBrush = (IStiTextBrush)((Object)(band instanceof IStiTextBrush ? band : null));
        StiBand brush = band instanceof IStiBrush ? band : null;
        IStiFont font = (IStiFont)((Object)(band instanceof IStiFont ? band : null));
        StiBand border = band instanceof IStiBorder ? band : null;
        StiBrush savedTextBrush = null;
        StiBrush savedBrush = null;
        StiFont savedFont = null;
        StiEnumSet savedBorderSides = StiEnumSet.of((Enum)StiBorderSides.None);
        if (textBrush != null) {
            savedTextBrush = textBrush.getTextBrush();
        }
        if (brush != null) {
            savedBrush = brush.getBrush();
        }
        if (font != null) {
            savedFont = font.getFont();
        }
        if (border != null && border.getBorder() != null) {
            savedBorderSides = border.getBorder().getSide();
        }
        boolean savedEnabled = band.getEnabled();
        StiReport report = band.getReport();
        StiBaseStyle parentStyle = null;
        boolean needHashParentStyles = false;
        if (band.getUseParentStyles() && band.getParent() != null) {
            if (report != null && report.getEngine() != null && report.getEngine().getHashParentStyles() != null && report.getEngine().getHashParentStyles().size() > 0) {
                parentStyle = report.getEngine().getHashParentStyles().get(band.getParent());
            }
            if (parentStyle == null) {
                parentStyle = StiBaseStyle.getStyle(band.getParent());
            }
            if (parentStyle != null) {
                parentStyle.SetStyleToComponent(band);
                needHashParentStyles = true;
                StiBaseStyle compStyle = band.GetComponentStyle();
                if (compStyle != null) {
                    compStyle.SetStyleToComponent(band);
                }
            }
        }
        if (!StiOptions.Engine.getUseParentStylesOldMode() && (tempStyle = StiOddEvenStylesHelper.applyOddEvenStyles(this.getReport(), band instanceof StiDataBand ? (StiDataBand)band : null, band)) != null) {
            parentStyle = tempStyle;
        }
        band.InvokeBeforePrint(band, EventArgs.Empty);
        if (report != null && report.getEngine() != null && report.getEngine().getHashUseParentStyles().containsKey(band)) {
            if (parentStyle == null && !StiValidationUtil.isNullOrWhiteSpace((String)band.getComponentStyle())) {
                parentStyle = report.getStyles().get(band.getComponentStyle());
            }
            if (report.getEngine().getHashParentStyles() != null && report.getEngine().getHashParentStyles().size() > 0 && (tempStyle = report.getEngine().getHashParentStyles().get(band)) != null) {
                parentStyle = tempStyle;
            }
            StiBaseStyle tempStyle2 = StiBaseStyle.getStyle((StiComponent)band, parentStyle);
            if (report.getEngine().getHashParentStyles() == null) {
                report.getEngine().setHashParentStyles(new Hashtable<StiComponent, StiBaseStyle>());
            }
            report.getEngine().getHashParentStyles().put(band, tempStyle2);
            needHashParentStyles = true;
        }
        StiDataBand dataBand = (StiDataBand)(band instanceof StiDataBand ? band : null);
        if (StiOptions.Engine.getOldModeOfRenderingEventInEngineV2() && dataBand != null && allowRenderingEvents) {
            if (band.getEnabled()) {
                dataBand.InvokeRendering();
                dataBand.InvokeGroupRendering();
            } else if (dataBand.getCalcInvisible()) {
                dataBand.InvokeRendering();
                dataBand.InvokeGroupRendering();
            }
        }
        if (band instanceof StiDataBand && !this.IsNeedToSkip(band) && !this.DenyClearPrintOnAllPagesIgnoreList) {
            this.getPrintOnAllPagesIgnoreList().clear();
            this.atLeastOneDatabandRenderedOnPage = true;
        }
        if (!((Boolean)isChildsEnabled.argvalue).booleanValue()) {
            band.setEnabled(false);
        }
        isChildsEnabled.argvalue = band.getEnabled();
        if (this.IsNeedToPrintOddEven(band) && !this.IsNeedToSkip(band) && band.getIsEnabled()) {
            StiComponent tempVar;
            this.SetReportVariables(band);
            if (!ignorePageBreaks) {
                this.ProcessNewContainerBefore(band);
            }
            renderedContainer = (StiContainer)((tempVar = band.InternalRender()) instanceof StiContainer ? tempVar : null);
            if (band instanceof StiDataBand) {
                boolean needStore;
                StiDataBand tempBand = (StiDataBand)(band instanceof StiDataBand ? band : null);
                renderedContainer.getContainerInfoV2().DataBandPosition = tempBand.getPosition();
                boolean bl = needStore = tempBand.getFilterMethodHandler() != null || tempBand.getSort() != null && tempBand.getSort().size() > 0 || report.DataBandsUsedInPageTotals != null && Arrays.asList(report.DataBandsUsedInPageTotals).indexOf(band.getName()) != -1;
                if (needStore && tempBand.getDataSource() != null) {
                    renderedContainer.getContainerInfoV2().DataSourceRow = tempBand.getDataSource().GetDataRow(tempBand.getDataSource().getPosition());
                }
            }
            if (band.getParent() != null) {
                if (band.getParent() instanceof StiPage) {
                    renderedContainer.setWidth(((StiPage)band.getParent()).getColumnWidthM());
                } else if (!band.getIsCross()) {
                    renderedContainer.setWidth(band.getParent().getWidth());
                }
            }
            StiPage storedPage = renderedContainer.getPage();
            renderedContainer.setPage(band.getPage());
            renderedContainer.invokeEvents();
            renderedContainer.setPage(storedPage);
            renderedContainer.getContainerInfoV2().setParentBand(band);
            if (band.getComponentType() != StiComponentType.Static) {
                renderedContainer.setDockStyle(StiDockStyle.None);
            }
            if (StiOptions.Engine.getUseParentStylesOldMode()) {
                StiOddEvenStylesHelper.applyOddEvenStyles(this.getReport(), (StiDataBand)(band instanceof StiDataBand ? band : null), renderedContainer);
            }
            if (!this.SilentMode) {
                this.RenderContainer(renderedContainer, this.getPrintAtBottom().CanProcess(band), this.getFootersOnAllPages().CanProcess(band));
            }
            if (!ignorePageBreaks) {
                this.ProcessNewContainerAfter(band);
            }
        }
        if (!StiOptions.Engine.getOldModeOfRenderingEventInEngineV2() && dataBand != null && allowRenderingEvents) {
            if (band.getEnabled()) {
                dataBand.InvokeRendering();
                dataBand.InvokeGroupRendering();
            } else if (dataBand.getCalcInvisible()) {
                dataBand.InvokeRendering();
                dataBand.InvokeGroupRendering();
            }
        }
        band.InvokeAfterPrint(band, EventArgs.Empty);
        if (needHashParentStyles && report.getEngine().hashParentStyles != null) {
            report.getEngine().hashParentStyles.remove(band);
        }
        if (textBrush != null) {
            textBrush.setTextBrush(savedTextBrush);
        }
        if (brush != null) {
            brush.setBrush(savedBrush);
        }
        if (font != null) {
            font.setFont(savedFont);
        }
        if (border != null && border.getBorder() != null) {
            border.getBorder().setSide(savedBorderSides);
        }
        band.setEnabled(savedEnabled);
        this.CheckContainerOnTable(renderedContainer);
        return renderedContainer;
    }

    private void CheckContainerOnTable(StiContainer panel) {
        if (panel == null || panel.getContainerInfoV2().getParentBand() == null) {
            return;
        }
        if (panel.getContainerInfoV2().getParentBand() instanceof StiHeaderBand) {
            if (!((StiHeaderBand)panel.getContainerInfoV2().getParentBand()).getHeaderBandInfoV2().IsTableHeader) {
                return;
            }
            StiComponentsCollection coll = panel.GetComponents();
            this.setSizeInComponents(coll);
            return;
        }
        if (panel.getContainerInfoV2().getParentBand() instanceof StiGroupHeaderBand) {
            if (!((StiGroupHeaderBand)panel.getContainerInfoV2().getParentBand()).getGroupHeaderBandInfoV2().IsTableGroupHeader) {
                return;
            }
            StiComponentsCollection coll = panel.GetComponents();
            this.setSizeInComponents(coll);
            return;
        }
        if (panel.getContainerInfoV2().getParentBand() instanceof StiTable) {
            StiComponentsCollection coll = panel.GetComponents();
            this.setSizeInComponents(coll);
            return;
        }
        if (panel.getContainerInfoV2().getParentBand() instanceof StiFooterBand) {
            if (!((StiFooterBand)panel.getContainerInfoV2().getParentBand()).getFooterBandInfoV2().IsTableFooter) {
                return;
            }
            StiComponentsCollection coll = panel.GetComponents();
            this.setSizeInComponents(coll);
            return;
        }
        if (panel.getContainerInfoV2().getParentBand() instanceof StiGroupFooterBand) {
            if (!((StiGroupFooterBand)panel.getContainerInfoV2().getParentBand()).getGroupFooterBandInfoV2().IsTableGroupFooter) {
                return;
            }
            StiComponentsCollection coll = panel.GetComponents();
            this.setSizeInComponents(coll);
            return;
        }
    }

    private void setSizeInComponents(StiComponentsCollection coll) {
        for (StiComponent comp : coll) {
            StiComponent parentJoinCell;
            IStiTableCell cell = (IStiTableCell)((Object)(comp instanceof IStiTableCell ? comp : null));
            if (cell == null || !cell.getJoin() || cell.getParentJoinCell() == null) continue;
            if (comp.getParent() != null) {
                StiSize size = new StiSize(comp.getParent().getWidth(), comp.getParent().getHeight());
                comp.getParent().setMaxSize(size);
                comp.getParent().setMinSize(size);
            }
            if ((parentJoinCell = coll.get(cell.getParentJoinCell().getName())) == null) continue;
            comp.setHeight(parentJoinCell.getParent().getBottom() - comp.getParent().getTop());
            if (cell.getCellDockStyle() == StiDockStyle.None) continue;
            StiSize size = new StiSize(comp.getWidth(), comp.getHeight());
            comp.setMaxSize(size);
            comp.setMinSize(size);
        }
    }

    public final StiContainer RenderContainer(StiContainer container) {
        return this.RenderContainer(container, false, false);
    }

    private StiContainer RenderContainer(StiContainer container, boolean isPrintAtBottom, boolean isFooterOnAllPages) {
        StiDataBand dataBand;
        if (container instanceof StiColumnsContainer) {
            return this.InternalRenderColumnsContainer(container);
        }
        if (container.getContainerInfoV2().IsColumns && this.getColumnsOnDataBand().GetColumns() == null) {
            this.getColumnsOnDataBand().RenderColumns((StiDataBand)(container.getContainerInfoV2().getParentBand() instanceof StiDataBand ? container.getContainerInfoV2().getParentBand() : null));
        }
        if ((dataBand = (StiDataBand)(container.getContainerInfoV2().getParentBand() instanceof StiDataBand ? container.getContainerInfoV2().getParentBand() : null)) != null && dataBand.getColumns() > 1 && this.getColumnsOnDataBand().getEnabled()) {
            return this.InternalRenderContainerToColumns(container, isPrintAtBottom, isFooterOnAllPages);
        }
        return this.InternalRenderContainer(container, isPrintAtBottom, isFooterOnAllPages);
    }

    private StiContainer InternalRenderColumnsContainer(StiContainer container) {
        if (this.getIsCrossBandsMode()) {
            container.setTop(this.getPositionY());
            container.setLeft(this.getPositionX());
            this.AddContainerToDestination(container);
            this.setCrossFreeSpace(this.getCrossFreeSpace() - container.getWidth());
            this.setPositionX(this.getPositionX() + container.getWidth());
        } else {
            container.setLeft(this.getPositionX());
            container.setTop(this.getPositionY());
            this.AddContainerToDestination(container);
            this.setFreeSpace(this.getFreeSpace() - container.getHeight());
            this.setPositionY(this.getPositionY() + container.getHeight());
        }
        return container;
    }

    private StiContainer InternalRenderContainerToColumns(StiContainer container, boolean isPrintAtBottom, boolean isFooterOnAllPages) {
        container.getContainerInfoV2().IsColumns = true;
        StiColumnsContainer columns = this.getColumnsOnDataBand().GetColumns();
        if (columns == null) {
            return null;
        }
        double additionalSpace = columns.HowMuchAdditionalSpaceNeeded(columns.getHeight(), container);
        if (additionalSpace > 0.0) {
            double correction = 0.0;
            if (columns.getPage() != null && columns.getPage().getUnlimitedHeight() && columns.getPage().getUnlimitedBreakable()) {
                double pageHeight = columns.getPage().getPageHeight() - columns.getPage().getMargins().getTop() - columns.getPage().getMargins().getBottom();
                if ((int)((columns.getTop() + columns.getHeight()) / pageHeight) != (int)((columns.getTop() + columns.getHeight() + additionalSpace) / pageHeight)) {
                    additionalSpace -= (correction += pageHeight - (columns.getTop() + columns.getHeight()) % pageHeight);
                }
            }
            if (this.getFreeSpace() < additionalSpace && !this.flagRenderColumnsOnDataBandOnNewPage && this.getPositionY() != 0.0) {
                StiDataBand parentBand = (StiDataBand)(columns.getContainerInfoV2().getParentBand() instanceof StiDataBand ? columns.getContainerInfoV2().getParentBand() : null);
                if (parentBand == null) {
                    parentBand = (StiDataBand)(container.getContainerInfoV2().getParentBand() instanceof StiDataBand ? container.getContainerInfoV2().getParentBand() : null);
                }
                this.NewDestination();
                StiColumnsContainer columns2 = this.getColumnsOnDataBand().GetColumns();
                if (columns2 == null) {
                    columns2 = this.getColumnsOnDataBand().RenderColumns(parentBand);
                } else {
                    this.getColumnsOnDataBand().setEnabled(true);
                }
                this.flagRenderColumnsOnDataBandOnNewPage = true;
                this.RenderContainer(container, isPrintAtBottom, isFooterOnAllPages);
                return container;
            }
            this.flagRenderColumnsOnDataBandOnNewPage = false;
            columns.setHeight(columns.getHeight() + additionalSpace + correction);
            this.setPositionY(this.getPositionY() + additionalSpace);
            this.setFreeSpace(this.getFreeSpace() - additionalSpace);
        }
        columns.AddContainer(container);
        return container;
    }

    private StiContainer InternalRenderContainer(StiContainer container, boolean isPrintAtBottom, boolean isFooterOnAllPages) {
        boolean isUnlimitedHeight;
        StiBand masterBand;
        this.getColumnsOnDataBand().setEnabled(false);
        if (this.getColumnsOnPanel().getCount() > 0) {
            container.setWidth(this.getColumnsOnPanel().GetColumnWidth());
        }
        if (this.IsNeedToSkip(container.getContainerInfoV2().getParentBand())) {
            return null;
        }
        if (container.getContainerInfoV2().getParentBand() instanceof StiChildBand && (masterBand = ((StiChildBand)container.getContainerInfoV2().getParentBand()).GetMaster()).getComponentType() == StiComponentType.Static) {
            this.getBreakable().SetCanBreak(container);
        }
        boolean bl = isUnlimitedHeight = container.getContainerInfoV2().getParentBand() != null && container.getContainerInfoV2().getParentBand().getPage() != null && container.getContainerInfoV2().getParentBand().getPage().getUnlimitedHeight();
        if (this.lastFreeSpaceOnPageAfterNewList > 0.0 && container.getHeight() > this.lastFreeSpaceOnPageAfterNewList && !container.getCanBreak() && !isUnlimitedHeight) {
            this.breakable.SetCanBreak(container);
            int position = -1;
            if (container.getContainerInfoV2().getParentBand() instanceof StiDataBand) {
                position = ((StiDataBand)container.getContainerInfoV2().getParentBand()).getPosition();
            }
            String str = String.format("Whilst the Can Break property was set to False the component %s%s was split because it couldn't be placed on the page entirely.", container.getName(), position >= 0 ? " (position " + position + ")" : "");
            LOG.warning(str);
            this.report.WriteToReportRenderingMessages(str);
        }
        container = this.getBreakable().ProcessBreakable(container);
        boolean canBreakStored = container.getCanBreak();
        int prevPagesCount = this.report.getRenderedPages().size();
        while (this.CheckFreeSpace(container)) {
        }
        if (prevPagesCount != this.report.getRenderedPages().size()) {
            this.ReprocessRuntimeVariables(container);
        }
        if (canBreakStored != container.getCanBreak()) {
            container = this.getBreakable().ProcessBreakable(container);
        }
        if (this.getIsCrossBandsMode()) {
            container.setTop(this.getPositionY());
            this.setCrossFreeSpace(this.getCrossFreeSpace() - container.getWidth());
        } else {
            container.setLeft(this.getPositionX());
            this.setFreeSpace(this.getFreeSpace() - container.getHeight());
        }
        if (container.getContainerInfoV2().getParentBand() instanceof StiPageFooterBand) {
            container.setTop(this.getPositionBottomY() - container.getHeight());
            this.positionBottomY -= container.getHeight();
        } else {
            if (this.getIsCrossBandsMode()) {
                container.setLeft(this.getPositionX());
            } else {
                container.setTop(this.getPositionY());
            }
            if (isFooterOnAllPages || isPrintAtBottom) {
                if (isFooterOnAllPages) {
                    this.getFootersOnAllPages().Add(container);
                }
                if (isPrintAtBottom) {
                    this.getPrintAtBottom().Add(container);
                }
            } else if (this.getIsCrossBandsMode()) {
                this.setPositionX(this.getPositionX() + container.getWidth());
            } else {
                this.setPositionY(this.getPositionY() + container.getHeight());
            }
        }
        this.AddContainerToDestination(container);
        if (container.getContainerInfoV2().getParentBand() instanceof StiDataBand && !this.DenyClearPrintOnAllPagesIgnoreList) {
            this.getPrintOnAllPagesIgnoreList().clear();
            this.atLeastOneDatabandRenderedOnPage = true;
        }
        return container;
    }

    public String getUniqueShortName(String fullName) {
        if (StiValidationUtil.isNullOrEmpty((String)fullName)) {
            return "";
        }
        if (this.shortNameMap == null) {
            this.shortNameMap = new HashMap();
        }
        if (this.shortNameMap.containsKey(fullName)) {
            return this.shortNameMap.get(fullName);
        }
        String nextShortName = StiEngine.toShortName(this.shortNameMap.size());
        this.shortNameMap.put(fullName, nextShortName);
        return nextShortName;
    }

    private static String toShortName(int index) {
        int alphabetLength = 26;
        int firstChar = 65;
        String result = "";
        do {
            result = (char)(firstChar + index % alphabetLength) + result;
        } while ((index = index / alphabetLength - 1) >= 0);
        return result;
    }

    public void setParserConversionStore(Hashtable value) {
        this.setparserConversionStore(value);
    }

    public Hashtable getParserConversionStore() {
        return this.getparserConversionStore();
    }

    public HashMap<StiDataBand, StiDataBand> getKeepFirstDetailTogetherList() {
        return this.keepFirstDetailTogetherList;
    }

    public Hashtable<StiComponent, StiBaseStyle> getHashParentStyles() {
        return this.hashParentStyles;
    }

    public Hashtable<StiComponent, Boolean> getHashUseParentStyles() {
        block0: for (StiComponent comp : this.report.GetComponents()) {
            StiContainer tempCont = comp instanceof StiContainer ? (StiContainer)comp : null;
            if (tempCont == null) continue;
            for (StiComponent comp2 : tempCont.getComponents()) {
                if (!comp2.getUseParentStyles()) continue;
                this.hashUseParentStyles.put(comp, true);
                continue block0;
            }
        }
        return this.hashUseParentStyles;
    }

    public void setHashUseParentStyles(Hashtable<StiComponent, Boolean> hashUseParentStyles) {
        this.hashUseParentStyles = hashUseParentStyles;
    }

    public void setHashParentStyles(Hashtable<StiComponent, StiBaseStyle> hashParentStyles) {
        this.hashParentStyles = hashParentStyles;
    }
}

