/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.engine.engineV2;

import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.bands.StiDataBand;
import com.stimulsoft.report.engine.engineV2.StiColumnsContainer;
import com.stimulsoft.report.engine.engineV2.StiEngine;
import com.stimulsoft.report.engine.engineV2.StiLevelContainer;

public class StiColumnsOnDataBand {
    public StiEngine engine = null;
    private boolean enabled = false;

    public final boolean getEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean value) {
        this.enabled = value;
    }

    public final StiColumnsContainer RenderColumns(StiDataBand dataBand) {
        if (dataBand.getColumns() > 1) {
            StiColumnsContainer columnsContainer = this.CreateColumns(dataBand);
            this.engine.RenderContainer(columnsContainer);
            this.setEnabled(true);
            return columnsContainer;
        }
        return null;
    }

    public final StiColumnsContainer GetColumns() {
        int countOfComponents = this.engine.getContainerForRender().components.size();
        if (countOfComponents > 0) {
            for (int index = countOfComponents - 1; index >= 0; --index) {
                StiComponent comp = (StiComponent)this.engine.getContainerForRender().components.get(index);
                if (comp instanceof StiColumnsContainer) {
                    return (StiColumnsContainer)(comp instanceof StiColumnsContainer ? comp : null);
                }
                if (!(comp instanceof StiLevelContainer)) continue;
            }
        }
        return null;
    }

    public final StiColumnsContainer CreateColumns(StiDataBand dataBand) {
        StiColumnsContainer columns = new StiColumnsContainer(this.engine);
        columns.setName("Columns" + dataBand.getName());
        columns.setWidth(dataBand.parent.getWidth());
        columns.setHeight(0.0);
        columns.Columns = dataBand.getColumns();
        columns.ColumnDirection = dataBand.getColumnDirection();
        columns.ColumnGaps = dataBand.getColumnGaps();
        columns.ColumnWidth = dataBand.GetColumnWidth();
        columns.MinRowsInColumn = dataBand.getMinRowsInColumn();
        columns.RightToLeft = dataBand.getRightToLeft();
        return columns;
    }

    public StiColumnsOnDataBand(StiEngine engine) {
        this.engine = engine;
    }
}

