/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.engine.engineV2;

import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentsCollection;
import com.stimulsoft.report.components.complexcomponents.StiContainer;
import com.stimulsoft.report.components.enums.StiColumnDirection;
import com.stimulsoft.report.engine.engineV2.StiEngine;
import com.stimulsoft.report.engine.engineV2.StiLevelContainer;
import java.util.ArrayList;
import java.util.Hashtable;

public class StiColumnsContainer
extends StiContainer {
    private int countOfItems = 0;
    public int Columns = 0;
    public double ColumnWidth = 0.0;
    public double ColumnGaps = 0.0;
    public StiColumnDirection ColumnDirection = StiColumnDirection.AcrossThenDown;
    public boolean RightToLeft = false;
    public int MinRowsInColumn = 0;
    private StiEngine engine = null;

    public final void AddContainer(StiContainer container) {
        this.getComponents().add(container);
        if (container instanceof StiLevelContainer) {
            return;
        }
        ++this.countOfItems;
    }

    public final double HowMuchAdditionalSpaceNeeded(double currentHeight, StiContainer container) {
        ++this.countOfItems;
        this.getComponents().add(container);
        double requredSpace = this.FinishColumns(true);
        this.getComponents().remove(container);
        --this.countOfItems;
        return Math.max(requredSpace - currentHeight, 0.0);
    }

    public final double FinishColumns() {
        return this.FinishColumns(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double FinishColumns(boolean onlyCalc) {
        int index;
        double positionY = 0.0;
        int column = 1;
        int columns = this.Columns;
        double columnWidth = this.ColumnWidth;
        double columnGaps = this.ColumnGaps;
        double fullColumnWidth = columnWidth + columnGaps;
        if (this.ColumnDirection == StiColumnDirection.AcrossThenDown) {
            int componentIndex = 0;
            int startLine = 0;
            int endLine = 0;
            StiComponentsCollection stiComponentsCollection = this.components;
            synchronized (stiComponentsCollection) {
                for (StiComponent componentList : this.components) {
                    StiContainer cont;
                    int index2;
                    StiContainer component = (StiContainer)componentList;
                    if (component instanceof StiLevelContainer) {
                        ++componentIndex;
                        ++endLine;
                    } else {
                        if (this.getPage() != null && this.getPage().getUnlimitedHeight() && this.getPage().getUnlimitedBreakable()) {
                            double pageHeight = this.getPage().getPageHeight() - this.getPage().getMargins().getTop() - this.getPage().getMargins().getBottom();
                            if ((int)((this.getTop() + positionY) / pageHeight) != (int)((this.getTop() + positionY + component.getHeight()) / pageHeight)) {
                                positionY += pageHeight - (this.getTop() + positionY) % pageHeight;
                            }
                        }
                        if (this.RightToLeft) {
                            component.setLeft(component.getParent().getWidth() - fullColumnWidth * (double)column + columnGaps);
                        } else {
                            component.setLeft(fullColumnWidth * (double)(column - 1));
                        }
                        component.setTop(positionY);
                        component.setWidth(columnWidth);
                        ++componentIndex;
                        ++endLine;
                        ++column;
                    }
                    if (column <= columns && componentIndex != this.components.size()) continue;
                    double maxHeight = 0.0;
                    for (index2 = startLine; index2 < endLine; ++index2) {
                        cont = (StiContainer)(this.components.get(index2) instanceof StiContainer ? (StiComponent)this.components.get(index2) : null);
                        if (cont instanceof StiLevelContainer) continue;
                        maxHeight = Math.max(cont.getHeight(), maxHeight);
                    }
                    if (!onlyCalc) {
                        for (index2 = startLine; index2 < endLine; ++index2) {
                            cont = (StiContainer)(this.components.get(index2) instanceof StiContainer ? (StiComponent)this.components.get(index2) : null);
                            if (cont instanceof StiLevelContainer) continue;
                            StiComponentsCollection stiComponentsCollection2 = cont.getComponents();
                            synchronized (stiComponentsCollection2) {
                                for (StiComponent comp : cont.getComponents()) {
                                    if (comp.getBottom() != cont.getHeight()) continue;
                                    comp.setHeight(maxHeight - comp.getTop());
                                }
                            }
                            cont.setHeight(maxHeight);
                        }
                    }
                    positionY += maxHeight;
                    column = 1;
                    startLine = componentIndex;
                    endLine = componentIndex;
                }
            }
        }
        onlyCalc = true;
        int[] itemsPerColumn = new int[columns];
        int tempItemsPerColumn = this.countOfItems / columns;
        int tempMinRowsInColumn = Math.min(this.MinRowsInColumn, this.countOfItems);
        if (tempMinRowsInColumn > 0) {
            tempItemsPerColumn = Math.max(tempMinRowsInColumn, tempItemsPerColumn);
        }
        for (index = 0; index < columns; ++index) {
            itemsPerColumn[index] = tempItemsPerColumn;
        }
        if (this.MinRowsInColumn > 0) {
            if (tempMinRowsInColumn <= tempItemsPerColumn) {
                tempItemsPerColumn = this.countOfItems - tempItemsPerColumn * columns;
                index = 0;
                while (index < tempItemsPerColumn) {
                    int n = index++;
                    itemsPerColumn[n] = itemsPerColumn[n] + 1;
                }
            }
        } else {
            int mod = this.countOfItems - tempItemsPerColumn * columns;
            if (mod > 0) {
                ++tempItemsPerColumn;
                for (int index3 = 0; index3 < columns; ++index3) {
                    itemsPerColumn[index3] = tempItemsPerColumn;
                }
            }
        }
        int currentItem = 0;
        double posY = 0.0;
        ArrayList[] listOfColumns = new ArrayList[columns];
        for (int index4 = 0; index4 < columns; ++index4) {
            listOfColumns[index4] = new ArrayList();
        }
        double storedHeight = -1.0;
        boolean usedCanGrow = false;
        StiComponentsCollection cont = this.components;
        synchronized (cont) {
            for (StiComponent componentList : this.components) {
                StiContainer component = (StiContainer)componentList;
                if (component instanceof StiLevelContainer) continue;
                if (!usedCanGrow) {
                    if (storedHeight == -1.0) {
                        storedHeight = component.getHeight();
                    } else if (storedHeight != component.getHeight()) {
                        usedCanGrow = true;
                    }
                }
                if (++currentItem > itemsPerColumn[column - 1]) {
                    currentItem = 1;
                    ++column;
                    posY = 0.0;
                }
                if (this.getPage() != null && this.getPage().getUnlimitedHeight() && this.getPage().getUnlimitedBreakable()) {
                    double pageHeight = this.getPage().getPageHeight() - this.getPage().getMargins().getTop() - this.getPage().getMargins().getBottom();
                    if ((int)((this.getTop() + posY) / pageHeight) != (int)((this.getTop() + posY + component.getHeight()) / pageHeight)) {
                        posY += pageHeight - (this.getTop() + posY) % pageHeight;
                    }
                }
                double dLeft = 0.0;
                dLeft = this.RightToLeft ? component.getParent().getWidth() - fullColumnWidth * (double)column + columnGaps : fullColumnWidth * (double)(column - 1);
                component.setLeft(dLeft);
                component.setWidth(dLeft - component.getLeft() + columnWidth);
                component.setTop(posY);
                positionY = Math.max(positionY, posY += component.getHeight());
                listOfColumns[column - 1].add(component);
            }
        }
        if (usedCanGrow) {
            int maxRows = 0;
            for (int columnIndex = 0; columnIndex < columns; ++columnIndex) {
                ArrayList list = listOfColumns[columnIndex] instanceof ArrayList ? listOfColumns[columnIndex] : null;
                maxRows = Math.max(list.size(), maxRows);
            }
            Hashtable<StiContainer, Double> containerHeights = new Hashtable<StiContainer, Double>();
            for (int rowIndex = 0; rowIndex < maxRows; ++rowIndex) {
                StiContainer container;
                int columnIndex;
                double maxHeight = 0.0;
                for (columnIndex = 0; columnIndex < columns; ++columnIndex) {
                    if (listOfColumns[columnIndex].size() <= rowIndex || (container = (StiContainer)(listOfColumns[columnIndex].get(rowIndex) instanceof StiContainer ? listOfColumns[columnIndex].get(rowIndex) : null)) instanceof StiLevelContainer) continue;
                    maxHeight = Math.max(maxHeight, container.getHeight());
                }
                for (columnIndex = 0; columnIndex < columns; ++columnIndex) {
                    if (listOfColumns[columnIndex].size() <= rowIndex || (container = (StiContainer)(listOfColumns[columnIndex].get(rowIndex) instanceof StiContainer ? listOfColumns[columnIndex].get(rowIndex) : null)) instanceof StiLevelContainer) continue;
                    if (container.getHeight() != maxHeight && !onlyCalc) {
                        StiComponentsCollection stiComponentsCollection = container.getComponents();
                        synchronized (stiComponentsCollection) {
                            for (StiComponent comp : container.getComponents()) {
                                if (comp.getBottom() != container.getHeight()) continue;
                                comp.setHeight(maxHeight - comp.getTop());
                            }
                        }
                    }
                    if (!onlyCalc) {
                        container.setHeight(maxHeight);
                        continue;
                    }
                    containerHeights.put(container, maxHeight);
                }
            }
            positionY = 0.0;
            for (int columnIndex = 0; columnIndex < columns; ++columnIndex) {
                posY = 0.0;
                ArrayList arrayList = listOfColumns[columnIndex];
                synchronized (arrayList) {
                    for (Object componentList : listOfColumns[columnIndex]) {
                        StiContainer cont2 = (StiContainer)componentList;
                        if (cont2 instanceof StiLevelContainer) continue;
                        cont2.setTop(posY);
                        double contHeight = onlyCalc ? ((Double)containerHeights.get(cont2)).doubleValue() : cont2.getHeight();
                        posY += contHeight;
                    }
                }
                positionY = Math.max(positionY, posY);
            }
        }
        return positionY;
    }

    public final int GetCurrentColumn() {
        if (this.ColumnDirection == StiColumnDirection.DownThenAcross) {
            return 1;
        }
        int lines = this.countOfItems / this.Columns;
        int column = this.countOfItems - lines * this.Columns + 1;
        return column;
    }

    public final int GetLengthOfLastRow() {
        int oldCount = this.countOfItems;
        int lines = oldCount / this.Columns;
        int newCount = lines * this.Columns;
        if (oldCount == newCount) {
            return this.Columns;
        }
        return oldCount - newCount;
    }

    public StiColumnsContainer(StiEngine engine) {
        this.engine = engine;
    }

    public StiColumnsContainer() {
    }
}

