/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.engine.engineV2;

import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentsCollection;
import com.stimulsoft.report.components.bands.StiBand;
import com.stimulsoft.report.components.bands.StiDataBand;
import com.stimulsoft.report.components.bands.StiGroupHeaderBand;
import com.stimulsoft.report.components.bands.StiHierarchicalBand;
import com.stimulsoft.report.components.complexcomponents.StiContainer;
import com.stimulsoft.report.engine.engineV2.StiEngine;
import java.util.ArrayList;

public class StiBandsOnAllPages {
    private final ArrayList<BandItem> bands = new ArrayList();
    public StiEngine engine = null;
    private boolean denyRendering = false;

    public final boolean getDenyRendering() {
        return this.denyRendering;
    }

    public final void setDenyRendering(boolean value) {
        this.denyRendering = value;
    }

    public final void Add(StiDataBand dataBand, StiBand band) {
        this.bands.add(new BandItem(dataBand, band));
    }

    public final void Remove(StiDataBand dataBand) {
        int index = 0;
        while (index < this.bands.size()) {
            BandItem item;
            BandItem bandItem = item = this.bands.get(index) instanceof BandItem ? this.bands.get(index) : null;
            if (item.DataBand == dataBand) {
                this.bands.remove(index);
                continue;
            }
            ++index;
        }
    }

    private boolean AllowRenderBand(StiBand band) {
        StiBand currentBand;
        if (this.engine.bandsInProgress.isEmpty()) {
            return true;
        }
        StiBand stiBand = currentBand = this.engine.bandsInProgress.get(this.engine.bandsInProgress.size() - 1) instanceof StiBand ? this.engine.bandsInProgress.get(this.engine.bandsInProgress.size() - 1) : null;
        if (band == currentBand && !(band instanceof StiHierarchicalBand)) {
            return false;
        }
        if (currentBand instanceof StiGroupHeaderBand && band instanceof StiGroupHeaderBand) {
            int currentBandIndex;
            if (((StiGroupHeaderBand)currentBand).GetDataBand() != ((StiGroupHeaderBand)band).GetDataBand()) {
                return true;
            }
            int bandIndex = band.getParent().components.indexOf(band);
            if (bandIndex > (currentBandIndex = band.getParent().components.indexOf(currentBand))) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void Render() {
        if (this.getDenyRendering()) {
            return;
        }
        boolean storedDenyRendering = this.getDenyRendering();
        try {
            this.setDenyRendering(true);
            this.engine.DenyClearPrintOnAllPagesIgnoreList = true;
            ArrayList<BandItem> arrayList = this.bands;
            synchronized (arrayList) {
                for (BandItem bandItem : this.bands) {
                    StiComponentsCollection conts;
                    StiBand band = bandItem.Band;
                    if (!this.AllowRenderBand(band) || (conts = this.RenderBand(band, true, false)) == null) continue;
                    StiComponentsCollection stiComponentsCollection = conts;
                    synchronized (stiComponentsCollection) {
                        for (StiComponent componemet : conts) {
                            StiContainer cont = (StiContainer)componemet;
                            if (cont.getContainerInfoV2().getParentBand() == null) continue;
                            cont.getContainerInfoV2().IsAutoRendered = true;
                            if (band instanceof StiHierarchicalBand && ((StiHierarchicalBand)band).getPrintOnAllPages()) continue;
                            this.engine.getPrintOnAllPagesIgnoreList().put(cont.getContainerInfoV2().getParentBand(), cont.getContainerInfoV2().getParentBand());
                        }
                    }
                }
            }
        }
        finally {
            this.engine.DenyClearPrintOnAllPagesIgnoreList = false;
            this.setDenyRendering(storedDenyRendering);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StiComponentsCollection RenderBand(StiBand band, boolean ignorePageBreaks, boolean ignoreRenderingEvents) {
        if (!(band instanceof StiHierarchicalBand)) {
            return this.engine.RenderBand(band, ignorePageBreaks, ignoreRenderingEvents);
        }
        StiComponentsCollection comps = new StiComponentsCollection();
        StiHierarchicalBand treeBand = (StiHierarchicalBand)(band instanceof StiHierarchicalBand ? band : null);
        treeBand.saveState("TreeBandPrintOnAllPages");
        boolean resPrintOnAllPages = treeBand.getPrintOnAllPages();
        treeBand.setPrintOnAllPages(false);
        try {
            ArrayList<Integer> positions = new ArrayList<Integer>();
            treeBand.setBrush((StiBrush)new StiSolidBrush(StiColorEnum.Green));
            int level = treeBand.getDataSource().GetLevel();
            treeBand.Prior();
            while (level >= 0 && !treeBand.getIsBof()) {
                int currentLevel = treeBand.getDataSource().GetLevel();
                if (level > currentLevel) {
                    positions.add(treeBand.getPosition());
                    level = currentLevel;
                }
                treeBand.Prior();
            }
            for (int index = positions.size() - 1; index >= 0; --index) {
                StiComponentsCollection comps2;
                treeBand.setPosition((Integer)positions.get(index));
                StiComponentsCollection stiComponentsCollection = comps2 = this.engine.RenderBand(treeBand, ignorePageBreaks, ignoreRenderingEvents);
                synchronized (stiComponentsCollection) {
                    for (StiComponent comp2 : comps2) {
                        comps.add(comp2);
                    }
                    continue;
                }
            }
            treeBand.setBrush((StiBrush)new StiSolidBrush(StiColorEnum.Transparent));
            treeBand.RestoreState("TreeBandPrintOnAllPages");
            StiComponentsCollection stiComponentsCollection = comps;
            return stiComponentsCollection;
        }
        finally {
            treeBand.setPrintOnAllPages(resPrintOnAllPages);
        }
    }

    public final boolean IsBandInBandsList(StiBand band) {
        if (band != null) {
            for (BandItem bandItem : this.bands) {
                if (bandItem.Band != band) continue;
                return true;
            }
        }
        return false;
    }

    public StiBandsOnAllPages(StiEngine engine) {
        this.engine = engine;
    }

    private static class BandItem {
        public StiDataBand DataBand;
        public StiBand Band;

        public BandItem(StiDataBand dataBand, StiBand band) {
            this.DataBand = dataBand;
            this.Band = band;
        }
    }
}

