/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary.userFunction.helpers;

import com.stimulsoft.base.system.StiDateOnly;
import com.stimulsoft.base.system.StiDateTime;
import com.stimulsoft.base.system.StiGuid;
import com.stimulsoft.base.system.StiTimeOnly;
import com.stimulsoft.base.system.StiTimeSpan;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.StiScriptHelper;
import com.stimulsoft.report.dictionary.StiUserFunction;
import com.stimulsoft.report.dictionary.StiUserFunctionArgument;
import com.stimulsoft.report.dictionary.StiUserFunctionArgumentType;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.stream.IntStream;

public class StiUserFunctionHelper {
    public static Object invokeFunction(StiUserFunction function, StiReport report, Object[] arguments) {
        int argumentCount;
        if (function == null || report == null) {
            return null;
        }
        int n = argumentCount = arguments == null ? 0 : arguments.length;
        if (argumentCount != function.getArguments().size()) {
            return null;
        }
        HashMap<String, Object> cacheArguments = new HashMap<String, Object>();
        IntStream.range(0, argumentCount).forEach(idx -> cacheArguments.put(((StiUserFunctionArgument)function.getArguments().get(idx)).getName(), arguments[idx]));
        if (StiScriptHelper.isAllowScriptsToRun(report) && !StiValidationUtil.isNullOrEmpty((String)function.getScriptCSharp())) {
            return StiScriptHelper.invokeScript(report, function.getScriptCSharp(), cacheArguments);
        }
        throw new RuntimeException(String.format("Function '%s' is not supported in the current report context.", function.getName()));
    }

    public static String getCategoryName(StiUserFunction function) {
        switch (function.getCategory()) {
            case Data: {
                return "Data";
            }
            case DateTime: {
                return "Date Time";
            }
            case Drawing: {
                return "Drawing";
            }
            case Math: {
                return "Math";
            }
            case Programming: {
                return "Programming";
            }
            case Strings: {
                return "Strings";
            }
            case Totals: {
                return "Totals";
            }
        }
        return function.getCustomCategory();
    }

    public static Class<?> getArgumentType(StiUserFunctionArgumentType argumentType) {
        switch (argumentType) {
            case String: {
                return String.class;
            }
            case Float: {
                return Double.class;
            }
            case Double: {
                return Double.class;
            }
            case Decimal: {
                return BigDecimal.class;
            }
            case DateTime: {
                return StiDateTime.class;
            }
            case DateTimeOffset: {
                return null;
            }
            case DateOnly: {
                return StiDateOnly.class;
            }
            case TimeSpan: {
                return StiTimeSpan.class;
            }
            case TimeOnly: {
                return StiTimeOnly.class;
            }
            case Sbyte: {
                return Integer.class;
            }
            case Byte: {
                return Integer.class;
            }
            case ByteArray: {
                return Integer[].class;
            }
            case Short: {
                return Integer.class;
            }
            case Ushort: {
                return Integer.class;
            }
            case Int: {
                return Long.class;
            }
            case Uint: {
                return Long.class;
            }
            case Long: {
                return Long.class;
            }
            case Ulong: {
                return Long.class;
            }
            case Bool: {
                return Boolean.class;
            }
            case Char: {
                return Character.TYPE;
            }
            case Guid: {
                return StiGuid.class;
            }
            case Object: {
                return Object.class;
            }
            case Text: {
                return null;
            }
        }
        return Object.class;
    }
}

