/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary.functions;

import com.stimulsoft.base.system.StiDateTime;
import com.stimulsoft.report.CalendarWeekRule;
import com.stimulsoft.report.DayOfWeek;
import java.time.LocalDate;
import java.time.temporal.WeekFields;
import java.util.Locale;

public class StiFunctionsDateTime {
    public static long weekOfYear(StiDateTime stiDate) {
        LocalDate date = stiDate.zonedDateTime().toLocalDate();
        return date.get(WeekFields.of(Locale.getDefault()).weekOfYear());
    }

    public static long weekOfYear(StiDateTime stiDate, DayOfWeek firstDayOfWeek) {
        LocalDate date = stiDate.zonedDateTime().toLocalDate();
        return date.get(WeekFields.of(firstDayOfWeek.getJavaDayOfWeek(), 1).weekOfYear());
    }

    public static long weekOfYear(StiDateTime stiDate, DayOfWeek firstDayOfWeek, CalendarWeekRule calendarWeekRule) {
        LocalDate date = stiDate.zonedDateTime().toLocalDate();
        int minimalDaysInWeek = calendarWeekRule == CalendarWeekRule.FirstDay ? 1 : (calendarWeekRule == CalendarWeekRule.FirstFourDayWeek ? 4 : 7);
        return date.get(WeekFields.of(firstDayOfWeek.getJavaDayOfWeek(), minimalDaysInWeek).weekOfYear());
    }

    public static long weekOfMonth(StiDateTime stiDate) {
        LocalDate date = stiDate.zonedDateTime().toLocalDate();
        return date.get(WeekFields.of(Locale.getDefault()).weekOfMonth());
    }

    public static long weekOfMonth(StiDateTime stiDate, DayOfWeek firstDayOfWeek) {
        LocalDate date = stiDate.zonedDateTime().toLocalDate();
        return date.get(WeekFields.of(firstDayOfWeek.getJavaDayOfWeek(), 1).weekOfMonth());
    }

    public static long weekOfMonth(StiDateTime stiDate, DayOfWeek firstDayOfWeek, CalendarWeekRule calendarWeekRule) {
        LocalDate date = stiDate.zonedDateTime().toLocalDate();
        int minimalDaysInWeek = calendarWeekRule == CalendarWeekRule.FirstDay ? 1 : (calendarWeekRule == CalendarWeekRule.FirstFourDayWeek ? 4 : 7);
        return date.get(WeekFields.of(firstDayOfWeek.getJavaDayOfWeek(), minimalDaysInWeek).weekOfMonth());
    }
}

