/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary.functions;

import com.stimulsoft.base.IStiAppFunction;
import com.stimulsoft.base.system.type.StiSystemType;
import com.stimulsoft.report.engine.parser.StiCallFunction;
import com.stimulsoft.report.engine.parser.enums.StiFunctionType;
import com.stimulsoft.report.enums.StiReportLanguageType;
import java.util.List;

public class StiFunction
implements Comparable<StiFunction>,
IStiAppFunction {
    private boolean useFullPath = true;
    private String category = "";
    private String groupFunctionName = "";
    private String functionName = "";
    private String description = "";
    private String typeOfFunction = null;
    private StiSystemType returnType = null;
    private String returnDescription = "";
    private StiSystemType[] argumentTypes = null;
    private String[] argumentNames = null;
    private String[] argumentDescriptions = null;

    public StiFunction(String category, String groupFunctionName, String functionName, String description, String typeOfFunction, StiSystemType returnType, String returnDescription, StiSystemType[] argumentTypes, String[] argumentNames, String[] argumentDescriptions) {
        this.category = category;
        this.description = description;
        this.returnDescription = returnDescription;
        this.groupFunctionName = groupFunctionName;
        this.functionName = functionName;
        this.typeOfFunction = typeOfFunction;
        this.returnType = returnType;
        this.argumentTypes = argumentTypes;
        this.argumentNames = argumentNames;
        this.argumentDescriptions = argumentDescriptions;
    }

    public String getFunctionString(StiReportLanguageType language) {
        return this.getFunctionString(language, true);
    }

    public String getFunctionString(StiReportLanguageType language, boolean addFunctionName) {
        StringBuilder sb = new StringBuilder();
        if (addFunctionName) {
            sb.append(this.getFunctionName());
        }
        sb.append(" (");
        int index = 0;
        if (this.getArgumentTypes() != null) {
            for (StiSystemType argumentType : this.getArgumentTypes()) {
                String argumentName = this.getArgumentNames()[index];
                if (argumentType.isList()) {
                    sb.append(argumentName);
                } else {
                    sb.append(this.convertTypeToString(argumentType, language));
                }
                if (++index == this.getArgumentTypes().length) continue;
                sb.append(", ");
            }
        }
        sb.append(")");
        sb.append(" : " + this.convertTypeToString(this.getReturnType(), language));
        return sb.toString();
    }

    public String GetLongFunctionString(StiReportLanguageType language) {
        if (language == StiReportLanguageType.CSharp) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.convertTypeToString(this.getReturnType(), language));
            sb.append("  ");
            sb.append(this.getFunctionName());
            sb.append(" (");
            int index = 0;
            if (this.argumentTypes != null) {
                for (StiSystemType argumentType : this.argumentTypes) {
                    String argumentName = this.getArgumentNames()[index];
                    sb.append(this.convertTypeToString(argumentType, language));
                    sb.append(" ");
                    sb.append(argumentName);
                    if (++index == this.argumentTypes.length) continue;
                    sb.append(", ");
                }
            }
            sb.append(")");
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.getFunctionName());
        sb.append("(");
        int index = 0;
        if (this.getArgumentTypes() != null) {
            for (StiSystemType argumentType : this.argumentTypes) {
                String argumentName = this.getArgumentNames()[index];
                sb.append(argumentName);
                sb.append(" As ");
                sb.append(this.convertTypeToString(argumentType, language));
                if (++index == this.getArgumentTypes().length) continue;
                sb.append(", ");
            }
        }
        sb.append(")");
        sb.append(" As " + this.convertTypeToString(this.getReturnType(), language));
        return sb.toString();
    }

    public String convertTypeToString(StiSystemType type, StiReportLanguageType language) {
        return type.getSerializeValue().replace("System.", "");
    }

    public boolean isUseFullPath() {
        return this.useFullPath;
    }

    public void setUseFullPath(boolean useFullPath) {
        this.useFullPath = useFullPath;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getGroupFunctionName() {
        return this.groupFunctionName;
    }

    public void setGroupFunctionName(String groupFunctionName) {
        this.groupFunctionName = groupFunctionName;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTypeOfFunction() {
        return this.typeOfFunction;
    }

    public void setTypeOfFunction(String typeOfFunction) {
        this.typeOfFunction = typeOfFunction;
    }

    public StiSystemType getReturnType() {
        return this.returnType;
    }

    public void setReturnType(StiSystemType returnType) {
        this.returnType = returnType;
    }

    public String getReturnDescription() {
        return this.returnDescription;
    }

    public void setReturnDescription(String returnDescription) {
        this.returnDescription = returnDescription;
    }

    public StiSystemType[] getArgumentTypes() {
        return this.argumentTypes;
    }

    public void setArgumentTypes(StiSystemType[] argumentTypes) {
        this.argumentTypes = argumentTypes;
    }

    public String[] getArgumentNames() {
        return this.argumentNames;
    }

    public void setArgumentNames(String[] argumentNames) {
        this.argumentNames = argumentNames;
    }

    public String[] getArgumentDescriptions() {
        return this.argumentDescriptions;
    }

    public void setArgumentDescriptions(String[] argumentDescriptions) {
        this.argumentDescriptions = argumentDescriptions;
    }

    @Override
    public int compareTo(StiFunction o) {
        return this.getFunctionName().compareTo(o.getFunctionName());
    }

    public String getName() {
        return this.functionName;
    }

    public Object invoke(List<Object> arguments) {
        return StiCallFunction.callFunc(StiFunctionType.valueOf(this.functionName), arguments, null, null, null);
    }
}

