/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary.dataSources;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.dictionary.data.DataTable;
import com.stimulsoft.report.dictionary.dataSources.StiDataSource;
import com.stimulsoft.report.dictionary.databases.StiDatabase;
import java.util.logging.Logger;

public abstract class StiDataStoreSource
extends StiDataSource {
    private static final Logger LOGGER = Logger.getLogger("com.stimulsoft.report.dictionary.dataSources.StiDataStoreSource");
    private String nameInSource;

    public StiDataStoreSource() {
        this("", "", "");
    }

    public StiDataStoreSource(String nameInSource, String name) {
        this(nameInSource, name, name);
    }

    public StiDataStoreSource(String nameInSource, String name, String alias) {
        super(name, alias);
        this.nameInSource = nameInSource;
    }

    @Override
    public String GetCategoryName() {
        int index = this.getNameInSource().lastIndexOf(".");
        if (index != -1) {
            return this.getNameInSource().substring(0, index).trim();
        }
        if (this.getNameInSource() != null && this.getNameInSource().length() > 0) {
            return this.getNameInSource().trim();
        }
        return super.GetCategoryName();
    }

    @StiSerializable
    public String getNameInSource() {
        return this.nameInSource;
    }

    public void setNameInSource(String value) {
        this.nameInSource = value;
    }

    @Override
    public void connect() throws StiException {
        StiDatabase database = this.getDatabase();
        if (StiOptions.Engine.logLevel >= 5) {
            LOGGER.info("Try to connect DB " + this.getName() + " category name: " + this.GetCategoryName() + " datebase: " + database);
        }
        if (database != null) {
            database.connect(this, this.getDictionary().getReport());
        }
    }

    @Override
    public void connect(Boolean fillTable) throws StiException {
        StiDatabase database = this.getDatabase();
        if (StiOptions.Engine.logLevel >= 5) {
            LOGGER.info("Try to connect DB " + this.getName() + " category name: " + this.GetCategoryName() + " datebase: " + database);
        }
        if (database != null) {
            database.InvokeConnecting();
            database.connect(this, fillTable, this.getDictionary().getReport());
            database.InvokeConnected();
        }
    }

    @Override
    public void disconnect() {
        super.disconnect();
        StiDatabase database = this.getDatabase();
        if (database != null) {
            database.InvokeDisconnecting();
            database.disconnect();
            database.InvokeDisconnected();
        }
    }

    private String getNameTableInSource() {
        if (StiValidationUtil.isNotEmpty((String)this.nameInSource)) {
            int index = this.nameInSource.lastIndexOf(".");
            if (index != -1) {
                return this.nameInSource.substring(index + 1, this.nameInSource.length());
            }
            return this.getNameInSource();
        }
        return super.getName();
    }

    @Deprecated
    public String getDataName() {
        return this.nameInSource;
    }

    @Deprecated
    public void setDataName(String value) {
        this.nameInSource = value;
    }

    public DataTable createNewTable() {
        return new DataTable(this.getNameTableInSource(), this.getColumns());
    }

    public String getQuery() {
        throw new RuntimeException("This type of  Source " + this.getClass().getSimpleName() + " not supported Query");
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyStringNullOfEmpty("NameInSource", this.getNameInSource());
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (!property.Name.equals("NameInSource")) continue;
            this.nameInSource = (String)property.Value;
        }
    }
}

