/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary.data;

import com.stimulsoft.base.DBNull;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.dictionary.StiDataColumn;
import com.stimulsoft.report.dictionary.data.DataCell;
import com.stimulsoft.report.dictionary.data.DataCellCollection;
import com.stimulsoft.report.dictionary.data.DataTable;
import com.stimulsoft.report.dictionary.data.StiBigDecimalDataCell;
import com.stimulsoft.report.dictionary.data.StiBooleanDataCell;
import com.stimulsoft.report.dictionary.data.StiBytesDataCell;
import com.stimulsoft.report.dictionary.data.StiClobDataCell;
import com.stimulsoft.report.dictionary.data.StiDBNullCell;
import com.stimulsoft.report.dictionary.data.StiDateDataCell;
import com.stimulsoft.report.dictionary.data.StiDoubleDataCell;
import com.stimulsoft.report.dictionary.data.StiIntegerDataCell;
import com.stimulsoft.report.dictionary.data.StiObjectDataCell;
import com.stimulsoft.report.dictionary.data.StiRefCursorDataCell;
import com.stimulsoft.report.dictionary.data.StiStringDataCell;
import com.stimulsoft.report.dictionary.dataSources.StiDataSource;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;

public class DataRow {
    private DataCellCollection cells;
    private DataTable table;
    private final HashMap<String, DataRow> parentRows = new HashMap();
    private final HashMap<String, ArrayList<DataRow>> childRows = new HashMap();

    public DataRow(DataCellCollection cells) {
        this.cells = cells;
    }

    public DataRow(DataTable table) {
        this.table = table;
        this.cells = new DataCellCollection(table.getColumns());
    }

    public DataCell getCell(String columnName) {
        int columnIndex = this.getColumnIndex(columnName);
        return this.cells.get(columnIndex);
    }

    public DataCellCollection getCells() {
        return this.cells;
    }

    public void setColumns(DataCellCollection cells) {
        this.cells = cells;
    }

    public DataCellCollection getColumns() {
        return this.cells;
    }

    public HashMap<String, DataRow> getParentRows() {
        return this.parentRows;
    }

    public void setValue(String column, Object value) {
        int columnIndex = this.getColumnIndex(column);
        StiDataColumn col = (StiDataColumn)this.table.getColumns().get(columnIndex);
        DataCell cell = DataRow.create(col, value);
        if (this.cells.size() - 1 < columnIndex) {
            for (int i = this.cells.size(); i < this.table.getColumns().size(); ++i) {
                this.cells.add2(DataCell.createEmpty((StiDataColumn)this.table.getColumns().get(i)));
            }
        }
        this.cells.add(columnIndex, cell);
    }

    public void setValue(int columnIndex, Object value) {
        StiDataColumn col = (StiDataColumn)this.table.getColumns().get(columnIndex);
        DataCell cell = DataRow.create(col, value);
        this.cells.add(columnIndex, cell);
    }

    public void addValue(String columnName, Object value) {
        this.addCell(columnName, value);
    }

    public Object getValue(int columnIndex) {
        return this.cells.size() > columnIndex ? this.cells.get(columnIndex).getValue() : null;
    }

    public Object getValueAsObject(String columnName) {
        int columnIndex = this.getColumnIndex(columnName);
        return this.cells.get(columnIndex).getValue();
    }

    public Object getValue(String columnName) {
        int columnIndex = this.getColumnIndex(columnName);
        return this.cells.get(columnIndex).getValue();
    }

    public int getColumnIndex(String columnName) {
        return this.table.getColumnIndex(columnName);
    }

    public static DataRow create(DataTable table) {
        DataRow newRow = new DataRow(table);
        return newRow;
    }

    public void addCell(String columnName, Object value) {
        StiDataColumn column = this.table.getColumn(columnName);
        DataCell dataCell = DataRow.create(column, value);
        int columnIndex = this.getColumnIndex(columnName);
        this.cells.set(columnIndex, dataCell);
    }

    public void addSqlCell(String columnName, int columnSqlIndex, int columnType, ResultSet rs) throws SQLException {
        this.addSqlCell(columnName, columnSqlIndex, columnType, rs, true);
    }

    public void addSqlCell(String columnName, int columnSqlIndex, int columnType, String columnTypeName, ResultSet rs, Boolean convertNull) throws SQLException {
        StiDataColumn column = this.table.getColumn(columnName);
        DataCell dataCell = DataRow.create(column, columnSqlIndex, columnType, columnTypeName, rs, convertNull);
        int columnIndex = this.getColumnIndex(columnName);
        if (columnIndex >= 0) {
            this.cells.set(columnIndex, dataCell);
        }
    }

    public void addSqlCell(String columnName, int columnSqlIndex, int columnType, Object rs, Boolean convertNull) throws SQLException {
        StiDataColumn column = this.table.getColumn(columnName);
        DataCell dataCell = DataRow.create(column, columnSqlIndex, columnType, rs, convertNull);
        int columnIndex = this.getColumnIndex(columnName);
        if (columnIndex >= 0) {
            this.cells.set(columnIndex, dataCell);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.cells.size()).append("| ");
        for (DataCell column : this.cells) {
            builder.append(column + " | ");
        }
        return builder.toString();
    }

    public void setParentRow(StiDataSource parentSource, String relationName, DataRow parentRow) {
        this.parentRows.put(relationName + "." + this.sourceKey(parentSource, ""), parentRow);
    }

    private String sourceKey(StiDataSource source, String relationName) {
        return source.getName() + relationName;
    }

    public DataRow getParentRow(StiDataSource parentSource, String relationName) {
        return this.parentRows.get(relationName + "." + this.sourceKey(parentSource, ""));
    }

    public boolean existParent(StiDataSource parentSource, String relationName) {
        return this.getParentRow(parentSource, relationName) != null;
    }

    public boolean existChildRows(StiDataSource childSource, String relationName) {
        return this.getChildRows(childSource, relationName) != null;
    }

    public void setChildRows(StiDataSource childSource, ArrayList<DataRow> cRows, String relationName) {
        this.childRows.put(this.sourceKey(childSource, relationName), cRows);
    }

    public ArrayList<DataRow> getChildRows(StiDataSource childSource, String relationName) {
        return this.childRows.get(this.sourceKey(childSource, relationName));
    }

    public ArrayList<DataRow> getChildRows(String childSourceName) {
        return this.childRows.get(childSourceName);
    }

    public static DataCell create(StiDataColumn column, int columnIndex, int columnType, String columnTypeName, ResultSet rs, Boolean convertNull) throws SQLException {
        switch (columnType) {
            case -4: 
            case -3: 
            case -2: 
            case 70: 
            case 2000: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2006: {
                return new StiBytesDataCell(column, rs.getBytes(columnIndex));
            }
            case 1111: {
                if ("uuid".equalsIgnoreCase(columnTypeName)) {
                    return new StiStringDataCell(column, rs.getString(columnIndex));
                }
                return new StiBytesDataCell(column, rs.getBytes(columnIndex));
            }
            case 121: {
                return new StiRefCursorDataCell(column, rs.getBytes(columnIndex));
            }
            case 0: {
                return new StiDBNullCell(column);
            }
            case 2005: {
                return new StiClobDataCell(column, rs.getClob(columnIndex));
            }
            case -101: 
            case 91: 
            case 93: {
                try {
                    return new StiDateDataCell(column, new java.util.Date(rs.getTimestamp(columnIndex).getTime()));
                }
                catch (Exception e) {
                    if (StiOptions.Engine.logLevel >= 10) {
                        e.printStackTrace();
                    }
                    try {
                        return new StiDateDataCell(column, rs.getDate(columnIndex));
                    }
                    catch (Exception e2) {
                        if (StiOptions.Engine.logLevel >= 10) {
                            e2.printStackTrace();
                        }
                        return DataRow.getDefaultDataCell(column, columnIndex, columnType, rs, convertNull);
                    }
                }
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return convertNull != false ? new StiIntegerDataCell(column, rs.getLong(columnIndex)) : new StiIntegerDataCell(column, rs.getObject(columnIndex));
            }
            case 6: 
            case 7: 
            case 8: {
                return convertNull != false ? new StiDoubleDataCell(column, rs.getDouble(columnIndex)) : new StiDoubleDataCell(column, rs.getObject(columnIndex));
            }
            case 2: 
            case 3: {
                return convertNull != false ? new StiBigDecimalDataCell(column, rs.getBigDecimal(columnIndex)) : new StiBigDecimalDataCell(column, rs.getObject(columnIndex));
            }
            case 1: 
            case 12: {
                return new StiStringDataCell(column, rs.getString(columnIndex));
            }
            case -7: 
            case 16: {
                return new StiBooleanDataCell(column, rs.getBoolean(columnIndex));
            }
        }
        return DataRow.getDefaultDataCell(column, columnIndex, columnType, rs, convertNull);
    }

    public static DataCell getDefaultDataCell(StiDataColumn column, int columnIndex, int columnType, ResultSet rs, Boolean convertNull) throws SQLException {
        Object object = rs.getObject(columnIndex);
        if (object != null) {
            return new DataCell(column, object.toString());
        }
        return new StiDBNullCell(column);
    }

    public static DataCell create(StiDataColumn column, int columnIndex, int columnType, Object rs, Boolean convertNull) throws SQLException {
        switch (columnType) {
            case -4: 
            case -3: 
            case -2: 
            case 70: 
            case 1111: 
            case 2000: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2006: {
                return new StiBytesDataCell(column, (byte[])DataRow.getValue("getBytes", columnIndex, rs));
            }
            case 121: {
                return new StiRefCursorDataCell(column, DataRow.getValue("getBytes", columnIndex, rs));
            }
            case 0: {
                return new StiDBNullCell(column);
            }
            case 2005: {
                return new StiClobDataCell(column, (Clob)DataRow.getValue("getClob", columnIndex, rs));
            }
            case -101: 
            case 91: 
            case 93: {
                return new StiDateDataCell(column, DataRow.getValue("getTimestamp", columnIndex, rs) != null ? new java.util.Date(((Timestamp)DataRow.getValue("getTimestamp", columnIndex, rs)).getTime()) : (Date)DataRow.getValue("getDate", columnIndex, rs));
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return convertNull != false ? new StiIntegerDataCell(column, (Long)DataRow.getValue("getLong", columnIndex, rs)) : new StiIntegerDataCell(column, DataRow.getValue("getObject", columnIndex, rs));
            }
            case 6: 
            case 7: 
            case 8: {
                return convertNull != false ? new StiDoubleDataCell(column, (Double)DataRow.getValue("getDouble", columnIndex, rs)) : new StiDoubleDataCell(column, DataRow.getValue("getObject", columnIndex, rs));
            }
            case 2: 
            case 3: {
                return convertNull != false ? new StiBigDecimalDataCell(column, (BigDecimal)DataRow.getValue("getBigDecimal", columnIndex, rs)) : new StiBigDecimalDataCell(column, DataRow.getValue("getObject", columnIndex, rs));
            }
            case 1: 
            case 12: {
                return new StiStringDataCell(column, (String)DataRow.getValue("getString", columnIndex, rs));
            }
            case -7: 
            case 16: {
                return new StiBooleanDataCell(column, (Boolean)DataRow.getValue("getBoolean", columnIndex, rs));
            }
        }
        Object object = DataRow.getValue("getObject", columnIndex, rs);
        if (object != null) {
            return new DataCell(column, object.toString());
        }
        return new StiDBNullCell(column);
    }

    public static Object getValue(String val, int columnIndex, Object ocs) {
        try {
            Class<?> cl = Class.forName("oracle.jdbc.OracleCallableStatement");
            return cl.getMethod(val, Integer.TYPE).invoke(ocs, columnIndex);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static DataCell create(StiDataColumn column, Object value) {
        if (value == null) {
            return DataCell.createEmpty(column);
        }
        if (column != null) {
            DataCell dataCell;
            switch (column.getType()) {
                case SystemDateTime: {
                    dataCell = new StiDateDataCell(column, value);
                    break;
                }
                case SystemInt16: 
                case SystemInt32: 
                case SystemInt64: {
                    dataCell = new StiIntegerDataCell(column, value);
                    break;
                }
                case SystemDecimal: 
                case SystemDouble: {
                    dataCell = new StiDoubleDataCell(column, value);
                    break;
                }
                case SystemObject: {
                    dataCell = new StiObjectDataCell(column, value);
                    break;
                }
                case SystemBoolean: {
                    dataCell = new StiBooleanDataCell(column, value instanceof Boolean ? (Boolean)value : (value != null ? Boolean.valueOf(Boolean.parseBoolean(value.toString())) : null));
                    break;
                }
                default: {
                    dataCell = DataRow.createByInstanceValue(column, value);
                }
            }
            return dataCell;
        }
        return DataRow.createByInstanceValue(column, value);
    }

    private static DataCell createByInstanceValue(StiDataColumn column, Object value) {
        DataCell dataCell = value instanceof Integer || value instanceof Long || value instanceof Short || value instanceof Byte ? new StiIntegerDataCell(column, value) : (value instanceof Double || value instanceof Float ? new StiDoubleDataCell(column, value) : (value == DBNull.Value ? new StiDBNullCell(column) : new DataCell(column, value.toString())));
        return dataCell;
    }
}

