/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary.businessObjects;

import com.stimulsoft.base.IStiJsonReportObject;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.StiSerializedObject;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.lib.commoninterface.IStiName;
import com.stimulsoft.report.StiNameValidator;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.StiStatesManager;
import com.stimulsoft.report.components.bands.StiDataBand;
import com.stimulsoft.report.dictionary.StiDataColumnsCollection;
import com.stimulsoft.report.dictionary.StiDictionary;
import com.stimulsoft.report.dictionary.businessObjects.StiBusinessObjectData;
import com.stimulsoft.report.dictionary.businessObjects.StiBusinessObjectHelper;
import com.stimulsoft.report.dictionary.businessObjects.StiBusinessObjectsCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;

public class StiBusinessObject
extends StiSerializedObject
implements IStiName,
IStiJsonReportObject {
    private StiStatesManager states;
    private boolean isEnumeratorCreated;
    private Object specPrevValue;
    private Object specNextValue;
    private boolean specNextValueRead;
    private boolean specMoveNextResult;
    private Object specStoredCurrentValue;
    public Iterator enumerator;
    private StiBusinessObject parentBusinessObject;
    private boolean inherited;
    protected int positionValue;
    public int Position;
    protected boolean isBofValue;
    protected boolean isEofValue;
    private boolean isEmpty;
    private Object current;
    private StiBusinessObjectsCollection businessObjects;
    private StiDataColumnsCollection columns;
    private String category;
    private String name;
    private String alias;
    private Object businessObjectValue;
    private StiDictionary dictionary;
    private String guid;

    public StiBusinessObject() {
        this("", "", "", null);
    }

    public StiBusinessObject(String category, String name, String alias, String guid) {
        this.Position = this.positionValue;
        this.category = category;
        this.name = name;
        this.alias = alias;
        this.columns = new StiDataColumnsCollection(this);
        this.businessObjects = new StiBusinessObjectsCollection(null, this);
        if (guid == null) {
            guid = UUID.randomUUID().toString().replace("-", "");
        }
        this.guid = guid;
    }

    protected final StiStatesManager getStates() {
        if (this.states == null) {
            this.states = new StiStatesManager();
        }
        return this.states;
    }

    public void ClearAllStates() {
        this.states = null;
    }

    @StiSerializable
    @StiDefaulValue(value="false")
    public final boolean getInherited() {
        return this.inherited;
    }

    public final void setInherited(boolean value) {
        this.inherited = value;
    }

    public int getPosition() {
        return this.positionValue;
    }

    public void setPosition(int value) {
        if (value != this.positionValue) {
            this.first();
            for (int count = value; count > 0; --count) {
                this.next();
            }
        }
    }

    public final int getCount() {
        this.CheckEnumerator();
        if (this.getBusinessObjectValue() instanceof Collection) {
            return ((Collection)this.getBusinessObjectValue()).size();
        }
        if (this.getBusinessObjectValue() instanceof List) {
            Object tempVar = this.getBusinessObjectValue();
            List listSource = (List)(tempVar instanceof List ? tempVar : null);
            return listSource.size();
        }
        if (this.getBusinessObjectValue() instanceof ArrayList) {
            Object tempVar2 = this.getBusinessObjectValue();
            ArrayList array = (ArrayList)(tempVar2 instanceof ArrayList ? tempVar2 : null);
            return array.size();
        }
        return 1;
    }

    public boolean getIsBof() {
        return this.isBofValue;
    }

    public void setIsBof(boolean value) {
        this.isBofValue = value;
    }

    public boolean getIsEof() {
        return this.isEofValue;
    }

    public void setIsEof(boolean value) {
        this.isEofValue = value;
    }

    public boolean getIsEmpty() {
        return this.isEmpty;
    }

    private void EnumeratorReset() {
    }

    public void first() {
        this.specNextValue = null;
        this.specNextValueRead = false;
        this.specPrevValue = null;
        this.positionValue = 0;
        this.isEofValue = false;
        this.isBofValue = true;
        if (this.enumerator != null) {
            this.EnumeratorReset();
            boolean value = this.enumerator.hasNext();
            if (!value) {
                this.isEmpty = true;
                this.isEofValue = true;
                this.current = null;
                this.specPrevValue = null;
            } else {
                this.current = this.enumerator.next();
                this.specPrevValue = null;
                this.isEmpty = false;
            }
        } else {
            this.current = null;
            this.specPrevValue = null;
            this.isEmpty = true;
            this.isEofValue = true;
        }
    }

    public void prior() {
        throw new RuntimeException("StiBusinessObject does not support IStiEnumerator.Prior");
    }

    public void next() {
        if (this.enumerator != null) {
            if (this.specNextValueRead) {
                boolean value = this.specMoveNextResult;
                if (!value) {
                    this.isEofValue = true;
                    this.current = null;
                    this.specPrevValue = null;
                } else {
                    this.specPrevValue = this.getCurrent();
                    this.current = this.specNextValue;
                    this.isBofValue = false;
                    this.isEofValue = false;
                    if (!this.isEofValue) {
                        ++this.positionValue;
                    }
                }
                this.specNextValueRead = false;
                this.specNextValue = null;
            } else {
                this.specNextValue = null;
                this.specNextValueRead = false;
                boolean value = this.enumerator.hasNext();
                if (!value) {
                    this.isEofValue = true;
                    this.current = null;
                } else {
                    this.specPrevValue = this.current;
                    this.current = this.enumerator.next();
                    this.isBofValue = false;
                    this.isEofValue = false;
                    if (!this.isEofValue) {
                        ++this.positionValue;
                    }
                }
            }
        }
    }

    public void last() {
        throw new RuntimeException("StiBusinessObject does not support IStiEnumerator.Last");
    }

    public final Object getCurrent() {
        this.CheckEnumerator();
        return this.current;
    }

    private StiReport getReport() {
        if (this.getDictionary() == null) {
            return null;
        }
        return this.getDictionary().getReport();
    }

    @StiSerializable
    public final StiBusinessObjectsCollection getBusinessObjects() {
        return this.businessObjects;
    }

    public final void setBusinessObjects(StiBusinessObjectsCollection value) {
        this.businessObjects = value;
    }

    @StiSerializable
    public StiDataColumnsCollection getColumns() {
        return this.columns;
    }

    public void setColumns(StiDataColumnsCollection value) {
        this.columns = value;
    }

    @StiSerializable
    public final String getGuid() {
        return this.guid;
    }

    public final void setGuid(String value) {
        this.guid = value;
    }

    @StiSerializable
    public final String getCategory() {
        return this.category;
    }

    public final void setCategory(String value) {
        this.category = value;
    }

    @StiSerializable
    public final String getName() {
        return this.name;
    }

    public final void setName(String value) {
        this.name = value;
    }

    @StiSerializable
    public final String getAlias() {
        return this.alias;
    }

    public final void setAlias(String value) {
        this.alias = value;
    }

    public final Object getBusinessObjectValue() {
        return this.businessObjectValue;
    }

    public final void setBusinessObjectValue(Object value) {
        this.businessObjectValue = value;
    }

    @StiSerializable(isRef=true)
    public final StiDictionary getDictionary() {
        return this.dictionary;
    }

    public final void setDictionary(StiDictionary value) {
        this.businessObjects.dictionary = this.dictionary = value;
        if (value != null) {
            for (StiBusinessObject businessObject : this.getBusinessObjects()) {
                businessObject.dictionary = this.dictionary;
            }
        }
    }

    private void CheckEnumerator() {
        if (!this.isEnumeratorCreated) {
            this.CreateEnumerator();
            this.SetDetails();
        }
    }

    public final void SetPrevValue() {
        this.specStoredCurrentValue = this.getCurrent();
        this.current = this.specPrevValue;
    }

    public final void SetNextValue() {
        this.specStoredCurrentValue = this.getCurrent();
        if (!this.specNextValueRead) {
            this.specMoveNextResult = this.enumerator.hasNext();
            if (this.specMoveNextResult) {
                this.current = this.specNextValue = this.enumerator.next();
            } else {
                this.specNextValue = null;
                this.current = null;
            }
            this.specNextValueRead = true;
        } else {
            this.current = this.specNextValue;
        }
    }

    public final void RestoreCurrentValue() {
        this.current = this.specStoredCurrentValue;
    }

    public final StiBusinessObject GetTopParentBusinessObject() {
        StiBusinessObject businessObject = this;
        while (businessObject.getParentBusinessObject() != null) {
            businessObject = businessObject.getParentBusinessObject();
        }
        return businessObject;
    }

    public final void CreateEnumerator() {
        if (this.getParentBusinessObject() == null) {
            this.setBusinessObjectValue(this.GetBusinessObjectData());
            this.enumerator = StiBusinessObjectHelper.getEnumeratorFromObject(this.getBusinessObjectValue());
        } else {
            Object value = this.getParentBusinessObject().getCurrent();
            if (value == null) {
                return;
            }
            this.setBusinessObjectValue(StiBusinessObjectHelper.getValueFromObject(value, this.getName()));
            this.enumerator = StiBusinessObjectHelper.getEnumeratorFromObject(this.getBusinessObjectValue());
        }
        this.first();
        this.isEnumeratorCreated = true;
    }

    private void DestroyEnumerator() {
        this.isEnumeratorCreated = false;
    }

    public final void SetDetails() {
        this.CreateEnumerator();
    }

    private Object GetBusinessObjectDataFromParent(StiBusinessObject businessObject) {
        for (StiBusinessObjectData businessObjectData : businessObject.dictionary.getReport().getBusinessObjectsStore()) {
            if (!businessObject.getName().equals(businessObjectData.getName())) continue;
            return businessObjectData.getBusinessObjectValue();
        }
        return null;
    }

    public final Object GetBusinessObjectData() {
        return this.GetBusinessObjectData(false);
    }

    public final Object GetBusinessObjectData(boolean isColumnsRetrieve) {
        if (this.getParentBusinessObject() == null) {
            return this.GetBusinessObjectDataFromParent(this);
        }
        ArrayList<StiBusinessObject> parents = new ArrayList<StiBusinessObject>();
        StiBusinessObject current = this;
        while (current.getParentBusinessObject() != null) {
            parents.add(0, current);
            current = current.getParentBusinessObject();
        }
        Object currentData = this.GetBusinessObjectDataFromParent(current);
        if (currentData instanceof Iterable) {
            Object currentData2 = StiBusinessObjectHelper.getElementFromEnumerable((Iterable)(currentData instanceof Iterable ? currentData : null));
            currentData = currentData2 == null ? StiBusinessObjectHelper.getElementType(currentData.getClass()) : currentData2;
        }
        for (StiBusinessObject businessObject : parents) {
            currentData = StiBusinessObjectHelper.getElementFromObject(currentData, businessObject.getName(), isColumnsRetrieve);
            current = businessObject;
        }
        return currentData;
    }

    public final String GetFullName() {
        if (StiOptions.Dictionary.showOnlyAliasForBusinessObject()) {
            return StiBusinessObjectHelper.getBusinessObjectFullAlias(this);
        }
        String fullName = StiBusinessObjectHelper.getBusinessObjectFullName(this);
        if (this.name.equals(this.alias)) {
            return fullName;
        }
        String fullAlias = StiBusinessObjectHelper.getBusinessObjectFullAlias(this);
        return String.format("%1$s [%2$s]", fullName, fullAlias);
    }

    public final String GetCorrectFullName() {
        if (this.getParentBusinessObject() != null) {
            return this.getParentBusinessObject().GetCorrectFullName() + "." + StiNameValidator.CorrectName(this.getName());
        }
        return this.getName();
    }

    public String toString() {
        if (StiOptions.Dictionary.showOnlyAliasForBusinessObject()) {
            return this.getAlias();
        }
        if (this.name.equals(this.alias)) {
            return this.name;
        }
        return String.format("%1$s [%2$s]", this.getName(), this.getAlias());
    }

    public final void Connect() {
        this.CreateEnumerator();
    }

    public final void Disconnect() {
        this.DestroyEnumerator();
        this.businessObjectValue = null;
    }

    public final StiBusinessObject getParentBusinessObject() {
        return this.parentBusinessObject;
    }

    public final void setParentBusinessObject(StiBusinessObject value) {
        this.parentBusinessObject = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object getItem(String name) {
        boolean stateIsEnumeratorCreated = this.isEnumeratorCreated;
        try {
            Object result;
            Object value = this.getCurrent();
            if (value == null) {
                Object var4_4 = null;
                return var4_4;
            }
            Object object = result = StiBusinessObjectHelper.getValueFromObject(value, name);
            return object;
        }
        finally {
            if (!stateIsEnumeratorCreated) {
                this.setBusinessObjectValue(null);
                this.enumerator = null;
                this.isEnumeratorCreated = false;
            }
        }
    }

    public boolean isEof() {
        return this.getIsEof();
    }

    public void setEof(boolean value) {
        this.setIsEof(value);
    }

    public boolean isBof() {
        return this.getIsBof();
    }

    public void setBof(boolean value) {
        this.setIsBof(value);
    }

    public boolean isEmpty() {
        return this.getIsEmpty();
    }

    public int getSize() {
        return this.getCount();
    }

    public int size() {
        return this.getSize();
    }

    public void SaveState(String string) {
    }

    public void RestoreState(String string) {
    }

    public Object get(String string) {
        return null;
    }

    public void setCurrentObject(Object object) {
    }

    public int getLevel() {
        return 0;
    }

    public void setOwnerBand(StiDataBand masterDataBand) {
    }

    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = new JSONObject();
        jObject.AddPropertyBool("Inherited", this.getInherited());
        jObject.AddPropertyJObject("BusinessObjects", this.getBusinessObjects().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("Columns", this.getColumns().SaveToJsonObject(mode));
        jObject.AddPropertyStringNullOfEmpty("Guid", this.getGuid());
        jObject.AddPropertyStringNullOfEmpty("Category", this.getCategory());
        jObject.AddPropertyStringNullOfEmpty("Name", this.getName());
        jObject.AddPropertyStringNullOfEmpty("Alias", this.getAlias());
        return jObject;
    }

    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("Inherited")) {
                this.inherited = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("BusinessObjects")) {
                this.businessObjects.LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if (property.Name.equals("Columns")) {
                this.columns.LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if (property.Name.equals("Guid")) {
                this.guid = (String)property.Value;
                continue;
            }
            if (property.Name.equals("Category")) {
                this.category = (String)property.Value;
                continue;
            }
            if (property.Name.equals("Name")) {
                this.name = (String)property.Value;
                continue;
            }
            if (property.Name.equals("Alias")) {
                this.alias = (String)property.Value;
                continue;
            }
            if (!property.Name.equals("Key")) continue;
        }
    }
}

