/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary.aggregateFunctions;

import com.stimulsoft.base.DBNull;
import com.stimulsoft.base.StiObjectConverter;
import com.stimulsoft.report.dictionary.aggregateFunctions.StiAggregateFunctionService;
import java.math.BigDecimal;
import java.util.Hashtable;

public class StiModeDecimalFunctionService
extends StiAggregateFunctionService {
    private Hashtable<Long, Integer> values;

    public StiModeDecimalFunctionService() {
    }

    public StiModeDecimalFunctionService(boolean runningTotal) {
        super(runningTotal);
    }

    @Override
    public void CalcItem(Object value) {
        if (value == null || value == DBNull.Value) {
            return;
        }
        long val = StiObjectConverter.ConvertToInt64((Object)value);
        Integer count = this.values.get(val);
        if (count == null) {
            count = 0;
        }
        count = count + 1;
        this.values.put(val, count);
    }

    @Override
    public boolean getRecureParam() {
        return true;
    }

    @Override
    public Class GetResultType() {
        return BigDecimal.class;
    }

    public String getServiceName() {
        return "Mode";
    }

    @Override
    public Object GetValue() {
        if (this.values == null || this.values.isEmpty()) {
            return null;
        }
        Long freqValue = new Long(0L);
        int freqCount = 0;
        for (Long value : this.values.keySet()) {
            int count = this.values.get(value);
            if (count <= freqCount) continue;
            freqCount = count;
            freqValue = value;
        }
        return freqValue;
    }

    @Override
    public void Init() {
        if (!this.getRunningTotal() || this.IsFirstInit) {
            this.values = new Hashtable();
        }
    }

    @Override
    public void SetValue(Object value) {
        throw new IllegalArgumentException("You can't set calculation result to Mode function!");
    }
}

