/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary.aggregateFunctions;

import com.stimulsoft.report.dictionary.aggregateFunctions.StiAggregateFunctionService;
import java.util.Date;

public class StiAvgTimeFunctionService
extends StiAggregateFunctionService {
    private long avgValue;
    private long count;

    public StiAvgTimeFunctionService(boolean runningTotal) {
        super(runningTotal);
    }

    public StiAvgTimeFunctionService() {
    }

    public String getServiceName() {
        return "AvgTime";
    }

    @Override
    public void Init() {
        if (!this.getRunningTotal() || this.IsFirstInit) {
            this.avgValue = 0L;
            this.count = 0L;
        }
    }

    @Override
    public void CalcItem(Object value) {
        if (value instanceof Date) {
            Date timeValue = (Date)value;
            this.avgValue += timeValue.getTime();
            ++this.count;
        } else if (value instanceof Date && value != null) {
            Date timeValue = (Date)value;
            this.avgValue += timeValue.getTime();
            ++this.count;
        }
    }

    @Override
    public Object GetValue() {
        if (this.count == 0L) {
            return null;
        }
        return new Date(this.avgValue - this.count);
    }

    @Override
    public void SetValue(Object value) {
        throw new IllegalArgumentException("You can't set calculation result to AvgTime function!");
    }

    @Override
    public Class GetResultType() {
        return Date.class;
    }

    @Override
    public boolean getRecureParam() {
        return true;
    }
}

