/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary.aggregateFunctions;

import com.stimulsoft.report.dictionary.aggregateFunctions.StiAggregateFunctionService;
import java.util.Date;

public class StiAvgDateFunctionService
extends StiAggregateFunctionService {
    private long avgValue = 0L;
    private long count = 0L;

    public StiAvgDateFunctionService(boolean runningTotal) {
        super(runningTotal);
    }

    public StiAvgDateFunctionService() {
    }

    public String getServiceName() {
        return "AvgDate";
    }

    @Override
    public void Init() {
        if (!this.getRunningTotal() || this.IsFirstInit) {
            this.avgValue = 0L;
            this.count = 0L;
        }
    }

    @Override
    public void CalcItem(Object value) {
        Date dateTimeValue;
        if (value instanceof Date) {
            dateTimeValue = (Date)value;
            this.avgValue += dateTimeValue.getTime();
            ++this.count;
        }
        if (value instanceof Date && value != null) {
            dateTimeValue = (Date)value;
            this.avgValue += dateTimeValue.getTime();
            ++this.count;
        }
    }

    @Override
    public Object GetValue() {
        if (this.count == 0L) {
            return null;
        }
        return new Date(this.avgValue - this.count);
    }

    @Override
    public void SetValue(Object value) {
        throw new IllegalArgumentException("You can't set calculation result to AvgDate function!");
    }

    @Override
    public Class GetResultType() {
        return Date.class;
    }

    @Override
    public boolean getRecureParam() {
        return true;
    }
}

