/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary;

import com.stimulsoft.report.components.bands.StiGroupHeaderBand;
import com.stimulsoft.report.components.enums.StiGroupSortDirection;
import com.stimulsoft.report.dictionary.data.DataRow;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Hashtable;

public class StiGroupSummaryDataSort
implements Comparator<DataRow> {
    private Hashtable groupSummaries;
    private Hashtable groupLines;
    private Hashtable baseRowOrder;
    private ArrayList<StiGroupHeaderBand> groupHeaders;

    public StiGroupSummaryDataSort(Hashtable groupSummaries, Hashtable groupLines, ArrayList<StiGroupHeaderBand> groupHeaders, Hashtable baseRowOrder) {
        this.groupSummaries = groupSummaries;
        this.groupLines = groupLines;
        this.baseRowOrder = baseRowOrder;
        this.groupHeaders = groupHeaders;
    }

    @Override
    public int compare(DataRow row1, DataRow row2) {
        try {
            if (row1 == row2) {
                return 0;
            }
            for (StiGroupHeaderBand group : this.groupHeaders) {
                Integer line2;
                Object value2;
                if (group.getSummarySortDirection() == StiGroupSortDirection.None) continue;
                int sortFactor = group.getSummarySortDirection() == StiGroupSortDirection.Ascending ? 1 : -1;
                Hashtable groupSummariesHash = (Hashtable)this.groupSummaries.get(group);
                Hashtable groupLinesHash = (Hashtable)this.groupLines.get(group);
                Object value1 = groupSummariesHash.get(row1);
                int result = this.compareValues(value1, value2 = groupSummariesHash.get(row2));
                if (result != 0) {
                    return result * sortFactor;
                }
                Integer line1 = (Integer)groupLinesHash.get(row1);
                result = line1.compareTo(line2 = (Integer)groupLinesHash.get(row2));
                if (result == 0) continue;
                return result * sortFactor;
            }
            Integer baseline1 = (Integer)this.baseRowOrder.get(row1);
            Integer baseline2 = (Integer)this.baseRowOrder.get(row2);
            return baseline1.compareTo(baseline2);
        }
        catch (Exception e) {
            return 0;
        }
    }

    private int compareValues(Object value1, Object value2) {
        if (value1 instanceof Comparable) {
            return ((Comparable)value1).compareTo(value2);
        }
        return 0;
    }
}

