/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary;

import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.design.IStiDefault;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.range.ByteRange;
import com.stimulsoft.base.range.CharRange;
import com.stimulsoft.base.range.DateTimeRange;
import com.stimulsoft.base.range.DecimalRange;
import com.stimulsoft.base.range.DoubleRange;
import com.stimulsoft.base.range.GuidRange;
import com.stimulsoft.base.range.LongRange;
import com.stimulsoft.base.range.Range;
import com.stimulsoft.base.range.StringRange;
import com.stimulsoft.base.range.TimeSpanRange;
import com.stimulsoft.base.serializing.StiSerializedObject;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.StiDateTime;
import com.stimulsoft.base.system.StiGuid;
import com.stimulsoft.base.system.StiTimeSpan;
import com.stimulsoft.base.system.type.StiSystemType;
import com.stimulsoft.base.system.type.StiSystemTypeEnum;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.simplecomponents.StiImage;
import com.stimulsoft.report.dictionary.StiDialogInfoItem;
import com.stimulsoft.report.dictionary.StiVariable;
import com.stimulsoft.report.dictionary.enums.StiDateTimeType;
import com.stimulsoft.report.dictionary.enums.StiItemsInitializationType;
import com.stimulsoft.report.dictionary.enums.StiVariableSortDirection;
import com.stimulsoft.report.dictionary.enums.StiVariableSortField;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class StiDialogInfo
extends StiSerializedObject
implements IStiDefault,
Cloneable {
    private StiDateTimeType dateTimeType = StiDateTimeType.Date;
    private StiItemsInitializationType itemsInitializationType = StiItemsInitializationType.Items;
    private String keysColumn = "";
    private String valuesColumn = "";
    private String mask = "";
    private boolean allowUserValues = true;
    private List<String> keys = new ArrayList<String>();
    private List<String> values = new ArrayList<String>();
    public String jsonLoadedBindingVariableName;
    private StiVariable bindingVariable = null;
    private String bindingValuesColumn = "";
    private boolean bindingValue = false;
    private List<Object>[] valuesBindingList = new ArrayList[0];
    private StiVariableSortDirection sortDirection = StiVariableSortDirection.Asc;
    private StiVariableSortField sortField = StiVariableSortField.Label;
    private String checkedColumn;
    public List<Boolean> checkedStates = new ArrayList<Boolean>(Arrays.asList(new Boolean[0]));

    public StiDialogInfo() {
    }

    public StiDialogInfo(StiDateTimeType type, String mask, boolean allowUserValues, List<String> keys, List<String> values, List<Boolean> checkedStates) {
        this.dateTimeType = type;
        this.mask = mask;
        this.allowUserValues = allowUserValues;
        this.keys = keys;
        this.values = values;
        this.itemsInitializationType = StiItemsInitializationType.Items;
        this.checkedStates = checkedStates;
    }

    public StiDialogInfo(StiDateTimeType type, String mask, boolean allowUserValues, String keysColumn, String valuesColumn, String checkedColumn) {
        this.dateTimeType = type;
        this.mask = mask;
        this.allowUserValues = allowUserValues;
        this.itemsInitializationType = StiItemsInitializationType.Columns;
        this.keysColumn = keysColumn;
        this.valuesColumn = valuesColumn;
        this.checkedColumn = checkedColumn;
    }

    public StiDialogInfo(StiDateTimeType type, String mask, boolean allowUserValues, String keysColumn, String valuesColumn, String checkedColumn, boolean bindingValue, StiVariable bindingVariable, String bindingValuesColumn) {
        this.dateTimeType = type;
        this.mask = mask;
        this.allowUserValues = allowUserValues;
        this.itemsInitializationType = StiItemsInitializationType.Columns;
        this.keysColumn = keysColumn;
        this.valuesColumn = valuesColumn;
        this.bindingValue = bindingValue;
        this.bindingVariable = bindingVariable;
        this.bindingValuesColumn = bindingValuesColumn;
        this.checkedColumn = checkedColumn;
    }

    public StiDialogInfo(StiDateTimeType type, String mask, boolean allowUserValues, String keysColumn, String valuesColumn, String checkedColumn, StiVariableSortDirection sortDirection, StiVariableSortField sortField) {
        this.dateTimeType = type;
        this.mask = mask;
        this.allowUserValues = allowUserValues;
        this.itemsInitializationType = StiItemsInitializationType.Columns;
        this.keysColumn = keysColumn;
        this.valuesColumn = valuesColumn;
        this.sortDirection = sortDirection;
        this.sortField = sortField;
        this.checkedColumn = checkedColumn;
    }

    public StiDialogInfo(StiDateTimeType type, String mask, boolean allowUserValues, String keysColumn, String valuesColumn, String checkedColumn, boolean bindingValue, StiVariable bindingVariable, String bindingValuesColumn, StiVariableSortDirection sortDirection, StiVariableSortField sortField) {
        this.dateTimeType = type;
        this.mask = mask;
        this.allowUserValues = allowUserValues;
        this.itemsInitializationType = StiItemsInitializationType.Columns;
        this.keysColumn = keysColumn;
        this.valuesColumn = valuesColumn;
        this.bindingValue = bindingValue;
        this.bindingVariable = bindingVariable;
        this.bindingValuesColumn = bindingValuesColumn;
        this.sortDirection = sortDirection;
        this.sortField = sortField;
        this.checkedColumn = checkedColumn;
    }

    @StiSerializable
    public StiVariableSortDirection getSortDirection() {
        return this.sortDirection;
    }

    public void setSortDirection(StiVariableSortDirection sortDirection) {
        this.sortDirection = sortDirection;
    }

    @StiSerializable
    public StiVariableSortField getSortField() {
        return this.sortField;
    }

    public void setSortField(StiVariableSortField sortField) {
        this.sortField = sortField;
    }

    @StiSerializable
    public String getBindingValuesColumn() {
        return this.bindingValuesColumn;
    }

    public List<Object>[] getValuesBindingList() {
        return this.valuesBindingList;
    }

    public void setValuesBindingList(List<Object>[] valuesBindingList) {
        this.valuesBindingList = valuesBindingList;
    }

    public void setBindingValuesColumn(String bindingValuesColumn) {
        this.bindingValuesColumn = bindingValuesColumn;
    }

    @StiSerializable
    public boolean isBindingValue() {
        return this.bindingValue;
    }

    public void setBindingValue(boolean bindingValue) {
        this.bindingValue = bindingValue;
    }

    @StiDefaulValue(value="Date")
    @StiSerializable
    public final StiDateTimeType getDateTimeType() {
        return this.dateTimeType;
    }

    public final void setDateTimeType(StiDateTimeType value) {
        this.dateTimeType = value;
    }

    @StiDefaulValue(value="Items")
    @StiSerializable
    public final StiItemsInitializationType getItemsInitializationType() {
        return this.itemsInitializationType;
    }

    public final void setItemsInitializationType(StiItemsInitializationType value) {
        this.itemsInitializationType = value;
    }

    @StiDefaulValue(value="")
    @StiSerializable
    public final String getKeysColumn() {
        return this.keysColumn;
    }

    public final void setKeysColumn(String value) {
        this.keysColumn = value;
    }

    @StiDefaulValue(value="")
    @StiSerializable
    public final String getValuesColumn() {
        return this.valuesColumn;
    }

    public final void setValuesColumn(String value) {
        this.valuesColumn = value;
    }

    @StiDefaulValue(value="")
    @StiSerializable
    public final String getMask() {
        return this.mask;
    }

    public final void setMask(String value) {
        this.mask = value;
    }

    @StiDefaulValue(value="true")
    @StiSerializable
    public final boolean getAllowUserValues() {
        return this.allowUserValues;
    }

    public final void setAllowUserValues(boolean value) {
        this.allowUserValues = value;
    }

    @StiSerializable
    public final List<String> getKeys() {
        return this.keys;
    }

    public final void setKeys(List<String> value) {
        this.keys = value;
    }

    @StiSerializable
    public final List<String> getValues() {
        return this.values;
    }

    public final void setValues(List<String> value) {
        this.values = value;
    }

    @StiSerializable
    public String getCheckedColumn() {
        return this.checkedColumn;
    }

    public void setCheckedColumn(String checkedColumn) {
        this.checkedColumn = checkedColumn;
    }

    @StiSerializable(listClass=Boolean.class)
    public List<Boolean> getCheckedStates() {
        return this.checkedStates;
    }

    public void setCheckedStates(List<Boolean> checkedStates) {
        this.checkedStates = checkedStates;
    }

    public final boolean isDefault() {
        return !(!this.getAllowUserValues() || this.getDateTimeType() != StiDateTimeType.Date || this.bindingVariable != null || !StiValidationUtil.isNullOrEmpty((String)this.getMask()) || this.sortDirection != StiVariableSortDirection.Asc || this.sortField != StiVariableSortField.Label || this.getKeys() != null && this.getKeys().size() != 0 || this.getValues() != null && this.getValues().size() != 0 || !StiValidationUtil.isNullOrEmpty((String)this.getKeysColumn()) || !StiValidationUtil.isNullOrEmpty((String)this.getValuesColumn()) || !StiValidationUtil.isNullOrEmpty((String)this.getBindingValuesColumn()) || !StiValidationUtil.isNullOrEmpty((String)this.getCheckedColumn()) || this.checkedStates != null && this.checkedStates.size() != 0);
    }

    public String getLable(int i) {
        return i < this.values.size() ? this.values.get(i) : this.keys.get(i);
    }

    public StiDialogInfo clone() {
        try {
            return (StiDialogInfo)super.clone();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setEmptyKeysValue() {
        this.keys = new ArrayList<String>();
        this.values = new ArrayList<String>();
    }

    public List<StiDialogInfoItem> getDialogInfoItems(StiSystemTypeEnum type) {
        ArrayList<StiDialogInfoItem> items = new ArrayList<StiDialogInfoItem>();
        if (this.getKeys() == null) {
            return items;
        }
        int index = 0;
        for (String key : this.getKeys()) {
            StiDialogInfoItem item = null;
            Object keyObject = null;
            Object keyObjectTo = null;
            try {
                Range range;
                if (key.startsWith("{") && key.endsWith("}")) {
                    range = null;
                    try {
                        range = (Range)Class.forName("com.stimulsoft.base.range." + type.getSystemType().getSerializeValue().replace("System.", "") + "Range").newInstance();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (range != null) {
                        if (key.contains("<<|>>")) {
                            String str = key.substring(1, key.length() - 2);
                            String[] strs = str.split("<<|>>");
                            if (strs.length == 2) {
                                keyObject = strs[0];
                                keyObjectTo = strs[0];
                            } else {
                                keyObject = key.substring(1, key.length() - 2);
                            }
                        } else {
                            keyObject = key.substring(1, key.length() - 2);
                        }
                        item = new StiDialogInfoItem.StiExpressionRangeDialogInfoItem();
                    } else {
                        keyObject = key.substring(1, key.length() - 2);
                        item = new StiDialogInfoItem.StiExpressionDialogInfoItem();
                    }
                } else if (type == StiSystemTypeEnum.SystemSByte || type == StiSystemTypeEnum.SystemByte || type == StiSystemTypeEnum.SystemInt16 || type == StiSystemTypeEnum.SystemUInt16 || type == StiSystemTypeEnum.SystemInt32 || type == StiSystemTypeEnum.SystemUInt32 || type == StiSystemTypeEnum.SystemInt64 || type == StiSystemTypeEnum.SystemUInt64 || type == StiSystemTypeEnum.SystemSByte || type == StiSystemTypeEnum.SystemByte || type == StiSystemTypeEnum.SystemByte && type.getSystemType().isList() || type == StiSystemTypeEnum.SystemInt16 && type.getSystemType().isList() || type == StiSystemTypeEnum.SystemInt32 && type.getSystemType().isList() || type == StiSystemTypeEnum.SystemInt64 && type.getSystemType().isList()) {
                    keyObject = Long.parseLong(key);
                    item = new StiDialogInfoItem.StiLongDialogInfoItem();
                } else if (type == StiSystemTypeEnum.SystemString || type == StiSystemTypeEnum.SystemString && type.getSystemType().isList()) {
                    keyObject = key;
                    item = new StiDialogInfoItem.StiStringDialogInfoItem();
                } else if (type == StiSystemTypeEnum.SystemDouble || type == StiSystemTypeEnum.SystemFloat || type == StiSystemTypeEnum.SystemDouble && type.getSystemType().isList() || type == StiSystemTypeEnum.SystemFloat && type.getSystemType().isList()) {
                    keyObject = Double.parseDouble(key);
                    item = new StiDialogInfoItem.StiDoubleDialogInfoItem();
                } else if (type == StiSystemTypeEnum.SystemDecimal || type == StiSystemTypeEnum.SystemDecimal && type.getSystemType().isList()) {
                    keyObject = new BigDecimal(key);
                    item = new StiDialogInfoItem.StiDecimalDialogInfoItem();
                } else if (type == StiSystemTypeEnum.SystemDateTime || type == StiSystemTypeEnum.SystemDateTime && type.getSystemType().isList()) {
                    keyObject = StiDateTime.fromString((String)key);
                    item = new StiDialogInfoItem.StiDateTimeDialogInfoItem();
                } else if (type == StiSystemTypeEnum.SystemTimeSpan || type == StiSystemTypeEnum.SystemTimeSpan && type.getSystemType().isList()) {
                    keyObject = StiTimeSpan.valueOf((String)key);
                    item = new StiDialogInfoItem.StiTimeSpanDialogInfoItem();
                } else if (type == StiSystemTypeEnum.SystemBoolean || type == StiSystemTypeEnum.SystemBoolean && type.getSystemType().isList()) {
                    keyObject = Boolean.parseBoolean(key);
                    item = new StiDialogInfoItem.StiBoolDialogInfoItem();
                } else if (type == StiSystemTypeEnum.SystemChar || type == StiSystemTypeEnum.SystemChar && type.getSystemType().isList()) {
                    keyObject = key.equals("") || key.length() < 1 ? Character.valueOf(' ') : Character.valueOf(key.charAt(0));
                    item = new StiDialogInfoItem.StiCharDialogInfoItem();
                } else if (type == StiSystemTypeEnum.SystemGuid || type == StiSystemTypeEnum.SystemGuid && type.getSystemType().isList()) {
                    keyObject = new StiGuid(key);
                    item = new StiDialogInfoItem.StiGuidDialogInfoItem();
                } else if (type == StiSystemTypeEnum.SystemDrawingImage || type == StiSystemTypeEnum.SystemDrawingImage && type.getSystemType().isList() || type == StiSystemTypeEnum.SystemDrawingBitmap) {
                    keyObject = new StiImage(key);
                    item = new StiDialogInfoItem.StiImageDialogInfoItem();
                } else if ((type == StiSystemTypeEnum.SystemByte || type == StiSystemTypeEnum.SystemInt16 || type == StiSystemTypeEnum.SystemInt32 || type == StiSystemTypeEnum.SystemInt64) && type.getSystemType().isRange()) {
                    range = new LongRange();
                    item = new StiDialogInfoItem.StiLongRangeDialogInfoItem();
                    keyObject = Long.parseLong(range.getFromObject().toString());
                    keyObjectTo = Long.parseLong(range.getToObject().toString());
                } else if (type == StiSystemTypeEnum.SystemString && type.getSystemType().isRange()) {
                    range = new StringRange();
                    item = new StiDialogInfoItem.StiStringRangeDialogInfoItem();
                    keyObject = range.getFromObject().toString();
                    keyObjectTo = range.getToObject().toString();
                } else if (type == StiSystemTypeEnum.SystemDouble || type == StiSystemTypeEnum.SystemFloat && type.getSystemType().isRange()) {
                    range = new DoubleRange();
                    item = new StiDialogInfoItem.StiDoubleRangeDialogInfoItem();
                    keyObject = Double.parseDouble(range.getFromObject().toString());
                    keyObjectTo = Double.parseDouble(range.getToObject().toString());
                } else if (type == StiSystemTypeEnum.SystemDecimal && type.getSystemType().isRange()) {
                    range = new DecimalRange();
                    item = new StiDialogInfoItem.StiDecimalRangeDialogInfoItem();
                    keyObject = new BigDecimal(range.getFromObject().toString());
                    keyObjectTo = new BigDecimal(range.getToObject().toString());
                } else if (type == StiSystemTypeEnum.SystemDateTime && type.getSystemType().isRange()) {
                    range = new DateTimeRange();
                    item = new StiDialogInfoItem.StiDateTimeRangeDialogInfoItem();
                    keyObject = range.getFromObject();
                    keyObjectTo = range.getToObject();
                } else if (type == StiSystemTypeEnum.SystemTimeSpan && type.getSystemType().isRange()) {
                    range = new TimeSpanRange();
                    item = new StiDialogInfoItem.StiTimeSpanRangeDialogInfoItem();
                    keyObject = range.getFromObject();
                    keyObjectTo = range.getToObject();
                } else if (type == StiSystemTypeEnum.SystemChar && type.getSystemType().isRange()) {
                    range = new CharRange();
                    item = new StiDialogInfoItem.StiCharRangeDialogInfoItem();
                    keyObject = range.getFromObject();
                    keyObjectTo = range.getToObject();
                } else if (type == StiSystemTypeEnum.SystemGuid && type.getSystemType().isRange()) {
                    range = new GuidRange();
                    item = new StiDialogInfoItem.StiGuidRangeDialogInfoItem();
                    keyObject = range.getFromObject();
                    keyObjectTo = range.getToObject();
                }
                item.KeyObject = keyObject;
                item.KeyObjectTo = keyObjectTo;
            }
            catch (Exception exception) {
                // empty catch block
            }
            item.setValue(this.values.size() > index && this.values.get(index) != null && !StiValidationUtil.isNullOrEmpty((String)this.values.get(index)) ? this.values.get(index) : "");
            item.checked = this.checkedStates != null && this.checkedStates.size() > index ? this.checkedStates.get(index) : true;
            item.ValueBinding = this.valuesBindingList.length > index ? this.valuesBindingList[index] : null;
            items.add(item);
            ++index;
        }
        return this.orderBy(items);
    }

    @StiSerializable
    public StiVariable getBindingVariable() {
        return this.bindingVariable;
    }

    public void setBindingVariable(StiVariable bindingVariable) {
        this.bindingVariable = bindingVariable;
    }

    public void setDialogInfoItems(List<StiDialogInfoItem> items, StiSystemType type) {
        if (items == null || items.size() == 0) {
            this.keys = null;
            this.values = null;
            this.checkedStates = null;
            return;
        }
        this.keys = new ArrayList<String>();
        this.values = new ArrayList<String>();
        this.checkedStates = new ArrayList<Boolean>();
        this.valuesBindingList = new List[items.size()];
        int index = 0;
        for (StiDialogInfoItem item : items) {
            Object keyObject = null;
            try {
                if (item instanceof StiDialogInfoItem.StiExpressionDialogInfoItem) {
                    keyObject = String.format("{%s}", item.KeyObject);
                } else if (item instanceof StiDialogInfoItem.StiExpressionRangeDialogInfoItem) {
                    keyObject = String.format("%s<<|>>%s", item.KeyObject, item.KeyObjectTo);
                } else if (item instanceof StiDialogInfoItem.StiLongDialogInfoItem || item instanceof StiDialogInfoItem.StiDoubleDialogInfoItem || item instanceof StiDialogInfoItem.StiDecimalDialogInfoItem || item instanceof StiDialogInfoItem.StiDateTimeDialogInfoItem || item instanceof StiDialogInfoItem.StiTimeSpanDialogInfoItem || item instanceof StiDialogInfoItem.StiBoolDialogInfoItem || item instanceof StiDialogInfoItem.StiCharDialogInfoItem || item instanceof StiDialogInfoItem.StiGuidDialogInfoItem || item instanceof StiDialogInfoItem.StiStringDialogInfoItem) {
                    keyObject = item.KeyObject.toString();
                } else if (item instanceof StiDialogInfoItem.StiImageDialogInfoItem) {
                    keyObject = ((StiImage)item.KeyObject).getImageBytesToDraw();
                } else if (item instanceof StiDialogInfoItem.StiLongRangeDialogInfoItem || item instanceof StiDialogInfoItem.StiDoubleRangeDialogInfoItem || item instanceof StiDialogInfoItem.StiDecimalRangeDialogInfoItem || item instanceof StiDialogInfoItem.StiDateTimeRangeDialogInfoItem || item instanceof StiDialogInfoItem.StiTimeSpanRangeDialogInfoItem || item instanceof StiDialogInfoItem.StiCharRangeDialogInfoItem || item instanceof StiDialogInfoItem.StiGuidRangeDialogInfoItem || item instanceof StiDialogInfoItem.StiStringRangeDialogInfoItem) {
                    ByteRange range = null;
                    switch (type.getEnumType()) {
                        case SystemByte: {
                            range = new ByteRange();
                            break;
                        }
                    }
                    range.Parse(item.KeyObject.toString(), item.KeyObjectTo.toString());
                    keyObject = range.serialize();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.keys.add(keyObject == null ? "" : keyObject.toString());
            this.values.add(item.Value);
            this.checkedStates.add(item.checked);
            this.valuesBindingList[index] = item.ValueBinding;
            ++index;
        }
    }

    public List<StiDialogInfoItem> orderBy(List<StiDialogInfoItem> items) {
        switch (this.sortField) {
            case Key: {
                if (this.sortDirection == StiVariableSortDirection.Asc) {
                    Collections.sort(items, new Comparator<StiDialogInfoItem>(){

                        @Override
                        public int compare(StiDialogInfoItem o1, StiDialogInfoItem o2) {
                            if (o1 != null && o2 != null && o1.KeyObject instanceof Comparable && o2.KeyObject instanceof Comparable) {
                                return ((Comparable)o1.KeyObject).compareTo(o2.KeyObject);
                            }
                            return 0;
                        }
                    });
                    break;
                }
                if (this.sortDirection != StiVariableSortDirection.Desc) break;
                Collections.sort(items, new Comparator<StiDialogInfoItem>(){

                    @Override
                    public int compare(StiDialogInfoItem o1, StiDialogInfoItem o2) {
                        if (o1 != null && o2 != null && o1.KeyObject instanceof Comparable && o2.KeyObject instanceof Comparable) {
                            return ((Comparable)o2.KeyObject).compareTo(o1.KeyObject);
                        }
                        return 0;
                    }
                });
                break;
            }
            case Label: {
                if (this.sortDirection == StiVariableSortDirection.Asc) {
                    Collections.sort(items, new Comparator<StiDialogInfoItem>(){

                        @Override
                        public int compare(StiDialogInfoItem o1, StiDialogInfoItem o2) {
                            if (o1 != null && o2 != null && o1.Value != null) {
                                return o1.Value.compareTo(o2.Value);
                            }
                            return 0;
                        }
                    });
                    break;
                }
                if (this.sortDirection != StiVariableSortDirection.Desc) break;
                Collections.sort(items, new Comparator<StiDialogInfoItem>(){

                    @Override
                    public int compare(StiDialogInfoItem o1, StiDialogInfoItem o2) {
                        if (o1 != null && o2 != null && o2.Value != null) {
                            return o2.Value.compareTo(o1.Value);
                        }
                        return 0;
                    }
                });
            }
        }
        return items;
    }

    public JSONObject SaveToJsonObject() throws JSONException {
        JSONObject jObject = new JSONObject();
        jObject.AddPropertyEnum("DateTimeType", (Enum)this.getDateTimeType(), (Enum)StiDateTimeType.Date);
        jObject.AddPropertyEnum("ItemsInitializationType", (Enum)this.getItemsInitializationType(), (Enum)StiItemsInitializationType.Items);
        jObject.AddPropertyStringNullOfEmpty("KeysColumn", this.getKeysColumn());
        jObject.AddPropertyStringNullOfEmpty("ValuesColumn", this.getValuesColumn());
        jObject.AddPropertyStringNullOfEmpty("BindingValuesColumn", this.bindingValuesColumn);
        jObject.AddPropertyStringNullOfEmpty("CheckedColumn", this.checkedColumn);
        jObject.AddPropertyStringNullOfEmpty("Mask", this.getMask());
        jObject.AddPropertyBool("AllowUserValues", this.getAllowUserValues(), true);
        jObject.AddPropertyBool("BindingValue", this.bindingValue);
        jObject.AddPropertyJObject("Keys", StiJsonReportObjectHelper.Serialize.StringArray((String[])this.getKeys().toArray(new String[0])));
        jObject.AddPropertyJObject("Values", StiJsonReportObjectHelper.Serialize.StringArray((String[])this.getValues().toArray(new String[0])));
        jObject.AddPropertyEnum("SortDirection", (Enum)this.sortDirection, (Enum)StiVariableSortDirection.Asc);
        jObject.AddPropertyEnum("SortField", (Enum)this.sortField, (Enum)StiVariableSortField.Label);
        if (this.checkedStates != null) {
            jObject.AddPropertyJObject("CheckedStates", StiJsonReportObjectHelper.Serialize.boolList(this.checkedStates));
        }
        if (this.bindingVariable != null) {
            jObject.AddPropertyStringNullOfEmpty("BindingVariable", this.bindingVariable.name);
        }
        return jObject;
    }

    public void LoadFromJsonObject(JSONObject jObject, StiReport report) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("DateTimeType")) {
                this.dateTimeType = StiDateTimeType.valueOf((String)property.Value);
                continue;
            }
            if (property.Name.equals("ItemsInitializationType")) {
                this.itemsInitializationType = StiItemsInitializationType.valueOf((String)property.Value);
                continue;
            }
            if (property.Name.equals("KeysColumn")) {
                this.keysColumn = (String)property.Value;
                continue;
            }
            if (property.Name.equals("ValuesColumn")) {
                this.valuesColumn = (String)property.Value;
                continue;
            }
            if (property.Name.equals("BindingValuesColumn")) {
                this.bindingValuesColumn = (String)property.Value;
                continue;
            }
            if (property.Name.equals("Mask")) {
                this.mask = (String)property.Value;
                continue;
            }
            if (property.Name.equals("CheckedColumn")) {
                this.checkedColumn = (String)property.Value;
                continue;
            }
            if (property.Name.equals("AllowUserValues")) {
                this.allowUserValues = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("BindingValue")) {
                this.bindingValue = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("Keys")) {
                this.keys = StiJsonReportObjectHelper.Deserialize.stringList((JSONObject)((JSONObject)property.Value));
                continue;
            }
            if (property.Name.equals("Values")) {
                this.values = StiJsonReportObjectHelper.Deserialize.stringList((JSONObject)((JSONObject)property.Value));
                continue;
            }
            if (property.Name.equals("CheckedStates")) {
                this.checkedStates = StiJsonReportObjectHelper.Deserialize.boolList((JSONObject)((JSONObject)property.Value));
                continue;
            }
            if (property.Name.equals("BindingVariable")) {
                this.jsonLoadedBindingVariableName = (String)property.Value;
                report.jsonLoaderHelper.DialogInfo.add(this);
                continue;
            }
            if (property.Name.equals("SortDirection")) {
                this.sortDirection = StiVariableSortDirection.valueOf((String)property.Value);
                continue;
            }
            if (!property.Name.equals("SortField")) continue;
            this.sortField = StiVariableSortField.valueOf((String)property.Value);
        }
    }
}

