/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dialogs;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.components.enums.StiReportControlToolboxPosition;
import com.stimulsoft.report.dialogs.IStiTextBoxControl;
import com.stimulsoft.report.dialogs.StiReportControl;
import com.stimulsoft.report.events.StiEvent;

public class StiTextBoxControl
extends StiReportControl
implements IStiTextBoxControl {
    private String textBinding = "";
    private boolean multiline = false;
    private boolean wordWrap = false;
    private boolean acceptsTab = false;
    private boolean acceptsReturn = false;
    private int maxLength = Short.MAX_VALUE;
    private char passwordChar = '\u0000';
    private String text = "TextBox";

    public StiTextBoxControl() {
        this(StiRectangle.empty());
    }

    public StiTextBoxControl(StiRectangle rect) {
        super(rect);
        super.setBackColor(StiColorEnum.Window.color());
        this.setPlaceOnToolbox(true);
        this.setText(this.getLocalizedName());
    }

    @Override
    public int getToolboxPosition() {
        return StiReportControlToolboxPosition.TextBoxControl.getValue();
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"Dialogs", (String)"StiTextBoxControl");
    }

    @Override
    @StiSerializable
    @StiDefaulValue(value="")
    public final String getTextBinding() {
        return this.textBinding;
    }

    @Override
    public final void setTextBinding(String value) {
        this.textBinding = value;
    }

    @Override
    public double getHeight() {
        if (!this.getMultiline()) {
            return 20.0;
        }
        return super.getHeight();
    }

    @Override
    public void setHeight(double value) {
        if (!this.getMultiline()) {
            super.setHeight(20.0);
        }
        super.setHeight(value);
    }

    @StiDefaulValue(value="false")
    @StiSerializable
    public boolean getMultiline() {
        return this.multiline;
    }

    public void setMultiline(boolean value) {
        this.multiline = value;
        this.UpdateReportControl("Multiline");
    }

    @StiDefaulValue(value="false")
    @StiSerializable
    public boolean getWordWrap() {
        return this.wordWrap;
    }

    public void setWordWrap(boolean value) {
        this.wordWrap = value;
        this.UpdateReportControl("WordWrap");
    }

    @StiDefaulValue(value="false")
    @StiSerializable
    public boolean getAcceptsTab() {
        return this.acceptsTab;
    }

    public void setAcceptsTab(boolean value) {
        this.acceptsTab = value;
        this.UpdateReportControl("AcceptsTab");
    }

    @StiDefaulValue(value="false")
    @StiSerializable
    public boolean getAcceptsReturn() {
        return this.acceptsReturn;
    }

    public void setAcceptsReturn(boolean value) {
        this.acceptsReturn = value;
        this.UpdateReportControl("AcceptsReturn");
    }

    @StiDefaulValue(value="32767")
    @StiSerializable
    public final int getMaxLength() {
        return this.maxLength;
    }

    public final void setMaxLength(int value) {
        this.maxLength = value;
        this.UpdateReportControl("MaxLength");
    }

    @StiDefaulValue(value="0")
    @StiSerializable
    public final char getPasswordChar() {
        return this.passwordChar;
    }

    public final void setPasswordChar(char value) {
        this.passwordChar = value;
        this.UpdateReportControl("PasswordChar");
    }

    @Override
    @StiSerializable
    public final String getText() {
        return this.text;
    }

    @Override
    public final void setText(String value) {
        this.text = value;
        this.UpdateReportControl("Text");
    }

    @Override
    public StiEvent GetDefaultEvent() {
        return this.getEnterEvent();
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyStringNullOfEmpty("TextBinding", this.getTextBinding());
        jObject.AddPropertyBool("Multiline", this.getMultiline());
        jObject.AddPropertyBool("WordWrap", this.getWordWrap());
        jObject.AddPropertyBool("AcceptsTab", this.getAcceptsTab());
        jObject.AddPropertyBool("AcceptsReturn", this.getAcceptsReturn());
        jObject.AddPropertyInt("MaxLength", this.getMaxLength(), Short.MAX_VALUE);
        jObject.AddPropertyStringNullOfEmpty("PasswordChar", Character.toString(this.getPasswordChar()));
        jObject.AddPropertyString("Text", this.getText());
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("TextBinding")) {
                this.textBinding = (String)property.Value;
                continue;
            }
            if (property.Name.equals("Multiline")) {
                this.multiline = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("WordWrap")) {
                this.wordWrap = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("AcceptsTab")) {
                this.acceptsTab = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("AcceptsReturn")) {
                this.acceptsReturn = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("MaxLength")) {
                this.maxLength = (Integer)property.Value;
                continue;
            }
            if (property.Name.equals("PasswordChar")) {
                String pass = (String)property.Value;
                this.passwordChar = pass.charAt(0);
                continue;
            }
            if (!property.Name.equals("Text")) continue;
            this.text = (String)property.Value;
        }
    }
}

