/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.design;

import com.stimulsoft.base.drawing.enums.StiAction;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.enums.StiMarkersStyle;
import com.stimulsoft.report.components.enums.StiQuickInfoType;
import com.stimulsoft.report.enums.StiGridMode;
import com.stimulsoft.report.enums.StiViewMode;
import com.stimulsoft.report.units.StiCentimetersUnit;
import com.stimulsoft.report.units.StiHundredthsOfInchUnit;
import com.stimulsoft.report.units.StiMillimetersUnit;
import com.stimulsoft.report.units.StiUnit;

public class StiDesignerInfo {
    private boolean alignToGrid = true;
    private int autoSaveInterval = 15;
    private boolean autoSaveReportToReportClass = false;
    private StiAction currentAction = StiAction.None;
    private boolean drawEventMarkers = true;
    private boolean drawMarkersWhenMoving = true;
    private boolean enableAutoSaveMode = false;
    private boolean fillBands = true;
    private boolean fillComponent = true;
    private boolean fillContainer = true;
    private boolean fillCrossBands = true;
    private boolean forceDesigningMode = false;
    private boolean generateLocalizedName = false;
    private StiGridMode gridMode = StiGridMode.Lines;
    private double gridSizeCentimetres = 0.2;
    private double gridSizeHundredthsOfInch = 10.0;
    private double gridSizeInch = 0.1;
    private double gridSizeMillimeters = 2.0;
    private double gridSizePixels = 8.0;
    private boolean isComponentsMoving = false;
    private boolean isTableMode = false;
    private StiMarkersStyle markersStyle = StiMarkersStyle.Corners;
    private boolean quickInfoOverlay = true;
    private StiQuickInfoType quickInfoType = StiQuickInfoType.None;
    private StiReport report;
    private boolean runDesignerAfterInsert = true;
    private boolean showDimensionLines = true;
    private boolean showGrid = true;
    private boolean showHeaders = true;
    private boolean showInteractive = true;
    private boolean showOrder = false;
    private boolean showRulers = true;
    private boolean useComponentColor = true;
    private boolean useLastFormat = true;
    private StiViewMode viewMode = StiViewMode.Normal;
    private double zoom = 0.75;
    private double pageZoom = 0.75;
    private StiComponent bookmarkComponent;
    private boolean exporting = false;

    public StiDesignerInfo() {
        this(null);
    }

    public StiDesignerInfo(StiReport report) {
        this.report = report;
    }

    public final boolean getAlignToGrid() {
        return this.alignToGrid;
    }

    public final int getAutoSaveInterval() {
        return this.autoSaveInterval;
    }

    public final boolean getAutoSaveReportToReportClass() {
        return this.autoSaveReportToReportClass;
    }

    public final StiAction getCurrentAction() {
        return this.currentAction;
    }

    public final boolean getDrawEventMarkers() {
        return this.drawEventMarkers;
    }

    public final boolean getDrawMarkersWhenMoving() {
        return this.drawMarkersWhenMoving;
    }

    public final boolean getEnableAutoSaveMode() {
        return this.enableAutoSaveMode;
    }

    public final boolean getFillBands() {
        return this.fillBands;
    }

    public final boolean getFillComponent() {
        return this.fillComponent;
    }

    public final boolean getFillContainer() {
        return this.fillContainer;
    }

    public final boolean getFillCrossBands() {
        return this.fillCrossBands;
    }

    public final boolean getForceDesigningMode() {
        return this.forceDesigningMode;
    }

    public final boolean getGenerateLocalizedName() {
        return this.generateLocalizedName;
    }

    public final StiGridMode getGridMode() {
        return this.gridMode;
    }

    public final double getGridSizeCentimetres() {
        return this.gridSizeCentimetres;
    }

    public final double getGridSizeHundredthsOfInch() {
        return this.gridSizeHundredthsOfInch;
    }

    public final double getGridSizeInch() {
        return this.gridSizeInch;
    }

    public final double getGridSizeMillimeters() {
        return this.gridSizeMillimeters;
    }

    public final double getGridSizePixels() {
        return this.gridSizePixels;
    }

    public final boolean getIsComponentsMoving() {
        return this.isComponentsMoving;
    }

    public final boolean getIsTableMode() {
        return this.isTableMode;
    }

    public final StiMarkersStyle getMarkersStyle() {
        return this.markersStyle;
    }

    public final boolean getQuickInfoOverlay() {
        return this.quickInfoOverlay;
    }

    public final StiQuickInfoType getQuickInfoType() {
        return this.quickInfoType;
    }

    public final StiReport getReport() {
        return this.report;
    }

    public final boolean getRunDesignerAfterInsert() {
        return this.runDesignerAfterInsert;
    }

    public final boolean getShowDimensionLines() {
        return this.showDimensionLines;
    }

    public final boolean getShowGrid() {
        return this.showGrid;
    }

    public final boolean getShowHeaders() {
        return this.showHeaders;
    }

    public final boolean getShowInteractive() {
        return this.showInteractive;
    }

    public final boolean getShowOrder() {
        return this.showOrder;
    }

    public final boolean getShowRulers() {
        return this.showRulers;
    }

    public final boolean getUseComponentColor() {
        return this.useComponentColor;
    }

    public final boolean getUseLastFormat() {
        return this.useLastFormat;
    }

    public final StiViewMode getViewMode() {
        return this.viewMode;
    }

    public final double getZoom() {
        return this.zoom;
    }

    public final void setAlignToGrid(boolean value) {
        this.alignToGrid = value;
    }

    public final void setAutoSaveInterval(int value) {
        this.autoSaveInterval = value;
    }

    public final void setAutoSaveReportToReportClass(boolean value) {
        this.autoSaveReportToReportClass = value;
    }

    public final void setCurrentAction(StiAction value) {
        this.currentAction = value;
    }

    public final void setDrawEventMarkers(boolean value) {
        this.drawEventMarkers = value;
    }

    public final void setDrawMarkersWhenMoving(boolean value) {
        this.drawMarkersWhenMoving = value;
    }

    public final void setEnableAutoSaveMode(boolean value) {
        this.enableAutoSaveMode = value;
    }

    public final void setFillBands(boolean value) {
        this.fillBands = value;
    }

    public final void setFillComponent(boolean value) {
        this.fillComponent = value;
    }

    public final void setFillContainer(boolean value) {
        this.fillContainer = value;
    }

    public final void setFillCrossBands(boolean value) {
        this.fillCrossBands = value;
    }

    public final void setForceDesigningMode(boolean value) {
        this.forceDesigningMode = value;
    }

    public final void setGenerateLocalizedName(boolean value) {
        this.generateLocalizedName = value;
    }

    public final void setGridMode(StiGridMode value) {
        this.gridMode = value;
    }

    public final void setGridSizeCentimetres(double value) {
        this.gridSizeCentimetres = value;
    }

    public final void setGridSizeHundredthsOfInch(double value) {
        this.gridSizeHundredthsOfInch = value;
    }

    public final void setGridSizeInch(double value) {
        this.gridSizeInch = value;
    }

    public final void setGridSizeMillimeters(double value) {
        this.gridSizeMillimeters = value;
    }

    public final void setGridSizePixels(double value) {
        this.gridSizePixels = value;
    }

    public final void setIsComponentsMoving(boolean value) {
        this.isComponentsMoving = value;
    }

    public final void setIsTableMode(boolean value) {
        this.isTableMode = value;
    }

    public final void setMarkersStyle(StiMarkersStyle value) {
        this.markersStyle = value;
    }

    public final void setQuickInfoOverlay(boolean value) {
        this.quickInfoOverlay = value;
    }

    public final void setQuickInfoType(StiQuickInfoType value) {
        this.quickInfoType = value;
    }

    public final void setReport(StiReport value) {
        this.report = value;
    }

    public final void setRunDesignerAfterInsert(boolean value) {
        this.runDesignerAfterInsert = value;
    }

    public final void setShowDimensionLines(boolean value) {
        this.showDimensionLines = value;
    }

    public final void setShowGrid(boolean value) {
        this.showGrid = value;
    }

    public final void setShowHeaders(boolean value) {
        this.showHeaders = value;
    }

    public final void setShowInteractive(boolean value) {
        this.showInteractive = value;
    }

    public final void setShowOrder(boolean value) {
        this.showOrder = value;
    }

    public final void setShowRulers(boolean value) {
        this.showRulers = value;
    }

    public final void setUseComponentColor(boolean value) {
        this.useComponentColor = value;
    }

    public final void setUseLastFormat(boolean value) {
        this.useLastFormat = value;
    }

    public final void setViewMode(StiViewMode value) {
        this.viewMode = value;
    }

    public final void setZoom(double value) {
        this.zoom = value;
    }

    public double getGridSize() {
        StiUnit unit = this.getReport().getUnit();
        if (unit instanceof StiMillimetersUnit) {
            return this.getReport().getInfo().gridSizeMillimeters;
        }
        if (unit instanceof StiCentimetersUnit) {
            return this.getReport().getInfo().gridSizeCentimetres;
        }
        if (unit instanceof StiHundredthsOfInchUnit) {
            return this.getReport().getInfo().gridSizeHundredthsOfInch;
        }
        return this.getReport().getInfo().gridSizeInch;
    }

    public double getPageZoom() {
        return this.pageZoom;
    }

    public void setPageZoom(double pageZoom) {
        this.pageZoom = pageZoom;
    }

    public Boolean isBookmarked(StiComponent component) {
        return this.bookmarkComponent != null && this.bookmarkComponent.equals(component);
    }

    public StiComponent getBookmarkComponent() {
        return this.bookmarkComponent;
    }

    public void setBookmarkComponent(StiComponent bookmarkComponent) {
        this.bookmarkComponent = bookmarkComponent;
    }

    public boolean isExporting() {
        return this.exporting;
    }

    public void setExporting(boolean exporting) {
        this.exporting = exporting;
    }
}

