/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.crossTab.core;

import com.stimulsoft.base.DBNull;
import com.stimulsoft.base.EventArgs;
import com.stimulsoft.base.utils.StiConvertHelper;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiBase;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentsCollection;
import com.stimulsoft.report.components.StiCrossHeaderInteraction;
import com.stimulsoft.report.components.simplecomponents.StiSimpleText;
import com.stimulsoft.report.components.textFormats.StiFormatService;
import com.stimulsoft.report.components.textFormats.StiGeneralFormatService;
import com.stimulsoft.report.crossTab.StiCrossColumn;
import com.stimulsoft.report.crossTab.StiCrossField;
import com.stimulsoft.report.crossTab.StiCrossHeader;
import com.stimulsoft.report.crossTab.StiCrossRow;
import com.stimulsoft.report.crossTab.StiCrossSummary;
import com.stimulsoft.report.crossTab.StiCrossSummaryHeader;
import com.stimulsoft.report.crossTab.StiCrossTab;
import com.stimulsoft.report.crossTab.StiCrossTitle;
import com.stimulsoft.report.crossTab.StiCrossTotal;
import com.stimulsoft.report.crossTab.core.StiCell;
import com.stimulsoft.report.crossTab.core.StiColumn;
import com.stimulsoft.report.crossTab.core.StiColumnCollection;
import com.stimulsoft.report.crossTab.core.StiGrid;
import com.stimulsoft.report.crossTab.core.StiRow;
import com.stimulsoft.report.crossTab.core.StiRowCollection;
import com.stimulsoft.report.crossTab.core.StiSummary;
import com.stimulsoft.report.crossTab.core.StiSummaryContainer;
import com.stimulsoft.report.crossTab.core.enums.StiEnumeratorType;
import com.stimulsoft.report.crossTab.core.enums.StiFieldType;
import com.stimulsoft.report.crossTab.core.enums.StiSortDirection;
import com.stimulsoft.report.crossTab.core.enums.StiSummaryDirection;
import com.stimulsoft.report.crossTab.core.enums.StiSummaryType;
import com.stimulsoft.report.crossTab.core.summaries.StiAverage;
import com.stimulsoft.report.crossTab.core.summaries.StiCount;
import com.stimulsoft.report.crossTab.core.summaries.StiCountDistinct;
import com.stimulsoft.report.crossTab.core.summaries.StiImage;
import com.stimulsoft.report.crossTab.core.summaries.StiMax;
import com.stimulsoft.report.crossTab.core.summaries.StiMin;
import com.stimulsoft.report.crossTab.core.summaries.StiNone;
import com.stimulsoft.report.crossTab.core.summaries.StiSum;
import com.stimulsoft.report.crossTab.core.summaries.StiSummaries;
import com.stimulsoft.report.dictionary.data.DataCell;
import com.stimulsoft.report.dictionary.data.DataRow;
import com.stimulsoft.report.dictionary.data.DataTable;
import com.stimulsoft.report.engine.engineV2.builders.StiCrossTabV2Builder;
import com.stimulsoft.report.engine.parser.StiParser;
import com.stimulsoft.report.events.StiGetValueEventArgs;
import java.awt.Rectangle;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;

public class StiCross
extends StiGrid {
    public static final String EMPTY_FIELD = "EMPTY_FIELD";
    private static final String STR_NULL = "";
    public StiCrossTab crossTab;
    private int oneCellSize;
    private int oneCellWidth;
    private int oneCellHeight;
    private StiSummaryDirection summaryDirection = StiSummaryDirection.LeftToRight;
    private int colsHeaderHeight;
    private int rowsHeaderWidth;
    private int widthCorrection;
    private int heightCorrection;
    private int colsWidth;
    private int rowsHeight;
    private final Hashtable<Integer, StiCrossField> columnsCell = new Hashtable();
    private final Hashtable<Integer, StiCrossField> rowsCell = new Hashtable();
    private final StiRowCollection rows = new StiRowCollection();
    private final StiColumnCollection cols = new StiColumnCollection();
    private StiComponentsCollection colTitleFields;
    private StiComponentsCollection rowTitleFields;
    private StiComponentsCollection rowFields;
    public StiComponentsCollection colFields;
    private StiComponentsCollection sumFields;
    private StiComponentsCollection sumHeaderFields;
    private StiSummaryContainer summaryContainer;
    public StiCrossTitle leftCrossTitle;
    public StiCrossTitle rightCrossTitle;
    public StiCrossTitle summaryCrossTitle;

    private void AddRowTotal(StiRowCollection rows, int level, int maxLevel, int setLevel) {
        while (true) {
            StiRow row = new StiRow(STR_NULL, STR_NULL);
            row.setIsTotal(true);
            row.setLevel(setLevel);
            StiGetValueEventArgs e = new StiGetValueEventArgs();
            StiCrossTotal total = ((StiCrossRow)this.getRowFields().get(setLevel)).getTotal();
            if (total != null) {
                total.InvokeGetValue(total, e);
            }
            row.setDisplayValue(e.getValue());
            rows.add(row);
            if (++level >= maxLevel) {
                return;
            }
            rows = rows.getItem(rows.size() - 1).getRows();
        }
    }

    public boolean isTopCrossTitleVisible() {
        return !this.getIsRowsEmpty() && this.isCrossTitleEnabled();
    }

    public boolean isLeftCrossTitleVisible() {
        return !this.isTopCrossTitleVisible() && this.isCrossTitleEnabled();
    }

    public boolean isCrossTitleEnabled() {
        return this.leftCrossTitle != null && this.leftCrossTitle.getEnabled() && this.rightCrossTitle != null && this.rightCrossTitle.getEnabled() || this.getSummaryCrossTitle() != null && this.summaryCrossTitle.getEnabled();
    }

    public boolean isCrossTitlePrintOnAllPages() {
        return this.leftCrossTitle != null && this.leftCrossTitle.getPrintOnAllPages() && this.rightCrossTitle != null && this.rightCrossTitle.getPrintOnAllPages() || this.summaryCrossTitle != null && this.summaryCrossTitle.getPrintOnAllPages();
    }

    private void AddColTotal(StiColumnCollection cols, int level, int maxLevel, int setLevel) {
        while (true) {
            StiColumn col = new StiColumn(STR_NULL, STR_NULL);
            col.setIsTotal(true);
            col.setLevel(setLevel);
            StiGetValueEventArgs e = new StiGetValueEventArgs();
            StiCrossTotal total = ((StiCrossColumn)this.getColFields().get(setLevel)).getTotal();
            if (total != null) {
                total.InvokeGetValue(total, e);
            }
            col.setDisplayValue(e.getValue());
            cols.add(col);
            if (++level >= maxLevel) {
                return;
            }
            cols = cols.getItem(cols.size() - 1).getCols();
        }
    }

    private void SortRows() {
        this.SortRows(this.getRows(), 0, this.GetRowsHeaderWidth());
    }

    private void SortRows(StiRowCollection rows, int level, int width) {
        StiComponent tempVar;
        StiSortDirection sortDirection;
        for (StiRow row : rows) {
            this.SortRows(row.getRows(), level + 1, width);
        }
        if (level < width && (sortDirection = ((StiCrossRow)((tempVar = (StiComponent)this.getRowFields().get(level)) instanceof StiCrossRow ? tempVar : null)).getSortDirection()) != StiSortDirection.None) {
            StiComponent tempVar2 = (StiComponent)this.getRowFields().get(level);
            rows.Sort(sortDirection, ((StiCrossRow)(tempVar2 instanceof StiCrossRow ? tempVar2 : null)).getSortType());
        }
    }

    private void SortCols() {
        this.SortCols(this.getCols(), 0, this.GetColsHeaderHeight());
    }

    private void SortCols(StiColumnCollection cols, int level, int height) {
        StiComponent tempVar;
        StiSortDirection sortDirection;
        for (StiColumn col : cols) {
            this.SortCols(col.getCols(), level + 1, height);
        }
        if (level < height && (sortDirection = ((StiCrossColumn)((tempVar = (StiComponent)this.getColFields().get(level)) instanceof StiCrossColumn ? tempVar : null)).getSortDirection()) != StiSortDirection.None) {
            StiComponent tempVar2 = (StiComponent)this.getColFields().get(level);
            cols.Sort(sortDirection, ((StiCrossColumn)(tempVar2 instanceof StiCrossColumn ? tempVar2 : null)).getSortType());
        }
    }

    private void CreateRowTotals() {
        int maxLevel = this.GetRowsHeaderWidth();
        if (maxLevel > 0) {
            this.CreateRowTotals(this.getRows(), 0, maxLevel);
        }
    }

    private void CreateRowTotals(StiRowCollection rows, int level, int maxLevel) {
        if (rows.size() > 0) {
            StiCrossRow prevField;
            for (StiRow row : rows) {
                this.CreateRowTotals(row.getRows(), level + 1, maxLevel);
            }
            StiCrossRow curField = (StiCrossRow)this.getRowFields().get(level);
            StiCrossRow stiCrossRow = prevField = level == 0 ? null : (StiCrossRow)this.getRowFields().get(level - 1);
            if (this.allowTotal(curField, prevField)) {
                this.AddRowTotal(rows, level, maxLevel, level);
            }
        }
    }

    private void CreateColTotals() {
        int maxLevel = this.GetColsHeaderHeight();
        if (maxLevel > 0) {
            this.CreateColTotals(this.getCols(), 0, maxLevel);
        }
    }

    private void CreateColTotals(StiColumnCollection cols, int level, int maxLevel) {
        if (cols.size() > 0) {
            StiCrossColumn prevField;
            for (StiColumn col : cols) {
                this.CreateColTotals(col.getCols(), level + 1, maxLevel);
            }
            StiCrossColumn curField = (StiCrossColumn)this.getColFields().get(level);
            StiCrossColumn stiCrossColumn = prevField = level == 0 ? null : (StiCrossColumn)this.getColFields().get(level - 1);
            if (this.allowTotal(curField, prevField)) {
                this.AddColTotal(cols, level, maxLevel, level);
            }
        }
    }

    private Object GetDataFromDataRow(DataRow dataRow, String field) {
        if (dataRow == null) {
            return STR_NULL;
        }
        DataCell dataCell = dataRow.getCell(field);
        if (dataCell != null && dataCell.isNotEmpty()) {
            return dataCell.getValue();
        }
        return STR_NULL;
    }

    private boolean allowTotal(StiCrossHeader row, StiCrossHeader prevRow) {
        if (row == null) {
            return false;
        }
        if (prevRow != null) {
            StiCrossHeaderInteraction interaction;
            StiCrossHeaderInteraction stiCrossHeaderInteraction = interaction = prevRow.getInteraction() instanceof StiCrossHeaderInteraction ? (StiCrossHeaderInteraction)prevRow.getInteraction() : null;
            if (interaction != null && interaction.getCollapsingEnabled()) {
                return false;
            }
        }
        return row.isTotalVisible();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object GetValueFromDataRow(DataRow dataRow, StiCrossSummary field) {
        if (dataRow == null) {
            return null;
        }
        Object value = dataRow.getValue(field.getName());
        StiSummaryType summaryType = field.getSummary();
        if (summaryType == StiSummaryType.Image) {
            return value;
        }
        if (summaryType == StiSummaryType.Count) {
            return value;
        }
        if (summaryType == StiSummaryType.CountDistinct) {
            return value;
        }
        if (summaryType == StiSummaryType.None) {
            if (value instanceof Date || value instanceof Calendar || value instanceof ZonedDateTime) {
                return value;
            }
            if (!field.getHideZeros()) {
                return value;
            }
            BigDecimal valueObj = new BigDecimal(0);
            if (value instanceof String) {
                String text = (String)(value instanceof String ? value : null);
                boolean isDigit = false;
                for (int index = 0; index < text.length(); ++index) {
                    if (!Character.isDigit(text.charAt(index))) continue;
                    isDigit = true;
                    break;
                }
                if (!isDigit) return value;
                text = text.replace(".", ",").replace(',', StiConvertHelper.DECIMAL_SEPARATOR).replace(" ", STR_NULL);
                try {
                    valueObj = new BigDecimal(text);
                }
                catch (Exception e) {
                    return value;
                }
            } else {
                valueObj = value != null && StiValidationUtil.isNotNullOrEmpty((String)value.toString()) ? new BigDecimal(value.toString()) : new BigDecimal(0);
            }
            if (valueObj.doubleValue() != 0.0) return value;
            return STR_NULL;
        }
        if (value instanceof String) {
            String text = (String)(value instanceof String ? value : null);
            if (text == null || text.length() == 0) {
                return null;
            }
            text = text.replace(",", ".");
            try {
                return new BigDecimal(text);
            }
            catch (Exception e) {
                return 0.0;
            }
        }
        if (value instanceof Date) {
            return value;
        }
        if (value == null) {
            return 0;
        }
        if (value == DBNull.Value) {
            return 0;
        }
        try {
            double dValue = Double.parseDouble(value.toString());
            if (dValue != (double)((int)dValue)) return value;
            return (int)dValue;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    private StiRow GetRow(DataRow dataRow) {
        StiRowCollection curRows = this.getRows();
        StiRow selectedRow = null;
        boolean split = false;
        int level = 0;
        for (StiComponent rowField : this.rowFields) {
            Object value = STR_NULL;
            Object displayValue = STR_NULL;
            if (!rowField.getName().equals(EMPTY_FIELD)) {
                value = this.GetDataFromDataRow(dataRow, rowField.getName());
                displayValue = this.GetDataFromDataRow(dataRow, "Display__" + rowField.getName());
            }
            if (split) {
                value = "all";
                displayValue = "all";
            }
            if (curRows.getItem(value) == null) {
                curRows.createRowAndAdd(value, displayValue);
            }
            selectedRow = curRows.getItem(value);
            split = rowField instanceof StiCrossHeader && StiCrossTabV2Builder.isCollapsed((StiCrossHeader)rowField, level, value.toString());
            curRows = selectedRow.getRows();
            ++level;
        }
        return selectedRow;
    }

    private StiColumn GetColumn(DataRow dataRow) {
        StiColumnCollection curCols = this.getCols();
        StiColumn selectedCol = null;
        boolean split = false;
        int level = 0;
        for (StiComponent colField : this.colFields) {
            Object value = STR_NULL;
            Object displayValue = STR_NULL;
            if (!colField.getName().equals(EMPTY_FIELD)) {
                value = this.GetDataFromDataRow(dataRow, colField.getName());
                displayValue = this.GetDataFromDataRow(dataRow, "Display__" + colField.getName());
            }
            if (split) {
                value = "all";
                displayValue = "all";
            }
            if (curCols.getItem(value) == null) {
                curCols.createRowAndAdd(value, displayValue);
            }
            selectedCol = curCols.getItem(value);
            split = colField instanceof StiCrossHeader && StiCrossTabV2Builder.isCollapsed((StiCrossHeader)colField, level, value);
            curCols = selectedCol.getCols();
            ++level;
        }
        return selectedCol;
    }

    private void CalculateDataTable(DataTable table) {
        if (table == null || table.getRows().size() == 0) {
            this.CalculateDataRow(null);
        } else if (this.crossTab.getDataSource() != null) {
            int resPosition = this.crossTab.getDataSource().getPosition();
            int index = 0;
            for (DataRow dataRow : table.getRows()) {
                this.crossTab.getDataSource().setPosition(index++);
                this.CalculateDataRow(dataRow);
            }
            this.crossTab.getDataSource().setPosition(resPosition);
        } else if (this.crossTab.getBusinessObject() != null) {
            int resPosition = this.crossTab.getBusinessObject().getPosition();
            int index = 0;
            for (DataRow dataRow : table.getRows()) {
                this.crossTab.getBusinessObject().setPosition(index++);
                this.CalculateDataRow(dataRow);
            }
            this.crossTab.getBusinessObject().setPosition(resPosition);
        }
    }

    private void CalculateDataRow(DataRow dataRow) {
        StiRow row = this.GetRow(dataRow);
        StiColumn col = this.GetColumn(dataRow);
        StiSummary summary = this.getSummaryContainer().GetSummary(col, row);
        int index = 0;
        for (StiComponent field : this.sumFields) {
            if (field.getName().equals(EMPTY_FIELD)) continue;
            Object summaryValue = this.GetValueFromDataRow(dataRow, (StiCrossSummary)field);
            summary.getSums()[index].add(summaryValue);
            this.InvokeEvents(field);
            summary.getHyperlinkValues()[index] = field.getHyperlinkValue();
            summary.getToolTipValues()[index] = field.getToolTipValue();
            summary.getTagValues()[index] = field.getTagStrValue();
            if (field.getDrillDownParameters() != null) {
                if (summary.getDrillDownParameters() == null) {
                    summary.setDrillDownParameters(new HashMap[summary.getTagValues().length]);
                }
                summary.getDrillDownParameters()[index] = field.getDrillDownParameters();
            }
            ++index;
        }
        for (StiComponent field : this.rowFields) {
            if (field.getName().equals(EMPTY_FIELD)) continue;
            this.InvokeEvents(field);
            row.setHyperlinkValue(field.getHyperlinkValue());
            row.setToolTipValue(field.getToolTipValue());
            row.setTagValue(field.getTagStrValue());
            if (field.getDrillDownParameters() == null) continue;
            if (row.getDrillDownParameters() == null) {
                row.setDrillDownParameters(new HashMap<String, Object>());
            }
            row.setDrillDownParameters(field.getDrillDownParameters());
        }
        for (StiComponent field : this.colFields) {
            if (field.getName().equals(EMPTY_FIELD)) continue;
            this.InvokeEvents(field);
            col.setHyperlinkValue(field.getHyperlinkValue());
            col.setToolTipValue(field.getToolTipValue());
            col.setTagValue(field.getTagStrValue());
            if (field.getDrillDownParameters() == null) continue;
            if (col.getDrillDownParameters() == null) {
                col.setDrillDownParameters(new HashMap<String, Object>());
            }
            col.setDrillDownParameters(field.getDrillDownParameters());
        }
    }

    private int CopyRows(StiRowCollection rows, int left, int top, int level, Object emptyValue) {
        int rowCount = 0;
        for (StiRow row : rows) {
            int curRowCount = this.CopyRows(row.getRows(), left + 1, top, level + 1, emptyValue);
            StiCrossField field = (StiCrossField)this.getRowFields().get(level);
            rowCount += curRowCount;
            int totalWidth = 1;
            if (StiCrossTabV2Builder.isCollapsed((StiCrossHeader)field, level, row.getValueStr())) {
                StiRow selectedRow = row;
                while (selectedRow.getRows().size() != 0) {
                    ++totalWidth;
                    selectedRow = (StiRow)selectedRow.getRows().get(0);
                }
            }
            Rectangle rect = new Rectangle(left, top, totalWidth, curRowCount);
            if (row.getIsTotal()) {
                rect.width = this.rowsHeaderWidth + this.widthCorrection - rect.x - (this.getIsSummarySubHeadersPresent() && this.summaryDirection == StiSummaryDirection.UpToDown ? 1 : 0);
                field = ((StiCrossHeader)field).getTotal();
            }
            String str = row.getDisplayValue() == null ? STR_NULL : field.getTextFormat().Format(row.getDisplayValue(), field.getReport() != null ? field.getReport().getLocale() : null);
            this.InvokeEvents(field, str);
            boolean isNumeric = false;
            if (field != null && field instanceof StiCrossRow && !(field.getTextFormat() instanceof StiGeneralFormatService)) {
                isNumeric = true;
            }
            if (field.getMergeHeaders() || this.getReport().getIsDesigning()) {
                this.SetCell(rect.x, rect.y, rect.width, rect.height, str, str, field, isNumeric, row.getHyperlinkValue(), row.getToolTipValue(), row.getTagValue(), row.getDrillDownParameters(), level, null, null, field instanceof StiCrossRow ? ((StiCrossRow)field).isKeepMergedCellsTogether() : false);
            } else {
                for (int index = 0; index < rect.height; ++index) {
                    this.SetCell(rect.x, rect.y + index, rect.width, 1, str, str, field, isNumeric, row.getHyperlinkValue(), row.getToolTipValue(), row.getTagValue(), row.getDrillDownParameters(), level, null, null, field instanceof StiCrossRow ? ((StiCrossRow)field).isKeepMergedCellsTogether() : false);
                }
            }
            top += rect.height;
        }
        return Math.max(rowCount, this.oneCellHeight);
    }

    private void InvokeEvents(StiComponent component, String displayValue) {
        Object parserResult;
        if (component.getHyperlink().getValue().length() > 0) {
            parserResult = StiParser.ParseTextValue(component.getHyperlink().getValue(), component);
            component.setHyperlinkValue(this.getReport().ToString(parserResult));
        }
        if (component.getToolTip().getValue().length() > 0) {
            parserResult = StiParser.ParseTextValue(component.getToolTip().getValue(), component);
            component.setToolTipValue(this.getReport().ToString(parserResult));
        }
        if (component.getTag().getValue().length() > 0) {
            parserResult = StiParser.ParseTextValue(component.getTag().getValue(), component);
            component.setTagValue(this.getReport().ToString(parserResult));
        }
        component.InvokeBeforePrint(component, EventArgs.Empty);
        component.InvokeAfterPrint(component, EventArgs.Empty);
    }

    private int CopyCols(StiColumnCollection cols, int left, int top, int level, Object emptyValue) {
        int colCount = 0;
        for (StiColumn col : cols) {
            int curColCount = this.CopyCols(col.getCols(), left, top + 1, level + 1, emptyValue);
            StiCrossField field = (StiCrossField)this.getColFields().get(level);
            colCount += curColCount;
            int totalHeight = 1;
            if (StiCrossTabV2Builder.isCollapsed((StiCrossHeader)field, level, col.getValueStr())) {
                StiColumn selectedCol = col;
                while (selectedCol.getCols().size() != 0) {
                    ++totalHeight;
                    selectedCol = (StiColumn)selectedCol.getCols().get(0);
                }
            }
            Rectangle rect = new Rectangle(left, top, curColCount, totalHeight);
            StiComponent tempVar = (StiComponent)this.getColFields().get(level);
            if (col.getIsTotal()) {
                rect.height = this.colsHeaderHeight + this.heightCorrection - rect.y;
                field = ((StiCrossHeader)field).getTotal();
            }
            String str = col.getDisplayValue() == null ? STR_NULL : field.getTextFormat().Format(col.getDisplayValue(), field.getReport() != null ? field.getReport().getLocale() : null);
            this.InvokeEvents(field, str);
            boolean isNumeric = false;
            if (field != null && field instanceof StiCrossColumn && !(field.getTextFormat() instanceof StiGeneralFormatService)) {
                isNumeric = true;
            }
            if (field.getMergeHeaders() || this.getReport().getIsDesigning()) {
                this.SetCell(rect.x, rect.y, rect.width, rect.height, str, str, field, isNumeric, col.getHyperlinkValue(), col.getToolTipValue(), col.getTagValue(), col.getDrillDownParameters(), level, null, null, false);
            } else {
                for (int index = 0; index < rect.width; ++index) {
                    this.SetCell(rect.x + index, rect.y, 1, rect.height, str, str, field, isNumeric, col.getHyperlinkValue(), col.getToolTipValue(), col.getTagValue(), col.getDrillDownParameters(), level, null, null, false);
                }
            }
            left += rect.width;
        }
        return Math.max(colCount, this.oneCellWidth);
    }

    private Object GetSummaryResult(ArrayList<Object> sums, int totalIndex, boolean grandTotal) {
        StiSummaries summary;
        StiComponent tempVar = (StiComponent)this.getSumFields().get(totalIndex);
        StiCrossSummary crossSummary = (StiCrossSummary)(tempVar instanceof StiCrossSummary ? tempVar : null);
        StiSummaryType summaryType = crossSummary.getSummary();
        if (grandTotal && (summaryType == StiSummaryType.Count || summaryType == StiSummaryType.CountDistinct)) {
            summaryType = StiSummaryType.Sum;
        }
        switch (summaryType) {
            case None: {
                summary = new StiNone(sums, totalIndex, this.getSumFields());
                break;
            }
            case Image: {
                summary = new StiImage(sums, totalIndex, this.getSumFields());
                break;
            }
            case Sum: {
                summary = new StiSum(sums, totalIndex, this.getSumFields());
                break;
            }
            case Max: {
                summary = new StiMax(sums, totalIndex, this.getSumFields());
                break;
            }
            case Min: {
                summary = new StiMin(sums, totalIndex, this.getSumFields());
                break;
            }
            case Count: {
                summary = new StiCount(sums, totalIndex, this.getSumFields());
                break;
            }
            case Average: {
                summary = new StiAverage(sums, totalIndex, this.getSumFields());
                break;
            }
            case CountDistinct: {
                summary = new StiCountDistinct(sums, totalIndex, this.getSumFields());
                break;
            }
            default: {
                throw new RuntimeException("Invalid StiSummaryType" + (Object)((Object)summaryType));
            }
        }
        return summary.calculation();
    }

    private void CopySummaries(int left, int top, Object emptyValue) {
        int sumIndex;
        Object[] sums;
        int x;
        ArrayList list;
        ArrayList rowsArray = this.GetRowsArray();
        ArrayList colsArray = this.GetColsArray();
        ArrayList[] sumsOnCell = null;
        sumsOnCell = new ArrayList[this.colsHeaderHeight * this.oneCellSize];
        for (int totalIndex = 0; totalIndex < sumsOnCell.length; ++totalIndex) {
            sumsOnCell[totalIndex] = new ArrayList();
        }
        int rowIndex = 0;
        int colIndex = 0;
        for (StiRow row : rowsArray) {
            for (int totalIndex = 0; totalIndex < sumsOnCell.length; ++totalIndex) {
                sumsOnCell[totalIndex].clear();
            }
            colIndex = 0;
            for (StiColumn col : colsArray) {
                if (col.getIsTotal()) {
                    for (int sumIndex2 = 0; sumIndex2 < this.oneCellSize; ++sumIndex2) {
                        StiCell cell2;
                        list = sumsOnCell[col.getLevel() * this.oneCellSize + sumIndex2] instanceof ArrayList ? sumsOnCell[col.getLevel() * this.oneCellSize + sumIndex2] : null;
                        Object value = this.GetSummaryResult(list, sumIndex2, true);
                        list.clear();
                        x = 0;
                        int y = 0;
                        if (this.summaryDirection == StiSummaryDirection.UpToDown) {
                            x = left + colIndex;
                            y = top + rowIndex * this.oneCellSize + sumIndex2;
                        } else {
                            x = left + colIndex * this.oneCellSize + sumIndex2;
                            y = top + rowIndex;
                        }
                        StiSummary summary = this.getSummaryContainer().GetSummary(col, row, true);
                        summary.getSums()[sumIndex2].add(value);
                        this.InvokeEvents((StiComponent)this.getSumFields().get(sumIndex2));
                        StiCell cell = this.SetCellValue(x, y, value, sumIndex2, col.getLevel(), StiFieldType.Column, ((StiComponent)this.getSumFields().get(sumIndex2)).getHyperlinkValue(), ((StiComponent)this.getSumFields().get(sumIndex2)).getToolTipValue(), ((StiComponent)this.getSumFields().get(sumIndex2)).getTagStrValue(), ((StiComponent)this.getSumFields().get(sumIndex2)).getDrillDownParameters());
                        cell.setSummaryIndex(sumIndex2);
                        cell.setIsCrossSummary(true);
                        if (((StiCrossSummary)this.sumFields.get(sumIndex2)).getSummary() == StiSummaryType.Image || ((StiCrossSummary)this.sumFields.get(sumIndex2)).getSummary() == StiSummaryType.None) {
                            cell.setValue(null);
                            cell.setText(STR_NULL);
                        }
                        BigDecimal valueTotal = new BigDecimal(0);
                        if (cell.getIsNumeric() && cell.getValue() != null) {
                            valueTotal = (BigDecimal)cell.getValue();
                        }
                        boolean showPercents = false;
                        for (int index = x - 1; index >= 0 && (cell2 = this.getCells()[index][y]).getField() instanceof StiCrossSummary; --index) {
                            BigDecimal value2 = new BigDecimal(0);
                            if (cell2.getIsNumeric()) {
                                value2 = (BigDecimal)cell2.getValue();
                            }
                            if (valueTotal.intValue() != 0 && value2.intValue() != 0) {
                                double val = value2.multiply(new BigDecimal(100)).divide(valueTotal, 2, RoundingMode.HALF_UP).doubleValue();
                                value2 = new BigDecimal(String.valueOf(val));
                            } else {
                                value2 = new BigDecimal(0);
                            }
                            if (!cell2.getIsNumeric() || !(cell2.getField() instanceof StiCrossSummary) || !((StiCrossSummary)cell2.getField()).getShowPercents()) continue;
                            cell2.setValue(value2);
                            if ((double)value2.intValue() == value2.doubleValue()) {
                                cell2.setText(String.format("%d%%", value2.intValue()));
                            } else {
                                cell2.setText(String.format("%1$s%%", value2));
                            }
                            showPercents = true;
                        }
                        if (showPercents && cell.getField() instanceof StiCrossTotal) {
                            cell.setText("100%");
                        }
                        if (!((StiCrossSummary)this.sumFields.get(sumIndex2)).getUseStyleOfSummaryInColumnTotal()) continue;
                        Object tempVar = ((StiComponent)this.getSumFields().get(sumIndex2)).clone();
                        this.SetCellField(x, y, (StiCrossField)(tempVar instanceof StiCrossField ? tempVar : null));
                    }
                } else {
                    StiSummary summary = this.getSummaryContainer().GetSummary(col, row, false);
                    sums = this.CopySummary(summary, left, top, colIndex, rowIndex, true, false, emptyValue);
                    for (int totalIndex = 0; totalIndex < this.colsHeaderHeight; ++totalIndex) {
                        for (sumIndex = 0; sumIndex < this.oneCellSize; ++sumIndex) {
                            ArrayList list2 = sumsOnCell[totalIndex * this.oneCellSize + sumIndex] instanceof ArrayList ? sumsOnCell[totalIndex * this.oneCellSize + sumIndex] : null;
                            list2.add(sums[sumIndex]);
                        }
                    }
                }
                ++colIndex;
            }
            ++rowIndex;
        }
        sumsOnCell = new ArrayList[this.rowsHeaderWidth * this.oneCellSize];
        for (int totalIndex = 0; totalIndex < sumsOnCell.length; ++totalIndex) {
            sumsOnCell[totalIndex] = new ArrayList();
        }
        colIndex = 0;
        for (StiColumn col : colsArray) {
            for (int totalIndex = 0; totalIndex < this.rowsHeaderWidth * this.oneCellSize; ++totalIndex) {
                sumsOnCell[totalIndex].clear();
            }
            rowIndex = 0;
            for (StiRow row : rowsArray) {
                if (row.getIsTotal()) {
                    for (int sumIndex3 = 0; sumIndex3 < this.oneCellSize; ++sumIndex3) {
                        list = sumsOnCell[row.getLevel() * this.oneCellSize + sumIndex3] instanceof ArrayList ? sumsOnCell[row.getLevel() * this.oneCellSize + sumIndex3] : null;
                        Object value = this.GetSummaryResult(list, sumIndex3, true);
                        list.clear();
                        x = 0;
                        int y = 0;
                        if (this.summaryDirection == StiSummaryDirection.UpToDown) {
                            x = left + colIndex;
                            y = top + rowIndex * this.oneCellSize + sumIndex3;
                        } else {
                            x = left + colIndex * this.oneCellSize + sumIndex3;
                            y = top + rowIndex;
                        }
                        this.InvokeEvents((StiComponent)this.getSumFields().get(sumIndex3));
                        StiCell cell = this.SetCellValue(x, y, value, sumIndex3, row.getLevel(), StiFieldType.Row, ((StiComponent)this.getSumFields().get(sumIndex3)).getHyperlinkValue(), ((StiComponent)this.getSumFields().get(sumIndex3)).getToolTipValue(), ((StiComponent)this.getSumFields().get(sumIndex3)).getTagStrValue(), ((StiComponent)this.getSumFields().get(sumIndex3)).getDrillDownParameters());
                        cell.setSummaryIndex(sumIndex3);
                        if (((StiCrossSummary)this.getSumFields().get(sumIndex3)).getSummary() == StiSummaryType.Image || ((StiCrossSummary)this.getSumFields().get(sumIndex3)).getSummary() == StiSummaryType.None) {
                            cell.setValue(null);
                            cell.setText(STR_NULL);
                        }
                        if (!((StiCrossSummary)this.getSumFields().get(sumIndex3)).getUseStyleOfSummaryInRowTotal()) continue;
                        Object tempVar2 = ((StiComponent)this.getSumFields().get(sumIndex3)).clone();
                        this.SetCellField(x, y, (StiCrossField)(tempVar2 instanceof StiCrossField ? tempVar2 : null));
                    }
                } else {
                    StiSummary summary = this.getSummaryContainer().GetSummary(col, row, false);
                    sums = this.CopySummary(summary, left, top, colIndex, rowIndex, false, colsArray.indexOf(col) == colsArray.size() - 1, emptyValue);
                    for (int totalIndex = 0; totalIndex < this.rowsHeaderWidth; ++totalIndex) {
                        for (sumIndex = 0; sumIndex < this.oneCellSize; ++sumIndex) {
                            ArrayList list3 = sumsOnCell[totalIndex * this.oneCellSize + sumIndex] instanceof ArrayList ? sumsOnCell[totalIndex * this.oneCellSize + sumIndex] : null;
                            list3.add(sums[sumIndex]);
                        }
                    }
                }
                ++rowIndex;
            }
            ++colIndex;
        }
    }

    private void InvokeEvents(StiComponent component) {
        Object parserResult;
        if (component.getHyperlink().getValue().length() > 0) {
            parserResult = StiParser.ParseTextValue(component.getHyperlink().getValue(), component);
            component.setHyperlinkValue(this.getReport().ToString(parserResult));
        }
        if (component.getToolTip().getValue().length() > 0) {
            parserResult = StiParser.ParseTextValue(component.getToolTip().getValue(), component);
            component.setToolTipValue(this.getReport().ToString(parserResult));
        }
        if (component.getTag().getValue().length() > 0) {
            parserResult = StiParser.ParseTextValue(component.getTag().getValue(), component);
            component.setTagValue(this.getReport().ToString(parserResult));
        }
        component.InvokeBeforePrint(component, EventArgs.Empty);
        component.InvokeAfterPrint(component, EventArgs.Empty);
    }

    private Object[] CopySummary(StiSummary summary, int left, int top, int colIndex, int rowIndex, boolean setValue, boolean grandTotal, Object emptyValue) {
        Object[] sumsOnCell = new Object[this.oneCellSize];
        for (int calcIndex = 0; calcIndex < this.oneCellSize; ++calcIndex) {
            HashMap<String, Object> drillDownParameters;
            Object value = emptyValue;
            if (summary != null) {
                sumsOnCell[calcIndex] = value = this.GetSummary(summary, calcIndex, grandTotal);
            }
            int x = 0;
            int y = 0;
            if (this.summaryDirection == StiSummaryDirection.UpToDown) {
                x = left + colIndex;
                y = top + rowIndex * this.oneCellSize + calcIndex;
            } else {
                x = left + colIndex * this.oneCellSize + calcIndex;
                y = top + rowIndex;
            }
            String hyperlinkValue = summary != null ? summary.getHyperlinkValues()[calcIndex] : null;
            String toolTipValue = summary != null ? summary.getToolTipValues()[calcIndex] : null;
            String tagValue = summary != null ? summary.getTagValues()[calcIndex] : null;
            HashMap<String, Object> hashMap = drillDownParameters = summary != null && summary.getDrillDownParameters() != null ? summary.getDrillDownParameters()[calcIndex] : null;
            if (!setValue) continue;
            StiCell cell = this.SetCellValue(x, y, value, calcIndex, 0, StiFieldType.Cell, hyperlinkValue, toolTipValue, tagValue, drillDownParameters);
            cell.setSummaryIndex(calcIndex);
        }
        return sumsOnCell;
    }

    private Object GetSummary(StiSummary summary, int calcIndex, boolean grandTotal) {
        ArrayList<Object> sums = new ArrayList<Object>();
        for (Object val : summary.getSums()[calcIndex]) {
            sums.add(val);
        }
        return this.GetSummaryResult(sums, calcIndex, grandTotal);
    }

    private StiCell SetCellValue(int x, int y, Object value, int calcIndex, int level, StiFieldType fieldType, String hyperlinkValue, String toolTipValue, String tagValue, HashMap<String, Object> drillDownParameters) {
        switch (fieldType) {
            case Column: {
                StiCrossField field = this.GetColumnTotalCell(level, calcIndex);
                String str = value == null ? STR_NULL : (value instanceof BigDecimal ? ((BigDecimal)value == BigDecimal.ZERO && field.getHideZeros() ? STR_NULL : field.getTextFormat().Format(value, field.getReport() != null ? field.getReport().getLocale() : null)) : (value instanceof Date ? (value == null && field.getHideZeros() ? STR_NULL : field.getTextFormat().Format(value, field.getReport() != null ? field.getReport().getLocale() : null)) : value.toString()));
                return this.SetCell(x, y, 1, 1, str, value, field, value instanceof BigDecimal, hyperlinkValue, toolTipValue, tagValue, drillDownParameters);
            }
            case Row: {
                StiCrossField field2 = this.GetRowTotalCell(level, calcIndex);
                String str2 = value == null ? STR_NULL : (value instanceof BigDecimal ? ((BigDecimal)value == BigDecimal.ZERO && field2.getHideZeros() ? STR_NULL : field2.getTextFormat().Format(value, field2.getReport() != null ? field2.getReport().getLocale() : null)) : (value instanceof Date ? (value == null && field2.getHideZeros() ? STR_NULL : field2.getTextFormat().Format(value, field2.getReport() != null ? field2.getReport().getLocale() : null)) : value.toString()));
                return this.SetCell(x, y, 1, 1, str2, value, field2, value instanceof BigDecimal, hyperlinkValue, toolTipValue, tagValue, drillDownParameters);
            }
            case Cell: {
                StiComponent tempVar = (StiComponent)this.getSumFields().get(calcIndex);
                StiCrossField field3 = (StiCrossField)(tempVar instanceof StiCrossField ? tempVar : null);
                String str3 = value == null ? STR_NULL : (value instanceof BigDecimal ? ((BigDecimal)value == BigDecimal.ZERO && field3.getHideZeros() ? STR_NULL : field3.getTextFormat().Format(value, field3.getReport() != null ? field3.getReport().getLocale() : null)) : (value instanceof Double ? ((Double)value == 0.0 && field3.getHideZeros() ? STR_NULL : field3.getTextFormat().Format(value, field3.getReport() != null ? field3.getReport().getLocale() : null)) : (value instanceof Date ? (value == null && field3.getHideZeros() ? STR_NULL : field3.getTextFormat().Format(value, field3.getReport() != null ? field3.getReport().getLocale() : null)) : value.toString())));
                return this.SetCell(x, y, 1, 1, str3, value, field3, value instanceof BigDecimal, hyperlinkValue, toolTipValue, tagValue, drillDownParameters);
            }
        }
        return null;
    }

    private StiCrossField GetColumnTotalCell(int level, int calcIndex) {
        StiCrossField column;
        StiCrossField stiCrossField = column = this.columnsCell.get(level * this.oneCellSize + calcIndex) instanceof StiCrossField ? this.columnsCell.get(level * this.oneCellSize + calcIndex) : null;
        if (column == null) {
            StiComponent tempVar = (StiComponent)this.getColFields().get(level);
            StiCrossHeader crossHeader = (StiCrossHeader)(tempVar instanceof StiCrossHeader ? tempVar : null);
            Object tempVar2 = crossHeader.getTotal().clone(true);
            column = (StiCrossField)(tempVar2 instanceof StiCrossField ? tempVar2 : null);
            this.columnsCell.put(level * this.oneCellSize + calcIndex, column);
            column.setHorAlignment(((StiCrossField)this.getSumFields().get(calcIndex)).getHorAlignment());
            column.setVertAlignment(((StiCrossField)this.getSumFields().get(calcIndex)).getVertAlignment());
            Object tempVar3 = ((StiCrossField)this.getSumFields().get(calcIndex)).getTextFormat().clone();
            column.setTextFormat((StiFormatService)((Object)(tempVar3 instanceof StiFormatService ? tempVar3 : null)));
        }
        return column;
    }

    private StiCrossField GetRowTotalCell(int level, int calcIndex) {
        StiCrossField row;
        StiCrossField stiCrossField = row = this.rowsCell.get(level * this.oneCellSize + calcIndex) instanceof StiCrossField ? this.rowsCell.get(level * this.oneCellSize + calcIndex) : null;
        if (row == null) {
            Object tempVar = ((StiCrossHeader)this.getRowFields().get(level)).getTotal().clone(true);
            row = (StiCrossField)(tempVar instanceof StiCrossField ? tempVar : null);
            this.rowsCell.put(level * this.oneCellSize + calcIndex, row);
            row.setHorAlignment(((StiCrossField)this.getSumFields().get(calcIndex)).getHorAlignment());
            row.setVertAlignment(((StiCrossField)this.getSumFields().get(calcIndex)).getVertAlignment());
            Object tempVar2 = ((StiCrossField)this.getSumFields().get(calcIndex)).getTextFormat().clone();
            row.setTextFormat((StiFormatService)((Object)(tempVar2 instanceof StiFormatService ? tempVar2 : null)));
        }
        return row;
    }

    private ArrayList GetRowsArray() {
        ArrayList array = new ArrayList();
        this.GetRowsArray(this.getRows(), array);
        return array;
    }

    private void GetRowsArray(StiRowCollection rows, ArrayList array) {
        for (StiRow row : rows) {
            if (row.getRows().size() == 0) {
                array.add(row);
            }
            this.GetRowsArray(row.getRows(), array);
        }
    }

    private ArrayList GetColsArray() {
        ArrayList array = new ArrayList();
        this.GetColsArray(this.getCols(), array);
        return array;
    }

    private void GetColsArray(StiColumnCollection cols, ArrayList array) {
        for (StiColumn col : cols) {
            if (col.getCols().size() == 0) {
                array.add(col);
            }
            this.GetColsArray(col.getCols(), array);
        }
    }

    private int GetRowsHeaderWidth() {
        if (this.getIsRowsEmpty()) {
            return 0;
        }
        return this.GetRowsHeaderWidth(this.getRows());
    }

    private int GetRowsHeaderWidth(StiRowCollection rows) {
        int width = 0;
        while (rows.size() > 0) {
            ++width;
            rows = rows.getItem(0).getRows();
        }
        return width;
    }

    private int GetColsHeaderHeight() {
        if (this.getIsColsEmpty()) {
            return 0;
        }
        return this.GetColsHeaderHeight(this.getCols());
    }

    private int GetColsHeaderHeight(StiColumnCollection cols) {
        int height = 0;
        while (cols.size() > 0) {
            ++height;
            cols = cols.getItem(0).getCols();
        }
        return height;
    }

    private int GetRowsHeight() {
        return this.GetRowsHeight(this.getRows(), this.GetRowsHeaderWidth(), 0);
    }

    private int GetRowsHeight(StiRowCollection rows, int maxLevel, int curLevel) {
        int rowHeight = 0;
        for (StiRow row : rows) {
            rowHeight += this.GetRowsHeight(row.getRows(), maxLevel, curLevel + 1);
            if (curLevel != maxLevel - 1) continue;
            rowHeight += this.oneCellHeight;
        }
        return rowHeight;
    }

    private int GetColsWidth() {
        return this.GetColsWidth(this.getCols(), this.GetColsHeaderHeight(), 0);
    }

    private int GetColsWidth(StiColumnCollection cols, int maxLevel, int curLevel) {
        int colWidth = 0;
        for (StiColumn col : cols) {
            colWidth += this.GetColsWidth(col.getCols(), maxLevel, curLevel + 1);
            if (curLevel != maxLevel - 1) continue;
            colWidth += this.oneCellWidth;
        }
        return colWidth;
    }

    private void EnumerateRows(StiRowCollection rows, int level) {
        StiComponent tempVar = (StiComponent)this.getRowFields().get(level);
        StiCrossRow crossRow = (StiCrossRow)(tempVar instanceof StiCrossRow ? tempVar : null);
        String separator = crossRow.getEnumeratorSeparator();
        int index = 0;
        for (StiRow row : rows) {
            if (row.getRows() != null && row.getRows().size() > 0) {
                this.EnumerateRows(row.getRows(), level + 1);
            }
            if (crossRow.getEnumeratorType() == StiEnumeratorType.None) continue;
            ++index;
            String number = null;
            if (crossRow.getEnumeratorType() == StiEnumeratorType.Arabic) {
                number = new Integer(index).toString();
            }
            row.setDisplayValue(String.format("%1$s%2$s%3$s", number, separator, row.getDisplayValue()));
        }
    }

    private void EnumerateColumns(StiColumnCollection columns, int level) {
        StiComponent tempVar = (StiComponent)this.getColFields().get(level);
        StiCrossColumn crossColumn = (StiCrossColumn)(tempVar instanceof StiCrossColumn ? tempVar : null);
        String separator = crossColumn.getEnumeratorSeparator();
        int index = 0;
        for (StiColumn column : columns) {
            if (column.getCols() != null && column.getCols().size() > 0) {
                this.EnumerateColumns(column.getCols(), level + 1);
            }
            if (crossColumn.getEnumeratorType() == StiEnumeratorType.None) continue;
            ++index;
            String number = null;
            if (crossColumn.getEnumeratorType() == StiEnumeratorType.Arabic) {
                number = new Integer(index).toString();
            }
            column.setDisplayValue(String.format("%1$s%2$s%3$s", number, separator, column.getDisplayValue()));
        }
    }

    private void CheckSeparators() {
        int newColCount = 0;
        Hashtable<StiCell, StiCell> findedCells = new Hashtable<StiCell, StiCell>();
        Hashtable<Integer, Integer> lengthOfColumn = new Hashtable<Integer, Integer>();
        boolean needProcess = false;
        for (int colIndex = 0; colIndex < this.getColCount(); ++colIndex) {
            int separatorCount = 1;
            for (int rowIndex = 0; rowIndex < this.getRowCount(); ++rowIndex) {
                StiCell cell = this.getCells()[colIndex][rowIndex];
                if (cell.getParentCell() != cell || !cell.getText().contains("#|#") || cell.getWidth() != 1) continue;
                int count = 1;
                for (int index2 = 0; index2 < cell.getText().length(); ++index2) {
                    if (index2 >= cell.getText().length() - 3 || cell.getText().charAt(index2) != '#' || cell.getText().charAt(index2 + 1) != '|' || cell.getText().charAt(index2 + 2) != '#') continue;
                    findedCells.put(cell, cell);
                    needProcess = true;
                    ++count;
                }
                separatorCount = Math.max(separatorCount, count);
            }
            lengthOfColumn.put(colIndex, separatorCount);
            newColCount += separatorCount;
        }
        if (newColCount > this.getColCount() || needProcess) {
            int oldColCount = this.getColCount();
            StiCell[][] oldCells = this.getCells();
            this.Init(newColCount, this.getRowCount());
            int newColIndex = 0;
            for (int colIndex = 0; colIndex < oldColCount; ++colIndex) {
                int length = (Integer)lengthOfColumn.get(colIndex);
                int separatorCount = 1;
                for (int rowIndex = 0; rowIndex < this.getRowCount(); ++rowIndex) {
                    StiCell oldCell = oldCells[colIndex][rowIndex];
                    if (findedCells.get(oldCell) != null && oldCell.getParentCell() == oldCell) {
                        String[] strs = oldCell.getText().split("#|#");
                        separatorCount = Math.max(separatorCount, strs.length + 1);
                        oldCell.setText(strs[0]);
                        this.getCells()[newColIndex][rowIndex] = oldCell;
                        for (int index2 = 1; index2 < strs.length; ++index2) {
                            StiCell copyCell;
                            Object tempVar = oldCell.clone();
                            this.getCells()[newColIndex + index2][rowIndex] = copyCell = (StiCell)(tempVar instanceof StiCell ? tempVar : null);
                            copyCell.setText(strs[index2]);
                        }
                        continue;
                    }
                    oldCell.getParentCell().setWidth(oldCell.getParentCell().getWidth() + length - 1);
                    this.getCells()[newColIndex][rowIndex] = oldCell;
                }
                newColIndex += length;
            }
        }
    }

    public final void Create(DataTable table, StiReport report, StiSummaryDirection direction, String emptyValue) {
        this.summaryDirection = direction;
        this.setReport(report);
        this.oneCellSize = this.getSumFields().size();
        this.oneCellWidth = this.summaryDirection == StiSummaryDirection.LeftToRight ? this.oneCellSize : 1;
        this.oneCellHeight = this.summaryDirection == StiSummaryDirection.UpToDown ? this.oneCellSize : 1;
        this.summaryContainer = new StiSummaryContainer(this.oneCellSize);
        this.getRows().clear();
        this.getCols().clear();
        this.CalculateDataTable(table);
        this.SortRows();
        this.SortCols();
        if (this.getRows().size() > 0) {
            this.EnumerateRows(this.getRows(), 0);
        }
        if (this.getCols().size() > 0) {
            this.EnumerateColumns(this.getCols(), 0);
        }
        this.CreateRowTotals();
        this.CreateColTotals();
        this.colsHeaderHeight = this.GetColsHeaderHeight();
        this.rowsHeaderWidth = this.GetRowsHeaderWidth();
        if (this.getIsSummarySubHeadersPresent()) {
            if (direction == StiSummaryDirection.LeftToRight) {
                ++this.colsHeaderHeight;
            } else {
                ++this.rowsHeaderWidth;
            }
        }
        this.colsWidth = this.GetColsWidth();
        this.rowsHeight = this.GetRowsHeight();
        int totalCellsWidth = this.colsWidth + this.rowsHeaderWidth;
        int totalCellsHeight = this.rowsHeight + this.colsHeaderHeight;
        if (this.getIsRowsEmpty()) {
            totalCellsHeight += this.oneCellHeight;
        }
        if (this.getIsColsEmpty()) {
            totalCellsWidth += this.oneCellWidth;
        }
        this.widthCorrection = 0;
        this.heightCorrection = 0;
        if (this.getIsColsEmpty() && this.getIsSummaryPresent()) {
            this.heightCorrection = 1;
        }
        if (this.getIsRowsEmpty() && this.getIsSummaryPresent()) {
            this.widthCorrection = 1;
        }
        if (this.getIsTopLinePresent()) {
            ++this.heightCorrection;
        }
        super.Init(totalCellsWidth + this.widthCorrection, totalCellsHeight + this.heightCorrection);
        if (this.getIsRowsEmpty() && this.getIsColsEmpty()) {
            return;
        }
        int index = 0;
        for (Object col : this.getColFields()) {
            StiComponent currTitle = null;
            for (StiComponent title : this.getColTitleFields()) {
                if (!((StiCrossTitle)title).getTypeOfComponent().equals("Col:" + ((StiBase)((Object)col)).getName())) continue;
                currTitle = (StiCrossTitle)title;
                break;
            }
            if (currTitle == null || !currTitle.getIsEnabled()) continue;
            int cellHeight = 1;
            int cellWidth = Math.max(this.rowsHeaderWidth, 1);
            this.InvokeEvents(currTitle);
            this.SetCell(0, index++, cellWidth, cellHeight, ((StiSimpleText)currTitle).getTextValue() != null ? ((StiSimpleText)currTitle).getTextValue() : ((StiSimpleText)currTitle).getTextInternal(), emptyValue, (StiCrossField)currTitle, false, currTitle.getHyperlinkValue(), currTitle.getToolTipValue(), currTitle.getTagStrValue(), currTitle.getDrillDownParameters());
        }
        boolean isRowTitlePresent = this.getIsRowTitlePresent();
        index = 0;
        for (StiComponent row : this.getRowFields()) {
            StiCrossTitle currTitle = null;
            for (StiComponent title : this.getRowTitleFields()) {
                if (!((StiCrossTitle)title).getTypeOfComponent().equals("Row:" + row.getName())) continue;
                currTitle = (StiCrossTitle)title;
                break;
            }
            if (currTitle == null || !isRowTitlePresent) continue;
            int cellWidth = 1;
            if (this.getIsSummarySubHeadersPresent() && direction != StiSummaryDirection.LeftToRight) {
                ++cellWidth;
            }
            int cellHeight = Math.max(this.colsHeaderHeight, 1);
            int top = this.getIsTopLinePresent() ? 1 : 0;
            this.InvokeEvents(currTitle);
            if (direction == StiSummaryDirection.LeftToRight && this.getIsColsEmpty() && this.sumFields.size() > 1) {
                ++cellHeight;
            }
            this.SetCell(index++, top, cellWidth, cellHeight, currTitle.getTextValue() != null ? currTitle.getTextValue() : currTitle.getTextInternal(), emptyValue, currTitle, false, currTitle.getHyperlinkValue(), currTitle.getToolTipValue(), currTitle.getTagValue(), currTitle.getDrillDownParameters());
        }
        if (this.getIsSummarySubHeadersPresent()) {
            StiGetValueEventArgs args;
            if (direction == StiSummaryDirection.LeftToRight) {
                int top = this.colsHeaderHeight + this.heightCorrection - 1;
                index = this.rowsHeaderWidth + this.widthCorrection;
                int summaryIndex = 0;
                int columnCount = this.colsWidth == 0 ? this.sumHeaderFields.size() : this.colsWidth;
                for (int index2 = 0; index2 < columnCount; ++index2) {
                    StiComponent tempVar = (StiComponent)this.getSumHeaderFields().get(summaryIndex);
                    StiCrossSummaryHeader header = (StiCrossSummaryHeader)(tempVar instanceof StiCrossSummaryHeader ? tempVar : null);
                    if (!this.getDesignTime()) {
                        if (header.text != null && header.text.getValue() != null) {
                            if (header.originalValue == null) {
                                header.originalValue = header.text.getValue();
                            } else {
                                header.text.setValue((String)header.originalValue);
                            }
                        }
                        args = new StiGetValueEventArgs();
                        header.InvokeGetValue(header, args);
                        header.SetTextInternal(args.getValue());
                    }
                    this.InvokeEvents(header);
                    this.SetCell(index, top, 1, 1, header.getTextValue() != null ? header.getTextValue() : header.getTextInternal(), emptyValue, header, false, header.getHyperlinkValue(), header.getToolTipValue(), header.getTagStrValue(), header.getDrillDownParameters());
                    ++index;
                    if (++summaryIndex != this.sumHeaderFields.size()) continue;
                    summaryIndex = 0;
                }
            } else {
                int left = this.rowsHeaderWidth + this.widthCorrection - 1;
                index = this.colsHeaderHeight + this.heightCorrection;
                int step = 0;
                int count = 0;
                count = this.rowsHeight == 0 ? this.getSumHeaderFields().size() : this.rowsHeight;
                for (int index2 = 0; index2 < count; ++index2) {
                    StiComponent tempVar2 = (StiComponent)this.getSumHeaderFields().get(step);
                    StiCrossSummaryHeader header = (StiCrossSummaryHeader)(tempVar2 instanceof StiCrossSummaryHeader ? tempVar2 : null);
                    if (!this.getDesignTime()) {
                        if (header.text != null && header.text.getValue() != null) {
                            if (header.originalValue == null) {
                                header.originalValue = header.text.getValue();
                            } else {
                                header.text.setValue((String)header.originalValue);
                            }
                        }
                        args = new StiGetValueEventArgs();
                        header.InvokeGetValue(header, args);
                        header.SetTextInternal(args.getValue());
                    }
                    this.InvokeEvents(header);
                    this.SetCell(left, index, 1, 1, header.getTextValue() != null ? header.getTextValue() : header.getTextInternal(), emptyValue, header, false, header.getHyperlinkValue(), header.getToolTipValue(), header.getTagValue(), header.getDrillDownParameters());
                    ++index;
                    if (++step != this.getSumHeaderFields().size()) continue;
                    step = 0;
                }
            }
        }
        if (this.getIsTopLinePresent()) {
            if (this.getIsLeftTopLinePresent()) {
                this.InvokeEvents(this.getLeftCrossTitle());
                this.SetCell(0, 0, this.rowsHeaderWidth, 1, this.getLeftCrossTitle().getTextValue() != null ? this.getLeftCrossTitle().getTextValue() : this.getLeftCrossTitle().getTextInternal(), emptyValue, this.getLeftCrossTitle(), false, this.getLeftCrossTitle().getHyperlinkValue(), this.getLeftCrossTitle().getToolTipValue(), this.getLeftCrossTitle().getTagValue(), this.getLeftCrossTitle().getDrillDownParameters());
            }
            if (this.getIsRightTopLinePresent()) {
                this.InvokeEvents(this.getRightCrossTitle());
                this.SetCell(this.rowsHeaderWidth, 0, totalCellsWidth - this.rowsHeaderWidth, 1, this.getRightCrossTitle().getTextValue() != null ? this.getRightCrossTitle().getTextValue() : this.getRightCrossTitle().getTextInternal(), emptyValue, this.getRightCrossTitle(), false, this.getRightCrossTitle().getHyperlinkValue(), this.getRightCrossTitle().getToolTipValue(), this.getRightCrossTitle().getTagValue(), this.getRightCrossTitle().getDrillDownParameters());
            }
        }
        if (this.getSummaryCrossTitle() != null) {
            if (this.getIsColsEmpty()) {
                this.InvokeEvents(this.getSummaryCrossTitle());
                this.SetCell(this.rowsHeaderWidth, 0, this.oneCellWidth, 1, this.getSummaryCrossTitle().getTextValue() != null ? this.getSummaryCrossTitle().getTextValue() : this.getSummaryCrossTitle().getTextInternal(), emptyValue, this.getSummaryCrossTitle(), false, this.getSummaryCrossTitle().getHyperlinkValue(), this.getSummaryCrossTitle().getToolTipValue(), this.getSummaryCrossTitle().getTagValue(), this.getSummaryCrossTitle().getDrillDownParameters());
            }
            if (this.getIsRowsEmpty()) {
                this.InvokeEvents(this.getSummaryCrossTitle());
                int y = direction == StiSummaryDirection.LeftToRight ? this.colsHeaderHeight - 1 : this.colsHeaderHeight;
                int height = direction == StiSummaryDirection.LeftToRight ? this.oneCellHeight + 1 : this.oneCellHeight;
                this.SetCell(0, y, 1, height, this.summaryCrossTitle.getTextValue() != null ? this.summaryCrossTitle.getTextValue() : this.summaryCrossTitle.getTextInternal(), emptyValue, this.summaryCrossTitle, false, this.summaryCrossTitle.getHyperlinkValue(), this.summaryCrossTitle.getToolTipValue(), this.summaryCrossTitle.getTagValue(), this.summaryCrossTitle.getDrillDownParameters());
            }
        }
        if (!this.getIsRowsEmpty()) {
            this.CopyRows(this.getRows(), 0, this.colsHeaderHeight + this.heightCorrection, 0, emptyValue);
        }
        if (!this.getIsColsEmpty()) {
            this.CopyCols(this.getCols(), this.rowsHeaderWidth + this.widthCorrection, this.heightCorrection, 0, emptyValue);
        }
        this.CopySummaries(this.rowsHeaderWidth + this.widthCorrection, this.colsHeaderHeight + this.heightCorrection, emptyValue);
        if (!this.getDesignTime()) {
            this.CheckSeparators();
        }
        for (int colIndex = 0; colIndex < this.getColCount(); ++colIndex) {
            for (int rowIndex = 0; rowIndex < this.getRowCount(); ++rowIndex) {
                StiCell cell = this.getCells()[colIndex][rowIndex];
                if (cell.getParentCell() != cell) continue;
                if (cell.getField() instanceof StiCrossSummary && ((StiCrossSummary)cell.getField()).getSummary() == StiSummaryType.Image) {
                    cell.setIsImage(true);
                }
                if (cell.getIsNumeric() && cell.getField() != null) {
                    if (cell.getField().getHideZeros() && cell.getValue() instanceof BigDecimal && (BigDecimal)cell.getValue() == BigDecimal.ZERO) continue;
                    if (cell.getValue() != null) {
                        cell.getField().setExcelDataValue(cell.getValue().toString());
                    }
                }
                BigDecimal val = new BigDecimal(0);
                if (cell.getValue() instanceof BigDecimal) {
                    val = (BigDecimal)cell.getValue();
                }
                if (!(cell.getField() instanceof StiCrossTotal)) continue;
                cell.setField(cell.getField());
            }
        }
        if (this.getIsRowsEmpty() && !this.getIsColsEmpty() && this.getIsSummariesEmpty()) {
            double[] heights = Arrays.copyOf(this.getHeights(), this.getHeights().length - 1);
            this.setHeights(heights);
            for (int i = 0; i < this.getCells().length; ++i) {
                StiCell[] cells = this.getCells()[i];
                this.getCells()[i] = Arrays.copyOf(cells, cells.length - 1);
            }
        }
    }

    private boolean getIsSummaryPresent() {
        if (this.getReport().getIsDesigning()) {
            return true;
        }
        return this.getSummaryCrossTitle() != null && this.getSummaryCrossTitle().getEnabled();
    }

    private boolean getIsRowTitlePresent() {
        if (this.getReport().getIsDesigning()) {
            return true;
        }
        for (StiComponent row : this.getRowFields()) {
            if (row.getIsEnabled()) continue;
            return false;
        }
        return true;
    }

    private boolean getIsTopLinePresent() {
        if (this.getIsColsEmpty()) {
            return false;
        }
        if (this.getLeftCrossTitle() == null && this.getRightCrossTitle() == null) {
            return false;
        }
        if (this.getReport().getIsDesigning()) {
            return true;
        }
        return this.getLeftCrossTitle().getIsEnabled() && this.getRightCrossTitle().getEnabled();
    }

    private boolean getIsShowSummarySubHeaders() {
        if (this.getDesignTime()) {
            return true;
        }
        for (StiComponent header : this.getSumHeaderFields()) {
            if (!header.getEnabled()) continue;
            return true;
        }
        return false;
    }

    private boolean getIsSummarySubHeadersPresent() {
        return this.getSumFields().size() > 1 && this.getIsShowSummarySubHeaders() && this.getSumHeaderFields().size() > 1;
    }

    private boolean getIsLeftTopLinePresent() {
        if (!this.getIsTopLinePresent()) {
            return false;
        }
        if (this.getLeftCrossTitle() == null) {
            return false;
        }
        if (this.getReport().getIsDesigning()) {
            return true;
        }
        return this.getLeftCrossTitle().getIsEnabled();
    }

    private boolean getIsRightTopLinePresent() {
        if (!this.getIsTopLinePresent()) {
            return false;
        }
        if (this.getRightCrossTitle() == null) {
            return false;
        }
        if (this.getReport().getIsDesigning()) {
            return true;
        }
        return this.getRightCrossTitle().getIsEnabled();
    }

    public final boolean getIsRowsEmpty() {
        return this.getRowFields().size() == 1 && EMPTY_FIELD.equals(((StiComponent)this.getRowFields().get(0)).getName());
    }

    public boolean getIsSummariesEmpty() {
        return this.getSumFields().size() == 1 && EMPTY_FIELD.equals(((StiComponent)this.getSumFields().get(0)).getName());
    }

    public final boolean getIsColsEmpty() {
        return this.getColFields().size() == 1 && EMPTY_FIELD.equals(((StiComponent)this.getColFields().get(0)).getName());
    }

    public final StiRowCollection getRows() {
        return this.rows;
    }

    public final StiColumnCollection getCols() {
        return this.cols;
    }

    public final StiComponentsCollection getColTitleFields() {
        return this.colTitleFields;
    }

    public final void setColTitleFields(StiComponentsCollection value) {
        this.colTitleFields = value;
    }

    public final StiComponentsCollection getRowTitleFields() {
        return this.rowTitleFields;
    }

    public final void setRowTitleFields(StiComponentsCollection value) {
        this.rowTitleFields = value;
    }

    public final StiComponentsCollection getRowFields() {
        return this.rowFields;
    }

    public final void setRowFields(StiComponentsCollection value) {
        if (value == null || value.size() == 0) {
            if (value == null) {
                value = new StiComponentsCollection();
            } else {
                value.clear();
            }
            StiCrossRow comp = new StiCrossRow();
            comp.setName(EMPTY_FIELD);
            value.add(comp);
        }
        this.rowFields = value;
    }

    public final StiComponentsCollection getColFields() {
        return this.colFields;
    }

    public final void setColFields(StiComponentsCollection value) {
        if (value == null || value.size() == 0) {
            if (value == null) {
                value = new StiComponentsCollection();
            } else {
                value.clear();
            }
            StiCrossColumn comp = new StiCrossColumn();
            comp.setName(EMPTY_FIELD);
            value.add(comp);
        }
        this.colFields = value;
    }

    public final StiComponentsCollection getSumFields() {
        return this.sumFields;
    }

    public final void setSumFields(StiComponentsCollection value) {
        if (value == null || value.size() == 0) {
            if (value == null) {
                value = new StiComponentsCollection();
            } else {
                value.clear();
            }
            StiCrossSummary comp = new StiCrossSummary();
            comp.setName(EMPTY_FIELD);
            value.add(comp);
        }
        this.sumFields = value;
    }

    public final StiComponentsCollection getSumHeaderFields() {
        return this.sumHeaderFields;
    }

    public final void setSumHeaderFields(StiComponentsCollection value) {
        if (value == null || value.size() == 0) {
            if (value == null) {
                value = new StiComponentsCollection();
            } else {
                value.clear();
            }
            StiCrossSummaryHeader comp = new StiCrossSummaryHeader();
            comp.setName(EMPTY_FIELD);
            value.add(comp);
        }
        this.sumHeaderFields = value;
    }

    public final StiSummaryContainer getSummaryContainer() {
        return this.summaryContainer;
    }

    public final StiCrossTitle getLeftCrossTitle() {
        return this.leftCrossTitle;
    }

    public final void setLeftCrossTitle(StiCrossTitle value) {
        this.leftCrossTitle = value;
    }

    public final StiCrossTitle getRightCrossTitle() {
        return this.rightCrossTitle;
    }

    public final void setRightCrossTitle(StiCrossTitle value) {
        this.rightCrossTitle = value;
    }

    public final StiCrossTitle getSummaryCrossTitle() {
        return this.summaryCrossTitle;
    }

    public final void setSummaryCrossTitle(StiCrossTitle value) {
        this.summaryCrossTitle = value;
    }
}

