/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.crossTab.core;

import com.stimulsoft.report.crossTab.core.ColumnComparator;
import com.stimulsoft.report.crossTab.core.StiColumn;
import com.stimulsoft.report.crossTab.core.enums.StiSortDirection;
import com.stimulsoft.report.crossTab.core.enums.StiSortType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class StiColumnCollection
extends ArrayList<StiColumn> {
    private static final Comparator<StiColumn> BY_VALUE = new Comparator<StiColumn>(){

        @Override
        public int compare(StiColumn value1, StiColumn value2) {
            return value1.getValueStr().compareTo(value2.getValueStr());
        }
    };
    private static final long serialVersionUID = 5172253304251531559L;

    public StiColumn getItem(int index) {
        return (StiColumn)this.get(index);
    }

    public void Sort(StiSortDirection sortDirection, StiSortType sortType) {
        if (sortDirection != StiSortDirection.None) {
            Collections.sort(this, new ColumnComparator(sortDirection, sortType));
        }
    }

    public StiColumn getItem(String value) {
        Collections.sort(this, BY_VALUE);
        StiColumn keyInstance = new StiColumn();
        keyInstance.setValue(value);
        int index = Collections.binarySearch(this, keyInstance, BY_VALUE);
        return index >= 0 ? (StiColumn)this.get(index) : null;
    }

    public StiColumn getItem(Object value) {
        return this.getItem(value.toString());
    }

    public void createRowAndAdd(Object value, Object displayValue) {
        StiColumn column = new StiColumn(value, displayValue);
        this.add(column);
    }
}

