/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.crossTab.core;

import com.stimulsoft.report.crossTab.core.StiColumn;
import com.stimulsoft.report.crossTab.core.enums.StiSortDirection;
import com.stimulsoft.report.crossTab.core.enums.StiSortType;
import java.util.Comparator;

class ColumnComparator
implements Comparator<StiColumn> {
    private final StiSortDirection sortDirection;
    private final StiSortType sortType;

    public ColumnComparator(StiSortDirection sortDirection, StiSortType sortType) {
        this.sortDirection = sortDirection;
        this.sortType = sortType;
    }

    @Override
    public int compare(StiColumn o1, StiColumn o2) {
        Object val2;
        Object val1;
        String valueStr2;
        String valueStr1;
        switch (this.sortType) {
            case ByDisplayValue: {
                valueStr1 = o1.getDisplayValueStr();
                valueStr2 = o2.getDisplayValueStr();
                val1 = o1.getDisplayValue();
                val2 = o2.getDisplayValue();
                break;
            }
            default: {
                valueStr1 = o1.getValueStr();
                valueStr2 = o2.getValueStr();
                val1 = o1.getValue();
                val2 = o2.getValue();
            }
        }
        if (val1 == null) {
            return 1;
        }
        if (val1 instanceof Comparable && val2 instanceof Comparable) {
            int result = ((Comparable)val1).compareTo(val2);
            return this.sortDirection == StiSortDirection.Asc ? result : result * -1;
        }
        int result = valueStr1.compareTo(valueStr2);
        return this.sortDirection == StiSortDirection.Asc ? result : result * -1;
    }
}

