/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.crossTab;

import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorUtils;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiNameValidator;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiFiltersCollection;
import com.stimulsoft.report.components.bands.StiBand;
import com.stimulsoft.report.components.complexcomponents.StiContainer;
import com.stimulsoft.report.components.enums.StiComponentPriority;
import com.stimulsoft.report.components.enums.StiComponentToolboxPosition;
import com.stimulsoft.report.components.enums.StiComponentType;
import com.stimulsoft.report.components.enums.StiFilterEngine;
import com.stimulsoft.report.components.enums.StiFilterMode;
import com.stimulsoft.report.components.interfaces.IStiBusinessObject;
import com.stimulsoft.report.components.interfaces.IStiCrossTab;
import com.stimulsoft.report.components.interfaces.IStiDataRelation;
import com.stimulsoft.report.components.interfaces.IStiDataSource;
import com.stimulsoft.report.components.interfaces.IStiFilter;
import com.stimulsoft.report.components.interfaces.IStiPrintIfEmpty;
import com.stimulsoft.report.components.interfaces.IStiSort;
import com.stimulsoft.report.crossTab.StiCrossColumn;
import com.stimulsoft.report.crossTab.StiCrossField;
import com.stimulsoft.report.crossTab.StiCrossRow;
import com.stimulsoft.report.crossTab.StiCrossSummary;
import com.stimulsoft.report.crossTab.StiCrossSummaryHeader;
import com.stimulsoft.report.crossTab.StiCrossTabInfo;
import com.stimulsoft.report.crossTab.StiCrossTabInfoV1;
import com.stimulsoft.report.crossTab.StiCrossTitle;
import com.stimulsoft.report.crossTab.StiCrossTotal;
import com.stimulsoft.report.crossTab.core.enums.StiSummaryDirection;
import com.stimulsoft.report.crossTab.enums.StiCrossHorAlignment;
import com.stimulsoft.report.dictionary.StiDataRelation;
import com.stimulsoft.report.dictionary.businessObjects.StiBusinessObject;
import com.stimulsoft.report.dictionary.businessObjects.StiBusinessObjectHelper;
import com.stimulsoft.report.dictionary.dataSources.StiDataSource;
import com.stimulsoft.report.engine.StiEngineVersion;
import com.stimulsoft.report.events.StiFilterEventHandler;
import com.stimulsoft.report.options.DesignerOptions;
import com.stimulsoft.report.styles.StiCrossTabStyle;
import com.stimulsoft.report.units.StiUnit;
import java.awt.Color;
import java.util.ArrayList;

public class StiCrossTab
extends StiContainer
implements IStiDataSource,
IStiFilter,
IStiCrossTab,
IStiSort,
IStiDataRelation,
IStiPrintIfEmpty,
IStiBusinessObject {
    private boolean printIfEmpty = true;
    private String dataRelationName = "";
    private String dataSourceName = "";
    private String businessObjectGuid = "";
    private ArrayList<String> sort = new ArrayList();
    public final StiCrossTabInfo crossTabInfo = new StiCrossTabInfo();
    private final StiCrossTabInfoV1 crossTabInfoV1 = new StiCrossTabInfoV1();
    private StiFilterEngine filterEngine = StiFilterEngine.ReportEngine;
    private StiFilterMode filterMode = StiFilterMode.And;
    private StiFilterEventHandler filterMethodHandler;
    private StiFiltersCollection filters = new StiFiltersCollection();
    private boolean filterOn = true;
    private int crossTabStyleIndex = 0;
    private Object crossTabStyleColor = null;
    private StiCrossHorAlignment horAlignment = StiCrossHorAlignment.None;
    private boolean printTitleOnAllPages = true;
    private StiSummaryDirection summaryDirection = StiSummaryDirection.UpToDown;
    public boolean keepCrossTabTogether = false;
    private String emptyValue = "";
    private boolean wrap = false;
    private double wrapGap = 0.0;
    private boolean rightToLeft = false;

    public StiCrossTab() {
        this(StiRectangle.empty());
    }

    public StiCrossTab(StiRectangle rect) {
        super(rect);
        this.setPlaceOnToolbox(true);
        this.setCanGrow(true);
    }

    @Override
    public boolean isDataSourceEmpty() {
        return this.getIsDataSourceEmpty();
    }

    @Override
    public void convert(StiUnit oldUnit, StiUnit newUnit) {
        super.convert(oldUnit, newUnit);
        this.setWrapGap(newUnit.ConvertFromHInches(oldUnit.ConvertToHInches(this.getWrapGap())));
    }

    @Override
    @StiDefaulValue(value="true")
    @StiSerializable
    public boolean getPrintIfEmpty() {
        return this.printIfEmpty;
    }

    @Override
    public void setPrintIfEmpty(boolean value) {
        this.printIfEmpty = value;
    }

    @Override
    @StiDefaulValue(value="true")
    @StiSerializable
    public boolean getCanGrow() {
        return super.getCanGrow();
    }

    @Override
    public void setCanGrow(boolean value) {
        super.setCanGrow(value);
    }

    @Override
    public StiDataRelation getDataRelation() {
        if (this.getPage() == null || this.getReport() == null || this.getReport().getDictionary() == null || this.getReport().getDictionary().getRelations() == null || this.getDataRelationName() == null || this.getDataRelationName().length() == 0) {
            return null;
        }
        return this.getReport().getDictionary().getRelations().get(this.getDataRelationName());
    }

    @Override
    public boolean existDataRelation() {
        if (this.getPage() == null || this.getReport() == null || this.getReport().getDictionary() == null || this.getReport().getDictionary().getRelations() == null || this.getDataRelationName() == null || this.getDataRelationName().length() == 0) {
            return false;
        }
        return this.getReport().getDictionary().getRelations().exist(this.getDataRelationName());
    }

    @Override
    @StiSerializable
    public final String getDataRelationName() {
        return this.dataRelationName;
    }

    @Override
    public final void setDataRelationName(String value) {
        this.dataRelationName = value;
    }

    @Override
    public StiDataSource getDataSource() {
        if (this.getPage() == null || this.getReport() == null || this.getReport().getDataSources() == null || this.getDataSourceName() == null || this.getDataSourceName().length() == 0) {
            return null;
        }
        return this.getReport().getDataSources().get(this.getDataSourceName());
    }

    @Override
    @StiSerializable
    public final String getDataSourceName() {
        return this.dataSourceName;
    }

    @Override
    public final void setDataSourceName(String value) {
        this.dataSourceName = StiNameValidator.CorrectName(value);
    }

    public final boolean getIsDataSourceEmpty() {
        return this.getDataSourceName() == null || this.getDataSourceName().length() == 0 || this.getDataSource() == null;
    }

    @Override
    public final boolean getIsBusinessObjectEmpty() {
        return this.getBusinessObjectGuid() == null || this.getBusinessObjectGuid().length() == 0 || this.getBusinessObject() == null;
    }

    @Override
    public StiBusinessObject getBusinessObject() {
        if (this.getPage() == null || this.getReport() == null || this.getBusinessObjectGuid() == null || this.getBusinessObjectGuid().length() == 0) {
            return null;
        }
        return StiBusinessObjectHelper.getBusinessObjectFromGuid(this.getReport(), this.getBusinessObjectGuid());
    }

    @Override
    @StiDefaulValue(value="")
    @StiSerializable
    public final String getBusinessObjectGuid() {
        return this.businessObjectGuid;
    }

    @Override
    public final void setBusinessObjectGuid(String value) {
        if (!this.businessObjectGuid.equals(value)) {
            this.businessObjectGuid = value;
            if (!StiValidationUtil.isNullOrEmpty((String)value)) {
                this.setDataSourceName(null);
            }
        }
    }

    @Override
    @StiSerializable
    public ArrayList<String> getSort() {
        return this.sort;
    }

    @Override
    public void setSort(ArrayList<String> value) {
        this.sort = value;
    }

    @Override
    public final void First() {
        if (this.getDataSource() != null) {
            this.getDataSource().First();
        } else if (this.getBusinessObject() != null) {
            this.getBusinessObject().first();
        }
    }

    @Override
    public final void Prior() {
        if (this.getDataSource() != null) {
            this.getDataSource().Prior();
        } else if (this.getBusinessObject() != null) {
            this.getBusinessObject().prior();
        }
    }

    @Override
    public final void Next() {
        if (this.getDataSource() != null) {
            this.getDataSource().Next();
        } else if (this.getBusinessObject() != null) {
            this.getBusinessObject().next();
        }
    }

    @Override
    public final void Last() {
        if (this.getDataSource() != null) {
            this.getDataSource().Last();
        } else if (this.getBusinessObject() != null) {
            this.getBusinessObject().last();
        }
    }

    @Override
    public final boolean getIsEof() {
        if (this.getDataSource() != null) {
            return this.getDataSource().getIsEof();
        }
        if (this.getBusinessObject() != null) {
            return this.getBusinessObject().getIsEof();
        }
        return true;
    }

    @Override
    public final void setIsEof(boolean value) {
        if (this.getDataSource() != null) {
            this.getDataSource().setIsEof(value);
        } else if (this.getBusinessObject() != null) {
            this.getBusinessObject().setIsEof(value);
        }
    }

    @Override
    public final boolean getIsBof() {
        if (this.getDataSource() != null) {
            return this.getDataSource().getIsBof();
        }
        if (this.getBusinessObject() != null) {
            return this.getBusinessObject().getIsBof();
        }
        return true;
    }

    @Override
    public final void setIsBof(boolean value) {
        if (this.getDataSource() != null) {
            this.getDataSource().setIsBof(value);
        } else if (this.getBusinessObject() != null) {
            this.getBusinessObject().setIsBof(value);
        }
    }

    @Override
    public final boolean getIsEmpty() {
        if (this.getDataSource() != null) {
            return this.getDataSource().getIsEmpty();
        }
        if (this.getBusinessObject() != null) {
            return this.getBusinessObject().getIsEmpty();
        }
        return true;
    }

    @Override
    public int getPosition() {
        if (this.getDataSource() != null) {
            return this.getDataSource().getPosition();
        }
        if (this.getBusinessObject() != null) {
            return this.getBusinessObject().getPosition();
        }
        return 0;
    }

    @Override
    public void setPosition(int value) {
        if (this.getDataSource() != null) {
            this.getDataSource().setPosition(value);
        } else if (this.getBusinessObject() != null) {
            this.getBusinessObject().setPosition(value);
        }
    }

    @Override
    public int getCount() {
        if (this.getDataSource() != null) {
            return this.getDataSource().getCount();
        }
        if (this.getBusinessObject() != null) {
            return this.getBusinessObject().getSize();
        }
        return 0;
    }

    @Override
    public Object clone() {
        StiCrossTab cross = (StiCrossTab)super.clone();
        return cross;
    }

    @Override
    public void packService() {
        super.packService();
        this.filters = null;
    }

    public final StiCrossTabInfo getCrossTabInfo() {
        return this.crossTabInfo;
    }

    public final StiCrossTabInfoV1 getCrossTabInfoV1() {
        return this.crossTabInfoV1;
    }

    @StiDefaulValue(value="ReportEngine")
    @StiSerializable
    public final StiFilterEngine getFilterEngine() {
        return this.filterEngine;
    }

    public final void setFilterEngine(StiFilterEngine value) {
        this.filterEngine = value;
    }

    @Override
    @StiDefaulValue(value="And")
    @StiSerializable
    public final StiFilterMode getFilterMode() {
        return this.filterMode;
    }

    @Override
    public final void setFilterMode(StiFilterMode value) {
        this.filterMode = value;
    }

    @Override
    public final StiFilterEventHandler getFilterMethodHandler() {
        return this.filterMethodHandler;
    }

    @Override
    public final void setFilterMethodHandler(StiFilterEventHandler value) {
        this.filterMethodHandler = value;
    }

    @Override
    @StiSerializable
    public final StiFiltersCollection getFilters() {
        return this.filters;
    }

    @Override
    public final void setFilters(StiFiltersCollection value) {
        this.filters = value;
    }

    @Override
    @StiDefaulValue(value="true")
    @StiSerializable
    public boolean getFilterOn() {
        return this.filterOn;
    }

    @Override
    public void setFilterOn(boolean value) {
        this.filterOn = value;
    }

    @Override
    public boolean canContainIn(StiComponent component) {
        if (component instanceof StiCrossTab) {
            return false;
        }
        return component instanceof StiContainer;
    }

    @Override
    public String getLocalizedCategory() {
        return StiLocalization.Get((String)"Report", (String)"CrossBands");
    }

    @Override
    public int getToolboxPosition() {
        return StiComponentToolboxPosition.CrossTab.getValue();
    }

    @Override
    public int getPriority() {
        return StiComponentPriority.CrossTab.getValue();
    }

    @Override
    public StiRectangle getDefaultClientRectangle() {
        return new StiRectangle(0L, 0L, 300L, 100L);
    }

    @Override
    public StiComponentType getComponentType() {
        if (this.getReport() != null && this.getReport().getEngineVersion() == StiEngineVersion.EngineV2) {
            return StiComponentType.Simple;
        }
        if (this.getParent() instanceof StiBand) {
            return StiComponentType.Simple;
        }
        return StiComponentType.Master;
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"Components", (String)"StiCrossTab");
    }

    @StiDefaulValue(value="0")
    @StiSerializable
    public final int getCrossTabStyleIndex() {
        return this.crossTabStyleIndex;
    }

    public final void setCrossTabStyleIndex(int value) {
        if (value != this.crossTabStyleIndex) {
            if (value != -1) {
                super.setComponentStyle("");
                this.crossTabStyleColor = null;
            }
            this.crossTabStyleIndex = value >= DesignerOptions.CrossTab.getStyleColors().length ? DesignerOptions.CrossTab.getStyleColors().length - 1 : value;
            if (this.getIsDesigning() && this.getReport() != null && !this.getReport().getIsSerializing()) {
                this.UpdateStyles();
            }
        }
    }

    public final Object getCrossTabStyleColor() {
        return this.crossTabStyleColor;
    }

    public final void setCrossTabStyleColor(Object value) {
        if (this.crossTabStyleColor != value) {
            this.crossTabStyleColor = value;
        }
    }

    @StiDefaulValue(value="")
    public final String getCrossTabStyle() {
        return this.getComponentStyle();
    }

    public final void setCrossTabStyle(String value) {
        this.setComponentStyle(value);
    }

    @Override
    @StiSerializable(need=false)
    public String getComponentStyle() {
        return super.getComponentStyle();
    }

    @Override
    public void setComponentStyle(String value) {
        if (value == null) {
            value = "";
        }
        if (!super.getComponentStyle().equals(value)) {
            super.setComponentStyle(value);
            this.crossTabStyleColor = null;
            this.crossTabStyleIndex = -1;
            this.UpdateStyles();
            for (StiComponent field : this.getComponents()) {
                ((StiCrossField)field).setComponentStyle(this.getComponentStyle());
            }
        }
    }

    public final void UpdateStyles() {
        for (StiComponent field : this.getComponents()) {
            this.ApplyFieldStyle((StiCrossField)field);
        }
    }

    public final StiColor GetCellColor() {
        if (this.getCrossTabStyleColor() instanceof Color) {
            return (StiColor)this.getCrossTabStyleColor();
        }
        if (this.getCrossTabStyle() != null && this.getCrossTabStyle().length() > 0 && this.getReport() != null) {
            StiCrossTabStyle style = (StiCrossTabStyle)(this.getReport().getStyles().get(this.getCrossTabStyle()) instanceof StiCrossTabStyle ? this.getReport().getStyles().get(this.getCrossTabStyle()) : null);
            return style.getColor();
        }
        if (this.getCrossTabStyleIndex() != -1) {
            return DesignerOptions.CrossTab.getStyleColors()[this.getCrossTabStyleIndex()];
        }
        return StiColor.White;
    }

    public final void ApplyFieldStyle(StiCrossField field) {
        if (field != null) {
            field.setBrush((StiBrush)new StiSolidBrush(StiColor.White));
            field.getBorder().setColor(StiColorUtils.dark((StiColor)this.GetCellColor(), (int)100));
            if (field instanceof StiCrossTitle || field instanceof StiCrossRow || field instanceof StiCrossColumn || field instanceof StiCrossSummaryHeader) {
                field.setBrush((StiBrush)new StiSolidBrush(this.GetCellColor()));
                field.setTextBrush((StiBrush)new StiSolidBrush(StiColorUtils.dark((StiColor)this.GetCellColor(), (int)150)));
            }
            if (field instanceof StiCrossTotal) {
                field.setBrush((StiBrush)new StiSolidBrush(StiColorUtils.light((StiColor)this.GetCellColor(), (int)50)));
            }
            if (field instanceof StiCrossSummary) {
                field.setBrush((StiBrush)new StiSolidBrush(StiColorUtils.light((StiColor)this.GetCellColor(), (int)100)));
            }
        }
    }

    @StiDefaulValue(value="Center")
    @StiSerializable
    public final StiCrossHorAlignment getHorAlignment() {
        return this.horAlignment;
    }

    public final void setHorAlignment(StiCrossHorAlignment value) {
        this.horAlignment = value;
    }

    @StiDefaulValue(value="true")
    @StiSerializable
    public final boolean getPrintTitleOnAllPages() {
        return this.printTitleOnAllPages;
    }

    public final void setPrintTitleOnAllPages(boolean value) {
        this.printTitleOnAllPages = value;
    }

    @StiDefaulValue(value="UpToDown")
    @StiSerializable
    public final StiSummaryDirection getSummaryDirection() {
        return this.summaryDirection;
    }

    public final void setSummaryDirection(StiSummaryDirection value) {
        this.summaryDirection = value;
    }

    @StiDefaulValue(value="false")
    @StiSerializable
    public boolean getKeepCrossTabTogether() {
        return this.keepCrossTabTogether;
    }

    public void setKeepCrossTabTogether(boolean value) {
        this.keepCrossTabTogether = value;
    }

    @StiSerializable
    public final String getEmptyValue() {
        return this.emptyValue;
    }

    public final void setEmptyValue(String value) {
        this.emptyValue = value;
    }

    @StiDefaulValue(value="false")
    @StiSerializable
    public final boolean getWrap() {
        return this.wrap;
    }

    public final void setWrap(boolean value) {
        this.wrap = value;
    }

    @StiDefaulValue(value="0.0")
    @StiSerializable
    public final double getWrapGap() {
        return this.wrapGap;
    }

    public final void setWrapGap(double value) {
        this.wrapGap = value;
    }

    @StiDefaulValue(value="false")
    @StiSerializable
    public boolean getRightToLeft() {
        return this.rightToLeft;
    }

    public void setRightToLeft(boolean value) {
        if (this.rightToLeft != value) {
            this.CheckBlockedException("RightToLeft");
            this.rightToLeft = value;
        }
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyBool("CanGrow", this.getCanGrow(), true);
        jObject.AddPropertyBool("PrintIfEmpty", this.getPrintIfEmpty(), true);
        jObject.AddPropertyStringNullOfEmpty("DataRelationName", this.getDataRelationName());
        jObject.AddPropertyStringNullOfEmpty("DataSourceName", this.getDataSourceName());
        jObject.AddPropertyStringNullOfEmpty("BusinessObjectGuid", this.getBusinessObjectGuid());
        jObject.AddPropertyJObject("Sort", StiJsonReportObjectHelper.Serialize.StringArray(this.getSort()));
        jObject.AddPropertyEnum("FilterEngine", (Enum)this.getFilterEngine(), (Enum)StiFilterEngine.ReportEngine);
        jObject.AddPropertyEnum("FilterMode", (Enum)this.getFilterMode(), (Enum)StiFilterMode.And);
        jObject.AddPropertyJObject("Filters", this.getFilters().SaveToJsonObject(mode));
        jObject.AddPropertyBool("FilterOn", this.getFilterOn(), true);
        jObject.AddPropertyInt("CrossTabStyleIndex", this.getCrossTabStyleIndex());
        jObject.AddPropertyEnum("HorAlignment", (Enum)this.getHorAlignment(), (Enum)StiCrossHorAlignment.None);
        jObject.AddPropertyBool("PrintTitleOnAllPages", this.getPrintTitleOnAllPages(), true);
        jObject.AddPropertyEnum("SummaryDirection", (Enum)this.getSummaryDirection(), (Enum)StiSummaryDirection.UpToDown);
        jObject.AddPropertyBool("KeepCrossTabTogether", this.getKeepCrossTabTogether());
        jObject.AddPropertyStringNullOfEmpty("EmptyValue", this.getEmptyValue());
        jObject.AddPropertyBool("Wrap", this.getWrap());
        jObject.AddPropertyDouble("WrapGap", this.getWrapGap(), 0.0);
        jObject.AddPropertyBool("RightToLeft", this.getRightToLeft());
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("PrintIfEmpty")) {
                this.printIfEmpty = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("DataRelationName")) {
                this.dataRelationName = (String)property.Value;
                continue;
            }
            if (property.Name.equals("DataSourceName")) {
                this.dataSourceName = (String)property.Value;
                continue;
            }
            if (property.Name.equals("BusinessObjectGuid")) {
                this.businessObjectGuid = (String)property.Value;
                continue;
            }
            if (property.Name.equals("Sort")) {
                this.sort = StiJsonReportObjectHelper.Deserialize.stringList((JSONObject)((JSONObject)property.Value));
                continue;
            }
            if (property.Name.equals("FilterEngine")) {
                this.filterEngine = StiFilterEngine.valueOf((String)property.Value);
                continue;
            }
            if (property.Name.equals("FilterMode")) {
                this.filterMode = StiFilterMode.valueOf((String)property.Value);
                continue;
            }
            if (property.Name.equals("Filters")) {
                this.filters.LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if (property.Name.equals("FilterOn")) {
                this.filterOn = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("CrossTabStyleIndex")) {
                this.crossTabStyleIndex = (Integer)property.Value;
                continue;
            }
            if (property.Name.equals("HorAlignment")) {
                this.horAlignment = StiCrossHorAlignment.valueOf((String)property.Value);
                continue;
            }
            if (property.Name.equals("PrintTitleOnAllPages")) {
                this.printTitleOnAllPages = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("SummaryDirection")) {
                this.summaryDirection = StiSummaryDirection.valueOf((String)property.Value);
                continue;
            }
            if (property.Name.equals("KeepCrossTabTogether")) {
                this.keepCrossTabTogether = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("EmptyValue")) {
                this.emptyValue = (String)property.Value;
                continue;
            }
            if (property.Name.equals("Wrap")) {
                this.wrap = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("WrapGap")) {
                this.wrapGap = property.doubleValue();
                continue;
            }
            if (!property.Name.equals("RightToLeft")) continue;
            this.setRightToLeft((Boolean)property.Value);
        }
    }
}

