/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components.simplecomponents;

import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.helper.StiSvgHelper;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.base.utils.Base64;
import com.stimulsoft.lib.base64.StiBase64DecoderUtil;
import com.stimulsoft.lib.base64.StiBase64EncoderUtil;
import com.stimulsoft.lib.io.StiIOUtil;
import com.stimulsoft.lib.utils.StiStringUtil;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.components.simplecomponents.StiImage;
import com.stimulsoft.report.export.tools.StiImageFormat;
import com.stimulsoft.report.export.tools.StiMonochromeDitheringType;
import com.stimulsoft.report.helpers.StiFontIcons;
import com.stimulsoft.report.helpers.StiFontIconsHelper;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.PixelGrabber;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

public final class StiImageHelper {
    private static final int[][] BAYER_MATRIX = new int[][]{{1, 9, 3, 11}, {13, 5, 15, 7}, {4, 12, 2, 10}, {16, 8, 14, 6}};
    private static final Logger LOG = Logger.getLogger(StiImageHelper.class.getName());
    private static final int[] RGB_MASKS = new int[]{0xFF0000, 65280, 255};
    private static final ColorModel RGB_OPAQUE = new DirectColorModel(32, RGB_MASKS[0], RGB_MASKS[1], RGB_MASKS[2]);

    public static void saveWithDPI(BufferedImage image, File output, StiImageFormat format, int dpi, float compression) {
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(output);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        StiImageHelper.saveWithDPI(image, stream, format, (Integer)dpi, compression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveWithDPI(BufferedImage image, OutputStream output, StiImageFormat format, Integer dpi, float compression) {
        Iterator<ImageWriter> iw = ImageIO.getImageWritersByFormatName(format.name().toLowerCase());
        while (iw.hasNext()) {
            ImageWriter writer = iw.next();
            writer.reset();
            ImageWriteParam writeParam = writer.getDefaultWriteParam();
            ImageTypeSpecifier typeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(image.getType());
            IIOMetadata metadata = writer.getDefaultImageMetadata(typeSpecifier, writeParam);
            if (metadata.isReadOnly() || !metadata.isStandardMetadataFormatSupported()) continue;
            if (writeParam.canWriteCompressed() && StiImageFormat.Jpeg.equals((Object)format)) {
                writeParam.setCompressionMode(2);
                writeParam.setCompressionQuality(compression);
            }
            try {
                StiImageHelper.setDPI(metadata, dpi);
                ImageOutputStream stream = ImageIO.createImageOutputStream(output);
                try {
                    writer.setOutput(stream);
                    writer.write(metadata, new IIOImage(image, null, metadata), writeParam);
                }
                finally {
                    stream.close();
                    output.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        try {
            ImageIO.write((RenderedImage)image, format.name().toLowerCase(), output);
            output.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void setDPI(IIOMetadata metadata, Integer dpi) throws IIOInvalidTreeException {
        if (dpi == null) {
            return;
        }
        double dotsPerMilli = (double)(dpi / 10) / 2.54;
        IIOMetadataNode horiz = new IIOMetadataNode("HorizontalPixelSize");
        horiz.setAttribute("value", Double.toString(dotsPerMilli));
        IIOMetadataNode vert = new IIOMetadataNode("VerticalPixelSize");
        vert.setAttribute("value", Double.toString(dotsPerMilli));
        IIOMetadataNode dim = new IIOMetadataNode("Dimension");
        dim.appendChild(horiz);
        dim.appendChild(vert);
        IIOMetadataNode root = new IIOMetadataNode("javax_imageio_1.0");
        root.appendChild(dim);
        metadata.mergeTree("javax_imageio_1.0", root);
    }

    public static int[] imageToRasterByteArray(BufferedImage image) {
        WritableRaster raster = image.getRaster();
        return raster.getPixels(0, 0, image.getWidth(), image.getHeight(), new int[image.getWidth() * image.getHeight() * 4]);
    }

    public static BufferedImage makeGrayscaleImage(BufferedImage image) {
        BufferedImage newImage = new BufferedImage(image.getWidth(), image.getHeight(), 10);
        Graphics2D newGraphics = newImage.createGraphics();
        newGraphics.setColor(Color.WHITE);
        newGraphics.fillRect(0, 0, image.getWidth(), image.getHeight());
        newGraphics.drawImage((Image)image, 0, 0, null);
        newGraphics.dispose();
        return newImage;
    }

    public static BufferedImage makeMonochromeImage(BufferedImage inputImage, StiMonochromeDitheringType ditheringType, int diffusionPower) {
        int imageWidth = inputImage.getWidth();
        int imageHeight = inputImage.getHeight();
        WritableRaster originalRaster = inputImage.copyData(null);
        BufferedImage resultImage = new BufferedImage(imageWidth, imageHeight, 12);
        WritableRaster resultRaster = resultImage.getRaster();
        float newPixel = 0.0f;
        for (int indexY = 0; indexY < imageHeight; ++indexY) {
            for (int indexX = 0; indexX < imageWidth; ++indexX) {
                int oldPixel = originalRaster.getSample(indexX, indexY, 0);
                if (ditheringType == StiMonochromeDitheringType.None) {
                    resultRaster.setSample(indexX, indexY, 0, oldPixel > 128 ? 1 : 0);
                    continue;
                }
                if (ditheringType == StiMonochromeDitheringType.FloydSteinberg) {
                    if (oldPixel < 128) {
                        resultRaster.setSample(indexX, indexY, 0, 0);
                        newPixel = oldPixel;
                    } else {
                        resultRaster.setSample(indexX, indexY, 0, 1);
                        newPixel = oldPixel - 255;
                    }
                    if (indexX <= 0 || indexY <= 0 || indexX >= imageWidth - 1 || indexY >= imageHeight - 1) continue;
                    oldPixel = originalRaster.getSample(indexX + 1, indexY, 0);
                    originalRaster.setSample(indexX + 1, indexY, 0, StiImageHelper.clamp((float)oldPixel + 0.4375f * newPixel));
                    oldPixel = originalRaster.getSample(indexX - 1, indexY + 1, 0);
                    originalRaster.setSample(indexX - 1, indexY + 1, 0, StiImageHelper.clamp((float)oldPixel + 0.1875f * newPixel));
                    oldPixel = originalRaster.getSample(indexX, indexY + 1, 0);
                    originalRaster.setSample(indexX, indexY + 1, 0, StiImageHelper.clamp((float)oldPixel + 0.3125f * newPixel));
                    oldPixel = originalRaster.getSample(indexX + 1, indexY + 1, 0);
                    originalRaster.setSample(indexX + 1, indexY + 1, 0, StiImageHelper.clamp((float)oldPixel + 0.0625f * newPixel));
                    continue;
                }
                if (ditheringType != StiMonochromeDitheringType.Ordered) continue;
                resultRaster.setSample(indexX, indexY, 0, (float)oldPixel >= 15.0f * (float)BAYER_MATRIX[indexX & 3][indexY & 3] ? 255 : 0);
            }
        }
        return resultImage;
    }

    public static int clamp(float value) {
        return Math.min(Math.max(Math.round(value), 0), 255);
    }

    public static byte[] imageToByteArray(BufferedImage image, StiImageFormat format) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        String fmt = format.name().toLowerCase();
        if ("jpeg".equals(fmt) || "jpg".equals(fmt)) {
            PixelGrabber pg = new PixelGrabber(image, 0, 0, -1, -1, true);
            try {
                pg.grabPixels();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            int width = pg.getWidth();
            int height = pg.getHeight();
            DataBufferInt buffer = new DataBufferInt((int[])pg.getPixels(), pg.getWidth() * pg.getHeight());
            WritableRaster raster = Raster.createPackedRaster(buffer, width, height, width, RGB_MASKS, null);
            image = new BufferedImage(RGB_OPAQUE, raster, false, null);
        }
        ImageIO.write((RenderedImage)image, fmt, baos);
        baos.flush();
        byte[] result = baos.toByteArray();
        baos.close();
        return result;
    }

    public static String imageToBase64(BufferedImage image, StiImageFormat format) {
        String base64 = "";
        try {
            base64 = Base64.encode((byte[])StiImageHelper.imageToByteArray(image, format));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return base64;
    }

    public static BufferedImage decodeImage(String value, StiRectangle rect) throws IOException {
        return StiImageHelper.decodeImage(value, rect, 1.0);
    }

    public static BufferedImage decodeImage(String value, StiRectangle rect, double zoom) throws IOException {
        int index = value.indexOf(";base64,");
        if (index > 0 && index < 30) {
            value = value.substring(index + 8);
        }
        byte[] bytes = StiBase64DecoderUtil.decode((String)value);
        return StiImageHelper.decodeImage(bytes, rect, zoom);
    }

    public static BufferedImage decodeImage(byte[] bytes, StiRectangle rect) throws IOException {
        return StiImageHelper.decodeImage(bytes, rect, 1.0);
    }

    public static BufferedImage decodeImage(byte[] bytes, StiRectangle rect, double zoom) throws IOException {
        BufferedImage result;
        block18: {
            block17: {
                byte[] bytes2;
                block16: {
                    result = null;
                    try {
                        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
                        result = ImageIO.read(in);
                        if (result == null) {
                            bytes2 = StiBase64DecoderUtil.decode((byte[])bytes);
                            in = new ByteArrayInputStream(bytes2);
                            result = ImageIO.read(in);
                        }
                    }
                    catch (Throwable e) {
                        if (StiOptions.Engine.logLevel >= 10) {
                            e.printStackTrace();
                        }
                        try {
                            Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName("JPEG");
                            ImageReader reader = null;
                            while (readers.hasNext() && !(reader = readers.next()).canReadRaster()) {
                            }
                            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
                            ImageInputStream input = ImageIO.createImageInputStream(in);
                            reader.setInput(input);
                            Raster raster = reader.readRaster(0, null);
                            result = new BufferedImage(raster.getWidth(), raster.getHeight(), 6);
                            result.getRaster().setRect(raster);
                        }
                        catch (Exception e2) {
                            if (StiOptions.Engine.logLevel < 10) break block16;
                            e2.printStackTrace();
                        }
                    }
                }
                if (result == null) {
                    try {
                        result = StiSvgHelper.decodeSVG((byte[])bytes, (StiRectangle)rect, (double)zoom);
                    }
                    catch (Throwable e) {
                        try {
                            bytes2 = StiBase64DecoderUtil.decode((byte[])bytes);
                            result = StiSvgHelper.decodeSVG((byte[])bytes2, (StiRectangle)rect, (double)zoom);
                        }
                        catch (Throwable ee) {
                            if (StiOptions.Engine.logLevel < 10) break block17;
                            e.printStackTrace();
                            ee.printStackTrace();
                        }
                    }
                }
            }
            if (result == null) {
                String text = new String(bytes, "UTF-8");
                try {
                    if (text.startsWith("icon;")) {
                        String[] values = text.split(";");
                        StiFontIcons icon = StiFontIcons.valueOf(values[1]);
                        StiColor iconColor = StiColor.deserializeString((String)values[2]);
                        int width = rect != null ? (int)Math.round(rect.width / zoom) : 10;
                        int height = rect != null ? (int)Math.round(rect.height / zoom) : 10;
                        return StiFontIconsHelper.convertFontIconToImage(icon, iconColor, width, height);
                    }
                }
                catch (Exception e) {
                    if (StiOptions.Engine.logLevel < 10) break block18;
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StiImage getImageFromObject(Object imageObject) {
        if (imageObject instanceof StiImage) {
            return (StiImage)(imageObject instanceof StiImage ? imageObject : null);
        }
        if (imageObject instanceof String && ((String)imageObject).length() > 0 && !new File(imageObject.toString()).exists()) {
            return new StiImage(imageObject.toString());
        }
        if (imageObject instanceof byte[]) {
            byte[] bytes = (byte[])imageObject;
            return new StiImage(bytes);
        }
        if (imageObject != null && new File(imageObject.toString()).exists()) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(new File(imageObject.toString()));
                StiImage stiImage = new StiImage(StiImageHelper.imageToBase64(StiImageHelper.decodeImage(StiIOUtil.toByteArray((InputStream)fis), null), StiImageFormat.Png));
                return stiImage;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                block16: {
                    try {
                        fis.close();
                    }
                    catch (Exception ee) {
                        if (StiOptions.Engine.logLevel < 10) break block16;
                        ee.printStackTrace();
                    }
                }
            }
        }
        LOG.info("Unable to get image: " + imageObject);
        return null;
    }

    private static String getImageName(byte[] data) {
        if (StiImageHelper.isTiff(data)) {
            return "Tiff";
        }
        if (StiImageHelper.isPng(data)) {
            return "Png";
        }
        if (StiImageHelper.isGif(data)) {
            return "Gif";
        }
        if (StiImageHelper.isJpeg(data)) {
            return "Jpeg";
        }
        if (StiImageHelper.isBmp(data)) {
            return "Bmp";
        }
        if (StiImageHelper.isEmf(data)) {
            return "Emf";
        }
        if (StiImageHelper.isWmf(data)) {
            return "Wmf";
        }
        if (StiImageHelper.isIcon(data)) {
            return "Icon";
        }
        if (StiImageHelper.isSvg(data)) {
            return "Svg";
        }
        if (StiImageHelper.isXml(data)) {
            for (int index = 5; index < data.length - 4; ++index) {
                if (data[index] != 60) continue;
                if (data[index + 1] != 115 || data[index + 2] != 118 || data[index + 3] != 103) break;
                return "Svg";
            }
        }
        return null;
    }

    public static boolean isXml(byte[] data) {
        return data[0] == 60 && data[1] == 63 && data[2] == 120 && data[3] == 109 && data[4] == 108;
    }

    public static boolean isSvg(byte[] data) {
        return data[0] == 60 && data[1] == 115 && data[2] == 118 && data[3] == 103;
    }

    public static boolean isIcon(byte[] data) {
        return data[0] == 0 && data[1] == 0 && (data[2] == 1 || data[2] == 2) && data[3] == 0 && data[4] != 0;
    }

    public static boolean isWmf(byte[] data) {
        return data[0] == 215 && data[1] == 205 && data[2] == 198 && data[3] == 154 || data[0] == 1 && data[1] == 0 && data[2] == 9 && data[3] == 0;
    }

    public static boolean isEmf(byte[] data) {
        return data[40] == 32 && data[41] == 69 && data[42] == 77 && data[43] == 70;
    }

    public static boolean isBmp(byte[] data) {
        return data[0] == 66 && data[1] == 77;
    }

    public static boolean isJpeg(byte[] data) {
        return data[0] == 255 && data[1] == 216;
    }

    public static boolean isGif(byte[] data) {
        return data[0] == 71 && data[1] == 73 && data[2] == 70;
    }

    public static boolean isPng(byte[] data) {
        return data[0] == 137 && data[1] == 80 && data[2] == 78 && data[3] == 71;
    }

    public static boolean isTiff(byte[] data) {
        return data[0] == 73 && data[1] == 73 && data[2] == 42 && data[3] == 0 || data[0] == 77 && data[1] == 77 && data[2] == 0 && data[3] == 42;
    }

    public static boolean isMetafile(byte[] data) {
        return StiImageHelper.isEmf(data) || StiImageHelper.isWmf(data);
    }

    public static boolean isImage(Object data) {
        if (data instanceof byte[]) {
            return StiImageHelper.isImage((byte[])data);
        }
        if (data instanceof String) {
            return StiImageHelper.isImage((String)data);
        }
        return data instanceof BufferedImage || data instanceof StiImage;
    }

    public static boolean isImage(byte[] data) {
        if (data.length < 128) {
            return false;
        }
        return StiImageHelper.getImageName(data) != null;
    }

    public static boolean isImage(String str) {
        if (str.length() < 128) {
            return false;
        }
        try {
            if (!StiStringUtil.isBase64String((String)str)) {
                return false;
            }
            byte[] data = StiBase64DecoderUtil.decode((String)str.substring(0, 128));
            return StiImageHelper.getImageName(data) != null;
        }
        catch (Exception e) {
            if (StiOptions.Engine.logLevel >= 10) {
                e.printStackTrace();
            }
            return false;
        }
    }

    public static StiImage FromFile(String path) throws FileNotFoundException, IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        StiIOUtil.copy((InputStream)new FileInputStream(path), (OutputStream)bos);
        StiImage img = new StiImage();
        img.setImageBytesToDraw(new String(StiBase64EncoderUtil.encode((byte[])bos.toByteArray()), "UTF-8"));
        return img;
    }
}

