/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components.signature;

import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.signature.StiSignature;

public class StiPdfDigitalSignature
extends StiSignature {
    private static final String DefaultSignaturePlaceholder = "Place for digital signature in PDF Viewer";
    public byte[] signatureImageBytes;
    public String placeholder = "Place for digital signature in PDF Viewer";

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyString("Placeholder", this.placeholder, DefaultSignaturePlaceholder);
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("Brush")) {
                this.brush = StiJsonReportObjectHelper.Deserialize.Brush((JProperty)property);
            } else if (property.Name.equals("Border")) {
                this.border = StiJsonReportObjectHelper.Deserialize.Border((JProperty)property);
            }
            if (property.Name.equals("Placeholder")) {
                this.placeholder = (String)property.Value;
            }
            if (!property.Name.equals("SignatureImageBytes")) continue;
        }
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"Components", (String)"StiPdfDigitalSignature");
    }

    public byte[] getSignatureImageBytes() {
        return this.signatureImageBytes;
    }

    public void setSignatureImageBytes(byte[] signatureImageBytes) {
        this.signatureImageBytes = signatureImageBytes;
    }

    @StiSerializable
    public String getPlaceholder() {
        return this.placeholder;
    }

    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
    }

    public StiComponent createNew() {
        return new StiPdfDigitalSignature();
    }

    public StiPdfDigitalSignature() {
        this(StiRectangle.empty());
    }

    public StiPdfDigitalSignature(StiRectangle rect) {
        super(rect);
        this.setPlaceOnToolbox(false);
    }
}

