/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components.conditions;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializable;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializableToString;
import com.stimulsoft.base.serializing.utils.StiSerializTypeConverter;
import com.stimulsoft.base.serializing.utils.StiXMLConvert;
import com.stimulsoft.report.components.enums.StiIcon;
import com.stimulsoft.report.components.enums.StiIconSetOperation;
import com.stimulsoft.report.components.enums.StiIconSetValueType;
import java.text.MessageFormat;

public class StiIconSetItem
implements IStiSerializable,
IStiSerializableToString {
    private StiIcon icon = StiIcon.None;
    private StiIconSetOperation operation = StiIconSetOperation.MoreThan;
    private StiIconSetValueType valueType = StiIconSetValueType.Percent;
    private float value = 0.0f;

    public StiIconSetItem() {
    }

    public StiIconSetItem(StiIcon icon, StiIconSetOperation operation, StiIconSetValueType valueType, float value) {
        this.icon = icon;
        this.operation = operation;
        this.valueType = valueType;
        this.value = value;
    }

    @StiSerializable
    public final StiIcon getIcon() {
        return this.icon;
    }

    public final void setIcon(StiIcon value) {
        this.icon = value;
    }

    @StiSerializable
    public final StiIconSetOperation getOperation() {
        return this.operation;
    }

    public final void setOperation(StiIconSetOperation value) {
        this.operation = value;
    }

    @StiSerializable
    public final StiIconSetValueType getValueType() {
        return this.valueType;
    }

    public final void setValueType(StiIconSetValueType value) {
        this.valueType = value;
    }

    @StiSerializable
    public final float getValue() {
        return this.value;
    }

    public final void setValue(float value) {
        this.value = value;
    }

    public void deserialize(String strObject) {
        this.deserializeStr(strObject);
    }

    public String serialize() {
        return MessageFormat.format("{0},{1},{2},{3}", StiXMLConvert.encodeName((Enum)this.icon), StiXMLConvert.encodeName((Enum)this.operation), StiXMLConvert.encodeName((Enum)this.valueType), StiXMLConvert.encodeName((String)String.valueOf(this.value)));
    }

    public void deserializeStr(String valuesStr) {
        String[] values = valuesStr.split(",");
        for (int i = 0; i < values.length; ++i) {
            values[i] = StiXMLConvert.decodeName((String)values[i]);
        }
        this.icon = StiIcon.valueOf(values[0]);
        this.operation = StiIconSetOperation.valueOf(values[1]);
        this.valueType = StiIconSetValueType.valueOf(values[2]);
        this.value = StiSerializTypeConverter.stringToFloat((String)StiXMLConvert.decodeName((String)values[3]));
    }

    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = new JSONObject();
        jObject.AddPropertyIdent("Ident", this.getClass().getName());
        jObject.AddPropertyEnum("Icon", (Enum)this.getIcon(), (Enum)StiIcon.None);
        jObject.AddPropertyEnum("Operation", (Enum)this.getOperation(), (Enum)StiIconSetOperation.MoreThan);
        jObject.AddPropertyEnum("ValueType", (Enum)this.getValueType(), (Enum)StiIconSetValueType.Percent);
        jObject.AddPropertyFloat("Value", (double)this.getValue(), 0.0);
        return jObject;
    }

    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("Icon")) {
                this.icon = StiIcon.valueOf((String)property.Value);
                continue;
            }
            if (property.Name.equals("Operation")) {
                this.operation = StiIconSetOperation.valueOf((String)property.Value);
                continue;
            }
            if (property.Name.equals("ValueType")) {
                this.valueType = StiIconSetValueType.valueOf((String)property.Value);
                continue;
            }
            if (!property.Name.equals("Value")) continue;
            this.value = property.floatValue().floatValue();
        }
    }
}

