/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components.conditions;

import com.stimulsoft.base.DBNull;
import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.serializing.utils.StiSerializTypeConverter;
import com.stimulsoft.base.serializing.utils.StiXMLConvert;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.components.conditions.StiBaseCondition;
import com.stimulsoft.report.components.enums.StiColorScaleType;
import com.stimulsoft.report.components.enums.StiMaximumType;
import com.stimulsoft.report.components.enums.StiMidType;
import com.stimulsoft.report.components.enums.StiMinimumType;
import com.stimulsoft.report.components.indicators.StiIndicator;
import com.stimulsoft.report.components.interfaces.IStiIndicatorCondition;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.dictionary.StiDataColumn;
import com.stimulsoft.report.dictionary.businessObjects.StiBusinessObject;
import com.stimulsoft.report.dictionary.dataSources.StiDataSource;

public class StiColorScaleCondition
extends StiBaseCondition
implements IStiIndicatorCondition {
    private Float minimum = Float.valueOf(0.0f);
    private StiColorScaleType scaleType = StiColorScaleType.Color2;
    private StiColor minimumColor = StiColorEnum.Red.color();
    private StiColor midColor = StiColorEnum.Yellow.color();
    private StiColor maximumColor = StiColorEnum.Green.color();
    private StiMinimumType minimumType = StiMinimumType.Auto;
    private float minimumValue = 0.0f;
    private StiMidType midType = StiMidType.Auto;
    private float midValue = 50.0f;
    private StiMaximumType maximumType = StiMaximumType.Auto;
    private float maximumValue = 100.0f;
    private final Float m = null;
    private Float maximum = null;

    public StiColorScaleCondition() {
    }

    public StiColorScaleCondition(String column, StiColorScaleType scaleType, StiColor minimumColor, StiColor midColor, StiColor maximumColor, StiMinimumType minimumType, float minimumValue, StiMidType midType, float midValue, StiMaximumType maximumType, float maximumValue) {
        this.column = column;
        this.scaleType = scaleType;
        this.minimumColor = minimumColor;
        this.midColor = midColor;
        this.maximumColor = maximumColor;
        this.minimumType = minimumType;
        this.minimumValue = minimumValue;
        this.midType = midType;
        this.midValue = midValue;
        this.maximumType = maximumType;
        this.maximumValue = maximumValue;
    }

    @Override
    public final void Reset() {
        this.minimum = null;
        this.maximum = null;
    }

    @StiSerializable
    public final StiColorScaleType getScaleType() {
        return this.scaleType;
    }

    public final void setScaleType(StiColorScaleType value) {
        this.scaleType = value;
    }

    @StiSerializable
    public final StiColor getMinimumColor() {
        return this.minimumColor;
    }

    public final void setMinimumColor(StiColor value) {
        this.minimumColor = value;
    }

    @StiSerializable
    public final StiColor getMidColor() {
        return this.midColor;
    }

    public final void setMidColor(StiColor value) {
        this.midColor = value;
    }

    @StiSerializable
    public final StiColor getMaximumColor() {
        return this.maximumColor;
    }

    public final void setMaximumColor(StiColor value) {
        this.maximumColor = value;
    }

    @StiSerializable
    public final StiMinimumType getMinimumType() {
        return this.minimumType;
    }

    public final void setMinimumType(StiMinimumType value) {
        this.minimumType = value;
    }

    @StiSerializable
    public final float getMinimumValue() {
        return this.minimumValue;
    }

    public final void setMinimumValue(float value) {
        this.minimumValue = value;
    }

    @StiSerializable
    public final StiMidType getMidType() {
        return this.midType;
    }

    public final void setMidType(StiMidType value) {
        this.midType = value;
    }

    @StiSerializable
    public final float getMidValue() {
        return this.midValue;
    }

    public final void setMidValue(float value) {
        this.midValue = value;
    }

    @StiSerializable
    public final StiMaximumType getMaximumType() {
        return this.maximumType;
    }

    public final void setMaximumType(StiMaximumType value) {
        this.maximumType = value;
    }

    @StiSerializable
    public final float getMaximumValue() {
        return this.maximumValue;
    }

    public final void setMaximumValue(float value) {
        this.maximumValue = value;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        StiColorScaleCondition condition = (StiColorScaleCondition)(obj instanceof StiColorScaleCondition ? obj : null);
        if (condition == null) {
            return false;
        }
        return this.column.equals(condition.column) && this.scaleType.equals((Object)condition.getScaleType()) && this.minimumColor.equals(condition.minimumColor) && this.midColor.equals(condition.midColor) && this.maximumColor.equals(condition.maximumColor) && this.minimumType.equals((Object)condition.minimumType) && new Float(this.minimumValue).equals(Float.valueOf(condition.minimumValue)) && this.midType.equals((Object)condition.midType) && new Float(this.midValue).equals(Float.valueOf(condition.midValue)) && this.maximumType.equals((Object)condition.maximumType) && new Float(this.maximumValue).equals(Float.valueOf(condition.maximumValue));
    }

    @Override
    public String serialize() {
        String result = String.format("%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s", new Object[]{"ColorScale", StiXMLConvert.encodeName((String)this.column), this.scaleType, this.minimumColor.serializeString(), this.midColor.serializeString(), this.maximumColor.serializeString(), this.minimumType, Float.valueOf(this.minimumValue), this.midType, Float.valueOf(this.midValue), this.maximumType, Float.valueOf(this.maximumValue)});
        return result;
    }

    @Override
    public void deserialize(String value) {
        String[] values = value.split(",");
        this.column = StiXMLConvert.decodeName((String)values[1]);
        this.scaleType = StiColorScaleType.valueOf(values[2]);
        this.minimumColor = StiColor.deserializeString((String)values[3]);
        this.midColor = StiColor.deserializeString((String)values[4]);
        this.maximumColor = StiColor.deserializeString((String)values[5]);
        this.minimumType = StiMinimumType.valueOf(values[6]);
        this.minimumValue = StiSerializTypeConverter.stringToFloat((String)values[7]);
        this.midType = StiMidType.valueOf(values[8]);
        this.midValue = StiSerializTypeConverter.stringToFloat((String)values[9]);
        this.maximumType = StiMaximumType.valueOf(values[10]);
        this.maximumValue = StiSerializTypeConverter.stringToFloat((String)values[11]);
    }

    @Override
    public StiIndicator CreateIndicator(StiText component) {
        StiColor maxColor;
        StiColor minColor;
        if (StiValidationUtil.isNullOrEmpty((String)this.column)) {
            component.getReport().WriteToReportRenderingMessages(String.format("Column of Color Scale Condition of '%1$s' component is not specified!", component.getName()));
            return null;
        }
        if (this.minimum == null || this.maximum == null) {
            this.minimum = Float.valueOf(0.0f);
            this.maximum = Float.valueOf(0.0f);
            StiDataSource dataSource = StiDataColumn.GetDataSourceFromDataColumn(component.getReport().getDictionary(), this.column);
            if (dataSource != null) {
                dataSource.saveState("Indicator");
                dataSource.First();
                int index = 0;
                while (!dataSource.getIsEof()) {
                    Object value = StiDataColumn.GetDataFromDataColumn(component.getReport().getDictionary(), this.column);
                    float floatValue = 0.0f;
                    try {
                        if (!(value instanceof DBNull)) {
                            floatValue = Float.parseFloat(value.toString());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (index == 0) {
                        this.minimum = Float.valueOf(floatValue);
                        this.maximum = Float.valueOf(floatValue);
                    } else {
                        this.minimum = Float.valueOf(Math.min(this.minimum == null ? 0.0f : this.minimum.floatValue(), floatValue));
                        this.maximum = Float.valueOf(Math.max(this.maximum == null ? 0.0f : this.maximum.floatValue(), floatValue));
                    }
                    ++index;
                    dataSource.Next();
                }
                dataSource.RestoreState("Indicator");
            }
            if (dataSource == null) {
                StiBusinessObject businessObject = StiDataColumn.GetBusinessObjectFromDataColumn(component.getReport().getDictionary(), this.column);
                if (businessObject == null) {
                    component.getReport().WriteToReportRenderingMessages(String.format("Column of Data Bar Condition of '%1$s' component is not found!", component.getName()));
                    return null;
                }
                businessObject.SaveState("Indicator");
                businessObject.CreateEnumerator();
                int index = 0;
                while (!businessObject.getIsEof()) {
                    Object value = StiDataColumn.GetDataFromDataColumn(component.getReport().getDictionary(), this.column);
                    float floatValue = 0.0f;
                    try {
                        if (!(value instanceof DBNull)) {
                            floatValue = Float.parseFloat(value.toString());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (index == 0) {
                        this.minimum = Float.valueOf(floatValue);
                        this.maximum = Float.valueOf(floatValue);
                    } else {
                        this.minimum = Float.valueOf(Math.min(this.minimum == null ? 0.0f : this.minimum.floatValue(), floatValue));
                        this.maximum = Float.valueOf(Math.max(this.maximum == null ? 0.0f : this.maximum.floatValue(), floatValue));
                    }
                    ++index;
                    businessObject.next();
                }
                businessObject.RestoreState("Indicator");
            }
        }
        float minimumToUse = this.minimum == null ? 0.0f : this.minimum.floatValue();
        float maximumToUse = this.maximum == null ? 0.0f : this.maximum.floatValue();
        float dist = maximumToUse - minimumToUse;
        float minimumPercent = this.getMinimumValue();
        minimumPercent = Math.min(minimumPercent, 100.0f);
        minimumPercent = Math.max(minimumPercent, 0.0f);
        float maximumPercent = this.getMaximumValue();
        maximumPercent = Math.min(maximumPercent, 100.0f);
        if (minimumPercent > (maximumPercent = Math.max(maximumPercent, 0.0f))) {
            minimumPercent = maximumPercent;
        }
        float midPercent = this.getMidValue();
        if (this.getMinimumType() == StiMinimumType.Value) {
            minimumToUse = this.getMinimumValue();
        } else if (this.getMinimumType() == StiMinimumType.Percent) {
            minimumToUse += dist * minimumPercent / 100.0f;
        }
        if (this.getMaximumType() == StiMaximumType.Value) {
            maximumToUse = this.getMaximumValue();
        } else if (this.getMaximumType() == StiMaximumType.Percent) {
            maximumToUse = minimumToUse + dist * maximumPercent / 100.0f;
        }
        float midToUse = (maximumToUse - minimumToUse) / 2.0f;
        if (this.getMidType() == StiMidType.Value) {
            midToUse = this.getMidValue();
        } else if (this.getMidType() == StiMidType.Percent) {
            midToUse = minimumToUse + dist * midPercent / 100.0f;
        }
        if (midToUse < minimumToUse) {
            midToUse = minimumToUse;
        }
        if (midToUse > maximumToUse) {
            midToUse = maximumToUse;
        }
        Object currentValue = StiDataColumn.GetDataFromDataColumn(component.getReport().getDictionary(), this.column);
        float floatCurrentValue = 0.0f;
        try {
            if (!(currentValue instanceof DBNull)) {
                floatCurrentValue = Float.parseFloat(currentValue.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (floatCurrentValue > maximumToUse) {
            floatCurrentValue = maximumToUse;
        }
        if (floatCurrentValue < minimumToUse) {
            floatCurrentValue = minimumToUse;
        }
        float percent = 0.0f;
        if (this.getScaleType() == StiColorScaleType.Color2) {
            percent = (floatCurrentValue - minimumToUse) / (maximumToUse - minimumToUse);
            minColor = this.getMinimumColor();
            maxColor = this.getMaximumColor();
        } else if (floatCurrentValue > midToUse) {
            percent = (floatCurrentValue - midToUse) / (maximumToUse - midToUse);
            minColor = this.getMidColor();
            maxColor = this.getMaximumColor();
        } else {
            percent = floatCurrentValue / (midToUse - minimumToUse);
            minColor = this.getMinimumColor();
            maxColor = this.getMidColor();
        }
        float a = (float)(maxColor.getA() - minColor.getA()) * percent + (float)minColor.getA();
        float r = (float)(maxColor.getR() - minColor.getR()) * percent + (float)minColor.getR();
        float g = (float)(maxColor.getG() - minColor.getG()) * percent + (float)minColor.getG();
        float b = (float)(maxColor.getB() - minColor.getB()) * percent + (float)minColor.getB();
        a = Math.min(a, 255.0f);
        r = Math.min(r, 255.0f);
        g = Math.min(g, 255.0f);
        b = Math.min(b, 255.0f);
        component.setBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)((int)a), (int)((int)r), (int)((int)g), (int)((int)b))));
        return null;
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyEnum("ScaleType", (Enum)this.getScaleType(), (Enum)StiColorScaleType.Color2);
        jObject.AddPropertyStringNullOfEmpty("MinimumColor", StiJsonReportObjectHelper.Serialize.jColor((StiColor)this.getMinimumColor(), (StiColor)StiColorEnum.Red.color()));
        jObject.AddPropertyStringNullOfEmpty("MidColor", StiJsonReportObjectHelper.Serialize.jColor((StiColor)this.getMidColor(), (StiColor)StiColorEnum.Yellow.color()));
        jObject.AddPropertyStringNullOfEmpty("MaximumColor", StiJsonReportObjectHelper.Serialize.jColor((StiColor)this.getMaximumColor(), (StiColor)StiColorEnum.Green.color()));
        jObject.AddPropertyEnum("MinimumType", (Enum)this.getMinimumType(), (Enum)StiMinimumType.Auto);
        jObject.AddPropertyFloat("MinimumValue", (double)this.getMinimumValue(), 0.0);
        jObject.AddPropertyEnum("MidType", (Enum)this.getMidType(), (Enum)StiMidType.Auto);
        jObject.AddPropertyFloat("MidValue", (double)this.getMidValue(), 50.0);
        jObject.AddPropertyEnum("MaximumType", (Enum)this.getMaximumType(), (Enum)StiMaximumType.Auto);
        jObject.AddPropertyFloat("MaximumValue", (double)this.getMaximumValue(), 100.0);
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("ScaleType")) {
                this.scaleType = StiColorScaleType.valueOf((String)property.Value);
                continue;
            }
            if (property.Name.equals("MinimumColor")) {
                this.minimumColor = StiJsonReportObjectHelper.Deserialize.Color((String)((String)property.Value));
                continue;
            }
            if (property.Name.equals("MidColor")) {
                this.midColor = StiJsonReportObjectHelper.Deserialize.Color((String)((String)property.Value));
                continue;
            }
            if (property.Name.equals("MaximumColor")) {
                this.maximumColor = StiJsonReportObjectHelper.Deserialize.Color((String)((String)property.Value));
                continue;
            }
            if (property.Name.equals("MinimumType")) {
                this.minimumType = StiMinimumType.valueOf((String)property.Value);
                continue;
            }
            if (property.Name.equals("MinimumValue")) {
                this.minimumValue = property.floatValue().floatValue();
                continue;
            }
            if (property.Name.equals("MidType")) {
                this.midType = StiMidType.valueOf((String)property.Value);
                continue;
            }
            if (property.Name.equals("MidValue")) {
                this.midValue = property.floatValue().floatValue();
                continue;
            }
            if (property.Name.equals("MaximumType")) {
                this.maximumType = StiMaximumType.valueOf((String)property.Value);
                continue;
            }
            if (!property.Name.equals("MaximumValue")) continue;
            this.maximumValue = property.floatValue().floatValue();
        }
    }
}

