/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components.bands;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentDivider;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.bands.StiDataBand;
import com.stimulsoft.report.components.bands.StiEmptyBand;
import com.stimulsoft.report.components.bands.StiStaticBand;
import com.stimulsoft.report.components.complexcomponents.StiContainer;
import com.stimulsoft.report.components.enums.StiComponentPriority;
import com.stimulsoft.report.components.enums.StiComponentToolboxPosition;
import com.stimulsoft.report.components.enums.StiComponentType;
import com.stimulsoft.report.components.enums.StiPrintOnEvenOddPagesType;
import com.stimulsoft.report.components.enums.StiPrintOnType;
import com.stimulsoft.report.components.interfaces.IStiBreakable;
import com.stimulsoft.report.components.interfaces.IStiPrintOnEvenOddPages;
import com.stimulsoft.report.dialogs.IStiReportControl;
import com.stimulsoft.report.engine.StiEngineVersion;

public class StiPageHeaderBand
extends StiStaticBand
implements IStiBreakable,
IStiPrintOnEvenOddPages {
    private StiPrintOnEvenOddPagesType printOnEvenOddPages = StiPrintOnEvenOddPagesType.Ignore;

    public StiPageHeaderBand() {
        this(StiRectangle.empty());
    }

    public StiPageHeaderBand(StiRectangle rect) {
        super(rect);
        this.setPlaceOnToolbox(true);
    }

    @Override
    public boolean getCanBreak() {
        return true;
    }

    @Override
    public void setCanBreak(boolean value) {
    }

    @Override
    public StiColor getHeaderStartColor() {
        return StiColor.White;
    }

    @Override
    public StiColor getHeaderEndColor() {
        return StiColor.create((StiColorEnum)StiColorEnum.LightGray);
    }

    @Override
    public int getToolboxPosition() {
        return StiComponentToolboxPosition.PageHeaderBand.getValue();
    }

    @Override
    public int getPriority() {
        if (this.getPage().TitleBeforeHeader()) {
            return StiComponentPriority.PageHeaderBandBefore.getValue();
        }
        return StiComponentPriority.PageHeaderBandAfter.getValue();
    }

    @Override
    public boolean canContainIn(StiComponent component) {
        if (component instanceof IStiReportControl) {
            return false;
        }
        return component instanceof StiPage;
    }

    @Override
    public StiComponentType getComponentType() {
        if (this.getReport() != null && this.getReport().getEngineVersion() == StiEngineVersion.EngineV2) {
            return super.getComponentType();
        }
        return StiComponentType.Simple;
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"Components", (String)"StiPageHeaderBand");
    }

    @Override
    @StiDefaulValue(value="Ignore")
    public StiPrintOnEvenOddPagesType getPrintOnEvenOddPages() {
        return this.printOnEvenOddPages;
    }

    @Override
    public void setPrintOnEvenOddPages(StiPrintOnEvenOddPagesType value) {
        this.printOnEvenOddPages = value;
    }

    @StiDefaulValue(value="true")
    public final boolean getPrintOnFirstPage() {
        return (this.getPrintOn().getValue() & StiPrintOnType.ExceptFirstPage.getValue()) == 0;
    }

    public final void setPrintOnFirstPage(boolean value) {
    }

    @Override
    public boolean Break(StiComponent dividedComponent, double devideFactor, StiRefObject<Double> divLine, StiRefObject<Boolean> haveBreaked) {
        divLine.argvalue = 0.0;
        StiContainer newCont = StiComponentDivider.BreakContainer(this.getHeight(), (StiContainer)this, haveBreaked);
        ((StiContainer)dividedComponent).getComponents().clear();
        ((StiContainer)dividedComponent).getComponents().addAll(newCont.getComponents());
        return true;
    }

    public final StiComponent GetMaster() {
        for (StiComponent component : this.getParent().getComponents()) {
            if (!(component instanceof StiDataBand) || component instanceof StiEmptyBand) continue;
            return component;
        }
        return null;
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.RemoveProperty("CanBreak");
        jObject.AddPropertyEnum("PrintOnEvenOddPages", (Enum)this.getPrintOnEvenOddPages(), (Enum)StiPrintOnEvenOddPagesType.Ignore);
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (!property.Name.equals("PrintOnEvenOddPages")) continue;
            this.printOnEvenOddPages = StiPrintOnEvenOddPagesType.valueOf((String)property.Value);
        }
    }
}

