/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components.bands;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.components.bands.StiDataBand;
import com.stimulsoft.report.components.bands.StiHierarchicalBandInfoV2;
import com.stimulsoft.report.components.enums.StiComponentToolboxPosition;
import com.stimulsoft.report.dictionary.businessObjects.StiBusinessObject;
import com.stimulsoft.report.engine.engineV2.builders.StiHierarchicalBandV2Builder;
import com.stimulsoft.report.engine.engineV2.builders.StiV2Builder;

public class StiHierarchicalBand
extends StiDataBand {
    private String keyDataColumn = "";
    private String masterKeyDataColumn = "";
    private String parentValue = "";
    private double indent = 20.0;
    private String headers = "";
    private String footers = "";
    private StiHierarchicalBandInfoV2 hierarchicalBandInfoV2;

    public StiHierarchicalBand() {
        this(StiRectangle.empty());
    }

    public StiHierarchicalBand(StiRectangle rect) {
        super(rect);
        this.setPlaceOnToolbox(false);
    }

    @Override
    public int getToolboxPosition() {
        return StiComponentToolboxPosition.HierarchicalBand.getValue();
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"Components", (String)"StiHierarchicalBand");
    }

    @Override
    public StiColor getHeaderStartColor() {
        return StiColor.Light((StiColorEnum)StiColorEnum.DarkSeaGreen, (int)20);
    }

    @Override
    public StiColor getHeaderEndColor() {
        return StiColor.Dark((StiColorEnum)StiColorEnum.DarkSeaGreen, (int)30);
    }

    @StiSerializable
    @StiDefaulValue(value="")
    public final String getKeyDataColumn() {
        return this.keyDataColumn;
    }

    public final void setKeyDataColumn(String value) {
        this.keyDataColumn = value;
    }

    @StiSerializable
    @StiDefaulValue(value="")
    public final String getMasterKeyDataColumn() {
        return this.masterKeyDataColumn;
    }

    public final void setMasterKeyDataColumn(String value) {
        this.masterKeyDataColumn = value;
    }

    @StiDefaulValue(value="")
    @StiSerializable
    public final String getParentValue() {
        return this.parentValue;
    }

    public final void setParentValue(String value) {
        this.parentValue = value;
    }

    @StiDefaulValue(value="20.0")
    @StiSerializable
    public double getIndent() {
        return this.indent;
    }

    public void setIndent(double value) {
        this.indent = value;
    }

    @StiSerializable
    @StiDefaulValue(value="")
    public final String getHeaders() {
        return this.headers;
    }

    public final void setHeaders(String value) {
        this.headers = value;
    }

    @StiSerializable
    @StiDefaulValue(value="")
    public final String getFooters() {
        return this.footers;
    }

    public final void setFooters(String value) {
        this.footers = value;
    }

    public final StiHierarchicalBandInfoV2 getHierarchicalBandInfoV2() {
        if (this.hierarchicalBandInfoV2 == null) {
            this.hierarchicalBandInfoV2 = new StiHierarchicalBandInfoV2();
        }
        return this.hierarchicalBandInfoV2;
    }

    @Override
    public StiBusinessObject getBusinessObject() {
        return super.getBusinessObject();
    }

    @Override
    protected StiV2Builder getBuilder() {
        return new StiHierarchicalBandV2Builder();
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyStringNullOfEmpty("KeyDataColumn", this.getKeyDataColumn());
        jObject.AddPropertyStringNullOfEmpty("MasterKeyDataColumn", this.getMasterKeyDataColumn());
        jObject.AddPropertyStringNullOfEmpty("ParentValue", this.getParentValue());
        jObject.AddPropertyDouble("Indent", this.getIndent(), 20.0);
        jObject.AddPropertyStringNullOfEmpty("Headers", this.getHeaders());
        jObject.AddPropertyStringNullOfEmpty("Footers", this.getFooters());
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("KeyDataColumn")) {
                this.keyDataColumn = (String)property.Value;
                continue;
            }
            if (property.Name.equals("MasterKeyDataColumn")) {
                this.masterKeyDataColumn = (String)property.Value;
                continue;
            }
            if (property.Name.equals("ParentValue")) {
                this.parentValue = (String)property.Value;
                continue;
            }
            if (property.Name.equals("Indent")) {
                this.indent = property.doubleValue();
                continue;
            }
            if (property.Name.equals("Headers")) {
                this.headers = (String)property.Value;
                continue;
            }
            if (!property.Name.equals("Footers")) continue;
            this.footers = (String)property.Value;
        }
    }
}

