/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components;

import com.stimulsoft.base.IStiJsonReportObject;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.SerializeMode;
import com.stimulsoft.base.serializing.StiDeserializerControler;
import com.stimulsoft.base.serializing.StiDeserializerDocument;
import com.stimulsoft.base.serializing.StiSerializerControler;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializable;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializableRef;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.lib.utils.StiXmlUtil;
import com.stimulsoft.report.StiNameCreation;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.StiReportCache;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentsCollection;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.StiSaveLoadPageEventHandler;
import com.stimulsoft.report.components.complexcomponents.StiContainer;
import com.stimulsoft.report.dialogs.StiForm;
import com.stimulsoft.report.engine.StiEngineVersion;
import com.stimulsoft.report.engine.engineV2.StiRenderProviderV2;
import com.stimulsoft.report.enums.StiReportCacheMode;
import com.stimulsoft.report.enums.StiReportPass;
import com.stimulsoft.report.options.EngineOptions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;

public class StiPagesCollection
extends ArrayList<StiPage>
implements IStiJsonReportObject {
    private static final long serialVersionUID = 4550198464665112953L;
    private StiReport report;
    public boolean cacheMode;
    public boolean canUseCacheMode;
    public StiSaveLoadPageEventHandler pageCache;
    private List<PageStore> quickCachedPages = null;
    public List<StiPage> notCachedPages = null;
    private int amountOfProcessedPagesForStartGCCollect = 0;
    private Object cacheL2;

    @Override
    public StiPage get(int index) {
        StiPage page = (StiPage)super.get(index);
        this.GetPage(page);
        return page;
    }

    @Override
    public StiPage set(int index, StiPage element) {
        this.GetPage(element);
        return super.set(index, element);
    }

    public StiPagesCollection() {
    }

    public StiPagesCollection(StiReport report) {
        this.report = report;
    }

    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        if (this.size() == 0) {
            return null;
        }
        JSONObject jObject = new JSONObject();
        Integer index = 0;
        for (StiPage page : this) {
            jObject.AddPropertyJObject(index.toString(), page.SaveToJsonObject(mode));
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
        }
        return jObject;
    }

    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            StiPage page = null;
            JSONObject propJObject = (JSONObject)property.Value;
            String ident = propJObject.Properties().FirstOrDefault((String)"Ident").Value.toString();
            if (ident.equals("StiPage")) {
                page = new StiPage();
            } else if (ident.equals("StiForm")) {
                page = new StiForm();
            }
            this.add(page);
            page.LoadFromJsonObject(propJObject);
        }
    }

    public boolean addPage(StiPage page) {
        if (this.report != null && this.report.getUnit() != page.getUnit()) {
            page.convert(page.getUnit(), this.report.getUnit());
        }
        if (this.report != null && this.report.getIsDesigning() && StiValidationUtil.isNullOrEmpty((String)page.getName())) {
            page.setName(StiNameCreation.createName(this.report, StiNameCreation.generateName(page)));
        }
        if (StiValidationUtil.isNullOrEmpty((String)page.getName())) {
            if (this.report != null && this.report.getIsDesigning()) {
                page.setName(StiNameCreation.createName(this.report, StiNameCreation.generateName(page)));
            } else {
                page.setName(StiNameCreation.createSimpleName(this.report, StiNameCreation.generateName(page)));
            }
        }
        if (page.getReport() == null) {
            page.setReport(this.report);
        }
        return this.addV2Internal(page);
    }

    @Override
    public boolean add(StiPage page) {
        return this.addPage(page);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addV2Internal(StiPage page) {
        if (page.getReport() == null) {
            page.setReport(this.report);
        }
        boolean added = super.add(page);
        if (this.report != null && this.canUseCacheMode) {
            if (this.cacheMode) {
                this.addPageToQuickCache(page, true);
            } else if (this.report.reportCacheMode == StiReportCacheMode.Auto && this.size() > EngineOptions.ReportCache.getLimitForStartUsingCache()) {
                this.cacheMode = true;
                int index = this.size();
                StiPagesCollection stiPagesCollection = this;
                synchronized (stiPagesCollection) {
                    for (StiPage pg : this) {
                        if (this.report == null || this.report.getEngineVersion() == StiEngineVersion.EngineV1) {
                            // empty if block
                        }
                        this.addPageToQuickCache(pg, true);
                        if (pg.getReport() != null && pg.getReport().getEngineVersion() == StiEngineVersion.EngineV2) {
                            StiRenderProviderV2.ProcessPageToCache(pg.getReport(), pg, false);
                        }
                        --index;
                    }
                }
            }
        }
        return added;
    }

    public void fillReport(StiReport report) {
        this.report = report;
        for (StiPage page : this) {
            page.setReport(report);
        }
    }

    public void fillPageInChildren() {
        for (StiPage page : this) {
            page.getComponents().fillPage(page);
        }
    }

    public boolean getCacheMode() {
        return this.cacheMode;
    }

    public void AddRange(StiPagesCollection pagesStore) {
        this.addAll(pagesStore);
        StiPagesCollection.copyEventsOfPagesCollection(pagesStore, this);
        this.quickCachedPages = pagesStore.quickCachedPages;
    }

    public void addAll(StiPagesCollection pagesStore) {
        super.addAll(pagesStore);
    }

    public void GetPage(StiPage page) {
        if (!(this.report == null || this.getCacheMode() && this.report.reportPass != StiReportPass.First)) {
            return;
        }
        if (this.cacheL2 != null) {
            // empty if block
        }
        if (page.getComponents().size() != 0) {
            return;
        }
        if (this.report != null && this.report.engine != null && this.report.engine.getProgressHelper() != null && this.report.engine.getProgressHelper().allowCachedPagesCache) {
            this.report.InvokeRendering();
        }
        this.loadPage(page);
        this.addPageToQuickCache(page, false);
    }

    public void savePage(StiPage page) {
        this.savePage(page, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePage(StiPage page, boolean clearContent) {
        int indexPage;
        if (page.getReport() != null && page.getReport().getEngineVersion() == StiEngineVersion.EngineV2) {
            StiRenderProviderV2.ProcessPageToCache(page.getReport(), page, true);
        }
        if (page != null && this.report.getRenderedPages().notCachedPages != null && (indexPage = this.report.getRenderedPages().notCachedPages.indexOf(page)) != -1) {
            this.report.getRenderedPages().notCachedPages.remove(indexPage);
        }
        if (page.getReport() != null && page.getReport().getReportPass() == StiReportPass.First) {
            return;
        }
        String path = StiReportCache.getPageCacheName(this.report.reportCachePath, page.getCacheGuid());
        page.setReport(null);
        if (this.pageCache != null) {
            this.pageCache.save(page, page, this.indexOf(page), path);
        } else {
            if (StiValidationUtil.isNullOrEmpty((String)this.report.reportCachePath)) {
                this.report.reportCachePath = StiReportCache.createNewCache();
                path = StiReportCache.getPageCacheName(this.report.reportCachePath, page.getCacheGuid());
            }
            if (this.cacheL2 == null) {
                try (FileOutputStream stream = new FileOutputStream(path);){
                    page.setReference(0);
                    StiSerializerControler.serializeDocument((IStiSerializableRef)page, (OutputStream)stream);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        page.setReport(this.report);
    }

    public void loadPage(StiPage page) {
        String path = StiReportCache.getPageCacheName(this.report.reportCachePath, page.getCacheGuid());
        if (this.pageCache != null) {
            this.pageCache.load(page, page, this.indexOf(page), path);
        } else if (this.cacheL2 == null && new File(path).exists()) {
            try {
                this.deserializePage(new FileInputStream(path), page);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        page.setReport(this.report);
        StiPagesCollection.setParent(page);
        StiComponentsCollection comps = page.GetComponents();
        for (StiComponent comp : comps) {
            comp.setPage(page);
        }
    }

    private void deserializePage(InputStream stream, StiPage page) {
        try {
            Document document = StiXmlUtil.parseXmlInputStream((InputStream)stream);
            StiDeserializerControler controler = new StiDeserializerControler(SerializeMode.document);
            IStiSerializable result = new StiDeserializerDocument(controler, (IStiSerializable)page, document.getFirstChild()).deserialize();
            controler.addReferences(result, "0");
            controler.finish();
            stream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveQuickPagesToCache() {
        if (this.quickCachedPages == null) {
            return;
        }
        List<PageStore> list = this.quickCachedPages;
        synchronized (list) {
            for (PageStore store : this.quickCachedPages) {
                if (!store.isNotSaved()) continue;
                if (this.cacheL2 != null) {
                    // empty if block
                }
                this.savePage(store.page, false);
                store.savePage = false;
            }
        }
    }

    @Deprecated
    public void flush() {
        this.flush(false);
    }

    @Deprecated
    public void flush(boolean final_) {
        if (this.cacheL2 != null) {
            // empty if block
        }
    }

    public static void copyEventsOfPagesCollection(StiPagesCollection sourcePages, StiPagesCollection destinationPages) {
        destinationPages.pageCache = sourcePages.pageCache;
    }

    public StiPage getPageWithoutCache(int pageIndex) {
        return this.get(pageIndex);
    }

    public void setPageWithoutCache(int pageIndex, StiPage page) {
        this.set(pageIndex, page);
    }

    public StiPage get(String pageName) {
        for (StiPage page : this) {
            if (!page.getName().equals(pageName)) continue;
            this.GetPage(page);
            return page;
        }
        return null;
    }

    public void addPageToQuickCache(StiPage page, boolean savePage) {
        if (this.quickCachedPages == null) {
            this.quickCachedPages = new ArrayList<PageStore>();
        }
        PageStore findedStore = null;
        for (PageStore store : this.quickCachedPages) {
            if (store.page != page) continue;
            findedStore = store;
            break;
        }
        if (findedStore == null) {
            this.quickCachedPages.add(new PageStore(page, savePage));
        } else {
            this.quickCachedPages.remove(findedStore);
            this.quickCachedPages.add(new PageStore(page, savePage || findedStore.savePage));
        }
        if (this.quickCachedPages.size() > EngineOptions.ReportCache.getAmountOfQuickAccessPages()) {
            PageStore prevPage = this.quickCachedPages.get(0);
            boolean needClearPage = true;
            if (this.cacheL2 == null && prevPage.savePage) {
                this.savePage(prevPage.page);
            }
            if (needClearPage) {
                prevPage.page.disposeImagesAndClearComponents();
            }
            this.quickCachedPages.remove(0);
            if (this.cacheL2 == null && EngineOptions.ReportCache.getAllowGCCollect()) {
                int amount = EngineOptions.ReportCache.getAmountOfProcessedPagesForStartGCCollect();
                ++this.amountOfProcessedPagesForStartGCCollect;
                if (this.amountOfProcessedPagesForStartGCCollect >= amount) {
                    this.amountOfProcessedPagesForStartGCCollect = 0;
                    System.gc();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNotSavedPage(StiPage page) {
        List<PageStore> list = this.quickCachedPages;
        synchronized (list) {
            for (PageStore store : this.quickCachedPages) {
                if (store.page != page) continue;
                return store.isNotSaved();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markPageAsNotSaved(StiPage page) {
        List<PageStore> list = this.quickCachedPages;
        synchronized (list) {
            for (PageStore store : this.quickCachedPages) {
                if (store.page != page) continue;
                store.savePage = true;
            }
        }
    }

    public StiComponent GetComponentByName(String componentName) {
        for (StiPage page : this) {
            StiComponent comp = page.getComponents().GetComponentByName(componentName, page);
            if (comp == null) continue;
            return comp;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setParent(StiContainer parent) {
        StiComponentsCollection stiComponentsCollection = parent.getComponents();
        synchronized (stiComponentsCollection) {
            for (StiComponent comp : parent.getComponents()) {
                comp.setParent(parent);
                if (!(comp instanceof StiContainer)) continue;
                StiPagesCollection.setParent((StiContainer)comp);
            }
        }
    }

    public StiReport getReport() {
        return this.report;
    }

    public void setCacheMode(boolean cacheMode) {
        this.cacheMode = cacheMode;
    }

    public void setReport(StiReport report) {
        this.report = report;
    }

    private class PageStore {
        public boolean savePage;
        public StiPage page;

        public boolean isNotSaved() {
            return this.savePage;
        }

        public PageStore(StiPage page, boolean savePage) {
            this.page = page;
            this.savePage = savePage;
        }
    }
}

