/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components;

import com.stimulsoft.base.EventArgs;
import com.stimulsoft.base.IStiEnum;
import com.stimulsoft.base.StiEnumSet;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiBorder;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.enums.StiBorderSides;
import com.stimulsoft.base.enums.StiPaperKind;
import com.stimulsoft.base.enums.StiPaperSourceKind;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiIgnoreSerializationForDocument;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.serializing.annotations.StiSerializeTypesEnum;
import com.stimulsoft.base.system.StiEventHandler;
import com.stimulsoft.base.system.StiEventObject;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.IStiStateSaveRestore;
import com.stimulsoft.report.StiBlocklyHelper;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentsCollection;
import com.stimulsoft.report.components.StiMargins;
import com.stimulsoft.report.components.StiPageHelper;
import com.stimulsoft.report.components.StiPageInfoV2;
import com.stimulsoft.report.components.StiWatermark;
import com.stimulsoft.report.components.complexcomponents.StiContainer;
import com.stimulsoft.report.components.complexcomponents.StiPanel;
import com.stimulsoft.report.components.enums.StiDockStyle;
import com.stimulsoft.report.components.enums.StiPageOrientation;
import com.stimulsoft.report.components.enums.StiPrintOnType;
import com.stimulsoft.report.components.enums.StiRestrictions;
import com.stimulsoft.report.components.enums.StiShiftMode;
import com.stimulsoft.report.components.interfaces.IStiResetPageNumber;
import com.stimulsoft.report.components.simplecomponents.StiImage;
import com.stimulsoft.report.engine.StiEngineVersion;
import com.stimulsoft.report.events.StiBeginRenderEvent;
import com.stimulsoft.report.events.StiColumnBeginRenderEvent;
import com.stimulsoft.report.events.StiColumnEndRenderEvent;
import com.stimulsoft.report.events.StiEndRenderEvent;
import com.stimulsoft.report.events.StiEventsCollection;
import com.stimulsoft.report.events.StiGetExcelSheetEvent;
import com.stimulsoft.report.events.StiGetExcelSheetEventArgs;
import com.stimulsoft.report.events.StiRenderingEvent;
import com.stimulsoft.report.expressions.StiExcelSheetExpression;
import com.stimulsoft.report.options.EngineOptions;
import com.stimulsoft.report.units.StiCentimetersUnit;
import com.stimulsoft.report.units.StiHundredthsOfInchUnit;
import com.stimulsoft.report.units.StiMillimetersUnit;
import com.stimulsoft.report.units.StiUnit;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.UUID;

@StiIgnoreSerializationForDocument
public class StiPage
extends StiPanel
implements IStiResetPageNumber,
IStiStateSaveRestore {
    public static StiPage EMPTY_PAGE = new StiPage();
    public StiMargins margins = new StiMargins(39.0, 39.0, 39.0, 39.0);
    private boolean resetPageNumber = false;
    private boolean denyDrawSegmentMode = false;
    private StiRectangle selectedRectangle = StiRectangle.empty();
    private ArrayList selectedComponents;
    private String excelSheetValue;
    private boolean isPrinted = false;
    private boolean printOnPreviousPage = false;
    private boolean printHeadersFootersFromPreviousPage = false;
    private StiPaperKind paperSize = StiOptions.Engine.getDefaultPaperSize();
    private String paperSourceOfFirstPage = "";
    private String paperSourceOfOtherPages = "";
    private int numberOfCopies = 1;
    private boolean unlimitedBreakable = true;
    private boolean largeHeight = false;
    private int largeHeightFactor = 4;
    private int currentWidthSegment;
    private int currentHeightSegment;
    private int stopBeforePrint = 0;
    public boolean skip = false;
    private boolean stretchToPrintArea = false;
    private boolean titleBeforeHeader = false;
    private boolean unlimitedHeight = false;
    private boolean unlimitedWidth = true;
    private StiRectangle offsetRectangle = StiRectangle.empty();
    private StiPageOrientation orientation = StiPageOrientation.Portrait;
    private double pageWidth;
    private double pageHeight;
    public Integer segmentPerWidth = 1;
    public Integer segmentPerHeight = 1;
    private StiWatermark watermark;
    private StiReport report;
    private StiUnit reportUnit = null;
    private boolean lockHighlight = false;
    private boolean drillDownActivated = false;
    private String cacheGuid = null;
    public StiPageInfoV2 pageInfoV2 = new StiPageInfoV2();
    public boolean drillDownPageGuid;
    private double largeHeightAutoFactor = 1.0;
    private Boolean mirrorMargins = false;
    public String icon;
    public StiEventHandler handlerBeginRender = StiEventHandler.empty();
    public StiEventHandler handlerRendering = StiEventHandler.empty();
    public StiEventHandler handlerEndRender = StiEventHandler.empty();
    public StiEventHandler handlerOnColumnBeginRender = StiEventHandler.empty();
    public StiEventHandler handlerOnColumnEndRender = StiEventHandler.empty();
    public StiEventHandler handlerOnGetExcelSheet = StiEventHandler.empty();

    public StiPage() {
        this((StiReport)null);
    }

    public StiPage(StiReport report) {
        super(new StiRectangle(0L, 0L, 0L, 0L));
        try {
            this.NewGuid();
            StiBorder border = new StiBorder();
            border.setSize(2.0);
            this.setBorder(border);
            this.Reset();
            this.setParent(null);
            this.setPaperSize(StiOptions.Engine.getDefaultPaperSize());
            StiSize size = null;
            if (this.getPaperSize() != StiPaperKind.Custom) {
                size = StiPageHelper.getPaperSizeFromPaperKind(this.getPaperSize());
            }
            if (size == null || this.getPaperSize() == StiPaperKind.Custom) {
                this.pageWidth = 827.0;
                this.pageHeight = 1169.0;
            } else {
                StiSize pageSize = StiPageHelper.getPaperSize(this, size);
                this.setPageWidth(pageSize.width);
                this.setPageHeight(pageSize.height);
            }
            this.report = report;
            this.segmentPerWidth = 1;
            this.segmentPerHeight = 1;
            this.setMargins(new StiMargins(39.0, 39.0, 39.0, 39.0));
            if (report != null && !report.getIsSerializing()) {
                this.convert(StiUnit.HundredthsOfInch, this.getUnit());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.setPlaceOnToolbox(false);
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.RemoveProperty("CanShrink");
        jObject.RemoveProperty("CanGrow");
        jObject.RemoveProperty("PrintOn");
        jObject.RemoveProperty("CanBreak");
        jObject.RemoveProperty("DockStyle");
        jObject.RemoveProperty("MinSize");
        jObject.RemoveProperty("MaxSize");
        jObject.RemoveProperty("ClientRectangle");
        jObject.RemoveProperty("DisplayRectangle");
        jObject.RemoveProperty("UseParentStyles");
        jObject.RemoveProperty("GrowToHeight");
        jObject.RemoveProperty("ShiftMode");
        jObject.RemoveProperty("Printable");
        jObject.RemoveProperty("Page");
        jObject.RemoveProperty("Parent");
        jObject.RemoveProperty("Restrictions");
        jObject.RemoveProperty("Locked");
        jObject.RemoveProperty("Linked");
        jObject.AddPropertyBool("ResetPageNumber", this.getResetPageNumber());
        jObject.AddPropertyJObject("BeginRenderEvent", this.getBeginRenderEvent().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("RenderingEvent", this.getRenderingEvent().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("EndRenderEvent", this.getEndRenderEvent().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("ColumnBeginRenderEvent", this.getColumnBeginRenderEvent().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("ColumnEndRenderEvent", this.getColumnEndRenderEvent().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("GetExcelSheetEvent", this.getGetExcelSheetEvent().SaveToJsonObject(mode));
        jObject.AddPropertyStringNullOfEmpty("ExcelSheetValue", this.getExcelSheetValue());
        jObject.AddPropertyJObject("ExcelSheet", this.getExcelSheet().SaveToJsonObject(mode));
        jObject.AddPropertyBool("PrintOnPreviousPage", this.getPrintOnPreviousPage());
        jObject.AddPropertyBool("PrintHeadersFootersFromPreviousPage", this.getPrintHeadersFootersFromPreviousPage());
        jObject.AddPropertyEnum("PaperSize", (Enum)this.getPaperSize(), (Enum)StiPaperKind.Custom);
        jObject.AddPropertyStringNullOfEmpty("PaperSourceOfFirstPage", this.getPaperSourceOfFirstPage());
        jObject.AddPropertyStringNullOfEmpty("PaperSourceOfOtherPages", this.getPaperSourceOfOtherPages());
        jObject.AddPropertyInt("NumberOfCopies", this.getNumberOfCopies(), 1);
        jObject.AddPropertyBool("UnlimitedBreakable", this.getUnlimitedBreakable(), true);
        jObject.AddPropertyBool("LargeHeight", this.getLargeHeight());
        jObject.AddPropertyInt("LargeHeightFactor", this.getLargeHeightFactor(), 4);
        jObject.AddPropertyInt("StopBeforePrint", this.getStopBeforePrint());
        jObject.AddPropertyBool("StretchToPrintArea", this.getStretchToPrintArea());
        jObject.AddPropertyBool("TitleBeforeHeader", this.getTitleBeforeHeader());
        jObject.AddPropertyBool("UnlimitedHeight", this.getUnlimitedHeight());
        jObject.AddPropertyBool("UnlimitedWidth", this.getUnlimitedWidth(), true);
        jObject.AddPropertyEnum("Orientation", (Enum)this.getOrientation(), (Enum)StiPageOrientation.Portrait);
        jObject.AddPropertyDouble("PageWidth", this.getPageWidth(), 827.0);
        jObject.AddPropertyDouble("PageHeight", this.getPageHeight(), 1169.0);
        jObject.AddPropertyInt("SegmentPerWidth", this.getSegmentPerWidth(), 1);
        jObject.AddPropertyInt("SegmentPerHeight", this.getSegmentPerHeight(), 1);
        jObject.AddPropertyJObject("Watermark", this.getWatermark().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("Margins", this.getMargins().SaveToJsonObject(mode, 39.0, 39.0, 39.0, 39.0));
        jObject.AddPropertyBool("MirrorMargins", this.getMirrorMargins().booleanValue(), false);
        jObject.AddPropertyStringNullOfEmpty("Icon", this.icon);
        if (this.getReportUnit() != null) {
            jObject.AddPropertyJObject("ReportUnit", StiUnit.SaveToJsonObject(this.getReportUnit()));
        }
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("ResetPageNumber")) {
                this.resetPageNumber = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("BeginRenderEvent")) {
                this.getBeginRenderEvent().LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if (property.Name.equals("RenderingEvent")) {
                this.getRenderingEvent().LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if (property.Name.equals("EndRenderEvent")) {
                this.getEndRenderEvent().LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if (property.Name.equals("ColumnBeginRenderEvent")) {
                this.getColumnBeginRenderEvent().LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if (property.Name.equals("ColumnEndRenderEvent")) {
                this.getColumnEndRenderEvent().LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if (property.Name.equals("GetExcelSheetEvent")) {
                this.getGetExcelSheetEvent().LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if (property.Name.equals("ExcelSheetValue")) {
                this.excelSheetValue = (String)property.Value;
                continue;
            }
            if (property.Name.equals("ExcelSheet")) {
                this.getExcelSheet().LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if (property.Name.equals("PrintOnPreviousPage")) {
                this.printOnPreviousPage = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("PrintHeadersFootersFromPreviousPage")) {
                this.printHeadersFootersFromPreviousPage = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("PaperSize")) {
                this.paperSize = StiPaperKind.valueOf((String)((String)property.Value));
                continue;
            }
            if (property.Name.equals("PaperSourceOfFirstPage")) {
                this.paperSourceOfFirstPage = (String)property.Value;
                continue;
            }
            if (property.Name.equals("Icon")) {
                this.icon = (String)property.Value;
                continue;
            }
            if (property.Name.equals("PaperSourceOfOtherPages")) {
                this.paperSourceOfOtherPages = (String)property.Value;
                continue;
            }
            if (property.Name.equals("NumberOfCopies")) {
                this.numberOfCopies = (Integer)property.Value;
                continue;
            }
            if (property.Name.equals("UnlimitedBreakable")) {
                this.unlimitedBreakable = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("LargeHeight")) {
                this.largeHeight = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("LargeHeightFactor")) {
                this.largeHeightFactor = (Integer)property.Value;
                continue;
            }
            if (property.Name.equals("StopBeforePrint")) {
                this.stopBeforePrint = (Integer)property.Value;
                continue;
            }
            if (property.Name.equals("StretchToPrintArea")) {
                this.stretchToPrintArea = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("TitleBeforeHeader")) {
                this.titleBeforeHeader = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("UnlimitedHeight")) {
                this.unlimitedHeight = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("UnlimitedWidth")) {
                this.unlimitedWidth = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("Orientation")) {
                this.orientation = StiPageOrientation.valueOf((String)property.Value);
                continue;
            }
            if (property.Name.equals("PageWidth")) {
                this.pageWidth = property.doubleValue();
                continue;
            }
            if (property.Name.equals("PageHeight")) {
                this.pageHeight = property.doubleValue();
                continue;
            }
            if (property.Name.equals("SegmentPerWidth")) {
                this.segmentPerWidth = (Integer)property.Value;
                continue;
            }
            if (property.Name.equals("SegmentPerHeight")) {
                this.segmentPerHeight = (Integer)property.Value;
                continue;
            }
            if (property.Name.equals("Watermark")) {
                this.getWatermark().LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if (property.Name.equals("Margins")) {
                this.margins.LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if (property.Name.equals("MirrorMargins")) {
                this.mirrorMargins = (Boolean)property.Value;
                continue;
            }
            if (!property.Name.equals("ReportUnit")) continue;
            this.reportUnit = StiUnit.LoadFromJsonObject((JSONObject)property.Value);
        }
    }

    @Override
    @StiDefaulValue(value="false")
    @StiSerializable
    public boolean getResetPageNumber() {
        return this.resetPageNumber;
    }

    @Override
    public void setResetPageNumber(boolean value) {
        this.resetPageNumber = value;
    }

    public final double ConvertToHInches(StiUnit unit, double value) {
        if (unit instanceof StiCentimetersUnit) {
            if (value == 21.0) {
                return 827.0;
            }
            if (value == 29.7) {
                return 1169.0;
            }
            if (value == 1.0) {
                return 39.0;
            }
        } else if (unit instanceof StiMillimetersUnit) {
            if (value == 210.0) {
                return 827.0;
            }
            if (value == 297.0) {
                return 1169.0;
            }
            if (value == 10.0) {
                return 39.0;
            }
        }
        return unit == null ? value : unit.ConvertToHInches(value);
    }

    public final double ConvertFromHInches(StiUnit unit, double value) {
        if (unit instanceof StiCentimetersUnit) {
            if (value == 827.0) {
                return 21.0;
            }
            if (value == 1169.0) {
                return 29.7;
            }
            if (value == 39.0) {
                return 1.0;
            }
        } else if (unit instanceof StiMillimetersUnit) {
            if (value == 827.0) {
                return 210.0;
            }
            if (value == 1169.0) {
                return 297.0;
            }
            if (value == 39.0) {
                return 10.0;
            }
        }
        return unit == null ? value : unit.ConvertFromHInches(value);
    }

    public final StiRectangle convertToHInches(StiUnit unit, StiRectangle rect) {
        return new StiRectangle(this.ConvertToHInches(unit, rect.getLeft()), this.ConvertToHInches(unit, rect.getTop()), this.ConvertToHInches(unit, rect.getWidth()), this.ConvertToHInches(unit, rect.getHeight()));
    }

    @Override
    public void convert(StiUnit oldUnit, StiUnit newUnit) {
        this.setPageWidth(this.ConvertFromHInches(newUnit, this.ConvertToHInches(oldUnit, this.getPageWidth())));
        this.setPageHeight(this.ConvertFromHInches(newUnit, this.ConvertToHInches(oldUnit, this.getPageHeight())));
        this.setMargins(new StiMargins(this.ConvertFromHInches(newUnit, this.ConvertToHInches(oldUnit, this.getMargins().getLeft())), this.ConvertFromHInches(newUnit, this.ConvertToHInches(oldUnit, this.getMargins().getRight())), this.ConvertFromHInches(newUnit, this.ConvertToHInches(oldUnit, this.getMargins().getTop())), this.ConvertFromHInches(newUnit, this.ConvertToHInches(oldUnit, this.getMargins().getBottom()))));
        for (StiComponent component : this.getComponents()) {
            component.convert(oldUnit, newUnit);
        }
    }

    @Override
    public boolean getCanShrink() {
        return super.getCanShrink();
    }

    @Override
    public void setCanShrink(boolean value) {
    }

    @Override
    public Object clone(boolean cloneProperties, boolean cloneComponents) {
        Object tempVar = super.clone(cloneProperties, cloneComponents);
        StiPage page = (StiPage)(tempVar instanceof StiPage ? tempVar : null);
        page.margins = (StiMargins)this.getMargins().clone();
        page.orientation = this.orientation;
        page.watermark = this.watermark != null ? (StiWatermark)this.watermark.clone() : null;
        page.setComponents(new StiComponentsCollection(page));
        if (cloneComponents) {
            for (StiComponent comp : this.getComponents()) {
                page.getComponents().add((StiComponent)comp.clone());
            }
            StiComponentsCollection comps = page.GetComponents();
            for (StiComponent comp : comps) {
                comp.setPage(page);
            }
        }
        return page;
    }

    @Override
    public boolean getCanGrow() {
        return super.getCanGrow();
    }

    @Override
    public void setCanGrow(boolean value) {
    }

    @Override
    public StiPrintOnType getPrintOn() {
        return super.getPrintOn();
    }

    @Override
    public void setPrintOn(StiPrintOnType value) {
        super.setPrintOn(value);
    }

    @Override
    public boolean getCanBreak() {
        return super.getCanBreak();
    }

    @Override
    public void setCanBreak(boolean value) {
        super.setCanBreak(value);
    }

    public boolean getIsAutomaticDock() {
        return true;
    }

    @Override
    public StiDockStyle getDockStyle() {
        return super.getDockStyle();
    }

    @Override
    public void setDockStyle(StiDockStyle value) {
        super.setDockStyle(value);
    }

    @Override
    public StiSize getMinSize() {
        return super.getMinSize();
    }

    @Override
    public void setMinSize(StiSize value) {
        super.setMinSize(value);
    }

    @Override
    public StiSize getMaxSize() {
        return super.getMaxSize();
    }

    @Override
    public void setMaxSize(StiSize value) {
        super.setMaxSize(value);
    }

    @Override
    public double getLeft() {
        return 0.0;
    }

    @Override
    public void setLeft(double value) {
        super.setLeft(0.0);
    }

    @Override
    public double getTop() {
        return 0.0;
    }

    @Override
    public void setTop(double value) {
    }

    @Override
    public double getWidth() {
        return (this.getPageWidth() - this.getMargins().getLeft() - this.getMargins().getRight()) * (double)this.getSegmentPerWidth();
    }

    @Override
    public void setWidth(double value) {
        this.pageWidth = value / (double)this.getSegmentPerWidth() + this.getMargins().getLeft() + this.getMargins().getRight();
    }

    @Override
    public double getHeight() {
        double value = (this.pageHeight - this.getMargins().getTop() - this.getMargins().getBottom()) * (double)this.getSegmentPerHeight();
        if (this.getIsDesigning()) {
            value = this.getLargeHeight() ? (value *= this.getLargeHeightAutoFactor()) : (value += (this.pageHeight - this.getMargins().getTop() - this.getMargins().getBottom()) * (this.getLargeHeightAutoFactor() - 1.0));
        }
        return value;
    }

    @Override
    public void setHeight(double value) {
        this.pageHeight = value / (double)this.getSegmentPerHeight() + this.getMargins().getTop() + this.getMargins().getBottom();
        if (this.getPage().getLargeHeight() && this.getIsDesigning()) {
            this.pageHeight /= (double)this.getLargeHeightFactor();
        }
    }

    @Override
    public double getRight() {
        return this.getWidth();
    }

    @Override
    public double getBottom() {
        return this.getHeight();
    }

    @Override
    @StiSerializable(need=false)
    public StiRectangle getClientRectangle() {
        return new StiRectangle(0.0, 0.0, this.getWidth(), this.getHeight());
    }

    @Override
    public void setClientRectangle(StiRectangle value) {
        this.setWidth(value.getWidth());
        this.setHeight(value.getHeight());
    }

    @Override
    public StiRectangle getDisplayRectangle() {
        return new StiRectangle(0.0, 0.0, this.getWidth() + this.getMargins().getLeft() + this.getMargins().getRight(), this.getHeight() + this.getMargins().getTop() + this.getMargins().getBottom());
    }

    public final boolean getDenyDrawSegmentMode() {
        return this.denyDrawSegmentMode;
    }

    public final void setDenyDrawSegmentMode(boolean value) {
        this.denyDrawSegmentMode = value;
    }

    public final StiRectangle getSelectedRectangle() {
        return this.selectedRectangle;
    }

    public final void setSelectedRectangle(StiRectangle value) {
        this.selectedRectangle = value;
    }

    public final ArrayList<StiComponent> getSelectedComponents() {
        if (this.selectedComponents == null) {
            this.selectedComponents = new ArrayList();
        }
        return this.selectedComponents;
    }

    @Override
    public boolean getUseParentStyles() {
        return super.getUseParentStyles();
    }

    @Override
    public void setUseParentStyles(boolean value) {
        if (super.getUseParentStyles() != value) {
            super.setUseParentStyles(value);
        }
    }

    @Override
    public boolean getGrowToHeight() {
        return super.getGrowToHeight();
    }

    @Override
    public void setGrowToHeight(boolean value) {
    }

    @Override
    public StiEnumSet<StiShiftMode> getShiftMode() {
        return StiEnumSet.of((Enum)StiShiftMode.None);
    }

    @Override
    public void setShiftMode(StiEnumSet<StiShiftMode> value) {
    }

    @Override
    @StiSerializable(need=false)
    public boolean getPrintable() {
        return false;
    }

    @Override
    public void setPrintable(boolean value) {
    }

    @Override
    public StiEventsCollection getEvents() {
        StiEventsCollection events = super.getEvents();
        if (this.getBeginRenderEvent() != null) {
            events.add(this.getBeginRenderEvent());
        }
        if (this.getRenderingEvent() != null) {
            events.add(this.getRenderingEvent());
        }
        if (this.getEndRenderEvent() != null) {
            events.add(this.getEndRenderEvent());
        }
        return events;
    }

    @Override
    public String getLocalizedName() {
        if (StiLocalization.getLocalization().getCultureName().equals("en")) {
            return "Page";
        }
        return StiLocalization.Get((String)"Components", (String)"StiPage");
    }

    @Override
    @StiSerializable
    @Deprecated
    public StiPage getPage() {
        return this;
    }

    @Override
    public void setPage(StiPage value) {
    }

    @Override
    public StiContainer getParent() {
        return this.parent;
    }

    @Override
    public void setParent(StiContainer value) {
    }

    @Override
    public StiEnumSet<StiRestrictions> getRestrictions() {
        return super.getRestrictions();
    }

    @Override
    public void setRestrictions(StiEnumSet<StiRestrictions> value) {
        super.setRestrictions(value);
    }

    protected void OnBeginRender(EventArgs e) {
    }

    @Override
    public final void InvokeBeginRender() {
        this.OnBeginRender(EventArgs.Empty);
        this.handlerBeginRender.invoke(new StiEventObject((Object)this));
        StiBlocklyHelper.invokeBlockly(this.getReport(), this, this.getBeginRenderEvent(), EventArgs.Empty);
    }

    @StiSerializable
    public StiBeginRenderEvent getBeginRenderEvent() {
        return new StiBeginRenderEvent(this);
    }

    public void setBeginRenderEvent(StiBeginRenderEvent value) {
        if (value != null) {
            value.set(this, value.getScript());
        }
    }

    protected void OnRendering(EventArgs e) {
    }

    public final void InvokeRendering() {
        this.OnRendering(EventArgs.Empty);
        this.handlerRendering.invoke(new StiEventObject((Object)this));
        StiBlocklyHelper.invokeBlockly(this.getReport(), this, this.getRenderingEvent());
    }

    @StiSerializable
    public StiRenderingEvent getRenderingEvent() {
        return new StiRenderingEvent(this);
    }

    public void setRenderingEvent(StiRenderingEvent value) {
        if (value != null) {
            value.set(this, value.getScript());
        }
    }

    protected void OnEndRender(EventArgs e) {
    }

    @Override
    public final void InvokeEndRender() {
        this.OnEndRender(EventArgs.Empty);
        this.handlerEndRender.invoke(new StiEventObject((Object)this));
        StiBlocklyHelper.invokeBlockly(this.getReport(), this, this.getEndRenderEvent());
    }

    @StiSerializable
    public StiEndRenderEvent getEndRenderEvent() {
        return new StiEndRenderEvent(this);
    }

    public void setEndRenderEvent(StiEndRenderEvent value) {
        if (value != null) {
            value.set(this, value.getScript());
        }
    }

    protected void OnColumnBeginRender(EventArgs e) {
    }

    public final void InvokeColumnBeginRender() {
        this.InvokeColumnBeginRender(this, EventArgs.Empty);
    }

    public final void InvokeColumnBeginRender(Object sender, EventArgs e) {
        this.OnColumnBeginRender(e);
        this.handlerOnColumnBeginRender.invoke(new StiEventObject(sender, e));
        StiBlocklyHelper.invokeBlockly(this.report, sender, this.getColumnBeginRenderEvent());
    }

    @StiSerializable
    public StiColumnBeginRenderEvent getColumnBeginRenderEvent() {
        return new StiColumnBeginRenderEvent(this);
    }

    public void setColumnBeginRenderEvent(StiColumnBeginRenderEvent value) {
        if (value != null) {
            value.set(this, value.getScript());
        }
    }

    protected void OnColumnEndRender(EventArgs e) {
    }

    public final void InvokeColumnEndRender() {
        this.InvokeColumnEndRender(this, EventArgs.Empty);
    }

    public final void InvokeColumnEndRender(Object sender, EventArgs e) {
        this.OnColumnEndRender(e);
        this.handlerOnColumnEndRender.invoke(new StiEventObject(sender, e));
        StiBlocklyHelper.invokeBlockly(this.report, sender, this.getColumnEndRenderEvent());
    }

    @StiSerializable
    public StiColumnEndRenderEvent getColumnEndRenderEvent() {
        return new StiColumnEndRenderEvent(this);
    }

    public void setColumnEndRenderEvent(StiColumnEndRenderEvent value) {
        if (value != null) {
            value.set(this, value.getScript());
        }
    }

    protected void OnGetExcelSheet(StiGetExcelSheetEventArgs e) {
    }

    public void InvokeGetExcelSheet(StiComponent sender, StiGetExcelSheetEventArgs e) {
        this.OnGetExcelSheet(e);
        this.handlerOnGetExcelSheet.invoke(new StiEventObject((Object)sender, (EventArgs)e));
        StiBlocklyHelper.invokeBlockly(this.getReport(), this, this.getGetExcelSheetEvent(), e);
    }

    @StiSerializable
    public StiGetExcelSheetEvent getGetExcelSheetEvent() {
        return new StiGetExcelSheetEvent(this);
    }

    public void setGetExcelSheetEvent(StiGetExcelSheetEvent value) {
        if (value != null) {
            value.set(this, value.getScript());
        }
    }

    @StiSerializable
    public final String getExcelSheetValue() {
        return this.excelSheetValue;
    }

    public final void setExcelSheetValue(String value) {
        this.excelSheetValue = value;
    }

    @StiSerializable
    public StiExcelSheetExpression getExcelSheet() {
        return new StiExcelSheetExpression(this, "ExcelSheet");
    }

    public void setExcelSheet(StiExcelSheetExpression value) {
        if (value != null) {
            value.set(this, "ExcelSheet", value.getValue());
        }
    }

    public final boolean getIsPrinted() {
        return this.isPrinted;
    }

    public final void setIsPrinted(boolean value) {
        this.isPrinted = value;
    }

    public double getZoom() {
        if (this.getReport() == null || this.getReport().getInfo() == null) {
            return 1.0;
        }
        return this.getReport().getInfo().getZoom();
    }

    public double getGridSize() {
        if (this.getReport().getUnit() instanceof StiMillimetersUnit) {
            return this.getReport().getInfo().getGridSizeMillimeters();
        }
        if (this.getReport().getUnit() instanceof StiCentimetersUnit) {
            return this.getReport().getInfo().getGridSizeCentimetres();
        }
        if (this.getReport().getUnit() instanceof StiHundredthsOfInchUnit) {
            return this.getReport().getInfo().getGridSizeHundredthsOfInch();
        }
        return this.getReport().getInfo().getGridSizeInch();
    }

    @StiDefaulValue(value="false")
    @StiSerializable(type=StiSerializeTypesEnum.SerializeToSaveLoad)
    public boolean getPrintOnPreviousPage() {
        return this.printOnPreviousPage;
    }

    public void setPrintOnPreviousPage(boolean value) {
        this.printOnPreviousPage = value;
    }

    @StiDefaulValue(value="false")
    @StiSerializable(type=StiSerializeTypesEnum.SerializeToSaveLoad)
    public boolean getPrintHeadersFootersFromPreviousPage() {
        return this.printHeadersFootersFromPreviousPage;
    }

    public void setPrintHeadersFootersFromPreviousPage(boolean value) {
        this.printHeadersFootersFromPreviousPage = value;
    }

    @StiDefaulValue(value="Custom")
    @StiSerializable
    public StiPaperKind getPaperSize() {
        return this.paperSize;
    }

    public void setPaperSize(StiPaperKind value) {
        if (this.paperSize != value) {
            this.paperSize = value;
            if (value == StiPaperKind.Custom || this.report == null) {
                return;
            }
            StiSize pageSize = StiPageHelper.getPaperSize(this, value.getSize());
            this.setPageWidth(pageSize.width);
            this.setPageHeight(pageSize.height);
        }
    }

    @StiDefaulValue(value="Custom")
    public StiPaperSourceKind getPaperSourceFirstPage() {
        return StiPaperSourceKind.Custom;
    }

    public void setPaperSourceFirstPage(StiPaperSourceKind value) {
        if (value == StiPaperSourceKind.Custom) {
            return;
        }
    }

    @StiDefaulValue(value="")
    @StiSerializable
    public String getPaperSourceOfFirstPage() {
        return this.paperSourceOfFirstPage;
    }

    public void setPaperSourceOfFirstPage(String value) {
        if (!this.paperSourceOfFirstPage.equals(value)) {
            this.paperSourceOfFirstPage = value;
        }
    }

    @StiDefaulValue(value="Custom")
    public StiPaperSourceKind getPaperSourceOtherPages() {
        return StiPaperSourceKind.Custom;
    }

    public void setPaperSourceOtherPages(StiPaperSourceKind value) {
        if (value == StiPaperSourceKind.Custom) {
            return;
        }
    }

    @StiDefaulValue(value="")
    @StiSerializable
    public String getPaperSourceOfOtherPages() {
        return this.paperSourceOfOtherPages;
    }

    public void setPaperSourceOfOtherPages(String value) {
        if (!this.paperSourceOfOtherPages.equals(value)) {
            this.paperSourceOfOtherPages = value;
        }
    }

    @StiDefaulValue(value="1")
    @StiSerializable(type=StiSerializeTypesEnum.SerializeToSaveLoad)
    public int getNumberOfCopies() {
        return this.numberOfCopies;
    }

    public void setNumberOfCopies(int value) {
        if (this.numberOfCopies != value) {
            if (value < 1) {
                throw new IllegalArgumentException("Value of NumberOfCopies must be greater than or equal to 1.");
            }
            this.numberOfCopies = value;
        }
    }

    @StiDefaulValue(value="true")
    @StiSerializable(type=StiSerializeTypesEnum.SerializeToSaveLoad)
    public boolean getUnlimitedBreakable() {
        return this.unlimitedBreakable;
    }

    public void setUnlimitedBreakable(boolean value) {
        this.unlimitedBreakable = value;
    }

    @StiDefaulValue(value="false")
    @StiSerializable(type=StiSerializeTypesEnum.SerializeToSaveLoad)
    public boolean getLargeHeight() {
        return this.largeHeight;
    }

    public void setLargeHeight(boolean value) {
        this.largeHeight = value;
    }

    @StiDefaulValue(value="4")
    @StiSerializable(type=StiSerializeTypesEnum.SerializeToSaveLoad)
    public int getLargeHeightFactor() {
        return this.largeHeightFactor;
    }

    public void setLargeHeightFactor(int value) {
        if (value >= 1 && value <= 20) {
            this.largeHeightFactor = value;
        }
    }

    public int getCurrentWidthSegment() {
        return this.currentWidthSegment;
    }

    public void setCurrentWidthSegment(int value) {
        this.currentWidthSegment = value;
    }

    public int getCurrentHeightSegment() {
        return this.currentHeightSegment;
    }

    public void setCurrentHeightSegment(int value) {
        this.currentHeightSegment = value;
    }

    @StiDefaulValue(value="0")
    @StiSerializable(type=StiSerializeTypesEnum.SerializeToSaveLoad)
    public int getStopBeforePrint() {
        return this.stopBeforePrint;
    }

    public void setStopBeforePrint(int value) {
        this.stopBeforePrint = value;
    }

    @StiDefaulValue(value="false")
    public boolean getSkip() {
        return this.skip;
    }

    public void setSkip(boolean value) {
        this.skip = value;
    }

    @StiDefaulValue(value="false")
    @StiSerializable
    public boolean getStretchToPrintArea() {
        return this.stretchToPrintArea;
    }

    public void setStretchToPrintArea(boolean value) {
        this.stretchToPrintArea = value;
    }

    @StiDefaulValue(value="false")
    @StiSerializable(type=StiSerializeTypesEnum.SerializeToSaveLoad)
    public boolean getTitleBeforeHeader() {
        return this.titleBeforeHeader;
    }

    public void setTitleBeforeHeader(boolean titleBeforeHeader) {
        this.titleBeforeHeader = titleBeforeHeader;
    }

    @StiDefaulValue(value="false")
    @StiSerializable
    public boolean getUnlimitedHeight() {
        return this.unlimitedHeight;
    }

    public void setUnlimitedHeight(boolean value) {
        this.unlimitedHeight = value;
    }

    @StiDefaulValue(value="true")
    @StiSerializable
    public boolean getUnlimitedWidth() {
        return this.unlimitedWidth;
    }

    public void setUnlimitedWidth(boolean value) {
        this.unlimitedWidth = value;
    }

    public StiRectangle getOffsetRectangle() {
        return this.offsetRectangle;
    }

    public void setOffsetRectangle(StiRectangle value) {
        this.offsetRectangle = value;
    }

    @StiDefaulValue(value="Portrait")
    @StiSerializable
    public StiPageOrientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(StiPageOrientation value) {
        double left = this.getMargins().getLeft();
        double right = this.getMargins().getRight();
        double top = this.getMargins().getTop();
        double bottom = this.getMargins().getBottom();
        if (this.orientation != value && this.report != null && !this.report.getIsSerializing()) {
            double temp = this.getPageHeight();
            this.setPageHeight(this.getPageWidth());
            this.setPageWidth(temp);
            if (value == StiPageOrientation.Landscape) {
                this.setMargins(new StiMargins(top, bottom, right, left));
            } else {
                this.setMargins(new StiMargins(bottom, top, left, right));
            }
        }
        this.orientation = value;
    }

    @Override
    public boolean getLocked() {
        return false;
    }

    @Override
    public void setLocked(boolean value) {
    }

    @Override
    public boolean getLinked() {
        return false;
    }

    @Override
    public void setLinked(boolean value) {
    }

    @StiDefaulValue(value="827.0")
    @StiSerializable
    public double getPageWidth() {
        return this.pageWidth;
    }

    public void setPageWidth(double value) {
        this.pageWidth = (double)Math.round(value * Math.pow(10.0, 2.0)) / Math.pow(10.0, 2.0);
    }

    @StiDefaulValue(value="1169.0")
    @StiSerializable
    public double getPageHeight() {
        return this.pageHeight;
    }

    public void setPageHeight(double value) {
        this.pageHeight = (double)Math.round(value * Math.pow(10.0, 2.0)) / Math.pow(10.0, 2.0);
    }

    @StiDefaulValue(value="1")
    @StiSerializable
    public int getSegmentPerWidth() {
        if (this.segmentPerWidth == null) {
            this.segmentPerWidth = 1;
        }
        return this.segmentPerWidth;
    }

    public void setSegmentPerWidth(int value) {
        if (value > 0) {
            this.segmentPerWidth = value;
        }
    }

    @StiDefaulValue(value="1")
    @StiSerializable
    public int getSegmentPerHeight() {
        if (this.segmentPerHeight == null) {
            this.segmentPerHeight = 1;
        }
        return this.segmentPerHeight;
    }

    public void setSegmentPerHeight(int value) {
        if (value > 0) {
            this.segmentPerHeight = value;
        }
    }

    @StiSerializable
    public StiWatermark getWatermark() {
        if (this.watermark == null) {
            this.watermark = new StiWatermark();
        }
        return this.watermark;
    }

    public void setWatermark(StiWatermark value) {
        this.watermark = value;
    }

    @StiSerializable
    public StiMargins getMargins() {
        if (this.margins == null) {
            this.margins = new StiMargins(39.0, 39.0, 39.0, 39.0);
        }
        return this.margins;
    }

    public void setMargins(StiMargins value) {
        this.margins = value;
    }

    @Override
    @StiSerializable(isRef=true, type=StiSerializeTypesEnum.SerializeToSaveLoad)
    public StiReport getReport() {
        return this.report;
    }

    @Override
    public void setReport(StiReport value) {
        this.report = value;
    }

    public StiUnit getUnit() {
        if (this.report == null) {
            return StiUnit.HundredthsOfInch;
        }
        return this.report.getUnit();
    }

    @StiSerializable(isRef=false)
    public final StiUnit getReportUnit() {
        return this.reportUnit;
    }

    public final void setReportUnit(StiUnit value) {
        this.reportUnit = value;
    }

    public final boolean getLockHighlight() {
        return this.lockHighlight;
    }

    public final void setLockHighlight(boolean value) {
        this.lockHighlight = value;
    }

    public final boolean getDrillDownActivated() {
        return this.drillDownActivated;
    }

    public final void setDrillDownActivated(boolean value) {
        this.drillDownActivated = value;
    }

    public final String getCacheGuid() {
        if (this.cacheGuid == null) {
            this.NewCacheGuid();
        }
        return this.cacheGuid;
    }

    public final void NewCacheGuid() {
        this.cacheGuid = UUID.randomUUID().toString().replace("-", "");
    }

    public final void ClearPage() {
        Hashtable<String, Object> cache = new Hashtable<String, Object>();
        Object resultTrue = new Object();
        Object resultFalse = new Object();
        this.getComponents().SetParent(this);
        this.MoveComponentsToPage();
        int index = 0;
        while (index < this.getComponents().size()) {
            StiContainer container = (StiContainer)(this.getComponents().get(index) instanceof StiContainer ? (StiComponent)this.getComponents().get(index) : null);
            boolean isPageTotalDataBand = false;
            if (container != null) {
                if (cache.get(container.getName()) == null) {
                    isPageTotalDataBand = this.GetIsPageTotalDataBand(container.getName());
                    if (isPageTotalDataBand) {
                        cache.put(container.getName(), resultTrue);
                    } else {
                        cache.put(container.getName(), resultFalse);
                    }
                } else {
                    isPageTotalDataBand = cache.get(container.getName()) == resultTrue;
                }
            }
            if (!isPageTotalDataBand && container != null && container.getTagValue() == null && container.getBookmarkValue() == null && container.getToolTipValue() == null && container.getHyperlinkValue() == null && container.getGuid() == null && container.getInteraction() == null && (container.getBorder() == null || container.getBorder().getSide().containsOnly((IStiEnum)StiBorderSides.None) && !container.getBorder().getDropShadow()) && (container.getBrush() == null || container.getBrush() instanceof StiSolidBrush && ((StiSolidBrush)container.getBrush()).getColor() == StiColor.Transparent)) {
                this.getComponents().remove(container);
                continue;
            }
            ++index;
        }
    }

    private boolean GetIsPageTotalDataBand(String name) {
        return false;
    }

    private int GetComponentsCount(StiContainer container) {
        int count = container.getComponents().size();
        for (StiComponent comp : container.getComponents()) {
            StiContainer cont = (StiContainer)(comp instanceof StiContainer ? comp : null);
            if (cont == null) continue;
            count += this.GetComponentsCount(cont);
        }
        return count;
    }

    @Override
    public int GetComponentsCount() {
        return this.GetComponentsCount(this);
    }

    public StiEngineVersion getEngineVersion() {
        return StiEngineVersion.EngineV2;
    }

    public boolean TitleBeforeHeader() {
        return this.getTitleBeforeHeader();
    }

    @Override
    public String getComponentPlacementForChildren() {
        return "";
    }

    @Override
    public Object clone() {
        StiPage object = (StiPage)super.clone();
        object.resetPageNumber = this.resetPageNumber;
        object.denyDrawSegmentMode = this.denyDrawSegmentMode;
        object.excelSheetValue = this.excelSheetValue;
        object.printOnPreviousPage = this.printOnPreviousPage;
        object.printHeadersFootersFromPreviousPage = this.printHeadersFootersFromPreviousPage;
        object.paperSize = this.paperSize;
        object.paperSourceOfFirstPage = this.paperSourceOfFirstPage;
        object.paperSourceOfOtherPages = this.paperSourceOfOtherPages;
        object.numberOfCopies = this.numberOfCopies;
        object.unlimitedBreakable = this.unlimitedBreakable;
        object.largeHeight = this.largeHeight;
        object.largeHeightFactor = this.largeHeightFactor;
        object.currentWidthSegment = this.currentWidthSegment;
        object.currentHeightSegment = this.currentHeightSegment;
        object.stopBeforePrint = this.stopBeforePrint;
        object.skip = this.skip;
        object.stretchToPrintArea = this.stretchToPrintArea;
        object.titleBeforeHeader = this.titleBeforeHeader;
        object.unlimitedHeight = this.unlimitedHeight;
        object.unlimitedWidth = this.unlimitedWidth;
        object.offsetRectangle = this.offsetRectangle.clone();
        object.orientation = this.orientation;
        object.pageWidth = this.pageWidth;
        object.pageHeight = this.pageHeight;
        object.segmentPerWidth = this.segmentPerWidth;
        object.segmentPerHeight = this.segmentPerHeight;
        object.report = this.report;
        object.lockHighlight = this.lockHighlight;
        object.drillDownActivated = this.drillDownActivated;
        object.pageInfoV2 = this.pageInfoV2;
        object.margins = (StiMargins)this.margins.clone();
        if (this.watermark != null) {
            object.watermark = (StiWatermark)this.watermark.clone();
        }
        if (this.reportUnit != null) {
            object.reportUnit = (StiUnit)((Object)this.reportUnit.clone());
        }
        return object;
    }

    public StiPageInfoV2 getPageInfoV2() {
        return this.pageInfoV2;
    }

    @Override
    @StiSerializable
    public String getName() {
        return super.getName();
    }

    @Override
    @StiSerializable
    @StiDefaulValue(value="null")
    public String getGuid() {
        return super.getGuid();
    }

    @Override
    @StiSerializable(type=StiSerializeTypesEnum.SerializeToDocument)
    public Object getTagValue() {
        return super.getTagValue();
    }

    @StiSerializable
    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public double getLargeHeightAutoFactor() {
        if (this.largeHeight) {
            return this.largeHeightFactor;
        }
        if (StiOptions.Designer.isAutoLargeHeight()) {
            return this.largeHeightAutoFactor;
        }
        return 1.0;
    }

    public void setLargeHeightAutoFactor(double largeHeightAutoFactor) {
        if (largeHeightAutoFactor < 1.0) {
            this.largeHeightAutoFactor = 1.0;
        }
        if (largeHeightAutoFactor >= 1.0 && largeHeightAutoFactor <= 20.0) {
            this.largeHeightAutoFactor = largeHeightAutoFactor;
        }
    }

    @StiSerializable
    public Boolean getMirrorMargins() {
        return this.mirrorMargins;
    }

    public void setMirrorMargins(Boolean mirrorMargins) {
        this.mirrorMargins = mirrorMargins;
    }

    public boolean isPage() {
        return true;
    }

    public void disposeImagesAndClearComponents() {
        if (EngineOptions.ReportCache.disposeImagesOnPageClear) {
            for (StiComponent comp : this.components) {
                StiImage image = comp instanceof StiImage ? (StiImage)comp : null;
                if (image == null || image.getImageBytesToDraw() == null) continue;
                image.setImageBytesToDraw(null);
            }
        }
        this.components.clear();
    }

    public StiComponent GetComponentByName(String componentName) {
        return this.getComponents().GetComponentByName(componentName, this);
    }
}

