/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components;

import com.stimulsoft.base.IStiJsonReportObject;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.design.IStiDefault;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.StiSerializedObject;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.StiGuid;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiBandInteraction;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiCrossHeaderInteraction;
import com.stimulsoft.report.components.StiDrillDownMode;
import com.stimulsoft.report.components.StiDrillDownParameter;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.enums.StiInteractionSortDirection;
import com.stimulsoft.report.components.interfaces.IStiInteractionClass;
import com.stimulsoft.report.engine.IStiReportProperty;
import com.stimulsoft.report.expressions.StiBookmarkExpression;
import com.stimulsoft.report.expressions.StiHyperlinkExpression;
import com.stimulsoft.report.expressions.StiTagExpression;
import com.stimulsoft.report.expressions.StiToolTipExpression;

public class StiInteraction
extends StiSerializedObject
implements Cloneable,
IStiInteractionClass,
IStiReportProperty,
IStiDefault,
IStiJsonReportObject {
    private boolean sortingEnabled = true;
    private String sortingColumn = "";
    private int sortingIndex = 0;
    private StiInteractionSortDirection sortingDirection = StiInteractionSortDirection.None;
    private boolean drillDownEnabled = false;
    private String drillDownReport = "";
    private StiDrillDownParameter drillDownParameter1;
    private StiDrillDownParameter drillDownParameter2;
    private StiDrillDownParameter drillDownParameter3;
    private StiDrillDownParameter drillDownParameter4;
    private StiDrillDownParameter drillDownParameter5;
    public String drillDownPageGuid;
    public StiComponent ParentComponent;
    private StiDrillDownMode drillDownMode = StiDrillDownMode.MultiPage;

    public StiInteraction() {
        this.setDrillDownParameter1(new StiDrillDownParameter());
        this.setDrillDownParameter2(new StiDrillDownParameter());
        this.setDrillDownParameter3(new StiDrillDownParameter());
        this.setDrillDownParameter4(new StiDrillDownParameter());
        this.setDrillDownParameter5(new StiDrillDownParameter());
    }

    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = new JSONObject();
        jObject.AddPropertyIdent("Ident", this.getClass().getName());
        jObject.AddPropertyBool("SortingEnabled", this.getSortingEnabled(), true);
        jObject.AddPropertyStringNullOfEmpty("SortingColumn", this.getSortingColumn());
        jObject.AddPropertyBool("DrillDownEnabled", this.getDrillDownEnabled());
        jObject.AddPropertyStringNullOfEmpty("DrillDownReport", this.getDrillDownReport());
        jObject.AddPropertyEnum("DrillDownMode", (Enum)this.getDrillDownMode(), (Enum)StiDrillDownMode.MultiPage);
        jObject.AddPropertyStringNullOfEmpty("DrillDownPageGuid", this.drillDownPageGuid);
        jObject.AddPropertyJObject("DrillDownParameter5", this.getDrillDownParameter5().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("DrillDownParameter1", this.getDrillDownParameter1().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("DrillDownParameter2", this.getDrillDownParameter2().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("DrillDownParameter3", this.getDrillDownParameter3().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("DrillDownParameter4", this.getDrillDownParameter4().SaveToJsonObject(mode));
        return jObject;
    }

    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("SortingEnabled")) {
                this.sortingEnabled = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("SortingColumn")) {
                this.sortingColumn = property.Value.toString();
                continue;
            }
            if (property.Name.equals("DrillDownEnabled")) {
                this.drillDownEnabled = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("DrillDownReport")) {
                this.drillDownReport = property.Value.toString();
                continue;
            }
            if (property.Name.equals("DrillDownMode")) {
                this.drillDownMode = StiDrillDownMode.valueOf(property.Value.toString());
                continue;
            }
            if (property.Name.equals("DrillDownPageGuid")) {
                this.drillDownPageGuid = property.Value.toString();
                continue;
            }
            if (property.Name.equals("DrillDownParameter1")) {
                this.drillDownParameter1.LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if (property.Name.equals("DrillDownParameter2")) {
                this.drillDownParameter2.LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if (property.Name.equals("DrillDownParameter3")) {
                this.drillDownParameter3.LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if (property.Name.equals("DrillDownParameter4")) {
                this.drillDownParameter4.LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if (!property.Name.equals("DrillDownParameter5")) continue;
            this.drillDownParameter5.LoadFromJsonObject((JSONObject)property.Value);
        }
    }

    static StiInteraction LoadInteractionFromJsonObject(JSONObject jObject) throws JSONException {
        String ident = jObject.Properties().FirstOrDefault((String)"Ident").Value.toString();
        StiInteraction interaction = null;
        if (ident.equals("StiInteraction")) {
            interaction = new StiInteraction();
        } else if (ident.equals("StiBandInteraction")) {
            interaction = new StiBandInteraction();
        } else if (ident.equals("StiCrossHeaderInteraction")) {
            interaction = new StiCrossHeaderInteraction();
        }
        interaction.LoadFromJsonObject(jObject);
        return interaction;
    }

    public boolean isDefault() {
        return !(!this.getSortingEnabled() || this.getSortingColumn() != null && this.getSortingColumn().length() != 0 || this.getDrillDownEnabled() || this.getDrillDownReport() != null && this.getDrillDownReport().length() != 0 || this.getDrillDownPageGuid() != null || !this.getDrillDownParameter1().isDefault() || !this.getDrillDownParameter2().isDefault() || !this.getDrillDownParameter3().isDefault() || !this.getDrillDownParameter4().isDefault() || !this.getDrillDownParameter5().isDefault());
    }

    @StiSerializable
    public StiDrillDownParameter getDrillDownParameter1() {
        return this.drillDownParameter1;
    }

    public void setDrillDownParameter1(StiDrillDownParameter value) {
        if (this.drillDownParameter1 != value) {
            this.drillDownParameter1 = value;
            if (value != null) {
                value.setInteraction(this);
            }
        }
    }

    @StiSerializable
    public StiDrillDownParameter getDrillDownParameter2() {
        return this.drillDownParameter2;
    }

    public void setDrillDownParameter2(StiDrillDownParameter value) {
        if (this.drillDownParameter2 != value) {
            this.drillDownParameter2 = value;
            if (value != null) {
                value.setInteraction(this);
            }
        }
    }

    @StiSerializable
    public StiDrillDownParameter getDrillDownParameter3() {
        return this.drillDownParameter3;
    }

    public void setDrillDownParameter3(StiDrillDownParameter value) {
        if (this.drillDownParameter3 != value) {
            this.drillDownParameter3 = value;
            if (value != null) {
                value.setInteraction(this);
            }
        }
    }

    @StiSerializable
    public StiDrillDownParameter getDrillDownParameter4() {
        return this.drillDownParameter4;
    }

    public void setDrillDownParameter4(StiDrillDownParameter value) {
        if (this.drillDownParameter4 != value) {
            this.drillDownParameter4 = value;
            if (value != null) {
                value.setInteraction(this);
            }
        }
    }

    @StiSerializable
    public StiDrillDownParameter getDrillDownParameter5() {
        return this.drillDownParameter5;
    }

    public void setDrillDownParameter5(StiDrillDownParameter value) {
        if (this.drillDownParameter5 != value) {
            this.drillDownParameter5 = value;
            if (value != null) {
                value.setInteraction(this);
            }
        }
    }

    @StiSerializable(need=false)
    public StiPage getDrillDownPage() {
        if (this.ParentComponent == null || this.ParentComponent.getReport() == null) {
            return null;
        }
        for (StiPage page : this.ParentComponent.getReport().getPages()) {
            if (!StiValidationUtil.equals((Object)this.getDrillDownPageGuid(), (Object)page.getGuid())) continue;
            return page;
        }
        return null;
    }

    public void setDrillDownPage(StiPage value) {
        if (value == null) {
            this.drillDownPageGuid = null;
        } else {
            if (value.getGuid() == null) {
                value.setGuid(StiGuid.newGuidString());
            }
            this.setDrillDownPageGuid(value.getGuid());
        }
    }

    public StiHyperlinkExpression getHyperlink() {
        return this.ParentComponent.getHyperlink();
    }

    public void setHyperlink(StiHyperlinkExpression value) {
        this.ParentComponent.setHyperlink(value);
    }

    public StiTagExpression getTag() {
        return this.ParentComponent.getTag();
    }

    public void setTag(StiTagExpression value) {
        this.ParentComponent.setTag(value);
    }

    public StiToolTipExpression getToolTip() {
        return this.ParentComponent.getToolTip();
    }

    public void setToolTip(StiToolTipExpression value) {
        this.ParentComponent.setToolTip(value);
    }

    public final String GetSortDataBandName() {
        if (this.getSortingColumn() == null || this.getSortingColumn().length() == 0 || !this.getSortingEnabled()) {
            return "";
        }
        int indexOfDot = this.getSortingColumn().indexOf(".");
        if (indexOfDot != -1) {
            return this.getSortingColumn().substring(0, indexOfDot);
        }
        return "";
    }

    public final String[] GetSortColumns() {
        String str = this.GetSortColumnsString();
        if (str.length() == 0) {
            return null;
        }
        String[] strs = str.split("[.]", -1);
        return strs;
    }

    public final String GetSortColumnsString() {
        if (this.getSortingColumn() == null || this.getSortingColumn().length() == 0 || !this.getSortingEnabled()) {
            return "";
        }
        int indexOfDot = this.getSortingColumn().indexOf(".");
        if (indexOfDot != -1) {
            return this.getSortingColumn().substring(indexOfDot + 1);
        }
        return "";
    }

    public final Object GetReport() {
        if (this.ParentComponent == null) {
            return null;
        }
        return this.ParentComponent.getReport();
    }

    public final Object clone() {
        StiInteraction interaction;
        try {
            interaction = (StiInteraction)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        return interaction;
    }

    @StiDefaulValue(value="true")
    @StiSerializable
    public boolean getSortingEnabled() {
        return this.sortingEnabled;
    }

    public void setSortingEnabled(boolean value) {
        this.sortingEnabled = value;
    }

    @StiDefaulValue(value="")
    @StiSerializable
    public String getSortingColumn() {
        return this.sortingColumn;
    }

    public void setSortingColumn(String value) {
        this.sortingColumn = value;
    }

    public int getSortingIndex() {
        return this.sortingIndex;
    }

    public void setSortingIndex(int value) {
        this.sortingIndex = value;
    }

    public StiInteractionSortDirection getSortingDirection() {
        return this.sortingDirection;
    }

    public void setSortingDirection(StiInteractionSortDirection value) {
        this.sortingDirection = value;
    }

    @StiDefaulValue(value="false")
    @StiSerializable
    public boolean getDrillDownEnabled() {
        return this.drillDownEnabled;
    }

    public void setDrillDownEnabled(boolean value) {
        this.drillDownEnabled = value;
    }

    @StiDefaulValue(value="")
    @StiSerializable
    public String getDrillDownReport() {
        return this.drillDownReport;
    }

    public void setDrillDownReport(String value) {
        this.drillDownReport = value;
    }

    @StiSerializable
    public final String getDrillDownPageGuid() {
        return this.drillDownPageGuid;
    }

    public final void setDrillDownPageGuid(String value) {
        this.drillDownPageGuid = value;
    }

    public StiBookmarkExpression getBookmark() {
        return this.ParentComponent.getBookmark();
    }

    public void setBookmark(StiBookmarkExpression value) {
        this.ParentComponent.setBookmark(value);
    }

    @Override
    public StiReport getReport() {
        if (this.ParentComponent == null) {
            return null;
        }
        return this.ParentComponent.getReport();
    }

    public StiDrillDownMode getDrillDownMode() {
        return this.drillDownMode;
    }

    public void setDrillDownMode(StiDrillDownMode drillDownMode) {
        this.drillDownMode = drillDownMode;
    }
}

