/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.check.page;

import com.stimulsoft.base.localization.StiLocalizationExt;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.check.StiCheckStatus;
import com.stimulsoft.report.check.page.StiPageCheck;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.bands.StiGroupFooterBand;
import com.stimulsoft.report.components.bands.StiGroupHeaderBand;
import com.stimulsoft.report.dialogs.IStiForm;

public class StiGroupHeaderNotEqualToGroupFooterOnPageCheck
extends StiPageCheck {
    @Override
    public boolean getPreviewVisible() {
        return true;
    }

    @Override
    public String getShortMessage() {
        return StiLocalizationExt.Get((String)"CheckComponent", (String)"StiGroupHeaderNotEqualToGroupFooterShort");
    }

    @Override
    public String getLongMessage() {
        return StiLocalizationExt.format((String)"CheckComponent", (String)"StiGroupHeaderNotEqualToGroupFooterOnPageLong", (Object[])new Object[]{this.getElementName()});
    }

    @Override
    public StiCheckStatus getStatus() {
        return StiCheckStatus.Information;
    }

    private boolean check() {
        StiPage page;
        StiPage stiPage = page = this.getElement() instanceof StiPage ? (StiPage)this.getElement() : null;
        if (page != null && !(page instanceof IStiForm)) {
            int countGroupHeader = 0;
            int countGroupFooter = 0;
            for (int index = 0; index < page.getComponents().size(); ++index) {
                if (page.getComponents().get(index) instanceof StiGroupHeaderBand) {
                    ++countGroupHeader;
                    continue;
                }
                if (!(page.getComponents().get(index) instanceof StiGroupFooterBand)) continue;
                ++countGroupFooter;
            }
            if (countGroupHeader < countGroupFooter) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object processCheck(StiReport report, Object obj) {
        this.setElement(obj);
        try {
            boolean failed = this.check();
            if (failed) {
                StiGroupHeaderNotEqualToGroupFooterOnPageCheck check = new StiGroupHeaderNotEqualToGroupFooterOnPageCheck();
                check.setElement(obj);
                StiGroupHeaderNotEqualToGroupFooterOnPageCheck stiGroupHeaderNotEqualToGroupFooterOnPageCheck = check;
                return stiGroupHeaderNotEqualToGroupFooterOnPageCheck;
            }
            Object var4_5 = null;
            return var4_5;
        }
        finally {
            this.setElement(null);
        }
    }
}

