/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.check.component;

import com.stimulsoft.base.localization.StiLocalizationExt;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.check.StiCheckStatus;
import com.stimulsoft.report.check.actions.component.StiGrowToHeightOverlappingAction;
import com.stimulsoft.report.check.component.StiComponentCheck;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.table.StiTable;

public class StiGrowToHeightOverlappingCheck
extends StiComponentCheck {
    @Override
    public boolean getPreviewVisible() {
        return true;
    }

    @Override
    public String getShortMessage() {
        return StiLocalizationExt.Get((String)"CheckComponent", (String)"StiGrowToHeightOverlappingShort");
    }

    @Override
    public String getLongMessage() {
        return StiLocalizationExt.format((String)"CheckComponent", (String)"StiGrowToHeightOverlappingLong", (Object[])new Object[]{this.getElementName()});
    }

    @Override
    public StiCheckStatus getStatus() {
        return StiCheckStatus.Warning;
    }

    private boolean check() {
        StiComponent component;
        StiComponent stiComponent = component = this.getElement() instanceof StiComponent ? (StiComponent)this.getElement() : null;
        if (component.getGrowToHeight() && component.getParent() != null && !(component.getParent() instanceof StiPage) && !(component.getParent() instanceof StiTable) && component.getParent().getComponents().size() > 1) {
            StiRectangle baseRect = component.getClientRectangle();
            StiRectangle baseRectGrow = new StiRectangle(baseRect.x, baseRect.y, baseRect.width, component.getParent().getHeight() - baseRect.y);
            for (StiComponent comp : component.getParent().getComponents()) {
                if (comp == component || comp.getTop() < baseRect.getBottom() || !baseRectGrow.IntersectsWith(comp.getClientRectangle())) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object processCheck(StiReport report, Object obj) {
        this.setElement(obj);
        try {
            boolean failed = this.check();
            if (failed) {
                StiGrowToHeightOverlappingCheck check = new StiGrowToHeightOverlappingCheck();
                check.setElement(obj);
                check.getActions().add(new StiGrowToHeightOverlappingAction());
                StiGrowToHeightOverlappingCheck stiGrowToHeightOverlappingCheck = check;
                return stiGrowToHeightOverlappingCheck;
            }
            Object var4_5 = null;
            return var4_5;
        }
        finally {
            this.setElement(null);
        }
    }
}

