/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.check.component;

import com.stimulsoft.base.localization.StiLocalizationExt;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.check.StiCheckStatus;
import com.stimulsoft.report.check.component.StiComponentCheck;
import com.stimulsoft.report.components.complexcomponents.StiContainer;
import com.stimulsoft.report.components.crossBands.StiCrossGroupFooterBand;
import com.stimulsoft.report.components.crossBands.StiCrossGroupHeaderBand;

public class StiCrossGroupHeaderNotEqualToCrossGroupFooterOnContainerCheck
extends StiComponentCheck {
    @Override
    public boolean getPreviewVisible() {
        return true;
    }

    @Override
    public String getShortMessage() {
        return StiLocalizationExt.Get((String)"CheckComponent", (String)"StiGroupHeaderNotEqualToGroupFooterShort");
    }

    @Override
    public String getLongMessage() {
        return StiLocalizationExt.format((String)"CheckComponent", (String)"StiCrossGroupHeaderNotEqualToGroupCrossFooterOnContainerLong", (Object[])new Object[]{this.getElementName()});
    }

    @Override
    public StiCheckStatus getStatus() {
        return StiCheckStatus.Information;
    }

    private boolean check() {
        StiContainer container;
        StiContainer stiContainer = container = this.getElement() instanceof StiContainer ? (StiContainer)this.getElement() : null;
        if (container != null) {
            int countCrossGroupHeader = 0;
            int countCrossGroupFooter = 0;
            for (int index = 0; index < container.getComponents().size(); ++index) {
                if (container.getComponents().get(index) instanceof StiCrossGroupHeaderBand) {
                    ++countCrossGroupHeader;
                    continue;
                }
                if (!(container.getComponents().get(index) instanceof StiCrossGroupFooterBand)) continue;
                ++countCrossGroupFooter;
            }
            if (countCrossGroupHeader < countCrossGroupFooter) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object processCheck(StiReport report, Object obj) {
        this.setElement(obj);
        try {
            boolean failed = this.check();
            if (failed) {
                StiCrossGroupHeaderNotEqualToCrossGroupFooterOnContainerCheck check = new StiCrossGroupHeaderNotEqualToCrossGroupFooterOnContainerCheck();
                check.setElement(obj);
                StiCrossGroupHeaderNotEqualToCrossGroupFooterOnContainerCheck stiCrossGroupHeaderNotEqualToCrossGroupFooterOnContainerCheck = check;
                return stiCrossGroupHeaderNotEqualToCrossGroupFooterOnContainerCheck;
            }
            Object var4_5 = null;
            return var4_5;
        }
        finally {
            this.setElement(null);
        }
    }
}

