/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.check;

import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.localization.StiLocalizationExt;
import com.stimulsoft.base.system.StiEventHandler;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.check.StiCheck;
import com.stimulsoft.report.check.StiCheckStatus;
import com.stimulsoft.report.check.component.StiAllowHtmlTagsInTextCheck;
import com.stimulsoft.report.check.component.StiCanGrowComponentInContainerCheck;
import com.stimulsoft.report.check.component.StiCanGrowGrowToHeightComponentInContainerCheck;
import com.stimulsoft.report.check.component.StiCanGrowWordWrapTextAndWysiwygCheck;
import com.stimulsoft.report.check.component.StiColumnsWidthGreaterContainerWidthCheck;
import com.stimulsoft.report.check.component.StiComponentBoundsAreOutOfBand;
import com.stimulsoft.report.check.component.StiComponentDataColumnCheck;
import com.stimulsoft.report.check.component.StiComponentStyleIsNotFoundAtComponentCheck;
import com.stimulsoft.report.check.component.StiContainerInEngineV2Check;
import com.stimulsoft.report.check.component.StiContourTextObsoleteCheck;
import com.stimulsoft.report.check.component.StiCorruptedCrossLinePrimitiveCheck;
import com.stimulsoft.report.check.component.StiCountDataDataSourceAtDataBandCheck;
import com.stimulsoft.report.check.component.StiCrossGroupHeaderNotEqualToCrossGroupFooterOnContainerCheck;
import com.stimulsoft.report.check.component.StiDataSourcesForImageCheck;
import com.stimulsoft.report.check.component.StiFontMissingCheck;
import com.stimulsoft.report.check.component.StiGroupHeaderNotEqualToGroupFooterOnContainerCheck;
import com.stimulsoft.report.check.component.StiGrowToHeightOverlappingCheck;
import com.stimulsoft.report.check.component.StiLocationOutsidePageCheck;
import com.stimulsoft.report.check.component.StiMinRowsInColumnsCheck;
import com.stimulsoft.report.check.component.StiNegativeSizesOfComponentsCheck;
import com.stimulsoft.report.check.component.StiNoConditionAtGroupCheck;
import com.stimulsoft.report.check.component.StiNoNameComponentCheck;
import com.stimulsoft.report.check.component.StiPanelInEngineV1Check;
import com.stimulsoft.report.check.component.StiPrintOnDoublePassCheck;
import com.stimulsoft.report.check.component.StiPropertiesOnlyEngineV1Check;
import com.stimulsoft.report.check.component.StiPropertiesOnlyEngineV2Check;
import com.stimulsoft.report.check.component.StiShowInsteadNullValuesCheck;
import com.stimulsoft.report.check.component.StiSystemTextObsoleteCheck;
import com.stimulsoft.report.check.component.StiTextColorEqualToBackColorCheck;
import com.stimulsoft.report.check.component.StiUndefinedComponentCheck;
import com.stimulsoft.report.check.component.StiVerySmallSizesOfComponentsCheck;
import com.stimulsoft.report.check.component.StiWidthHeightZeroComponentCheck;
import com.stimulsoft.report.check.component.StiWordWrapCanGrowTextDoesNotFitCheck;
import com.stimulsoft.report.check.connection.StiUndefinedConnectionCheck;
import com.stimulsoft.report.check.datarelation.StiDifferentAmountOfKeysInDataRelationCheck;
import com.stimulsoft.report.check.datarelation.StiKeysInAbsentDataRelationCheck;
import com.stimulsoft.report.check.datarelation.StiKeysNotFoundRelationCheck;
import com.stimulsoft.report.check.datarelation.StiKeysTypesMismatchDataRelationCheck;
import com.stimulsoft.report.check.datarelation.StiNoNameDataRelationCheck;
import com.stimulsoft.report.check.datarelation.StiNoNameInSourceDataRelationCheck;
import com.stimulsoft.report.check.datarelation.StiSourcesInAbsentDataRelationCheck;
import com.stimulsoft.report.check.datasource.StiNoNameDataSourceCheck;
import com.stimulsoft.report.check.datasource.StiNoNameInSourceDataSourceCheck;
import com.stimulsoft.report.check.datasource.StiUndefinedDataSourceCheck;
import com.stimulsoft.report.check.page.StiColumnsWidthGreaterPageWidthCheck;
import com.stimulsoft.report.check.page.StiComponentStyleIsNotFoundAtPageCheck;
import com.stimulsoft.report.check.page.StiCrossGroupHeaderNotEqualToCrossGroupFooterOnPageCheck;
import com.stimulsoft.report.check.page.StiGroupHeaderNotEqualToGroupFooterOnPageCheck;
import com.stimulsoft.report.check.page.StiLargeHeightAtPageCheck;
import com.stimulsoft.report.check.page.StiLostPointsOnPageCheck;
import com.stimulsoft.report.check.page.StiNoNamePageCheck;
import com.stimulsoft.report.check.page.StiOrientationPageCheck;
import com.stimulsoft.report.check.page.StiPrintHeadersAndFootersFromPreviousPageCheck;
import com.stimulsoft.report.check.page.StiPrintOnPreviousPageCheck;
import com.stimulsoft.report.check.page.StiPrintOnPreviousPageCheck2;
import com.stimulsoft.report.check.page.StiResetPageNumberCheck;
import com.stimulsoft.report.check.report.StiDuplicatedNameCheck;
import com.stimulsoft.report.check.report.StiDuplicatedNameInSourceInDataRelationReportCheck;
import com.stimulsoft.report.check.report.StiIsFirstPageIsLastPageDoublePassCheck;
import com.stimulsoft.report.check.report.StiIsFirstPassIsSecondPassCheck;
import com.stimulsoft.report.check.report.StiTotalPageCountDoublePassCheck;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentsCollection;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.dictionary.StiDataColumn;
import com.stimulsoft.report.dictionary.StiDataRelation;
import com.stimulsoft.report.dictionary.StiVariable;
import com.stimulsoft.report.dictionary.dataSources.StiDataSource;
import com.stimulsoft.report.dictionary.databases.StiDatabase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class StiCheckEngine {
    public StiEventHandler finishCheckingReport;
    public StiEventHandler StartCheckingPages;
    public StiEventHandler CheckingPages;
    public StiEventHandler FinishCheckingPages;
    public StiEventHandler StartCheckingComponents;
    public StiEventHandler CheckingComponents;
    public StiEventHandler FinishCheckingComponents;
    public StiEventHandler StartCheckingDatabases;
    public StiEventHandler CheckingDatabases;
    public StiEventHandler FinishCheckingDatabases;
    public StiEventHandler StartCheckingDataSource;
    public StiEventHandler CheckingDataSource;
    public StiEventHandler FinishCheckingDataSource;
    public StiEventHandler StartCheckingRelations;
    public StiEventHandler CheckingRelations;
    public StiEventHandler FinishCheckingRelations;
    public StiEventHandler StartCheckingVariables;
    public StiEventHandler CheckingVariables;
    public StiEventHandler FinishCheckingVariables;
    private static List<StiCheck> checks = null;
    private double progressValue = 0.0;
    private double progressMaximum = 0.0;
    private String progressInformation = "";

    private void InvokeFinishCheckingReport() {
        if (this.finishCheckingReport != null) {
            this.finishCheckingReport.invoke(null);
        }
    }

    private void InvokeStartCheckingPages() {
        if (this.StartCheckingPages != null) {
            this.StartCheckingPages.invoke(null);
        }
    }

    private void InvokeCheckingPages() {
        if (this.CheckingPages != null) {
            this.CheckingPages.invoke(null);
        }
    }

    private void InvokeFinishCheckingPages() {
        if (this.FinishCheckingPages != null) {
            this.FinishCheckingPages.invoke(null);
        }
    }

    private void InvokeStartCheckingComponents() {
        if (this.StartCheckingComponents != null) {
            this.StartCheckingComponents.invoke(null);
        }
    }

    private void InvokeCheckingComponents() {
        if (this.CheckingComponents != null) {
            this.CheckingComponents.invoke(null);
        }
    }

    private void InvokeFinishCheckingComponents() {
        if (this.FinishCheckingComponents != null) {
            this.FinishCheckingComponents.invoke(null);
        }
    }

    private void InvokeStartCheckingDatabases() {
        if (this.StartCheckingDatabases != null) {
            this.StartCheckingDatabases.invoke(null);
        }
    }

    private void InvokeCheckingDatabases() {
        if (this.CheckingDatabases != null) {
            this.CheckingDatabases.invoke(null);
        }
    }

    private void InvokeFinishCheckingDatabases() {
        if (this.FinishCheckingDatabases != null) {
            this.FinishCheckingDatabases.invoke(null);
        }
    }

    private void InvokeStartCheckingDataSource() {
        if (this.StartCheckingDataSource != null) {
            this.StartCheckingDataSource.invoke(null);
        }
    }

    private void InvokeCheckingDataSource() {
        if (this.CheckingDataSource != null) {
            this.CheckingDataSource.invoke(null);
        }
    }

    private void InvokeFinishCheckingDataSource() {
        if (this.FinishCheckingDataSource != null) {
            this.FinishCheckingDataSource.invoke(null);
        }
    }

    private void InvokeStartCheckingRelations() {
        if (this.StartCheckingRelations != null) {
            this.StartCheckingRelations.invoke(null);
        }
    }

    private void InvokeCheckingRelations() {
        if (this.CheckingRelations != null) {
            this.CheckingRelations.invoke(null);
        }
    }

    private void InvokeFinishCheckingRelations() {
        if (this.FinishCheckingRelations != null) {
            this.FinishCheckingRelations.invoke(null);
        }
    }

    private void InvokeStartCheckingVariables() {
        if (this.StartCheckingVariables != null) {
            this.StartCheckingVariables.invoke(null);
        }
    }

    private void InvokeCheckingVariables() {
        if (this.CheckingVariables != null) {
            this.CheckingVariables.invoke(null);
        }
    }

    private void InvokeFinishCheckingVariables() {
        if (this.FinishCheckingVariables != null) {
            this.FinishCheckingVariables.invoke(null);
        }
    }

    public static List<StiCheck> getChecks() {
        if (checks == null) {
            StiCheckEngine.CreateChecks();
        }
        return checks;
    }

    private static void CreateChecks() {
        checks = new ArrayList<StiCheck>();
        checks.add(new StiDuplicatedNameCheck());
        checks.add(new StiNoNamePageCheck());
        checks.add(new StiComponentStyleIsNotFoundAtPageCheck());
        checks.add(new StiNoNameComponentCheck());
        checks.add(new StiUndefinedComponentCheck());
        checks.add(new StiUndefinedConnectionCheck());
        checks.add(new StiDifferentAmountOfKeysInDataRelationCheck());
        checks.add(new StiKeysInAbsentDataRelationCheck());
        checks.add(new StiKeysNotFoundRelationCheck());
        checks.add(new StiKeysTypesMismatchDataRelationCheck());
        checks.add(new StiNoNameDataRelationCheck());
        checks.add(new StiNoNameInSourceDataRelationCheck());
        checks.add(new StiNoNameDataSourceCheck());
        checks.add(new StiNoNameInSourceDataSourceCheck());
        checks.add(new StiUndefinedDataSourceCheck());
        checks.add(new StiLostPointsOnPageCheck());
        checks.add(new StiOrientationPageCheck());
        checks.add(new StiColumnsWidthGreaterPageWidthCheck());
        checks.add(new StiAllowHtmlTagsInTextCheck());
        checks.add(new StiCanGrowComponentInContainerCheck());
        checks.add(new StiGrowToHeightOverlappingCheck());
        checks.add(new StiComponentStyleIsNotFoundAtComponentCheck());
        checks.add(new StiCorruptedCrossLinePrimitiveCheck());
        checks.add(new StiPrintOnDoublePassCheck());
        checks.add(new StiLocationOutsidePageCheck());
        checks.add(new StiNegativeSizesOfComponentsCheck());
        checks.add(new StiPanelInEngineV1Check());
        checks.add(new StiWordWrapCanGrowTextDoesNotFitCheck());
        checks.add(new StiDuplicatedNameInSourceInDataRelationReportCheck());
        checks.add(new StiSourcesInAbsentDataRelationCheck());
        checks.add(new StiIsFirstPageIsLastPageDoublePassCheck());
        checks.add(new StiComponentBoundsAreOutOfBand());
        checks.add(new StiComponentDataColumnCheck());
        checks.add(new StiTotalPageCountDoublePassCheck());
        checks.add(new StiIsFirstPassIsSecondPassCheck());
        checks.add(new StiPrintHeadersAndFootersFromPreviousPageCheck());
        checks.add(new StiLargeHeightAtPageCheck());
        checks.add(new StiPrintOnPreviousPageCheck());
        checks.add(new StiPrintOnPreviousPageCheck2());
        checks.add(new StiResetPageNumberCheck());
        checks.add(new StiVerySmallSizesOfComponentsCheck());
        checks.add(new StiShowInsteadNullValuesCheck());
        checks.add(new StiPropertiesOnlyEngineV1Check());
        checks.add(new StiPropertiesOnlyEngineV2Check());
        checks.add(new StiMinRowsInColumnsCheck());
        checks.add(new StiDataSourcesForImageCheck());
        checks.add(new StiCanGrowGrowToHeightComponentInContainerCheck());
        checks.add(new StiCanGrowWordWrapTextAndWysiwygCheck());
        checks.add(new StiColumnsWidthGreaterContainerWidthCheck());
        checks.add(new StiGroupHeaderNotEqualToGroupFooterOnPageCheck());
        checks.add(new StiCrossGroupHeaderNotEqualToCrossGroupFooterOnPageCheck());
        checks.add(new StiGroupHeaderNotEqualToGroupFooterOnContainerCheck());
        checks.add(new StiCrossGroupHeaderNotEqualToCrossGroupFooterOnContainerCheck());
        checks.add(new StiContainerInEngineV2Check());
        checks.add(new StiSystemTextObsoleteCheck());
        checks.add(new StiContourTextObsoleteCheck());
        checks.add(new StiCountDataDataSourceAtDataBandCheck());
        checks.add(new StiNoConditionAtGroupCheck());
        checks.add(new StiWidthHeightZeroComponentCheck());
        checks.add(new StiTextColorEqualToBackColorCheck());
        checks.add(new StiTextColorEqualToBackColorCheck());
        checks.add(new StiFontMissingCheck());
    }

    public List<StiCheck> checkReport(StiReport report) {
        ArrayList<StiCheck> results = new ArrayList<StiCheck>();
        ArrayList<StiCheck> checksReport = new ArrayList<StiCheck>();
        ArrayList<StiCheck> checksReportCompilation = new ArrayList<StiCheck>();
        ArrayList<StiCheck> checksPage = new ArrayList<StiCheck>();
        ArrayList<StiCheck> checksComponent = new ArrayList<StiCheck>();
        ArrayList<StiCheck> checksDatabase = new ArrayList<StiCheck>();
        ArrayList<StiCheck> checksDataSource = new ArrayList<StiCheck>();
        ArrayList<StiCheck> checksDataRelation = new ArrayList<StiCheck>();
        ArrayList<StiCheck> checksDataColumn = new ArrayList<StiCheck>();
        ArrayList<StiCheck> checksVariable = new ArrayList<StiCheck>();
        for (StiCheck check : StiCheckEngine.getChecks()) {
            if (!check.getEnabled()) continue;
            switch (check.getObjectType()) {
                case Report: {
                    checksReport.add(check);
                    break;
                }
                case Page: {
                    checksPage.add(check);
                    break;
                }
                case Component: {
                    checksComponent.add(check);
                    break;
                }
                case Database: {
                    checksDatabase.add(check);
                    break;
                }
                case DataSource: {
                    checksDataSource.add(check);
                    break;
                }
                case DataRelation: {
                    checksDataRelation.add(check);
                    break;
                }
                case DataColumn: {
                    checksDataColumn.add(check);
                    break;
                }
                case Variable: {
                    checksVariable.add(check);
                }
            }
        }
        StiCheckEngine.checkObject(report, report, results, checksReport);
        boolean hasErrors = false;
        for (StiCheck repCheck : results) {
            if (!(repCheck instanceof StiDuplicatedNameCheck)) continue;
            hasErrors = true;
        }
        if (!hasErrors) {
            StiCheckEngine.checkObject(report, report, results, checksReportCompilation);
        }
        this.InvokeFinishCheckingReport();
        this.progressMaximum = report.getPages().size();
        this.progressValue = 0.0;
        this.InvokeStartCheckingPages();
        for (StiPage page : report.getPages()) {
            this.progressInformation = page.getName();
            this.progressValue += 1.0;
            this.InvokeCheckingPages();
            StiCheckEngine.checkObject(report, page, results, checksPage);
        }
        this.InvokeFinishCheckingPages();
        this.progressMaximum = report.getComponentsCount();
        this.progressValue = 0.0;
        this.InvokeStartCheckingComponents();
        for (StiPage page : report.getPages()) {
            StiComponentsCollection comps = page.GetComponents();
            for (StiComponent comp : comps) {
                this.progressInformation = comp.getName();
                this.progressValue += 1.0;
                this.InvokeCheckingComponents();
                StiCheckEngine.checkObject(report, comp, results, checksComponent);
            }
        }
        this.InvokeFinishCheckingComponents();
        this.progressMaximum = report.getDictionary().getDatabases().size();
        this.progressValue = 0.0;
        this.InvokeStartCheckingDatabases();
        for (StiDatabase database : report.getDictionary().getDatabases()) {
            this.progressInformation = String.format("%s - '%s'", StiLocalization.Get((String)"QueryBuilder", (String)"Database"), database.getName());
            this.progressValue += 1.0;
            this.InvokeCheckingDatabases();
            StiCheckEngine.checkObject(report, database, results, checksDatabase);
        }
        this.InvokeFinishCheckingDatabases();
        this.progressMaximum = report.getDictionary().getDataSources().size();
        this.progressValue = 0.0;
        this.InvokeStartCheckingDataSource();
        Iterator iterator = report.getDictionary().getDataSources().iterator();
        while (iterator.hasNext()) {
            StiDataSource dataSource = (StiDataSource)iterator.next();
            this.progressInformation = String.format("%s - '%s'", StiLocalization.Get((String)"PropertyMain", (String)"DataSource"), dataSource.getName());
            this.progressValue += 1.0;
            this.InvokeCheckingDataSource();
            StiCheckEngine.checkObject(report, dataSource, results, checksDataSource);
            Iterator iterator2 = dataSource.getColumns().iterator();
            while (iterator2.hasNext()) {
                StiDataColumn dataColumn = (StiDataColumn)iterator2.next();
                StiCheckEngine.checkObject(report, dataColumn, results, checksDataColumn);
            }
        }
        this.InvokeFinishCheckingDataSource();
        this.progressMaximum = report.getDictionary().getRelations().size();
        this.progressValue = 0.0;
        this.InvokeStartCheckingRelations();
        for (StiDataRelation dataRelation : report.getDictionary().getRelations()) {
            this.progressInformation = String.format("%s - '%s'", StiLocalization.Get((String)"PropertyMain", (String)"DataRelation"), dataRelation.getName());
            this.progressValue += 1.0;
            this.InvokeCheckingRelations();
            StiCheckEngine.checkObject(report, dataRelation, results, checksDataRelation);
        }
        this.InvokeFinishCheckingRelations();
        this.progressMaximum = report.getDictionary().getVariables().size();
        this.progressValue = 0.0;
        this.InvokeStartCheckingVariables();
        iterator = report.getDictionary().getVariables().iterator();
        while (iterator.hasNext()) {
            StiVariable variable = (StiVariable)iterator.next();
            this.progressInformation = String.format("%s - '%s'", StiLocalization.Get((String)"PropertyMain", (String)"Variable"), variable.getName());
            this.progressValue += 1.0;
            this.InvokeCheckingVariables();
            StiCheckEngine.checkObject(report, variable, results, checksVariable);
        }
        this.InvokeFinishCheckingVariables();
        Collections.sort(results, new CheckComparer());
        return results;
    }

    private static void checkObject(StiReport report, Object obj, List<StiCheck> results, List<StiCheck> checksObject) {
        for (StiCheck check : checksObject) {
            List createdChecks;
            StiCheck createdCheck;
            Object checkObject = check.processCheck(report, obj);
            if (checkObject == null) continue;
            StiCheck stiCheck = createdCheck = checkObject instanceof StiCheck ? (StiCheck)checkObject : null;
            if (createdCheck != null) {
                results.add(createdCheck);
            }
            if ((createdChecks = checkObject instanceof List ? (List)checkObject : null) == null) continue;
            for (StiCheck createdCheck2 : createdChecks) {
                results.add(createdCheck2);
            }
        }
    }

    public StiCheckEngine() throws StiException {
        if (StiLocalizationExt.getLocalization() == null) {
            StiLocalizationExt.loadDefConfig();
        }
    }

    private class CheckComparer
    implements Comparator<StiCheck> {
        private CheckComparer() {
        }

        @Override
        public int compare(StiCheck check1, StiCheck check2) {
            if (check1.getStatus() == StiCheckStatus.Error) {
                if (check2.getStatus() == StiCheckStatus.Error) {
                    return 0;
                }
                return -1;
            }
            if (check1.getStatus() == StiCheckStatus.Warning) {
                if (check2.getStatus() == StiCheckStatus.Error) {
                    return 1;
                }
                if (check2.getStatus() == StiCheckStatus.Information) {
                    return -1;
                }
                return 0;
            }
            if (check2.getStatus() == StiCheckStatus.Error || check2.getStatus() == StiCheckStatus.Warning) {
                return 1;
            }
            return 0;
        }
    }
}

