/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.view._3d;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.report.chart.enums.StiPie3dLightingStyle;
import com.stimulsoft.report.chart.view._3d.Sti3dOptions;

public class StiPie3dOptions
extends Sti3dOptions {
    private StiPie3dLightingStyle lighting = StiPie3dLightingStyle.Gradient;
    private float height = 25.0f;
    private float distance = 4.0f;

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyFloat("Height", (double)this.getHeight(), 25.0);
        jObject.AddPropertyFloat("Distance", (double)this.getDistance(), 4.0);
        jObject.AddPropertyEnum("Lighting", (Enum)this.getLighting());
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("Height")) {
                this.setHeight(property.doubleValue().floatValue());
                continue;
            }
            if (property.Name.equals("Distance")) {
                this.setDistance(property.floatValue().floatValue());
                continue;
            }
            if (!property.Name.equals("Lighting")) continue;
            this.setLighting(StiPie3dLightingStyle.valueOf((String)property.Value));
        }
    }

    @Override
    public boolean isDefault() {
        return super.isDefault() && this.getLighting() == StiPie3dLightingStyle.Gradient && this.getHeight() == 25.0f && this.getDistance() == 4.0f;
    }

    @StiSerializable
    public final StiPie3dLightingStyle getLighting() {
        return this.lighting;
    }

    public final void setLighting(StiPie3dLightingStyle value) {
        this.lighting = value;
    }

    @StiSerializable
    public final float getHeight() {
        return this.height;
    }

    public final void setHeight(float value) {
        if (value >= 0.0f) {
            this.height = value;
        }
    }

    @StiSerializable
    public float getDistance() {
        return this.distance;
    }

    public void setDistance(float value) {
        if (value >= 0.0f) {
            this.distance = value;
        }
    }
}

