/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.series.pie;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.animation.StiAnimation;
import com.stimulsoft.base.context.chart.animation.StiOpacityAnimation;
import com.stimulsoft.base.context.chart.geoms.StiArcSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.StiLineSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.StiPenGeom;
import com.stimulsoft.base.context.chart.geoms.StiSegmentGeom;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiGlareBrush;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.StiChartHelper;
import com.stimulsoft.report.chart.enums.StiPie3dLightingStyle;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.series.StiSeriesElementGeom;
import com.stimulsoft.report.chart.helpers.StiPie3dHelper;
import com.stimulsoft.report.chart.interfaces.series.pie.IStiPie3dSeries;
import com.stimulsoft.report.chart.view.series.StiSeriesInteractionData;
import com.stimulsoft.report.chart.view.series.pie.StiPie3dPeripherySurfaceBounds;
import com.stimulsoft.report.chart.view.series.pie.StiPie3dQuadrilateral;
import com.stimulsoft.report.chart.view.series.pie.StiPie3dSlice;
import java.util.ArrayList;

public class StiPie3dSidesSeriesElementGeom
extends StiSeriesElementGeom {
    private static float sShadowAngle = 20.0f;
    private StiPenGeom pen;
    private float startnAngle;
    private float sweepAngle;
    private StiRectangle mBoundingRectangle = new StiRectangle();
    private float mSliceHeight;
    private float mStartAngle;
    private float mSweepAngle;
    private StiPoint mCenter = new StiPoint();
    private StiPoint mCenterBelow = new StiPoint();
    private StiPoint mPointStart = new StiPoint();
    private StiPoint mPointStartBelow = new StiPoint();
    private StiPoint mPointEnd = new StiPoint();
    private StiPoint mPointEndBelow = new StiPoint();
    private StiBrush mBrushStartSide;
    private StiBrush mBrushEndSide;
    private StiBrush mBrushPeripherySurface;
    private StiBrush mBrushSurface;
    private StiPie3dQuadrilateral mStartSide;
    private StiPie3dQuadrilateral mEndSide;
    private boolean startSideExists;
    private boolean endSideExists;
    private int count;
    private StiPie3dSlice pie3DSlice;

    public final float getStartAngle() {
        return this.mStartAngle;
    }

    public final float getEndAngle() {
        return (this.mStartAngle + this.mSweepAngle) % 360.0f;
    }

    @Override
    public StiSeriesInteractionData getInteraction() {
        return this.getPie3DSlice().getInteraction();
    }

    public final StiPie3dSlice getPie3DSlice() {
        return this.pie3DSlice;
    }

    private void setPie3DSlice(StiPie3dSlice value) {
        this.pie3DSlice = value;
    }

    @Override
    public boolean Contains(double px, double py) {
        StiPoint point = new StiPoint(px, py);
        if (this.peripheryContainsPoint(point)) {
            return true;
        }
        if (this.mStartSide.contains(point)) {
            return true;
        }
        return this.mEndSide.contains(point);
    }

    public final boolean peripheryContainsPoint(StiPoint point) {
        ArrayList<StiPie3dPeripherySurfaceBounds> peripherySurfaceBounds = this.getVisiblePeripherySurfaceBounds();
        for (StiPie3dPeripherySurfaceBounds surfaceBounds : peripherySurfaceBounds) {
            if (!this.cylinderSurfaceSectionContainsPoint(point, surfaceBounds.StartAngle, surfaceBounds.EndAngle, surfaceBounds.StartPoint, surfaceBounds.EndPoint)) continue;
            return true;
        }
        return false;
    }

    private boolean cylinderSurfaceSectionContainsPoint(StiPoint point, double startAngle, double endAngle, StiPoint point1, StiPoint point2) {
        if (this.mSliceHeight > 0.0f) {
            return StiPie3dQuadrilateral.contains(point, new StiPoint[]{point1, new StiPoint(point1.x, point1.y + (double)this.mSliceHeight), new StiPoint(point2.x, point2.y + (double)this.mSliceHeight), point2});
        }
        return false;
    }

    @Override
    public void Draw(StiContext context) {
        context.PushSmoothingModeToAntiAlias();
        this.drawHiddenPeriphery(context);
        if (this.getStartAngle() > 90.0f && this.getStartAngle() < 270.0f) {
            this.drawEndSide(context);
            this.drawStartSide(context);
        } else {
            this.drawStartSide(context);
            this.drawEndSide(context);
        }
        this.drawVisiblePeriphery(context);
        context.PopSmoothingMode();
    }

    private void drawStartSide(StiContext context) {
        if (this.mStartSide != null) {
            if (this.getStartAngle() > 90.0f && this.getStartAngle() < 270.0f) {
                this.mStartSide.draw(context, this.pen, this.mBrushStartSide, this.getIsMouseOver());
            } else {
                this.mStartSide.draw(context, this.pen, this.mBrushSurface, this.getIsMouseOver());
            }
        }
    }

    private void drawEndSide(StiContext context) {
        if (this.mEndSide != null) {
            if (this.getEndAngle() > 90.0f && this.getEndAngle() < 270.0f) {
                this.mEndSide.draw(context, this.pen, this.mBrushSurface, this.getIsMouseOver());
            } else {
                this.mEndSide.draw(context, this.pen, this.mBrushEndSide, this.getIsMouseOver());
            }
        }
    }

    private void drawVisiblePeriphery(StiContext context) {
        ArrayList<StiPie3dPeripherySurfaceBounds> peripherySurfaceBounds = this.getVisiblePeripherySurfaceBounds();
        for (StiPie3dPeripherySurfaceBounds surfaceBounds : peripherySurfaceBounds) {
            this.drawCylinderSurfaceSection(context, this.pen, this.mBrushPeripherySurface, surfaceBounds);
        }
    }

    private void drawHiddenPeriphery(StiContext context) {
        ArrayList<StiPie3dPeripherySurfaceBounds> peripherySurfaceBounds = this.getHiddenPeripherySurfaceBounds();
        for (StiPie3dPeripherySurfaceBounds surfaceBounds : peripherySurfaceBounds) {
            this.drawCylinderSurfaceSection(context, this.pen, this.mBrushSurface, surfaceBounds);
        }
    }

    private ArrayList<StiPie3dPeripherySurfaceBounds> getHiddenPeripherySurfaceBounds() {
        ArrayList<StiPie3dPeripherySurfaceBounds> peripherySurfaceBounds = new ArrayList<StiPie3dPeripherySurfaceBounds>();
        if (!(this.mSweepAngle == 0.0f || this.mStartAngle >= 0.0f && this.mStartAngle + this.mSweepAngle <= 180.0f || !(this.mStartAngle + this.mSweepAngle > 180.0f))) {
            float fStartAngle = this.mStartAngle;
            StiPoint fStartPoint = new StiPoint(this.mPointStart.x, this.mPointStart.y);
            float fEndAngle = this.mStartAngle + this.mSweepAngle;
            StiPoint fEndPoint = new StiPoint(this.mPointEnd.x, this.mPointEnd.y);
            float rStartAngle = this.startnAngle;
            float rEndAngle = this.startnAngle + this.sweepAngle;
            if (fStartAngle < 180.0f) {
                rStartAngle = 180.0f;
                fStartAngle = 180.0f;
                fStartPoint.x = this.mBoundingRectangle.getLeft();
                fStartPoint.y = this.mCenter.y;
            }
            if (fEndAngle > 360.0f) {
                rEndAngle = 360.0f;
                fEndAngle = 360.0f;
                fEndPoint.x = this.mBoundingRectangle.getRight();
                fEndPoint.y = this.mCenter.y;
            }
            peripherySurfaceBounds.add(new StiPie3dPeripherySurfaceBounds(fStartAngle, fEndAngle, fStartPoint, fEndPoint, rStartAngle, rEndAngle));
            if (this.mStartAngle < 360.0f && this.mStartAngle + this.mSweepAngle > 540.0f) {
                fStartAngle = 180.0f;
                fStartPoint = new StiPoint(this.mBoundingRectangle.getLeft(), this.mCenter.y);
                fEndAngle = this.getEndAngle();
                fEndPoint = new StiPoint(this.mPointEnd.x, this.mPointEnd.y);
                peripherySurfaceBounds.add(new StiPie3dPeripherySurfaceBounds(fStartAngle, fEndAngle, fStartPoint, fEndPoint, rStartAngle, rEndAngle));
            }
        }
        return peripherySurfaceBounds;
    }

    private ArrayList<StiPie3dPeripherySurfaceBounds> getVisiblePeripherySurfaceBounds() {
        ArrayList<StiPie3dPeripherySurfaceBounds> peripherySurfaceBounds = new ArrayList<StiPie3dPeripherySurfaceBounds>();
        if (!(this.mSweepAngle == 0.0f || this.mStartAngle >= 180.0f && this.mStartAngle + this.mSweepAngle <= 360.0f)) {
            float rEndAngle;
            float rStartAngle;
            StiPoint fEndPoint;
            float fEndAngle;
            StiPoint fStartPoint;
            float fStartAngle;
            if (this.getStartAngle() < 180.0f) {
                fStartAngle = this.mStartAngle;
                fStartPoint = new StiPoint(this.mPointStart.x, this.mPointStart.y);
                fEndAngle = this.getEndAngle();
                fEndPoint = new StiPoint(this.mPointEnd.x, this.mPointEnd.y);
                rStartAngle = this.startnAngle;
                rEndAngle = this.startnAngle + this.sweepAngle;
                if (this.mStartAngle + this.mSweepAngle > 180.0f) {
                    rEndAngle = 180.0f;
                    fEndAngle = 180.0f;
                    fEndPoint.x = this.mBoundingRectangle.x;
                    fEndPoint.y = this.mCenter.y;
                }
                peripherySurfaceBounds.add(new StiPie3dPeripherySurfaceBounds(fStartAngle, fEndAngle, fStartPoint, fEndPoint, rStartAngle, rEndAngle));
            }
            if (this.mStartAngle + this.mSweepAngle > 360.0f) {
                fStartAngle = 0.0f;
                fStartPoint = new StiPoint(this.mBoundingRectangle.getRight(), this.mCenter.y);
                fEndAngle = this.getEndAngle();
                fEndPoint = new StiPoint(this.mPointEnd.x, this.mPointEnd.y);
                rStartAngle = this.startnAngle;
                rEndAngle = this.startnAngle + this.sweepAngle;
                if (fEndAngle > 180.0f) {
                    rEndAngle = 180.0f;
                    fEndAngle = 180.0f;
                    fEndPoint.x = this.mBoundingRectangle.getLeft();
                    fEndPoint.y = this.mCenter.y;
                }
                peripherySurfaceBounds.add(new StiPie3dPeripherySurfaceBounds(fStartAngle, fEndAngle, fStartPoint, fEndPoint, rStartAngle, rEndAngle));
            }
        }
        return peripherySurfaceBounds;
    }

    protected final void drawCylinderSurfaceSection(StiContext context, StiPenGeom pen, StiBrush brush, StiPie3dPeripherySurfaceBounds peripherySurfaceBounds) {
        ArrayList<StiSegmentGeom> path = this.createPathForCylinderSurfaceSection(peripherySurfaceBounds);
        StiRectangle rect = context.GetPathBounds(path);
        StiAnimation animation = this.getAnimation();
        if (animation != null) {
            context.DrawAnimationPathElement(brush, brush, pen, path, (Object)rect, this.GetToolTip(), (Object)this, animation, this.getInteractionData());
        } else {
            context.FillPath((Object)brush, path, (Object)rect, null);
            context.DrawPath(pen, path, (Object)rect);
        }
    }

    public final StiPoint getTextPosition() {
        if (this.sweepAngle >= 180.0f) {
            return this.peripheralPoint(this.mCenter.x, this.mCenter.y, this.mBoundingRectangle.width / 3.0, this.mBoundingRectangle.height / 3.0, this.getActualAngle(this.getStartAngle()) + this.sweepAngle / 2.0f);
        }
        double x = (this.mPointStart.x + this.mPointEnd.x) / 2.0;
        double y = (this.mPointStart.y + this.mPointEnd.y) / 2.0;
        float angle = (float)(Math.atan2(y - this.mCenter.y, x - this.mCenter.x) * 180.0 / Math.PI);
        return this.peripheralPoint(this.mCenter.x, this.mCenter.y, this.mBoundingRectangle.width / 3.0, this.mBoundingRectangle.height / 3.0, this.getActualAngle(angle));
    }

    protected final float getActualAngle(float transformedAngle) {
        double x = this.mBoundingRectangle.height * Math.cos((double)transformedAngle * Math.PI / 180.0);
        double y = this.mBoundingRectangle.width * Math.sin((double)transformedAngle * Math.PI / 180.0);
        float result = (float)(Math.atan2(y, x) * 180.0 / Math.PI);
        if (result < 0.0f) {
            return result + 360.0f;
        }
        return result;
    }

    private ArrayList<StiSegmentGeom> createPathForCylinderSurfaceSection(StiPie3dPeripherySurfaceBounds peripherySurfaceBounds) {
        double startAngle = peripherySurfaceBounds.StartAngle;
        double endAngle = peripherySurfaceBounds.EndAngle;
        StiPoint pointStart = peripherySurfaceBounds.StartPoint;
        StiPoint pointEnd = peripherySurfaceBounds.EndPoint;
        double realStartAngle = peripherySurfaceBounds.RealStartAngle;
        double realEndAngle = peripherySurfaceBounds.RealEndAngle;
        double realSweetAngle = peripherySurfaceBounds.RealEndAngle - peripherySurfaceBounds.RealStartAngle;
        ArrayList<StiSegmentGeom> path = new ArrayList<StiSegmentGeom>();
        path.add((StiSegmentGeom)new StiArcSegmentGeom(this.mBoundingRectangle, (float)startAngle, (float)(endAngle - startAngle), Float.valueOf((float)realStartAngle), Float.valueOf((float)realSweetAngle)));
        path.add((StiSegmentGeom)new StiLineSegmentGeom(pointEnd.x, pointEnd.y, pointEnd.x, pointEnd.y + (double)this.mSliceHeight));
        StiRectangle rect = new StiRectangle(this.mBoundingRectangle.x, this.mBoundingRectangle.y + (double)this.mSliceHeight, this.mBoundingRectangle.width, this.mBoundingRectangle.height);
        path.add((StiSegmentGeom)new StiArcSegmentGeom(rect, (float)endAngle, (float)(startAngle - endAngle), Float.valueOf((float)realEndAngle), Float.valueOf((float)(realStartAngle - realEndAngle))));
        path.add((StiSegmentGeom)new StiLineSegmentGeom(pointStart.x, pointStart.y + (double)this.mSliceHeight, pointStart.x, pointStart.y));
        return path;
    }

    private void initializePieSlice(float xBoundingRect, float yBoundingRect, float widthBoundingRect, float heightBoundingRect, float sliceHeight, StiPie3dLightingStyle shadowStyle) {
        this.mBoundingRectangle = new StiRectangle((double)xBoundingRect, (double)yBoundingRect, (double)widthBoundingRect, (double)heightBoundingRect);
        this.mSliceHeight = sliceHeight;
        float mActualStartAngle = this.startnAngle;
        this.mStartAngle = this.transformAngle(this.startnAngle);
        this.mSweepAngle = this.sweepAngle;
        if (this.mSweepAngle % 180.0f != 0.0f) {
            this.mSweepAngle = this.transformAngle(mActualStartAngle + this.sweepAngle) - this.mStartAngle;
        }
        if (this.mSweepAngle < 0.0f) {
            this.mSweepAngle += 360.0f;
        }
        this.createSurfaceBrushes(shadowStyle);
        float xCenter = xBoundingRect + widthBoundingRect / 2.0f;
        float yCenter = yBoundingRect + heightBoundingRect / 2.0f;
        this.mCenter = new StiPoint((double)xCenter, (double)yCenter);
        this.mCenterBelow = new StiPoint((double)xCenter, (double)(yCenter + sliceHeight));
        this.mPointStart = this.peripheralPoint(xCenter, yCenter, widthBoundingRect / 2.0f, heightBoundingRect / 2.0f, mActualStartAngle);
        this.mPointStartBelow = new StiPoint(this.mPointStart.x, this.mPointStart.y + (double)sliceHeight);
        this.mPointEnd = this.peripheralPoint(xCenter, yCenter, widthBoundingRect / 2.0f, heightBoundingRect / 2.0f, mActualStartAngle + this.sweepAngle);
        this.mPointEndBelow = new StiPoint(this.mPointEnd.x, this.mPointEnd.y + (double)sliceHeight);
        this.initializeSides(this.startSideExists, this.endSideExists);
    }

    private void initializeSides(boolean startSideExists, boolean endSideExists) {
        StiAnimation animation = this.getAnimation();
        this.mStartSide = startSideExists ? new StiPie3dQuadrilateral(this.mBoundingRectangle, this.mCenter, this.mPointStart, this.mPointStartBelow, this.mCenterBelow, this.mSweepAngle != 180.0f, animation) : StiPie3dQuadrilateral.empty;
        this.mEndSide = endSideExists ? new StiPie3dQuadrilateral(this.mBoundingRectangle, this.mCenter, this.mPointEnd, this.mPointEndBelow, this.mCenterBelow, this.mSweepAngle != 180.0f, animation) : StiPie3dQuadrilateral.empty;
    }

    protected void createSurfaceBrushes(StiPie3dLightingStyle shadowStyle) {
        StiColor surfaceColor = StiBrush.ToColor((StiBrush)this.seriesBrush);
        this.mBrushSurface = new StiSolidBrush(surfaceColor);
        switch (shadowStyle) {
            case No: {
                this.mBrushEndSide = this.mBrushPeripherySurface = new StiSolidBrush(surfaceColor);
                this.mBrushStartSide = this.mBrushPeripherySurface;
                break;
            }
            case Solid: {
                this.mBrushEndSide = this.mBrushPeripherySurface = StiBrush.light((StiBrush)this.seriesBrush, (int)30);
                this.mBrushStartSide = this.mBrushPeripherySurface;
                break;
            }
            case Gradient: {
                double angle = this.mStartAngle - 180.0f - sShadowAngle;
                if (angle < 0.0) {
                    angle += 360.0;
                }
                this.mBrushStartSide = this.createBrushForSide(surfaceColor, angle);
                angle = this.mStartAngle + this.mSweepAngle - sShadowAngle;
                if (angle < 0.0) {
                    angle += 360.0;
                }
                this.mBrushEndSide = this.createBrushForSide(surfaceColor, angle);
                this.mBrushPeripherySurface = this.createBrushForPeriphery(surfaceColor);
            }
        }
    }

    protected StiBrush createBrushForSide(StiColor color, double angle) {
        return new StiSolidBrush(StiPie3dHelper.createColorWithCorrectedLightness(color, -((float)((double)0.3f * (1.0 - 0.8 * Math.cos(angle * Math.PI / 180.0))))));
    }

    protected StiBrush createBrushForPeriphery(StiColor color) {
        return new StiGlareBrush(color, StiPie3dSidesSeriesElementGeom.createColorWithCorrectedLightness(color, -0.3f), 90.0, 0.1f, 1.0f);
    }

    public static StiColor createColorWithCorrectedLightness(StiColor color, float correctionFactor) {
        if (correctionFactor == 0.0f) {
            return color;
        }
        float red = color.r;
        float green = color.g;
        float blue = color.b;
        if (correctionFactor < 0.0f) {
            correctionFactor = 1.0f + correctionFactor;
            red *= correctionFactor;
            green *= correctionFactor;
            blue *= correctionFactor;
        } else {
            red = (255.0f - red) * correctionFactor + red;
            green = (255.0f - green) * correctionFactor + green;
            blue = (255.0f - blue) * correctionFactor + blue;
        }
        return StiColor.fromArgb((int)color.a, (int)((int)red), (int)((int)green), (int)((int)blue));
    }

    protected final StiPoint peripheralPoint(double xCenter, double yCenter, double semiMajor, double semiMinor, double angleDegrees) {
        double angleRadians = angleDegrees * Math.PI / 180.0;
        return new StiPoint(xCenter + (double)((float)(semiMajor * Math.cos(angleRadians))), yCenter + (double)((float)(semiMinor * Math.sin(angleRadians))));
    }

    protected final float transformAngle(float angle) {
        double x = this.mBoundingRectangle.width * Math.cos((double)angle * Math.PI / 180.0);
        double y = this.mBoundingRectangle.height * Math.sin((double)angle * Math.PI / 180.0);
        float result = (float)(Math.atan2(y, x) * 180.0 / Math.PI);
        if (result < 0.0f) {
            return result + 360.0f;
        }
        return result;
    }

    private StiAnimation getAnimation() {
        if (!((StiChart)this.getSeries().getChart()).isAnimation) {
            return null;
        }
        int duration = StiChartHelper.GlobalDurationElement;
        int beginTime = StiChartHelper.GlobalBeginTimeElement;
        StiOpacityAnimation animation = null;
        Object pieAnimation = null;
        if (animation == null) {
            int beginTimeAnimationOpacity = beginTime / this.count * this.getIndex();
            StiOpacityAnimation opacityAnimation = new StiOpacityAnimation(Integer.valueOf(duration), Integer.valueOf(beginTimeAnimationOpacity));
            opacityAnimation.id = String.format("series_%1$s_%2$s", this.getSeries().getChart().getSeries().indexOf(this.getSeries()), this.getIndex());
            animation = opacityAnimation;
        }
        return animation;
    }

    public StiPie3dSidesSeriesElementGeom(StiPie3dSlice pie3DSlice, StiAreaGeom areaGeom, double value, int index, int count, IStiPie3dSeries series, StiRectangle clientRectangle, StiColor borderColor, StiBrush brush, float startAngle, float sweepAngle, float pieHeight, boolean startSideExists, boolean endSideExists) {
        super(areaGeom, value, index, series, clientRectangle, brush);
        this.setPie3DSlice(pie3DSlice);
        this.count = count;
        this.startnAngle = startAngle;
        this.pen = new StiPenGeom(borderColor);
        this.sweepAngle = sweepAngle;
        this.startSideExists = startSideExists;
        this.endSideExists = endSideExists;
        this.initializePieSlice((float)clientRectangle.x, (float)clientRectangle.y, (float)clientRectangle.width, (float)clientRectangle.height, pieHeight, series.getOptions3D().getLighting());
    }
}

